// Copyright 2015 - 2025, GIBIS-UNIFESP and the wiRedPanda contributors
// SPDX-License-Identifier: GPL-3.0-or-later

#include "lengthdialog.h"
#include "lengthdialog_ui.h"

LengthDialog::LengthDialog(const int currentLength, QWidget *parent)
    : QDialog(parent)
    , m_ui(std::make_unique<LengthDialog_Ui>())
{
    m_ui->setupUi(this);

    m_ui->lengthSpinBox->setValue(currentLength);

    setWindowTitle(tr("Simulation Length Selection"));

    connect(m_ui->buttonBox, &QDialogButtonBox::accepted, this, &QDialog::accept);
    connect(m_ui->buttonBox, &QDialogButtonBox::rejected, this, &QDialog::reject);
}

LengthDialog::~LengthDialog()
{
}

int LengthDialog::length()
{
    return (exec() == QDialog::Accepted) ? m_ui->lengthSpinBox->value() : -1;
}
