#
# Tcl Library for TkRev
#

# Import new files and directories into a CVS repository
proc cvs_import_setup {} {
  global cwd
  global incvs
  global insvn
  global ingit
  global inrcs
  global cvsglb
  
  gen_log:log T "ENTER"
  
  # Make sure we're not in a directory that's already under revision control
  lassign [vcs_detect [pwd]] incvs insvn inrcs ingit
  if {$incvs} {
    cvsok "This directory is already in CVS.\nCan\'t import here!" .import
    gen_log:log T "LEAVE"
    return
  }
  if {$insvn} {
    cvsok "There are Subversion directories here.\nPlease remove them first." .import
    gen_log:log T "LEAVE"
    return
  }
  if {$ingit} {
    cvsok "There are Git directories here.\nPlease remove them first." .import
    gen_log:log T "LEAVE"
    return
  }
  if {$inrcs} {
    cvsok "There are RCS directories here.\nPlease remove them first." .import
    gen_log:log T "LEAVE"
    return
  }
  
  if {[winfo exists .import]} {
    wm deiconify .import
    raise .import
    grab set .import
    gen_log:log T "LEAVE"
    return
  }
  
  # Set some defaults
  set cvsglb(newcode) [file tail $cwd]
  set cvsglb(newdir) $cvsglb(newcode)
  set cvsglb(newdesc) "Imported"
  # Give it a default.  This is what you get without the -b option.
  set cvsglb(newvers) 1.1.1
  
  toplevel .import
  grab set .import
  
  frame .import.top
  
  message .import.top.explain -justify left -width 500 -relief groove \
    -text "This will import the current directory and its sub-directories\
          into CVS, creating a new module.  If you haven't created a CVS repository,\
          you must do that first with \"cvs init.\""
  label .import.top.lnewcode -text "New Module Name"  -anchor w
  label .import.top.lnewdir  -text "Path relative to \$CVSROOT" -anchor w
  label .import.top.lnewdesc -text "Descriptive Title" -anchor w
  label .import.top.lnewvers  -text "Initial Version Number" -anchor w
  
  entry .import.top.tnewcode -textvariable cvsglb(newcode) -width 40
  entry .import.top.tnewdir -textvariable cvsglb(newdir) -width 40
  entry .import.top.tnewdesc -textvariable cvsglb(newdesc) -width 40
  entry .import.top.tnewvers -textvariable cvsglb(newvers) -width 40
  
  grid .import.top.explain -column 0 -row 0 -columnspan 3 -sticky ew
  grid .import.top.lnewcode -column 0 -row 1 -sticky w
  grid .import.top.tnewcode -column 1 -row 1 -sticky ew
  grid .import.top.lnewdir -column 0 -row 2 -sticky w
  grid .import.top.tnewdir -column 1 -row 2 -sticky ew
  grid .import.top.lnewdesc -column 0 -row 3 -sticky w
  grid .import.top.tnewdesc -column 1 -row 3 -sticky ew
  grid .import.top.lnewvers -column 0 -row 4 -sticky w
  grid .import.top.tnewvers -column 1 -row 4 -sticky ew
  
  frame .import.down -relief groove -borderwidth 2
  button .import.down.ok -text "OK" \
    -command {
      if {! [cvs_import_errorcheck]} {
        grab release .import
        wm withdraw .import
        cvs_import_do
     }
  }
  button .import.down.quit -text "Cancel" \
      -command {
    grab release .import
    wm withdraw .import
  }
  
  pack .import.down -side bottom -expand yes -fill x
  pack .import.top -side top -expand yes -fill x
  pack .import.down.ok -side left -expand yes
  pack .import.down.quit -side left -expand yes
  
  wm title .import "Create a New Module"
  wm minsize .import 1 1
  
  gen_log:log T "LEAVE"
}

proc cvs_import_errorcheck {} {
  global cvscfg
  global cvsglb
  global modlist_sorted
  global modval
  global cvs

  set error_exists 0

  # Make sure the repository exists
  set command "$cvs -d $cvscfg(cvsroot) rlog"
  set ret [catch {exec {*}$command} output]
  if {$ret} {
    cvsok "Repository $cvscfg(cvsroot) isn't reachable or doesn't exist" .import
    set error_exists 1
  }
  # Other error checks
  if { $cvsglb(newcode) == "" } {
    cvsok "You must type in a new module name." .import
    set error_exists 1
  }
  if { $cvsglb(newdir) == "" } {
    cvsok "You must type in a new module path directory." .import
    set error_exists 1
  }
  
  # In case the module browser isn't running
  if {! [info exists modlist_sorted]} {
    modbrowse_run
  }
  
  # Make sure it isn't a duplicate key
  foreach {key value} [array get modval] {
    if { $cvsglb(newcode) == $key } {
      cvsok "$cvsglb(newcode) is not a new Module" .import
      set error_exists 1
    }
  }
  if {$error_exists} {
    return 1
  }
  return 0
}

proc cvs_import_do {} {
  global cvs
  global cvsglb
  global cvscfg
  global cwd
  global modlist_sorted
  global modval
  global modtitle
  global ExModList ExModDirList
  
  gen_log:log T "ENTER"
  set imdir [pwd]
  
  # See if all apropriate Directories in newdirname exist.  CVS import will
  # create them, but we'll want to make a #D entry.
  set cvsglb(newdir) [string trimleft $cvsglb(newdir) "/"]
  set pathname [file dirname $cvsglb(newdir)]
  set need_Dir 0
  if {$pathname != "."} {
    foreach idx $modlist_sorted {
      lappend knowndirs [lindex $idx 0]
    }
    gen_log:log D "looking for $pathname in known directories ($knowndirs)"
    if {$pathname ni $knowndirs} {
      set need_Dir 1
    }
  }
  
  # Make a baseline tag
  set versions [split $cvsglb(newvers) ".,/ -"]
  set baseline "baseline-[join $versions {_}]"
  
  set commandline "$cvs -d \"$cvscfg(cvsroot)\" import -m \"Imported using TkRev\""
  # Let it default to 1.1.1 or you will have big problems later from cvs.
  #if {$cvsglb(newvers) != ""} {
  #append commandline " -b 1.1.1"
  #}
  append commandline " \"$cvsglb(newdir)\" IMPORT $baseline"
  
  set v [viewer::new "Import Module"]
  $v\::log "\nCVS Import\n"
  $v\::do "$commandline"
  $v\::wait
  update
  
  # Update the modules file.
  set commandline "$cvs -d $cvscfg(cvsroot) -w checkout CVSROOT/modules"
  $v\::log "\nCheckout New Module\n"
  $v\::do "$commandline"
  $v\::wait
  
  cd CVSROOT
  gen_log:log F "CD [pwd]"
  set modfile [open modules a]
  if {$need_Dir} {
    puts $modfile ""
    gen_log:log D "#D	$pathname"
    puts $modfile "#D	$pathname"
  }
  gen_log:log D "#M\t$cvsglb(newcode)\t$cvsglb(newdesc)"
  puts $modfile "#M\t$cvsglb(newcode)\t$cvsglb(newdesc)"
  gen_log:log D "$cvsglb(newcode)\t$cvsglb(newdir)"
  puts $modfile "$cvsglb(newcode)\t$cvsglb(newdir)"
  close $modfile
  set commandline "$cvs -d $cvscfg(cvsroot) ci -m \"added $cvsglb(newcode)\" modules"
  $v\::log "\nCVS Checkin CVSROOT\n"
  $v\::do "$commandline"
  $v\::wait
  cd ../
  gen_log:log F "CD [pwd]"
  set commandline "$cvs -d $cvscfg(cvsroot) -Q release -d CVSROOT"
  $v\::do "$commandline"
  $v\::wait
  
  modbrowse_run
  
  # Now check out the new module
  cd ..
  gen_log:log F "CD [pwd]"
  # We have to move the original stuff entirely out of the way.
  # Otherwise checkout won't do the whole tree.
  gen_log:log F "MOVE $imdir $imdir.orig"
  if {[file isdirectory $imdir.orig]} {
    file delete -force -- $imdir.orig
  }
  file rename $imdir $imdir.orig
  set commandline \
      "$cvs -d $cvscfg(cvsroot) checkout -R \"$cvsglb(newcode)\""
  #gen_log:log C "$commandline"
  $v\::log "\nCVS Checkout\n"
  $v\::do "$commandline"
  $v\::wait
  
  # cd to the checked out module. $cwd is the correct directory to cd to
  # only if the name of the new module is the same as the directory name
  # where the source code is in. Define ckmoddir to be used instead.
  
  set ckmoddir $cwd
  if { $cvsglb(newcode) != [file tail $cwd] } {
    set ckmoddir [file join [file dirname $cwd] $cvsglb(newcode)]
  }
  if { [catch "cd $ckmoddir" err]} {
    cvsok "$err" .import
  } else {
    gen_log:log F "CD [pwd]"
  }
  
  if {$cvscfg(auto_status)} {
    setup_dir
  }
  gen_log:log T "LEAVE"
}

