/*
 * Decompiled with CFR 0.152.
 */
package glguerin.authkit.imp.macosx;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class AuthProcess
extends Process {
    private String myName;
    private InputStream in;
    private OutputStream out;

    protected AuthProcess(String string, int n, int n2) {
        this.myName = string;
        this.in = new FIn(n);
        this.out = new FOut(n2);
    }

    public String toString() {
        return this.myName;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public InputStream getErrorStream() {
        throw new IllegalArgumentException("No stderr stream");
    }

    public int waitFor() throws InterruptedException {
        throw new IllegalArgumentException("No waiting");
    }

    public int exitValue() {
        throw new IllegalArgumentException("No exit value");
    }

    public void destroy() {
        throw new IllegalArgumentException("Can't destroy");
    }

    protected static native int read(int var0, byte[] var1, int var2, int var3);

    protected static native int write(int var0, byte[] var1, int var2, int var3);

    protected static native int close(int var0);

    public static class FOut
    extends OutputStream {
        private byte[] one = new byte[1];
        private int myFD;

        public FOut(int n) {
            this.myFD = n;
        }

        protected void finalize() throws Throwable {
            this.close();
        }

        public void write(int n) throws IOException {
            this.one[0] = (byte)n;
            this.write(this.one, 0, 1);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.myFD < 0) {
                throw new IOException("Closed");
            }
            int n3 = AuthProcess.write(this.myFD, byArray, n, n2);
            if (n3 != n2) {
                throw new IOException("Errno: " + -n3);
            }
        }

        public void close() throws IOException {
            if (this.myFD >= 0) {
                int n = this.myFD;
                this.myFD = -1;
                int n2 = AuthProcess.close(n);
                if (n2 != 0) {
                    throw new IOException("Errno: " + n2);
                }
            }
        }
    }

    public static class FIn
    extends InputStream {
        private byte[] one = new byte[1];
        private int myFD;

        public FIn(int n) {
            this.myFD = n;
        }

        protected void finalize() throws Throwable {
            this.close();
        }

        public int read() throws IOException {
            int n = this.read(this.one, 0, 1);
            if (n == 1) {
                return 0xFF & this.one[0];
            }
            return -1;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.myFD < 0) {
                throw new IOException("Closed");
            }
            int n3 = AuthProcess.read(this.myFD, byArray, n, n2);
            if (n3 > 0) {
                return n3;
            }
            if (n3 == 0) {
                return -1;
            }
            throw new IOException("Errno: " + -n3);
        }

        public void close() throws IOException {
            if (this.myFD >= 0) {
                int n = this.myFD;
                this.myFD = -1;
                int n2 = AuthProcess.close(n);
                if (n2 != 0) {
                    throw new IOException("Errno: " + n2);
                }
            }
        }
    }
}

