// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option.
// All files in the project carrying such notice may not be copied, modified, or distributed
// except according to those terms.
use shared::minwindef::USHORT;
pub type USAGE = USHORT;
pub type PUSAGE = *mut USAGE;
pub const HID_USAGE_PAGE_UNDEFINED: USAGE = 0x00;
pub const HID_USAGE_PAGE_GENERIC: USAGE = 0x01;
pub const HID_USAGE_PAGE_SIMULATION: USAGE = 0x02;
pub const HID_USAGE_PAGE_VR: USAGE = 0x03;
pub const HID_USAGE_PAGE_SPORT: USAGE = 0x04;
pub const HID_USAGE_PAGE_GAME: USAGE = 0x05;
pub const HID_USAGE_PAGE_KEYBOARD: USAGE = 0x07;
pub const HID_USAGE_PAGE_LED: USAGE = 0x08;
pub const HID_USAGE_PAGE_BUTTON: USAGE = 0x09;
pub const HID_USAGE_PAGE_ORDINAL: USAGE = 0x0A;
pub const HID_USAGE_PAGE_TELEPHONY: USAGE = 0x0B;
pub const HID_USAGE_PAGE_CONSUMER: USAGE = 0x0C;
pub const HID_USAGE_PAGE_DIGITIZER: USAGE = 0x0D;
pub const HID_USAGE_PAGE_UNICODE: USAGE = 0x10;
pub const HID_USAGE_PAGE_ALPHANUMERIC: USAGE = 0x14;
pub const HID_USAGE_PAGE_SENSOR: USAGE = 0x20;
pub const HID_USAGE_PAGE_BARCODE_SCANNER: USAGE = 0x8C;
pub const HID_USAGE_PAGE_WEIGHING_DEVICE: USAGE = 0x8D;
pub const HID_USAGE_PAGE_MAGNETIC_STRIPE_READER: USAGE = 0x8E;
pub const HID_USAGE_PAGE_CAMERA_CONTROL: USAGE = 0x90;
pub const HID_USAGE_PAGE_MICROSOFT_BLUETOOTH_HANDSFREE: USAGE = 0xFFF3;
pub const HID_USAGE_PAGE_VENDOR_DEFINED_BEGIN: USAGE = 0xFF00;
pub const HID_USAGE_PAGE_VENDOR_DEFINED_END: USAGE = 0xFFFF;
pub const HID_USAGE_GENERIC_POINTER: USAGE = 0x01;
pub const HID_USAGE_GENERIC_MOUSE: USAGE = 0x02;
pub const HID_USAGE_GENERIC_JOYSTICK: USAGE = 0x04;
pub const HID_USAGE_GENERIC_GAMEPAD: USAGE = 0x05;
pub const HID_USAGE_GENERIC_KEYBOARD: USAGE = 0x06;
pub const HID_USAGE_GENERIC_KEYPAD: USAGE = 0x07;
pub const HID_USAGE_GENERIC_PORTABLE_DEVICE_CONTROL: USAGE = 0x0D;
pub const HID_USAGE_GENERIC_SYSTEM_CTL: USAGE = 0x80;
pub const HID_USAGE_GENERIC_X: USAGE = 0x30;
pub const HID_USAGE_GENERIC_Y: USAGE = 0x31;
pub const HID_USAGE_GENERIC_Z: USAGE = 0x32;
pub const HID_USAGE_GENERIC_RX: USAGE = 0x33;
pub const HID_USAGE_GENERIC_RY: USAGE = 0x34;
pub const HID_USAGE_GENERIC_RZ: USAGE = 0x35;
pub const HID_USAGE_GENERIC_SLIDER: USAGE = 0x36;
pub const HID_USAGE_GENERIC_DIAL: USAGE = 0x37;
pub const HID_USAGE_GENERIC_WHEEL: USAGE = 0x38;
pub const HID_USAGE_GENERIC_HATSWITCH: USAGE = 0x39;
pub const HID_USAGE_GENERIC_COUNTED_BUFFER: USAGE = 0x3A;
pub const HID_USAGE_GENERIC_BYTE_COUNT: USAGE = 0x3B;
pub const HID_USAGE_GENERIC_MOTION_WAKEUP: USAGE = 0x3C;
pub const HID_USAGE_GENERIC_VX: USAGE = 0x40;
pub const HID_USAGE_GENERIC_VY: USAGE = 0x41;
pub const HID_USAGE_GENERIC_VZ: USAGE = 0x42;
pub const HID_USAGE_GENERIC_VBRX: USAGE = 0x43;
pub const HID_USAGE_GENERIC_VBRY: USAGE = 0x44;
pub const HID_USAGE_GENERIC_VBRZ: USAGE = 0x45;
pub const HID_USAGE_GENERIC_VNO: USAGE = 0x46;
pub const HID_USAGE_GENERIC_RESOLUTION_MULTIPLIER: USAGE = 0x48;
pub const HID_USAGE_GENERIC_SYSCTL_POWER: USAGE = 0x81;
pub const HID_USAGE_GENERIC_SYSCTL_SLEEP: USAGE = 0x82;
pub const HID_USAGE_GENERIC_SYSCTL_WAKE: USAGE = 0x83;
pub const HID_USAGE_GENERIC_SYSCTL_CONTEXT_MENU: USAGE = 0x84;
pub const HID_USAGE_GENERIC_SYSCTL_MAIN_MENU: USAGE = 0x85;
pub const HID_USAGE_GENERIC_SYSCTL_APP_MENU: USAGE = 0x86;
pub const HID_USAGE_GENERIC_SYSCTL_HELP_MENU: USAGE = 0x87;
pub const HID_USAGE_GENERIC_SYSCTL_MENU_EXIT: USAGE = 0x88;
pub const HID_USAGE_GENERIC_SYSCTL_MENU_SELECT: USAGE = 0x89;
pub const HID_USAGE_GENERIC_SYSCTL_MENU_RIGHT: USAGE = 0x8A;
pub const HID_USAGE_GENERIC_SYSCTL_MENU_LEFT: USAGE = 0x8B;
pub const HID_USAGE_GENERIC_SYSCTL_MENU_UP: USAGE = 0x8C;
pub const HID_USAGE_GENERIC_SYSCTL_MENU_DOWN: USAGE = 0x8D;
pub const HID_USAGE_GENERIC_SYSTEM_DISPLAY_ROTATION_LOCK_BUTTON: USAGE = 0xC9;
pub const HID_USAGE_GENERIC_SYSTEM_DISPLAY_ROTATION_LOCK_SLIDER_SWITCH: USAGE = 0xCA;
pub const HID_USAGE_GENERIC_CONTROL_ENABLE: USAGE = 0xCB;
pub const HID_USAGE_SIMULATION_RUDDER: USAGE = 0xBA;
pub const HID_USAGE_SIMULATION_THROTTLE: USAGE = 0xBB;
pub const HID_USAGE_KEYBOARD_NOEVENT: USAGE = 0x00;
pub const HID_USAGE_KEYBOARD_ROLLOVER: USAGE = 0x01;
pub const HID_USAGE_KEYBOARD_POSTFAIL: USAGE = 0x02;
pub const HID_USAGE_KEYBOARD_UNDEFINED: USAGE = 0x03;
pub const HID_USAGE_KEYBOARD_aA: USAGE = 0x04;
pub const HID_USAGE_KEYBOARD_zZ: USAGE = 0x1D;
pub const HID_USAGE_KEYBOARD_ONE: USAGE = 0x1E;
pub const HID_USAGE_KEYBOARD_ZERO: USAGE = 0x27;
pub const HID_USAGE_KEYBOARD_LCTRL: USAGE = 0xE0;
pub const HID_USAGE_KEYBOARD_LSHFT: USAGE = 0xE1;
pub const HID_USAGE_KEYBOARD_LALT: USAGE = 0xE2;
pub const HID_USAGE_KEYBOARD_LGUI: USAGE = 0xE3;
pub const HID_USAGE_KEYBOARD_RCTRL: USAGE = 0xE4;
pub const HID_USAGE_KEYBOARD_RSHFT: USAGE = 0xE5;
pub const HID_USAGE_KEYBOARD_RALT: USAGE = 0xE6;
pub const HID_USAGE_KEYBOARD_RGUI: USAGE = 0xE7;
pub const HID_USAGE_KEYBOARD_SCROLL_LOCK: USAGE = 0x47;
pub const HID_USAGE_KEYBOARD_NUM_LOCK: USAGE = 0x53;
pub const HID_USAGE_KEYBOARD_CAPS_LOCK: USAGE = 0x39;
pub const HID_USAGE_KEYBOARD_F1: USAGE = 0x3A;
pub const HID_USAGE_KEYBOARD_F2: USAGE = 0x3B;
pub const HID_USAGE_KEYBOARD_F3: USAGE = 0x3C;
pub const HID_USAGE_KEYBOARD_F4: USAGE = 0x3D;
pub const HID_USAGE_KEYBOARD_F5: USAGE = 0x3E;
pub const HID_USAGE_KEYBOARD_F6: USAGE = 0x3F;
pub const HID_USAGE_KEYBOARD_F7: USAGE = 0x40;
pub const HID_USAGE_KEYBOARD_F8: USAGE = 0x41;
pub const HID_USAGE_KEYBOARD_F9: USAGE = 0x42;
pub const HID_USAGE_KEYBOARD_F10: USAGE = 0x43;
pub const HID_USAGE_KEYBOARD_F11: USAGE = 0x44;
pub const HID_USAGE_KEYBOARD_F12: USAGE = 0x45;
pub const HID_USAGE_KEYBOARD_F13: USAGE = 0x68;
pub const HID_USAGE_KEYBOARD_F14: USAGE = 0x69;
pub const HID_USAGE_KEYBOARD_F15: USAGE = 0x6A;
pub const HID_USAGE_KEYBOARD_F16: USAGE = 0x6B;
pub const HID_USAGE_KEYBOARD_F17: USAGE = 0x6C;
pub const HID_USAGE_KEYBOARD_F18: USAGE = 0x6D;
pub const HID_USAGE_KEYBOARD_F19: USAGE = 0x6E;
pub const HID_USAGE_KEYBOARD_F20: USAGE = 0x6F;
pub const HID_USAGE_KEYBOARD_F21: USAGE = 0x70;
pub const HID_USAGE_KEYBOARD_F22: USAGE = 0x71;
pub const HID_USAGE_KEYBOARD_F23: USAGE = 0x72;
pub const HID_USAGE_KEYBOARD_F24: USAGE = 0x73;
pub const HID_USAGE_KEYBOARD_RETURN: USAGE = 0x28;
pub const HID_USAGE_KEYBOARD_ESCAPE: USAGE = 0x29;
pub const HID_USAGE_KEYBOARD_DELETE: USAGE = 0x2A;
pub const HID_USAGE_KEYBOARD_PRINT_SCREEN: USAGE = 0x46;
pub const HID_USAGE_KEYBOARD_DELETE_FORWARD: USAGE = 0x4C;
pub const HID_USAGE_LED_NUM_LOCK: USAGE = 0x01;
pub const HID_USAGE_LED_CAPS_LOCK: USAGE = 0x02;
pub const HID_USAGE_LED_SCROLL_LOCK: USAGE = 0x03;
pub const HID_USAGE_LED_COMPOSE: USAGE = 0x04;
pub const HID_USAGE_LED_KANA: USAGE = 0x05;
pub const HID_USAGE_LED_POWER: USAGE = 0x06;
pub const HID_USAGE_LED_SHIFT: USAGE = 0x07;
pub const HID_USAGE_LED_DO_NOT_DISTURB: USAGE = 0x08;
pub const HID_USAGE_LED_MUTE: USAGE = 0x09;
pub const HID_USAGE_LED_TONE_ENABLE: USAGE = 0x0A;
pub const HID_USAGE_LED_HIGH_CUT_FILTER: USAGE = 0x0B;
pub const HID_USAGE_LED_LOW_CUT_FILTER: USAGE = 0x0C;
pub const HID_USAGE_LED_EQUALIZER_ENABLE: USAGE = 0x0D;
pub const HID_USAGE_LED_SOUND_FIELD_ON: USAGE = 0x0E;
pub const HID_USAGE_LED_SURROUND_FIELD_ON: USAGE = 0x0F;
pub const HID_USAGE_LED_REPEAT: USAGE = 0x10;
pub const HID_USAGE_LED_STEREO: USAGE = 0x11;
pub const HID_USAGE_LED_SAMPLING_RATE_DETECT: USAGE = 0x12;
pub const HID_USAGE_LED_SPINNING: USAGE = 0x13;
pub const HID_USAGE_LED_CAV: USAGE = 0x14;
pub const HID_USAGE_LED_CLV: USAGE = 0x15;
pub const HID_USAGE_LED_RECORDING_FORMAT_DET: USAGE = 0x16;
pub const HID_USAGE_LED_OFF_HOOK: USAGE = 0x17;
pub const HID_USAGE_LED_RING: USAGE = 0x18;
pub const HID_USAGE_LED_MESSAGE_WAITING: USAGE = 0x19;
pub const HID_USAGE_LED_DATA_MODE: USAGE = 0x1A;
pub const HID_USAGE_LED_BATTERY_OPERATION: USAGE = 0x1B;
pub const HID_USAGE_LED_BATTERY_OK: USAGE = 0x1C;
pub const HID_USAGE_LED_BATTERY_LOW: USAGE = 0x1D;
pub const HID_USAGE_LED_SPEAKER: USAGE = 0x1E;
pub const HID_USAGE_LED_HEAD_SET: USAGE = 0x1F;
pub const HID_USAGE_LED_HOLD: USAGE = 0x20;
pub const HID_USAGE_LED_MICROPHONE: USAGE = 0x21;
pub const HID_USAGE_LED_COVERAGE: USAGE = 0x22;
pub const HID_USAGE_LED_NIGHT_MODE: USAGE = 0x23;
pub const HID_USAGE_LED_SEND_CALLS: USAGE = 0x24;
pub const HID_USAGE_LED_CALL_PICKUP: USAGE = 0x25;
pub const HID_USAGE_LED_CONFERENCE: USAGE = 0x26;
pub const HID_USAGE_LED_STAND_BY: USAGE = 0x27;
pub const HID_USAGE_LED_CAMERA_ON: USAGE = 0x28;
pub const HID_USAGE_LED_CAMERA_OFF: USAGE = 0x29;
pub const HID_USAGE_LED_ON_LINE: USAGE = 0x2A;
pub const HID_USAGE_LED_OFF_LINE: USAGE = 0x2B;
pub const HID_USAGE_LED_BUSY: USAGE = 0x2C;
pub const HID_USAGE_LED_READY: USAGE = 0x2D;
pub const HID_USAGE_LED_PAPER_OUT: USAGE = 0x2E;
pub const HID_USAGE_LED_PAPER_JAM: USAGE = 0x2F;
pub const HID_USAGE_LED_REMOTE: USAGE = 0x30;
pub const HID_USAGE_LED_FORWARD: USAGE = 0x31;
pub const HID_USAGE_LED_REVERSE: USAGE = 0x32;
pub const HID_USAGE_LED_STOP: USAGE = 0x33;
pub const HID_USAGE_LED_REWIND: USAGE = 0x34;
pub const HID_USAGE_LED_FAST_FORWARD: USAGE = 0x35;
pub const HID_USAGE_LED_PLAY: USAGE = 0x36;
pub const HID_USAGE_LED_PAUSE: USAGE = 0x37;
pub const HID_USAGE_LED_RECORD: USAGE = 0x38;
pub const HID_USAGE_LED_ERROR: USAGE = 0x39;
pub const HID_USAGE_LED_SELECTED_INDICATOR: USAGE = 0x3A;
pub const HID_USAGE_LED_IN_USE_INDICATOR: USAGE = 0x3B;
pub const HID_USAGE_LED_MULTI_MODE_INDICATOR: USAGE = 0x3C;
pub const HID_USAGE_LED_INDICATOR_ON: USAGE = 0x3D;
pub const HID_USAGE_LED_INDICATOR_FLASH: USAGE = 0x3E;
pub const HID_USAGE_LED_INDICATOR_SLOW_BLINK: USAGE = 0x3F;
pub const HID_USAGE_LED_INDICATOR_FAST_BLINK: USAGE = 0x40;
pub const HID_USAGE_LED_INDICATOR_OFF: USAGE = 0x41;
pub const HID_USAGE_LED_FLASH_ON_TIME: USAGE = 0x42;
pub const HID_USAGE_LED_SLOW_BLINK_ON_TIME: USAGE = 0x43;
pub const HID_USAGE_LED_SLOW_BLINK_OFF_TIME: USAGE = 0x44;
pub const HID_USAGE_LED_FAST_BLINK_ON_TIME: USAGE = 0x45;
pub const HID_USAGE_LED_FAST_BLINK_OFF_TIME: USAGE = 0x46;
pub const HID_USAGE_LED_INDICATOR_COLOR: USAGE = 0x47;
pub const HID_USAGE_LED_RED: USAGE = 0x48;
pub const HID_USAGE_LED_GREEN: USAGE = 0x49;
pub const HID_USAGE_LED_AMBER: USAGE = 0x4A;
pub const HID_USAGE_LED_GENERIC_INDICATOR: USAGE = 0x4B;
pub const HID_USAGE_TELEPHONY_PHONE: USAGE = 0x01;
pub const HID_USAGE_TELEPHONY_ANSWERING_MACHINE: USAGE = 0x02;
pub const HID_USAGE_TELEPHONY_MESSAGE_CONTROLS: USAGE = 0x03;
pub const HID_USAGE_TELEPHONY_HANDSET: USAGE = 0x04;
pub const HID_USAGE_TELEPHONY_HEADSET: USAGE = 0x05;
pub const HID_USAGE_TELEPHONY_KEYPAD: USAGE = 0x06;
pub const HID_USAGE_TELEPHONY_PROGRAMMABLE_BUTTON: USAGE = 0x07;
pub const HID_USAGE_TELEPHONY_REDIAL: USAGE = 0x24;
pub const HID_USAGE_TELEPHONY_TRANSFER: USAGE = 0x25;
pub const HID_USAGE_TELEPHONY_DROP: USAGE = 0x26;
pub const HID_USAGE_TELEPHONY_LINE: USAGE = 0x2A;
pub const HID_USAGE_TELEPHONY_RING_ENABLE: USAGE = 0x2D;
pub const HID_USAGE_TELEPHONY_SEND: USAGE = 0x31;
pub const HID_USAGE_TELEPHONY_KEYPAD_0: USAGE = 0xB0;
pub const HID_USAGE_TELEPHONY_KEYPAD_D: USAGE = 0xBF;
pub const HID_USAGE_TELEPHONY_HOST_AVAILABLE: USAGE = 0xF1;
pub const HID_USAGE_CONSUMERCTRL: USAGE = 0x01;
pub const HID_USAGE_CONSUMER_CHANNEL_INCREMENT: USAGE = 0x9C;
pub const HID_USAGE_CONSUMER_CHANNEL_DECREMENT: USAGE = 0x9D;
pub const HID_USAGE_CONSUMER_PLAY: USAGE = 0xB0;
pub const HID_USAGE_CONSUMER_PAUSE: USAGE = 0xB1;
pub const HID_USAGE_CONSUMER_RECORD: USAGE = 0xB2;
pub const HID_USAGE_CONSUMER_FAST_FORWARD: USAGE = 0xB3;
pub const HID_USAGE_CONSUMER_REWIND: USAGE = 0xB4;
pub const HID_USAGE_CONSUMER_SCAN_NEXT_TRACK: USAGE = 0xB5;
pub const HID_USAGE_CONSUMER_SCAN_PREV_TRACK: USAGE = 0xB6;
pub const HID_USAGE_CONSUMER_STOP: USAGE = 0xB7;
pub const HID_USAGE_CONSUMER_PLAY_PAUSE: USAGE = 0xCD;
pub const HID_USAGE_CONSUMER_VOLUME: USAGE = 0xE0;
pub const HID_USAGE_CONSUMER_BALANCE: USAGE = 0xE1;
pub const HID_USAGE_CONSUMER_MUTE: USAGE = 0xE2;
pub const HID_USAGE_CONSUMER_BASS: USAGE = 0xE3;
pub const HID_USAGE_CONSUMER_TREBLE: USAGE = 0xE4;
pub const HID_USAGE_CONSUMER_BASS_BOOST: USAGE = 0xE5;
pub const HID_USAGE_CONSUMER_SURROUND_MODE: USAGE = 0xE6;
pub const HID_USAGE_CONSUMER_LOUDNESS: USAGE = 0xE7;
pub const HID_USAGE_CONSUMER_MPX: USAGE = 0xE8;
pub const HID_USAGE_CONSUMER_VOLUME_INCREMENT: USAGE = 0xE9;
pub const HID_USAGE_CONSUMER_VOLUME_DECREMENT: USAGE = 0xEA;
pub const HID_USAGE_CONSUMER_BASS_INCREMENT: USAGE = 0x152;
pub const HID_USAGE_CONSUMER_BASS_DECREMENT: USAGE = 0x153;
pub const HID_USAGE_CONSUMER_TREBLE_INCREMENT: USAGE = 0x154;
pub const HID_USAGE_CONSUMER_TREBLE_DECREMENT: USAGE = 0x155;
pub const HID_USAGE_CONSUMER_AL_CONFIGURATION: USAGE = 0x183;
pub const HID_USAGE_CONSUMER_AL_EMAIL: USAGE = 0x18A;
pub const HID_USAGE_CONSUMER_AL_CALCULATOR: USAGE = 0x192;
pub const HID_USAGE_CONSUMER_AL_BROWSER: USAGE = 0x194;
pub const HID_USAGE_CONSUMER_AC_SEARCH: USAGE = 0x221;
pub const HID_USAGE_CONSUMER_AC_GOTO: USAGE = 0x222;
pub const HID_USAGE_CONSUMER_AC_HOME: USAGE = 0x223;
pub const HID_USAGE_CONSUMER_AC_BACK: USAGE = 0x224;
pub const HID_USAGE_CONSUMER_AC_FORWARD: USAGE = 0x225;
pub const HID_USAGE_CONSUMER_AC_STOP: USAGE = 0x226;
pub const HID_USAGE_CONSUMER_AC_REFRESH: USAGE = 0x227;
pub const HID_USAGE_CONSUMER_AC_PREVIOUS: USAGE = 0x228;
pub const HID_USAGE_CONSUMER_AC_NEXT: USAGE = 0x229;
pub const HID_USAGE_CONSUMER_AC_BOOKMARKS: USAGE = 0x22A;
pub const HID_USAGE_CONSUMER_AC_PAN: USAGE = 0x238;
pub const HID_USAGE_CONSUMER_EXTENDED_KEYBOARD_ATTRIBUTES_COLLECTION: USAGE = 0x2C0;
pub const HID_USAGE_CONSUMER_KEYBOARD_FORM_FACTOR: USAGE = 0x2C1;
pub const HID_USAGE_CONSUMER_KEYBOARD_KEY_TYPE: USAGE = 0x2C2;
pub const HID_USAGE_CONSUMER_KEYBOARD_PHYSICAL_LAYOUT: USAGE = 0x2C3;
pub const HID_USAGE_CONSUMER_VENDOR_SPECIFIC_KEYBOARD_PHYSICAL_LAYOUT: USAGE = 0x2C4;
pub const HID_USAGE_CONSUMER_KEYBOARD_IETF_LANGUAGE_TAG_INDEX: USAGE = 0x2C5;
pub const HID_USAGE_CONSUMER_IMPLEMENTED_KEYBOARD_INPUT_ASSIST_CONTROLS: USAGE = 0x2C6;
pub const HID_USAGE_DIGITIZER_PEN: USAGE = 0x02;
pub const HID_USAGE_DIGITIZER_IN_RANGE: USAGE = 0x32;
pub const HID_USAGE_DIGITIZER_TIP_SWITCH: USAGE = 0x42;
pub const HID_USAGE_DIGITIZER_BARREL_SWITCH: USAGE = 0x44;
pub const HID_USAGE_CAMERA_AUTO_FOCUS: USAGE = 0x20;
pub const HID_USAGE_CAMERA_SHUTTER: USAGE = 0x21;
pub const HID_USAGE_MS_BTH_HF_DIALNUMBER: USAGE = 0x21;
pub const HID_USAGE_MS_BTH_HF_DIALMEMORY: USAGE = 0x22;
