# encoding: UTF-8

# IdnaMappingTable-9.0.0.txt
# Date: 2016-06-16, 13:35:01 GMT
# © 2016 Unicode®, Inc.
# Unicode and the Unicode Logo are registered trademarks of Unicode, Inc. in the U.S. and other countries.
# For terms of use, see http://www.unicode.org/terms_of_use.html
#
# Unicode IDNA Compatible Preprocessing (UTS #46)
# For documentation, see http://www.unicode.org/reports/tr46/
# Total code points: 1114112

module SimpleIDN
  UTS64MAPPING = {
    65 => 97,
    66 => 98,
    67 => 99,
    68 => 100,
    69 => 101,
    70 => 102,
    71 => 103,
    72 => 104,
    73 => 105,
    74 => 106,
    75 => 107,
    76 => 108,
    77 => 109,
    78 => 110,
    79 => 111,
    80 => 112,
    81 => 113,
    82 => 114,
    83 => 115,
    84 => 116,
    85 => 117,
    86 => 118,
    87 => 119,
    88 => 120,
    89 => 121,
    90 => 122,
    160 => 32,
    168 => [32, 776],
    170 => 97,
    173 => [],
    175 => [32, 772],
    178 => 50,
    179 => 51,
    180 => [32, 769],
    181 => 956,
    184 => [32, 807],
    185 => 49,
    186 => 111,
    188 => [49, 8260, 52],
    189 => [49, 8260, 50],
    190 => [51, 8260, 52],
    192 => 224,
    193 => 225,
    194 => 226,
    195 => 227,
    196 => 228,
    197 => 229,
    198 => 230,
    199 => 231,
    200 => 232,
    201 => 233,
    202 => 234,
    203 => 235,
    204 => 236,
    205 => 237,
    206 => 238,
    207 => 239,
    208 => 240,
    209 => 241,
    210 => 242,
    211 => 243,
    212 => 244,
    213 => 245,
    214 => 246,
    216 => 248,
    217 => 249,
    218 => 250,
    219 => 251,
    220 => 252,
    221 => 253,
    222 => 254,
    256 => 257,
    258 => 259,
    260 => 261,
    262 => 263,
    264 => 265,
    266 => 267,
    268 => 269,
    270 => 271,
    272 => 273,
    274 => 275,
    276 => 277,
    278 => 279,
    280 => 281,
    282 => 283,
    284 => 285,
    286 => 287,
    288 => 289,
    290 => 291,
    292 => 293,
    294 => 295,
    296 => 297,
    298 => 299,
    300 => 301,
    302 => 303,
    304 => [105, 775],
    306 => [105, 106],
    307 => [105, 106],
    308 => 309,
    310 => 311,
    313 => 314,
    315 => 316,
    317 => 318,
    319 => [108, 183],
    320 => [108, 183],
    321 => 322,
    323 => 324,
    325 => 326,
    327 => 328,
    329 => [700, 110],
    330 => 331,
    332 => 333,
    334 => 335,
    336 => 337,
    338 => 339,
    340 => 341,
    342 => 343,
    344 => 345,
    346 => 347,
    348 => 349,
    350 => 351,
    352 => 353,
    354 => 355,
    356 => 357,
    358 => 359,
    360 => 361,
    362 => 363,
    364 => 365,
    366 => 367,
    368 => 369,
    370 => 371,
    372 => 373,
    374 => 375,
    376 => 255,
    377 => 378,
    379 => 380,
    381 => 382,
    383 => 115,
    385 => 595,
    386 => 387,
    388 => 389,
    390 => 596,
    391 => 392,
    393 => 598,
    394 => 599,
    395 => 396,
    398 => 477,
    399 => 601,
    400 => 603,
    401 => 402,
    403 => 608,
    404 => 611,
    406 => 617,
    407 => 616,
    408 => 409,
    412 => 623,
    413 => 626,
    415 => 629,
    416 => 417,
    418 => 419,
    420 => 421,
    422 => 640,
    423 => 424,
    425 => 643,
    428 => 429,
    430 => 648,
    431 => 432,
    433 => 650,
    434 => 651,
    435 => 436,
    437 => 438,
    439 => 658,
    440 => 441,
    444 => 445,
    452 => [100, 382],
    453 => [100, 382],
    454 => [100, 382],
    455 => [108, 106],
    456 => [108, 106],
    457 => [108, 106],
    458 => [110, 106],
    459 => [110, 106],
    460 => [110, 106],
    461 => 462,
    463 => 464,
    465 => 466,
    467 => 468,
    469 => 470,
    471 => 472,
    473 => 474,
    475 => 476,
    478 => 479,
    480 => 481,
    482 => 483,
    484 => 485,
    486 => 487,
    488 => 489,
    490 => 491,
    492 => 493,
    494 => 495,
    497 => [100, 122],
    498 => [100, 122],
    499 => [100, 122],
    500 => 501,
    502 => 405,
    503 => 447,
    504 => 505,
    506 => 507,
    508 => 509,
    510 => 511,
    512 => 513,
    514 => 515,
    516 => 517,
    518 => 519,
    520 => 521,
    522 => 523,
    524 => 525,
    526 => 527,
    528 => 529,
    530 => 531,
    532 => 533,
    534 => 535,
    536 => 537,
    538 => 539,
    540 => 541,
    542 => 543,
    544 => 414,
    546 => 547,
    548 => 549,
    550 => 551,
    552 => 553,
    554 => 555,
    556 => 557,
    558 => 559,
    560 => 561,
    562 => 563,
    570 => 11365,
    571 => 572,
    573 => 410,
    574 => 11366,
    577 => 578,
    579 => 384,
    580 => 649,
    581 => 652,
    582 => 583,
    584 => 585,
    586 => 587,
    588 => 589,
    590 => 591,
    688 => 104,
    689 => 614,
    690 => 106,
    691 => 114,
    692 => 633,
    693 => 635,
    694 => 641,
    695 => 119,
    696 => 121,
    728 => [32, 774],
    729 => [32, 775],
    730 => [32, 778],
    731 => [32, 808],
    732 => [32, 771],
    733 => [32, 779],
    736 => 611,
    737 => 108,
    738 => 115,
    739 => 120,
    740 => 661,
    832 => 768,
    833 => 769,
    835 => 787,
    836 => [776, 769],
    837 => 953,
    847 => [],
    880 => 881,
    882 => 883,
    884 => 697,
    886 => 887,
    890 => [32, 953],
    894 => 59,
    895 => 1011,
    900 => [32, 769],
    901 => [32, 776, 769],
    902 => 940,
    903 => 183,
    904 => 941,
    905 => 942,
    906 => 943,
    908 => 972,
    910 => 973,
    911 => 974,
    913 => 945,
    914 => 946,
    915 => 947,
    916 => 948,
    917 => 949,
    918 => 950,
    919 => 951,
    920 => 952,
    921 => 953,
    922 => 954,
    923 => 955,
    924 => 956,
    925 => 957,
    926 => 958,
    927 => 959,
    928 => 960,
    929 => 961,
    931 => 963,
    932 => 964,
    933 => 965,
    934 => 966,
    935 => 967,
    936 => 968,
    937 => 969,
    938 => 970,
    939 => 971,
    975 => 983,
    976 => 946,
    977 => 952,
    978 => 965,
    979 => 973,
    980 => 971,
    981 => 966,
    982 => 960,
    984 => 985,
    986 => 987,
    988 => 989,
    990 => 991,
    992 => 993,
    994 => 995,
    996 => 997,
    998 => 999,
    1000 => 1001,
    1002 => 1003,
    1004 => 1005,
    1006 => 1007,
    1008 => 954,
    1009 => 961,
    1010 => 963,
    1012 => 952,
    1013 => 949,
    1015 => 1016,
    1017 => 963,
    1018 => 1019,
    1021 => 891,
    1022 => 892,
    1023 => 893,
    1024 => 1104,
    1025 => 1105,
    1026 => 1106,
    1027 => 1107,
    1028 => 1108,
    1029 => 1109,
    1030 => 1110,
    1031 => 1111,
    1032 => 1112,
    1033 => 1113,
    1034 => 1114,
    1035 => 1115,
    1036 => 1116,
    1037 => 1117,
    1038 => 1118,
    1039 => 1119,
    1040 => 1072,
    1041 => 1073,
    1042 => 1074,
    1043 => 1075,
    1044 => 1076,
    1045 => 1077,
    1046 => 1078,
    1047 => 1079,
    1048 => 1080,
    1049 => 1081,
    1050 => 1082,
    1051 => 1083,
    1052 => 1084,
    1053 => 1085,
    1054 => 1086,
    1055 => 1087,
    1056 => 1088,
    1057 => 1089,
    1058 => 1090,
    1059 => 1091,
    1060 => 1092,
    1061 => 1093,
    1062 => 1094,
    1063 => 1095,
    1064 => 1096,
    1065 => 1097,
    1066 => 1098,
    1067 => 1099,
    1068 => 1100,
    1069 => 1101,
    1070 => 1102,
    1071 => 1103,
    1120 => 1121,
    1122 => 1123,
    1124 => 1125,
    1126 => 1127,
    1128 => 1129,
    1130 => 1131,
    1132 => 1133,
    1134 => 1135,
    1136 => 1137,
    1138 => 1139,
    1140 => 1141,
    1142 => 1143,
    1144 => 1145,
    1146 => 1147,
    1148 => 1149,
    1150 => 1151,
    1152 => 1153,
    1162 => 1163,
    1164 => 1165,
    1166 => 1167,
    1168 => 1169,
    1170 => 1171,
    1172 => 1173,
    1174 => 1175,
    1176 => 1177,
    1178 => 1179,
    1180 => 1181,
    1182 => 1183,
    1184 => 1185,
    1186 => 1187,
    1188 => 1189,
    1190 => 1191,
    1192 => 1193,
    1194 => 1195,
    1196 => 1197,
    1198 => 1199,
    1200 => 1201,
    1202 => 1203,
    1204 => 1205,
    1206 => 1207,
    1208 => 1209,
    1210 => 1211,
    1212 => 1213,
    1214 => 1215,
    1217 => 1218,
    1219 => 1220,
    1221 => 1222,
    1223 => 1224,
    1225 => 1226,
    1227 => 1228,
    1229 => 1230,
    1232 => 1233,
    1234 => 1235,
    1236 => 1237,
    1238 => 1239,
    1240 => 1241,
    1242 => 1243,
    1244 => 1245,
    1246 => 1247,
    1248 => 1249,
    1250 => 1251,
    1252 => 1253,
    1254 => 1255,
    1256 => 1257,
    1258 => 1259,
    1260 => 1261,
    1262 => 1263,
    1264 => 1265,
    1266 => 1267,
    1268 => 1269,
    1270 => 1271,
    1272 => 1273,
    1274 => 1275,
    1276 => 1277,
    1278 => 1279,
    1280 => 1281,
    1282 => 1283,
    1284 => 1285,
    1286 => 1287,
    1288 => 1289,
    1290 => 1291,
    1292 => 1293,
    1294 => 1295,
    1296 => 1297,
    1298 => 1299,
    1300 => 1301,
    1302 => 1303,
    1304 => 1305,
    1306 => 1307,
    1308 => 1309,
    1310 => 1311,
    1312 => 1313,
    1314 => 1315,
    1316 => 1317,
    1318 => 1319,
    1320 => 1321,
    1322 => 1323,
    1324 => 1325,
    1326 => 1327,
    1329 => 1377,
    1330 => 1378,
    1331 => 1379,
    1332 => 1380,
    1333 => 1381,
    1334 => 1382,
    1335 => 1383,
    1336 => 1384,
    1337 => 1385,
    1338 => 1386,
    1339 => 1387,
    1340 => 1388,
    1341 => 1389,
    1342 => 1390,
    1343 => 1391,
    1344 => 1392,
    1345 => 1393,
    1346 => 1394,
    1347 => 1395,
    1348 => 1396,
    1349 => 1397,
    1350 => 1398,
    1351 => 1399,
    1352 => 1400,
    1353 => 1401,
    1354 => 1402,
    1355 => 1403,
    1356 => 1404,
    1357 => 1405,
    1358 => 1406,
    1359 => 1407,
    1360 => 1408,
    1361 => 1409,
    1362 => 1410,
    1363 => 1411,
    1364 => 1412,
    1365 => 1413,
    1366 => 1414,
    1415 => [1381, 1410],
    1653 => [1575, 1652],
    1654 => [1608, 1652],
    1655 => [1735, 1652],
    1656 => [1610, 1652],
    2392 => [2325, 2364],
    2393 => [2326, 2364],
    2394 => [2327, 2364],
    2395 => [2332, 2364],
    2396 => [2337, 2364],
    2397 => [2338, 2364],
    2398 => [2347, 2364],
    2399 => [2351, 2364],
    2524 => [2465, 2492],
    2525 => [2466, 2492],
    2527 => [2479, 2492],
    2611 => [2610, 2620],
    2614 => [2616, 2620],
    2649 => [2582, 2620],
    2650 => [2583, 2620],
    2651 => [2588, 2620],
    2654 => [2603, 2620],
    2908 => [2849, 2876],
    2909 => [2850, 2876],
    3635 => [3661, 3634],
    3763 => [3789, 3762],
    3804 => [3755, 3737],
    3805 => [3755, 3745],
    3852 => 3851,
    3907 => [3906, 4023],
    3917 => [3916, 4023],
    3922 => [3921, 4023],
    3927 => [3926, 4023],
    3932 => [3931, 4023],
    3945 => [3904, 4021],
    3955 => [3953, 3954],
    3957 => [3953, 3956],
    3958 => [4018, 3968],
    3959 => [4018, 3953, 3968],
    3960 => [4019, 3968],
    3961 => [4019, 3953, 3968],
    3969 => [3953, 3968],
    3987 => [3986, 4023],
    3997 => [3996, 4023],
    4002 => [4001, 4023],
    4007 => [4006, 4023],
    4012 => [4011, 4023],
    4025 => [3984, 4021],
    4295 => 11559,
    4301 => 11565,
    4348 => 4316,
    5112 => 5104,
    5113 => 5105,
    5114 => 5106,
    5115 => 5107,
    5116 => 5108,
    5117 => 5109,
    6155 => [],
    6156 => [],
    6157 => [],
    7296 => 1074,
    7297 => 1076,
    7298 => 1086,
    7299 => 1089,
    7300 => 1090,
    7301 => 1090,
    7302 => 1098,
    7303 => 1123,
    7304 => 42571,
    7468 => 97,
    7469 => 230,
    7470 => 98,
    7472 => 100,
    7473 => 101,
    7474 => 477,
    7475 => 103,
    7476 => 104,
    7477 => 105,
    7478 => 106,
    7479 => 107,
    7480 => 108,
    7481 => 109,
    7482 => 110,
    7484 => 111,
    7485 => 547,
    7486 => 112,
    7487 => 114,
    7488 => 116,
    7489 => 117,
    7490 => 119,
    7491 => 97,
    7492 => 592,
    7493 => 593,
    7494 => 7426,
    7495 => 98,
    7496 => 100,
    7497 => 101,
    7498 => 601,
    7499 => 603,
    7500 => 604,
    7501 => 103,
    7503 => 107,
    7504 => 109,
    7505 => 331,
    7506 => 111,
    7507 => 596,
    7508 => 7446,
    7509 => 7447,
    7510 => 112,
    7511 => 116,
    7512 => 117,
    7513 => 7453,
    7514 => 623,
    7515 => 118,
    7516 => 7461,
    7517 => 946,
    7518 => 947,
    7519 => 948,
    7520 => 966,
    7521 => 967,
    7522 => 105,
    7523 => 114,
    7524 => 117,
    7525 => 118,
    7526 => 946,
    7527 => 947,
    7528 => 961,
    7529 => 966,
    7530 => 967,
    7544 => 1085,
    7579 => 594,
    7580 => 99,
    7581 => 597,
    7582 => 240,
    7583 => 604,
    7584 => 102,
    7585 => 607,
    7586 => 609,
    7587 => 613,
    7588 => 616,
    7589 => 617,
    7590 => 618,
    7591 => 7547,
    7592 => 669,
    7593 => 621,
    7594 => 7557,
    7595 => 671,
    7596 => 625,
    7597 => 624,
    7598 => 626,
    7599 => 627,
    7600 => 628,
    7601 => 629,
    7602 => 632,
    7603 => 642,
    7604 => 643,
    7605 => 427,
    7606 => 649,
    7607 => 650,
    7608 => 7452,
    7609 => 651,
    7610 => 652,
    7611 => 122,
    7612 => 656,
    7613 => 657,
    7614 => 658,
    7615 => 952,
    7680 => 7681,
    7682 => 7683,
    7684 => 7685,
    7686 => 7687,
    7688 => 7689,
    7690 => 7691,
    7692 => 7693,
    7694 => 7695,
    7696 => 7697,
    7698 => 7699,
    7700 => 7701,
    7702 => 7703,
    7704 => 7705,
    7706 => 7707,
    7708 => 7709,
    7710 => 7711,
    7712 => 7713,
    7714 => 7715,
    7716 => 7717,
    7718 => 7719,
    7720 => 7721,
    7722 => 7723,
    7724 => 7725,
    7726 => 7727,
    7728 => 7729,
    7730 => 7731,
    7732 => 7733,
    7734 => 7735,
    7736 => 7737,
    7738 => 7739,
    7740 => 7741,
    7742 => 7743,
    7744 => 7745,
    7746 => 7747,
    7748 => 7749,
    7750 => 7751,
    7752 => 7753,
    7754 => 7755,
    7756 => 7757,
    7758 => 7759,
    7760 => 7761,
    7762 => 7763,
    7764 => 7765,
    7766 => 7767,
    7768 => 7769,
    7770 => 7771,
    7772 => 7773,
    7774 => 7775,
    7776 => 7777,
    7778 => 7779,
    7780 => 7781,
    7782 => 7783,
    7784 => 7785,
    7786 => 7787,
    7788 => 7789,
    7790 => 7791,
    7792 => 7793,
    7794 => 7795,
    7796 => 7797,
    7798 => 7799,
    7800 => 7801,
    7802 => 7803,
    7804 => 7805,
    7806 => 7807,
    7808 => 7809,
    7810 => 7811,
    7812 => 7813,
    7814 => 7815,
    7816 => 7817,
    7818 => 7819,
    7820 => 7821,
    7822 => 7823,
    7824 => 7825,
    7826 => 7827,
    7828 => 7829,
    7834 => [97, 702],
    7835 => 7777,
    7838 => [115, 115],
    7840 => 7841,
    7842 => 7843,
    7844 => 7845,
    7846 => 7847,
    7848 => 7849,
    7850 => 7851,
    7852 => 7853,
    7854 => 7855,
    7856 => 7857,
    7858 => 7859,
    7860 => 7861,
    7862 => 7863,
    7864 => 7865,
    7866 => 7867,
    7868 => 7869,
    7870 => 7871,
    7872 => 7873,
    7874 => 7875,
    7876 => 7877,
    7878 => 7879,
    7880 => 7881,
    7882 => 7883,
    7884 => 7885,
    7886 => 7887,
    7888 => 7889,
    7890 => 7891,
    7892 => 7893,
    7894 => 7895,
    7896 => 7897,
    7898 => 7899,
    7900 => 7901,
    7902 => 7903,
    7904 => 7905,
    7906 => 7907,
    7908 => 7909,
    7910 => 7911,
    7912 => 7913,
    7914 => 7915,
    7916 => 7917,
    7918 => 7919,
    7920 => 7921,
    7922 => 7923,
    7924 => 7925,
    7926 => 7927,
    7928 => 7929,
    7930 => 7931,
    7932 => 7933,
    7934 => 7935,
    7944 => 7936,
    7945 => 7937,
    7946 => 7938,
    7947 => 7939,
    7948 => 7940,
    7949 => 7941,
    7950 => 7942,
    7951 => 7943,
    7960 => 7952,
    7961 => 7953,
    7962 => 7954,
    7963 => 7955,
    7964 => 7956,
    7965 => 7957,
    7976 => 7968,
    7977 => 7969,
    7978 => 7970,
    7979 => 7971,
    7980 => 7972,
    7981 => 7973,
    7982 => 7974,
    7983 => 7975,
    7992 => 7984,
    7993 => 7985,
    7994 => 7986,
    7995 => 7987,
    7996 => 7988,
    7997 => 7989,
    7998 => 7990,
    7999 => 7991,
    8008 => 8000,
    8009 => 8001,
    8010 => 8002,
    8011 => 8003,
    8012 => 8004,
    8013 => 8005,
    8025 => 8017,
    8027 => 8019,
    8029 => 8021,
    8031 => 8023,
    8040 => 8032,
    8041 => 8033,
    8042 => 8034,
    8043 => 8035,
    8044 => 8036,
    8045 => 8037,
    8046 => 8038,
    8047 => 8039,
    8049 => 940,
    8051 => 941,
    8053 => 942,
    8055 => 943,
    8057 => 972,
    8059 => 973,
    8061 => 974,
    8064 => [7936, 953],
    8065 => [7937, 953],
    8066 => [7938, 953],
    8067 => [7939, 953],
    8068 => [7940, 953],
    8069 => [7941, 953],
    8070 => [7942, 953],
    8071 => [7943, 953],
    8072 => [7936, 953],
    8073 => [7937, 953],
    8074 => [7938, 953],
    8075 => [7939, 953],
    8076 => [7940, 953],
    8077 => [7941, 953],
    8078 => [7942, 953],
    8079 => [7943, 953],
    8080 => [7968, 953],
    8081 => [7969, 953],
    8082 => [7970, 953],
    8083 => [7971, 953],
    8084 => [7972, 953],
    8085 => [7973, 953],
    8086 => [7974, 953],
    8087 => [7975, 953],
    8088 => [7968, 953],
    8089 => [7969, 953],
    8090 => [7970, 953],
    8091 => [7971, 953],
    8092 => [7972, 953],
    8093 => [7973, 953],
    8094 => [7974, 953],
    8095 => [7975, 953],
    8096 => [8032, 953],
    8097 => [8033, 953],
    8098 => [8034, 953],
    8099 => [8035, 953],
    8100 => [8036, 953],
    8101 => [8037, 953],
    8102 => [8038, 953],
    8103 => [8039, 953],
    8104 => [8032, 953],
    8105 => [8033, 953],
    8106 => [8034, 953],
    8107 => [8035, 953],
    8108 => [8036, 953],
    8109 => [8037, 953],
    8110 => [8038, 953],
    8111 => [8039, 953],
    8114 => [8048, 953],
    8115 => [945, 953],
    8116 => [940, 953],
    8119 => [8118, 953],
    8120 => 8112,
    8121 => 8113,
    8122 => 8048,
    8123 => 940,
    8124 => [945, 953],
    8125 => [32, 787],
    8126 => 953,
    8127 => [32, 787],
    8128 => [32, 834],
    8129 => [32, 776, 834],
    8130 => [8052, 953],
    8131 => [951, 953],
    8132 => [942, 953],
    8135 => [8134, 953],
    8136 => 8050,
    8137 => 941,
    8138 => 8052,
    8139 => 942,
    8140 => [951, 953],
    8141 => [32, 787, 768],
    8142 => [32, 787, 769],
    8143 => [32, 787, 834],
    8147 => 912,
    8152 => 8144,
    8153 => 8145,
    8154 => 8054,
    8155 => 943,
    8157 => [32, 788, 768],
    8158 => [32, 788, 769],
    8159 => [32, 788, 834],
    8163 => 944,
    8168 => 8160,
    8169 => 8161,
    8170 => 8058,
    8171 => 973,
    8172 => 8165,
    8173 => [32, 776, 768],
    8174 => [32, 776, 769],
    8175 => 96,
    8178 => [8060, 953],
    8179 => [969, 953],
    8180 => [974, 953],
    8183 => [8182, 953],
    8184 => 8056,
    8185 => 972,
    8186 => 8060,
    8187 => 974,
    8188 => [969, 953],
    8189 => [32, 769],
    8190 => [32, 788],
    8192 => 32,
    8193 => 32,
    8194 => 32,
    8195 => 32,
    8196 => 32,
    8197 => 32,
    8198 => 32,
    8199 => 32,
    8200 => 32,
    8201 => 32,
    8202 => 32,
    8203 => [],
    8209 => 8208,
    8215 => [32, 819],
    8239 => 32,
    8243 => [8242, 8242],
    8244 => [8242, 8242, 8242],
    8246 => [8245, 8245],
    8247 => [8245, 8245, 8245],
    8252 => [33, 33],
    8254 => [32, 773],
    8263 => [63, 63],
    8264 => [63, 33],
    8265 => [33, 63],
    8279 => [8242, 8242, 8242, 8242],
    8287 => 32,
    8288 => [],
    8292 => [],
    8304 => 48,
    8305 => 105,
    8308 => 52,
    8309 => 53,
    8310 => 54,
    8311 => 55,
    8312 => 56,
    8313 => 57,
    8314 => 43,
    8315 => 8722,
    8316 => 61,
    8317 => 40,
    8318 => 41,
    8319 => 110,
    8320 => 48,
    8321 => 49,
    8322 => 50,
    8323 => 51,
    8324 => 52,
    8325 => 53,
    8326 => 54,
    8327 => 55,
    8328 => 56,
    8329 => 57,
    8330 => 43,
    8331 => 8722,
    8332 => 61,
    8333 => 40,
    8334 => 41,
    8336 => 97,
    8337 => 101,
    8338 => 111,
    8339 => 120,
    8340 => 601,
    8341 => 104,
    8342 => 107,
    8343 => 108,
    8344 => 109,
    8345 => 110,
    8346 => 112,
    8347 => 115,
    8348 => 116,
    8360 => [114, 115],
    8448 => [97, 47, 99],
    8449 => [97, 47, 115],
    8450 => 99,
    8451 => [176, 99],
    8453 => [99, 47, 111],
    8454 => [99, 47, 117],
    8455 => 603,
    8457 => [176, 102],
    8458 => 103,
    8459 => 104,
    8460 => 104,
    8461 => 104,
    8462 => 104,
    8463 => 295,
    8464 => 105,
    8465 => 105,
    8466 => 108,
    8467 => 108,
    8469 => 110,
    8470 => [110, 111],
    8473 => 112,
    8474 => 113,
    8475 => 114,
    8476 => 114,
    8477 => 114,
    8480 => [115, 109],
    8481 => [116, 101, 108],
    8482 => [116, 109],
    8484 => 122,
    8486 => 969,
    8488 => 122,
    8490 => 107,
    8491 => 229,
    8492 => 98,
    8493 => 99,
    8495 => 101,
    8496 => 101,
    8497 => 102,
    8499 => 109,
    8500 => 111,
    8501 => 1488,
    8502 => 1489,
    8503 => 1490,
    8504 => 1491,
    8505 => 105,
    8507 => [102, 97, 120],
    8508 => 960,
    8509 => 947,
    8510 => 947,
    8511 => 960,
    8512 => 8721,
    8517 => 100,
    8518 => 100,
    8519 => 101,
    8520 => 105,
    8521 => 106,
    8528 => [49, 8260, 55],
    8529 => [49, 8260, 57],
    8530 => [49, 8260, 49, 48],
    8531 => [49, 8260, 51],
    8532 => [50, 8260, 51],
    8533 => [49, 8260, 53],
    8534 => [50, 8260, 53],
    8535 => [51, 8260, 53],
    8536 => [52, 8260, 53],
    8537 => [49, 8260, 54],
    8538 => [53, 8260, 54],
    8539 => [49, 8260, 56],
    8540 => [51, 8260, 56],
    8541 => [53, 8260, 56],
    8542 => [55, 8260, 56],
    8543 => [49, 8260],
    8544 => 105,
    8545 => [105, 105],
    8546 => [105, 105, 105],
    8547 => [105, 118],
    8548 => 118,
    8549 => [118, 105],
    8550 => [118, 105, 105],
    8551 => [118, 105, 105, 105],
    8552 => [105, 120],
    8553 => 120,
    8554 => [120, 105],
    8555 => [120, 105, 105],
    8556 => 108,
    8557 => 99,
    8558 => 100,
    8559 => 109,
    8560 => 105,
    8561 => [105, 105],
    8562 => [105, 105, 105],
    8563 => [105, 118],
    8564 => 118,
    8565 => [118, 105],
    8566 => [118, 105, 105],
    8567 => [118, 105, 105, 105],
    8568 => [105, 120],
    8569 => 120,
    8570 => [120, 105],
    8571 => [120, 105, 105],
    8572 => 108,
    8573 => 99,
    8574 => 100,
    8575 => 109,
    8585 => [48, 8260, 51],
    8748 => [8747, 8747],
    8749 => [8747, 8747, 8747],
    8751 => [8750, 8750],
    8752 => [8750, 8750, 8750],
    9001 => 12296,
    9002 => 12297,
    9312 => 49,
    9313 => 50,
    9314 => 51,
    9315 => 52,
    9316 => 53,
    9317 => 54,
    9318 => 55,
    9319 => 56,
    9320 => 57,
    9321 => [49, 48],
    9322 => [49, 49],
    9323 => [49, 50],
    9324 => [49, 51],
    9325 => [49, 52],
    9326 => [49, 53],
    9327 => [49, 54],
    9328 => [49, 55],
    9329 => [49, 56],
    9330 => [49, 57],
    9331 => [50, 48],
    9332 => [40, 49, 41],
    9333 => [40, 50, 41],
    9334 => [40, 51, 41],
    9335 => [40, 52, 41],
    9336 => [40, 53, 41],
    9337 => [40, 54, 41],
    9338 => [40, 55, 41],
    9339 => [40, 56, 41],
    9340 => [40, 57, 41],
    9341 => [40, 49, 48, 41],
    9342 => [40, 49, 49, 41],
    9343 => [40, 49, 50, 41],
    9344 => [40, 49, 51, 41],
    9345 => [40, 49, 52, 41],
    9346 => [40, 49, 53, 41],
    9347 => [40, 49, 54, 41],
    9348 => [40, 49, 55, 41],
    9349 => [40, 49, 56, 41],
    9350 => [40, 49, 57, 41],
    9351 => [40, 50, 48, 41],
    9372 => [40, 97, 41],
    9373 => [40, 98, 41],
    9374 => [40, 99, 41],
    9375 => [40, 100, 41],
    9376 => [40, 101, 41],
    9377 => [40, 102, 41],
    9378 => [40, 103, 41],
    9379 => [40, 104, 41],
    9380 => [40, 105, 41],
    9381 => [40, 106, 41],
    9382 => [40, 107, 41],
    9383 => [40, 108, 41],
    9384 => [40, 109, 41],
    9385 => [40, 110, 41],
    9386 => [40, 111, 41],
    9387 => [40, 112, 41],
    9388 => [40, 113, 41],
    9389 => [40, 114, 41],
    9390 => [40, 115, 41],
    9391 => [40, 116, 41],
    9392 => [40, 117, 41],
    9393 => [40, 118, 41],
    9394 => [40, 119, 41],
    9395 => [40, 120, 41],
    9396 => [40, 121, 41],
    9397 => [40, 122, 41],
    9398 => 97,
    9399 => 98,
    9400 => 99,
    9401 => 100,
    9402 => 101,
    9403 => 102,
    9404 => 103,
    9405 => 104,
    9406 => 105,
    9407 => 106,
    9408 => 107,
    9409 => 108,
    9410 => 109,
    9411 => 110,
    9412 => 111,
    9413 => 112,
    9414 => 113,
    9415 => 114,
    9416 => 115,
    9417 => 116,
    9418 => 117,
    9419 => 118,
    9420 => 119,
    9421 => 120,
    9422 => 121,
    9423 => 122,
    9424 => 97,
    9425 => 98,
    9426 => 99,
    9427 => 100,
    9428 => 101,
    9429 => 102,
    9430 => 103,
    9431 => 104,
    9432 => 105,
    9433 => 106,
    9434 => 107,
    9435 => 108,
    9436 => 109,
    9437 => 110,
    9438 => 111,
    9439 => 112,
    9440 => 113,
    9441 => 114,
    9442 => 115,
    9443 => 116,
    9444 => 117,
    9445 => 118,
    9446 => 119,
    9447 => 120,
    9448 => 121,
    9449 => 122,
    9450 => 48,
    10764 => [8747, 8747, 8747, 8747],
    10868 => [58, 58, 61],
    10869 => [61, 61],
    10870 => [61, 61, 61],
    10972 => [10973, 824],
    11264 => 11312,
    11265 => 11313,
    11266 => 11314,
    11267 => 11315,
    11268 => 11316,
    11269 => 11317,
    11270 => 11318,
    11271 => 11319,
    11272 => 11320,
    11273 => 11321,
    11274 => 11322,
    11275 => 11323,
    11276 => 11324,
    11277 => 11325,
    11278 => 11326,
    11279 => 11327,
    11280 => 11328,
    11281 => 11329,
    11282 => 11330,
    11283 => 11331,
    11284 => 11332,
    11285 => 11333,
    11286 => 11334,
    11287 => 11335,
    11288 => 11336,
    11289 => 11337,
    11290 => 11338,
    11291 => 11339,
    11292 => 11340,
    11293 => 11341,
    11294 => 11342,
    11295 => 11343,
    11296 => 11344,
    11297 => 11345,
    11298 => 11346,
    11299 => 11347,
    11300 => 11348,
    11301 => 11349,
    11302 => 11350,
    11303 => 11351,
    11304 => 11352,
    11305 => 11353,
    11306 => 11354,
    11307 => 11355,
    11308 => 11356,
    11309 => 11357,
    11310 => 11358,
    11360 => 11361,
    11362 => 619,
    11363 => 7549,
    11364 => 637,
    11367 => 11368,
    11369 => 11370,
    11371 => 11372,
    11373 => 593,
    11374 => 625,
    11375 => 592,
    11376 => 594,
    11378 => 11379,
    11381 => 11382,
    11388 => 106,
    11389 => 118,
    11390 => 575,
    11391 => 576,
    11392 => 11393,
    11394 => 11395,
    11396 => 11397,
    11398 => 11399,
    11400 => 11401,
    11402 => 11403,
    11404 => 11405,
    11406 => 11407,
    11408 => 11409,
    11410 => 11411,
    11412 => 11413,
    11414 => 11415,
    11416 => 11417,
    11418 => 11419,
    11420 => 11421,
    11422 => 11423,
    11424 => 11425,
    11426 => 11427,
    11428 => 11429,
    11430 => 11431,
    11432 => 11433,
    11434 => 11435,
    11436 => 11437,
    11438 => 11439,
    11440 => 11441,
    11442 => 11443,
    11444 => 11445,
    11446 => 11447,
    11448 => 11449,
    11450 => 11451,
    11452 => 11453,
    11454 => 11455,
    11456 => 11457,
    11458 => 11459,
    11460 => 11461,
    11462 => 11463,
    11464 => 11465,
    11466 => 11467,
    11468 => 11469,
    11470 => 11471,
    11472 => 11473,
    11474 => 11475,
    11476 => 11477,
    11478 => 11479,
    11480 => 11481,
    11482 => 11483,
    11484 => 11485,
    11486 => 11487,
    11488 => 11489,
    11490 => 11491,
    11499 => 11500,
    11501 => 11502,
    11506 => 11507,
    11631 => 11617,
    11935 => 27597,
    12019 => 40863,
    12032 => 19968,
    12033 => 20008,
    12034 => 20022,
    12035 => 20031,
    12036 => 20057,
    12037 => 20101,
    12038 => 20108,
    12039 => 20128,
    12040 => 20154,
    12041 => 20799,
    12042 => 20837,
    12043 => 20843,
    12044 => 20866,
    12045 => 20886,
    12046 => 20907,
    12047 => 20960,
    12048 => 20981,
    12049 => 20992,
    12050 => 21147,
    12051 => 21241,
    12052 => 21269,
    12053 => 21274,
    12054 => 21304,
    12055 => 21313,
    12056 => 21340,
    12057 => 21353,
    12058 => 21378,
    12059 => 21430,
    12060 => 21448,
    12061 => 21475,
    12062 => 22231,
    12063 => 22303,
    12064 => 22763,
    12065 => 22786,
    12066 => 22794,
    12067 => 22805,
    12068 => 22823,
    12069 => 22899,
    12070 => 23376,
    12071 => 23424,
    12072 => 23544,
    12073 => 23567,
    12074 => 23586,
    12075 => 23608,
    12076 => 23662,
    12077 => 23665,
    12078 => 24027,
    12079 => 24037,
    12080 => 24049,
    12081 => 24062,
    12082 => 24178,
    12083 => 24186,
    12084 => 24191,
    12085 => 24308,
    12086 => 24318,
    12087 => 24331,
    12088 => 24339,
    12089 => 24400,
    12090 => 24417,
    12091 => 24435,
    12092 => 24515,
    12093 => 25096,
    12094 => 25142,
    12095 => 25163,
    12096 => 25903,
    12097 => 25908,
    12098 => 25991,
    12099 => 26007,
    12100 => 26020,
    12101 => 26041,
    12102 => 26080,
    12103 => 26085,
    12104 => 26352,
    12105 => 26376,
    12106 => 26408,
    12107 => 27424,
    12108 => 27490,
    12109 => 27513,
    12110 => 27571,
    12111 => 27595,
    12112 => 27604,
    12113 => 27611,
    12114 => 27663,
    12115 => 27668,
    12116 => 27700,
    12117 => 28779,
    12118 => 29226,
    12119 => 29238,
    12120 => 29243,
    12121 => 29247,
    12122 => 29255,
    12123 => 29273,
    12124 => 29275,
    12125 => 29356,
    12126 => 29572,
    12127 => 29577,
    12128 => 29916,
    12129 => 29926,
    12130 => 29976,
    12131 => 29983,
    12132 => 29992,
    12133 => 30000,
    12134 => 30091,
    12135 => 30098,
    12136 => 30326,
    12137 => 30333,
    12138 => 30382,
    12139 => 30399,
    12140 => 30446,
    12141 => 30683,
    12142 => 30690,
    12143 => 30707,
    12144 => 31034,
    12145 => 31160,
    12146 => 31166,
    12147 => 31348,
    12148 => 31435,
    12149 => 31481,
    12150 => 31859,
    12151 => 31992,
    12152 => 32566,
    12153 => 32593,
    12154 => 32650,
    12155 => 32701,
    12156 => 32769,
    12157 => 32780,
    12158 => 32786,
    12159 => 32819,
    12160 => 32895,
    12161 => 32905,
    12162 => 33251,
    12163 => 33258,
    12164 => 33267,
    12165 => 33276,
    12166 => 33292,
    12167 => 33307,
    12168 => 33311,
    12169 => 33390,
    12170 => 33394,
    12171 => 33400,
    12172 => 34381,
    12173 => 34411,
    12174 => 34880,
    12175 => 34892,
    12176 => 34915,
    12177 => 35198,
    12178 => 35211,
    12179 => 35282,
    12180 => 35328,
    12181 => 35895,
    12182 => 35910,
    12183 => 35925,
    12184 => 35960,
    12185 => 35997,
    12186 => 36196,
    12187 => 36208,
    12188 => 36275,
    12189 => 36523,
    12190 => 36554,
    12191 => 36763,
    12192 => 36784,
    12193 => 36789,
    12194 => 37009,
    12195 => 37193,
    12196 => 37318,
    12197 => 37324,
    12198 => 37329,
    12199 => 38263,
    12200 => 38272,
    12201 => 38428,
    12202 => 38582,
    12203 => 38585,
    12204 => 38632,
    12205 => 38737,
    12206 => 38750,
    12207 => 38754,
    12208 => 38761,
    12209 => 38859,
    12210 => 38893,
    12211 => 38899,
    12212 => 38913,
    12213 => 39080,
    12214 => 39131,
    12215 => 39135,
    12216 => 39318,
    12217 => 39321,
    12218 => 39340,
    12219 => 39592,
    12220 => 39640,
    12221 => 39647,
    12222 => 39717,
    12223 => 39727,
    12224 => 39730,
    12225 => 39740,
    12226 => 39770,
    12227 => 40165,
    12228 => 40565,
    12229 => 40575,
    12230 => 40613,
    12231 => 40635,
    12232 => 40643,
    12233 => 40653,
    12234 => 40657,
    12235 => 40697,
    12236 => 40701,
    12237 => 40718,
    12238 => 40723,
    12239 => 40736,
    12240 => 40763,
    12241 => 40778,
    12242 => 40786,
    12243 => 40845,
    12244 => 40860,
    12245 => 40864,
    12288 => 32,
    12290 => 46,
    12342 => 12306,
    12344 => 21313,
    12345 => 21316,
    12346 => 21317,
    12443 => [32, 12441],
    12444 => [32, 12442],
    12447 => [12424, 12426],
    12543 => [12467, 12488],
    12593 => 4352,
    12594 => 4353,
    12595 => 4522,
    12596 => 4354,
    12597 => 4524,
    12598 => 4525,
    12599 => 4355,
    12600 => 4356,
    12601 => 4357,
    12602 => 4528,
    12603 => 4529,
    12604 => 4530,
    12605 => 4531,
    12606 => 4532,
    12607 => 4533,
    12608 => 4378,
    12609 => 4358,
    12610 => 4359,
    12611 => 4360,
    12612 => 4385,
    12613 => 4361,
    12614 => 4362,
    12615 => 4363,
    12616 => 4364,
    12617 => 4365,
    12618 => 4366,
    12619 => 4367,
    12620 => 4368,
    12621 => 4369,
    12622 => 4370,
    12623 => 4449,
    12624 => 4450,
    12625 => 4451,
    12626 => 4452,
    12627 => 4453,
    12628 => 4454,
    12629 => 4455,
    12630 => 4456,
    12631 => 4457,
    12632 => 4458,
    12633 => 4459,
    12634 => 4460,
    12635 => 4461,
    12636 => 4462,
    12637 => 4463,
    12638 => 4464,
    12639 => 4465,
    12640 => 4466,
    12641 => 4467,
    12642 => 4468,
    12643 => 4469,
    12645 => 4372,
    12646 => 4373,
    12647 => 4551,
    12648 => 4552,
    12649 => 4556,
    12650 => 4558,
    12651 => 4563,
    12652 => 4567,
    12653 => 4569,
    12654 => 4380,
    12655 => 4573,
    12656 => 4575,
    12657 => 4381,
    12658 => 4382,
    12659 => 4384,
    12660 => 4386,
    12661 => 4387,
    12662 => 4391,
    12663 => 4393,
    12664 => 4395,
    12665 => 4396,
    12666 => 4397,
    12667 => 4398,
    12668 => 4399,
    12669 => 4402,
    12670 => 4406,
    12671 => 4416,
    12672 => 4423,
    12673 => 4428,
    12674 => 4593,
    12675 => 4594,
    12676 => 4439,
    12677 => 4440,
    12678 => 4441,
    12679 => 4484,
    12680 => 4485,
    12681 => 4488,
    12682 => 4497,
    12683 => 4498,
    12684 => 4500,
    12685 => 4510,
    12686 => 4513,
    12690 => 19968,
    12691 => 20108,
    12692 => 19977,
    12693 => 22235,
    12694 => 19978,
    12695 => 20013,
    12696 => 19979,
    12697 => 30002,
    12698 => 20057,
    12699 => 19993,
    12700 => 19969,
    12701 => 22825,
    12702 => 22320,
    12703 => 20154,
    12800 => [40, 4352, 41],
    12801 => [40, 4354, 41],
    12802 => [40, 4355, 41],
    12803 => [40, 4357, 41],
    12804 => [40, 4358, 41],
    12805 => [40, 4359, 41],
    12806 => [40, 4361, 41],
    12807 => [40, 4363, 41],
    12808 => [40, 4364, 41],
    12809 => [40, 4366, 41],
    12810 => [40, 4367, 41],
    12811 => [40, 4368, 41],
    12812 => [40, 4369, 41],
    12813 => [40, 4370, 41],
    12814 => [40, 44032, 41],
    12815 => [40, 45208, 41],
    12816 => [40, 45796, 41],
    12817 => [40, 46972, 41],
    12818 => [40, 47560, 41],
    12819 => [40, 48148, 41],
    12820 => [40, 49324, 41],
    12821 => [40, 50500, 41],
    12822 => [40, 51088, 41],
    12823 => [40, 52264, 41],
    12824 => [40, 52852, 41],
    12825 => [40, 53440, 41],
    12826 => [40, 54028, 41],
    12827 => [40, 54616, 41],
    12828 => [40, 51452, 41],
    12829 => [40, 50724, 51204, 41],
    12830 => [40, 50724, 54980, 41],
    12832 => [40, 19968, 41],
    12833 => [40, 20108, 41],
    12834 => [40, 19977, 41],
    12835 => [40, 22235, 41],
    12836 => [40, 20116, 41],
    12837 => [40, 20845, 41],
    12838 => [40, 19971, 41],
    12839 => [40, 20843, 41],
    12840 => [40, 20061, 41],
    12841 => [40, 21313, 41],
    12842 => [40, 26376, 41],
    12843 => [40, 28779, 41],
    12844 => [40, 27700, 41],
    12845 => [40, 26408, 41],
    12846 => [40, 37329, 41],
    12847 => [40, 22303, 41],
    12848 => [40, 26085, 41],
    12849 => [40, 26666, 41],
    12850 => [40, 26377, 41],
    12851 => [40, 31038, 41],
    12852 => [40, 21517, 41],
    12853 => [40, 29305, 41],
    12854 => [40, 36001, 41],
    12855 => [40, 31069, 41],
    12856 => [40, 21172, 41],
    12857 => [40, 20195, 41],
    12858 => [40, 21628, 41],
    12859 => [40, 23398, 41],
    12860 => [40, 30435, 41],
    12861 => [40, 20225, 41],
    12862 => [40, 36039, 41],
    12863 => [40, 21332, 41],
    12864 => [40, 31085, 41],
    12865 => [40, 20241, 41],
    12866 => [40, 33258, 41],
    12867 => [40, 33267, 41],
    12868 => 21839,
    12869 => 24188,
    12870 => 25991,
    12871 => 31631,
    12880 => [112, 116, 101],
    12881 => [50, 49],
    12882 => [50, 50],
    12883 => [50, 51],
    12884 => [50, 52],
    12885 => [50, 53],
    12886 => [50, 54],
    12887 => [50, 55],
    12888 => [50, 56],
    12889 => [50, 57],
    12890 => [51, 48],
    12891 => [51, 49],
    12892 => [51, 50],
    12893 => [51, 51],
    12894 => [51, 52],
    12895 => [51, 53],
    12896 => 4352,
    12897 => 4354,
    12898 => 4355,
    12899 => 4357,
    12900 => 4358,
    12901 => 4359,
    12902 => 4361,
    12903 => 4363,
    12904 => 4364,
    12905 => 4366,
    12906 => 4367,
    12907 => 4368,
    12908 => 4369,
    12909 => 4370,
    12910 => 44032,
    12911 => 45208,
    12912 => 45796,
    12913 => 46972,
    12914 => 47560,
    12915 => 48148,
    12916 => 49324,
    12917 => 50500,
    12918 => 51088,
    12919 => 52264,
    12920 => 52852,
    12921 => 53440,
    12922 => 54028,
    12923 => 54616,
    12924 => [52280, 44256],
    12925 => [51452, 51032],
    12926 => 50864,
    12928 => 19968,
    12929 => 20108,
    12930 => 19977,
    12931 => 22235,
    12932 => 20116,
    12933 => 20845,
    12934 => 19971,
    12935 => 20843,
    12936 => 20061,
    12937 => 21313,
    12938 => 26376,
    12939 => 28779,
    12940 => 27700,
    12941 => 26408,
    12942 => 37329,
    12943 => 22303,
    12944 => 26085,
    12945 => 26666,
    12946 => 26377,
    12947 => 31038,
    12948 => 21517,
    12949 => 29305,
    12950 => 36001,
    12951 => 31069,
    12952 => 21172,
    12953 => 31192,
    12954 => 30007,
    12955 => 22899,
    12956 => 36969,
    12957 => 20778,
    12958 => 21360,
    12959 => 27880,
    12960 => 38917,
    12961 => 20241,
    12962 => 20889,
    12963 => 27491,
    12964 => 19978,
    12965 => 20013,
    12966 => 19979,
    12967 => 24038,
    12968 => 21491,
    12969 => 21307,
    12970 => 23447,
    12971 => 23398,
    12972 => 30435,
    12973 => 20225,
    12974 => 36039,
    12975 => 21332,
    12976 => 22812,
    12977 => [51, 54],
    12978 => [51, 55],
    12979 => [51, 56],
    12980 => [51, 57],
    12981 => [52, 48],
    12982 => [52, 49],
    12983 => [52, 50],
    12984 => [52, 51],
    12985 => [52, 52],
    12986 => [52, 53],
    12987 => [52, 54],
    12988 => [52, 55],
    12989 => [52, 56],
    12990 => [52, 57],
    12991 => [53, 48],
    12992 => [49, 26376],
    12993 => [50, 26376],
    12994 => [51, 26376],
    12995 => [52, 26376],
    12996 => [53, 26376],
    12997 => [54, 26376],
    12998 => [55, 26376],
    12999 => [56, 26376],
    13000 => [57, 26376],
    13001 => [49, 48, 26376],
    13002 => [49, 49, 26376],
    13003 => [49, 50, 26376],
    13004 => [104, 103],
    13005 => [101, 114, 103],
    13006 => [101, 118],
    13007 => [108, 116, 100],
    13008 => 12450,
    13009 => 12452,
    13010 => 12454,
    13011 => 12456,
    13012 => 12458,
    13013 => 12459,
    13014 => 12461,
    13015 => 12463,
    13016 => 12465,
    13017 => 12467,
    13018 => 12469,
    13019 => 12471,
    13020 => 12473,
    13021 => 12475,
    13022 => 12477,
    13023 => 12479,
    13024 => 12481,
    13025 => 12484,
    13026 => 12486,
    13027 => 12488,
    13028 => 12490,
    13029 => 12491,
    13030 => 12492,
    13031 => 12493,
    13032 => 12494,
    13033 => 12495,
    13034 => 12498,
    13035 => 12501,
    13036 => 12504,
    13037 => 12507,
    13038 => 12510,
    13039 => 12511,
    13040 => 12512,
    13041 => 12513,
    13042 => 12514,
    13043 => 12516,
    13044 => 12518,
    13045 => 12520,
    13046 => 12521,
    13047 => 12522,
    13048 => 12523,
    13049 => 12524,
    13050 => 12525,
    13051 => 12527,
    13052 => 12528,
    13053 => 12529,
    13054 => 12530,
    13056 => [12450, 12497, 12540, 12488],
    13057 => [12450, 12523, 12501, 12449],
    13058 => [12450, 12531, 12506, 12450],
    13059 => [12450, 12540, 12523],
    13060 => [12452, 12491, 12531, 12464],
    13061 => [12452, 12531, 12481],
    13062 => [12454, 12457, 12531],
    13063 => [12456, 12473, 12463, 12540, 12489],
    13064 => [12456, 12540, 12459, 12540],
    13065 => [12458, 12531, 12473],
    13066 => [12458, 12540, 12512],
    13067 => [12459, 12452, 12522],
    13068 => [12459, 12521, 12483, 12488],
    13069 => [12459, 12525, 12522, 12540],
    13070 => [12460, 12525, 12531],
    13071 => [12460, 12531, 12510],
    13072 => [12462, 12460],
    13073 => [12462, 12491, 12540],
    13074 => [12461, 12517, 12522, 12540],
    13075 => [12462, 12523, 12480, 12540],
    13076 => [12461, 12525],
    13077 => [12461, 12525, 12464, 12521, 12512],
    13078 => [12461, 12525, 12513, 12540, 12488, 12523],
    13079 => [12461, 12525, 12527, 12483, 12488],
    13080 => [12464, 12521, 12512],
    13081 => [12464, 12521, 12512, 12488, 12531],
    13082 => [12463, 12523, 12476, 12452, 12525],
    13083 => [12463, 12525, 12540, 12493],
    13084 => [12465, 12540, 12473],
    13085 => [12467, 12523, 12490],
    13086 => [12467, 12540, 12509],
    13087 => [12469, 12452, 12463, 12523],
    13088 => [12469, 12531, 12481, 12540, 12512],
    13089 => [12471, 12522, 12531, 12464],
    13090 => [12475, 12531, 12481],
    13091 => [12475, 12531, 12488],
    13092 => [12480, 12540, 12473],
    13093 => [12487, 12471],
    13094 => [12489, 12523],
    13095 => [12488, 12531],
    13096 => [12490, 12494],
    13097 => [12494, 12483, 12488],
    13098 => [12495, 12452, 12484],
    13099 => [12497, 12540, 12475, 12531, 12488],
    13100 => [12497, 12540, 12484],
    13101 => [12496, 12540, 12524, 12523],
    13102 => [12500, 12450, 12473, 12488, 12523],
    13103 => [12500, 12463, 12523],
    13104 => [12500, 12467],
    13105 => [12499, 12523],
    13106 => [12501, 12449, 12521, 12483, 12489],
    13107 => [12501, 12451, 12540, 12488],
    13108 => [12502, 12483, 12471, 12455, 12523],
    13109 => [12501, 12521, 12531],
    13110 => [12504, 12463, 12479, 12540, 12523],
    13111 => [12506, 12477],
    13112 => [12506, 12491, 12498],
    13113 => [12504, 12523, 12484],
    13114 => [12506, 12531, 12473],
    13115 => [12506, 12540, 12472],
    13116 => [12505, 12540, 12479],
    13117 => [12509, 12452, 12531, 12488],
    13118 => [12508, 12523, 12488],
    13119 => [12507, 12531],
    13120 => [12509, 12531, 12489],
    13121 => [12507, 12540, 12523],
    13122 => [12507, 12540, 12531],
    13123 => [12510, 12452, 12463, 12525],
    13124 => [12510, 12452, 12523],
    13125 => [12510, 12483, 12495],
    13126 => [12510, 12523, 12463],
    13127 => [12510, 12531, 12471, 12519, 12531],
    13128 => [12511, 12463, 12525, 12531],
    13129 => [12511, 12522],
    13130 => [12511, 12522, 12496, 12540, 12523],
    13131 => [12513, 12460],
    13132 => [12513, 12460, 12488, 12531],
    13133 => [12513, 12540, 12488, 12523],
    13134 => [12516, 12540, 12489],
    13135 => [12516, 12540, 12523],
    13136 => [12518, 12450, 12531],
    13137 => [12522, 12483, 12488, 12523],
    13138 => [12522, 12521],
    13139 => [12523, 12500, 12540],
    13140 => [12523, 12540, 12502, 12523],
    13141 => [12524, 12512],
    13142 => [12524, 12531, 12488, 12466, 12531],
    13143 => [12527, 12483, 12488],
    13144 => [48, 28857],
    13145 => [49, 28857],
    13146 => [50, 28857],
    13147 => [51, 28857],
    13148 => [52, 28857],
    13149 => [53, 28857],
    13150 => [54, 28857],
    13151 => [55, 28857],
    13152 => [56, 28857],
    13153 => [57, 28857],
    13154 => [49, 48, 28857],
    13155 => [49, 49, 28857],
    13156 => [49, 50, 28857],
    13157 => [49, 51, 28857],
    13158 => [49, 52, 28857],
    13159 => [49, 53, 28857],
    13160 => [49, 54, 28857],
    13161 => [49, 55, 28857],
    13162 => [49, 56, 28857],
    13163 => [49, 57, 28857],
    13164 => [50, 48, 28857],
    13165 => [50, 49, 28857],
    13166 => [50, 50, 28857],
    13167 => [50, 51, 28857],
    13168 => [50, 52, 28857],
    13169 => [104, 112, 97],
    13170 => [100, 97],
    13171 => [97, 117],
    13172 => [98, 97, 114],
    13173 => [111, 118],
    13174 => [112, 99],
    13175 => [100, 109],
    13176 => [100, 109, 50],
    13177 => [100, 109, 51],
    13178 => [105, 117],
    13179 => [24179, 25104],
    13180 => [26157, 21644],
    13181 => [22823, 27491],
    13182 => [26126, 27835],
    13183 => [26666, 24335, 20250, 31038],
    13184 => [112, 97],
    13185 => [110, 97],
    13186 => [956, 97],
    13187 => [109, 97],
    13188 => [107, 97],
    13189 => [107, 98],
    13190 => [109, 98],
    13191 => [103, 98],
    13192 => [99, 97, 108],
    13193 => [107, 99, 97, 108],
    13194 => [112, 102],
    13195 => [110, 102],
    13196 => [956, 102],
    13197 => [956, 103],
    13198 => [109, 103],
    13199 => [107, 103],
    13200 => [104, 122],
    13201 => [107, 104, 122],
    13202 => [109, 104, 122],
    13203 => [103, 104, 122],
    13204 => [116, 104, 122],
    13205 => [956, 108],
    13206 => [109, 108],
    13207 => [100, 108],
    13208 => [107, 108],
    13209 => [102, 109],
    13210 => [110, 109],
    13211 => [956, 109],
    13212 => [109, 109],
    13213 => [99, 109],
    13214 => [107, 109],
    13215 => [109, 109, 50],
    13216 => [99, 109, 50],
    13217 => [109, 50],
    13218 => [107, 109, 50],
    13219 => [109, 109, 51],
    13220 => [99, 109, 51],
    13221 => [109, 51],
    13222 => [107, 109, 51],
    13223 => [109, 8725, 115],
    13224 => [109, 8725, 115, 50],
    13225 => [112, 97],
    13226 => [107, 112, 97],
    13227 => [109, 112, 97],
    13228 => [103, 112, 97],
    13229 => [114, 97, 100],
    13230 => [114, 97, 100, 8725, 115],
    13231 => [114, 97, 100, 8725, 115, 50],
    13232 => [112, 115],
    13233 => [110, 115],
    13234 => [956, 115],
    13235 => [109, 115],
    13236 => [112, 118],
    13237 => [110, 118],
    13238 => [956, 118],
    13239 => [109, 118],
    13240 => [107, 118],
    13241 => [109, 118],
    13242 => [112, 119],
    13243 => [110, 119],
    13244 => [956, 119],
    13245 => [109, 119],
    13246 => [107, 119],
    13247 => [109, 119],
    13248 => [107, 969],
    13249 => [109, 969],
    13251 => [98, 113],
    13252 => [99, 99],
    13253 => [99, 100],
    13254 => [99, 8725, 107, 103],
    13256 => [100, 98],
    13257 => [103, 121],
    13258 => [104, 97],
    13259 => [104, 112],
    13260 => [105, 110],
    13261 => [107, 107],
    13262 => [107, 109],
    13263 => [107, 116],
    13264 => [108, 109],
    13265 => [108, 110],
    13266 => [108, 111, 103],
    13267 => [108, 120],
    13268 => [109, 98],
    13269 => [109, 105, 108],
    13270 => [109, 111, 108],
    13271 => [112, 104],
    13273 => [112, 112, 109],
    13274 => [112, 114],
    13275 => [115, 114],
    13276 => [115, 118],
    13277 => [119, 98],
    13278 => [118, 8725, 109],
    13279 => [97, 8725, 109],
    13280 => [49, 26085],
    13281 => [50, 26085],
    13282 => [51, 26085],
    13283 => [52, 26085],
    13284 => [53, 26085],
    13285 => [54, 26085],
    13286 => [55, 26085],
    13287 => [56, 26085],
    13288 => [57, 26085],
    13289 => [49, 48, 26085],
    13290 => [49, 49, 26085],
    13291 => [49, 50, 26085],
    13292 => [49, 51, 26085],
    13293 => [49, 52, 26085],
    13294 => [49, 53, 26085],
    13295 => [49, 54, 26085],
    13296 => [49, 55, 26085],
    13297 => [49, 56, 26085],
    13298 => [49, 57, 26085],
    13299 => [50, 48, 26085],
    13300 => [50, 49, 26085],
    13301 => [50, 50, 26085],
    13302 => [50, 51, 26085],
    13303 => [50, 52, 26085],
    13304 => [50, 53, 26085],
    13305 => [50, 54, 26085],
    13306 => [50, 55, 26085],
    13307 => [50, 56, 26085],
    13308 => [50, 57, 26085],
    13309 => [51, 48, 26085],
    13310 => [51, 49, 26085],
    13311 => [103, 97, 108],
    42560 => 42561,
    42562 => 42563,
    42564 => 42565,
    42566 => 42567,
    42568 => 42569,
    42570 => 42571,
    42572 => 42573,
    42574 => 42575,
    42576 => 42577,
    42578 => 42579,
    42580 => 42581,
    42582 => 42583,
    42584 => 42585,
    42586 => 42587,
    42588 => 42589,
    42590 => 42591,
    42592 => 42593,
    42594 => 42595,
    42596 => 42597,
    42598 => 42599,
    42600 => 42601,
    42602 => 42603,
    42604 => 42605,
    42624 => 42625,
    42626 => 42627,
    42628 => 42629,
    42630 => 42631,
    42632 => 42633,
    42634 => 42635,
    42636 => 42637,
    42638 => 42639,
    42640 => 42641,
    42642 => 42643,
    42644 => 42645,
    42646 => 42647,
    42648 => 42649,
    42650 => 42651,
    42652 => 1098,
    42653 => 1100,
    42786 => 42787,
    42788 => 42789,
    42790 => 42791,
    42792 => 42793,
    42794 => 42795,
    42796 => 42797,
    42798 => 42799,
    42802 => 42803,
    42804 => 42805,
    42806 => 42807,
    42808 => 42809,
    42810 => 42811,
    42812 => 42813,
    42814 => 42815,
    42816 => 42817,
    42818 => 42819,
    42820 => 42821,
    42822 => 42823,
    42824 => 42825,
    42826 => 42827,
    42828 => 42829,
    42830 => 42831,
    42832 => 42833,
    42834 => 42835,
    42836 => 42837,
    42838 => 42839,
    42840 => 42841,
    42842 => 42843,
    42844 => 42845,
    42846 => 42847,
    42848 => 42849,
    42850 => 42851,
    42852 => 42853,
    42854 => 42855,
    42856 => 42857,
    42858 => 42859,
    42860 => 42861,
    42862 => 42863,
    42864 => 42863,
    42873 => 42874,
    42875 => 42876,
    42877 => 7545,
    42878 => 42879,
    42880 => 42881,
    42882 => 42883,
    42884 => 42885,
    42886 => 42887,
    42891 => 42892,
    42893 => 613,
    42896 => 42897,
    42898 => 42899,
    42902 => 42903,
    42904 => 42905,
    42906 => 42907,
    42908 => 42909,
    42910 => 42911,
    42912 => 42913,
    42914 => 42915,
    42916 => 42917,
    42918 => 42919,
    42920 => 42921,
    42922 => 614,
    42923 => 604,
    42924 => 609,
    42925 => 620,
    42926 => 618,
    42928 => 670,
    42929 => 647,
    42930 => 669,
    42931 => 43859,
    42932 => 42933,
    42934 => 42935,
    43000 => 295,
    43001 => 339,
    43868 => 42791,
    43869 => 43831,
    43870 => 619,
    43871 => 43858,
    43888 => 5024,
    43889 => 5025,
    43890 => 5026,
    43891 => 5027,
    43892 => 5028,
    43893 => 5029,
    43894 => 5030,
    43895 => 5031,
    43896 => 5032,
    43897 => 5033,
    43898 => 5034,
    43899 => 5035,
    43900 => 5036,
    43901 => 5037,
    43902 => 5038,
    43903 => 5039,
    43904 => 5040,
    43905 => 5041,
    43906 => 5042,
    43907 => 5043,
    43908 => 5044,
    43909 => 5045,
    43910 => 5046,
    43911 => 5047,
    43912 => 5048,
    43913 => 5049,
    43914 => 5050,
    43915 => 5051,
    43916 => 5052,
    43917 => 5053,
    43918 => 5054,
    43919 => 5055,
    43920 => 5056,
    43921 => 5057,
    43922 => 5058,
    43923 => 5059,
    43924 => 5060,
    43925 => 5061,
    43926 => 5062,
    43927 => 5063,
    43928 => 5064,
    43929 => 5065,
    43930 => 5066,
    43931 => 5067,
    43932 => 5068,
    43933 => 5069,
    43934 => 5070,
    43935 => 5071,
    43936 => 5072,
    43937 => 5073,
    43938 => 5074,
    43939 => 5075,
    43940 => 5076,
    43941 => 5077,
    43942 => 5078,
    43943 => 5079,
    43944 => 5080,
    43945 => 5081,
    43946 => 5082,
    43947 => 5083,
    43948 => 5084,
    43949 => 5085,
    43950 => 5086,
    43951 => 5087,
    43952 => 5088,
    43953 => 5089,
    43954 => 5090,
    43955 => 5091,
    43956 => 5092,
    43957 => 5093,
    43958 => 5094,
    43959 => 5095,
    43960 => 5096,
    43961 => 5097,
    43962 => 5098,
    43963 => 5099,
    43964 => 5100,
    43965 => 5101,
    43966 => 5102,
    43967 => 5103,
    63744 => 35912,
    63745 => 26356,
    63746 => 36554,
    63747 => 36040,
    63748 => 28369,
    63749 => 20018,
    63750 => 21477,
    63751 => 40860,
    63752 => 40860,
    63753 => 22865,
    63754 => 37329,
    63755 => 21895,
    63756 => 22856,
    63757 => 25078,
    63758 => 30313,
    63759 => 32645,
    63760 => 34367,
    63761 => 34746,
    63762 => 35064,
    63763 => 37007,
    63764 => 27138,
    63765 => 27931,
    63766 => 28889,
    63767 => 29662,
    63768 => 33853,
    63769 => 37226,
    63770 => 39409,
    63771 => 20098,
    63772 => 21365,
    63773 => 27396,
    63774 => 29211,
    63775 => 34349,
    63776 => 40478,
    63777 => 23888,
    63778 => 28651,
    63779 => 34253,
    63780 => 35172,
    63781 => 25289,
    63782 => 33240,
    63783 => 34847,
    63784 => 24266,
    63785 => 26391,
    63786 => 28010,
    63787 => 29436,
    63788 => 37070,
    63789 => 20358,
    63790 => 20919,
    63791 => 21214,
    63792 => 25796,
    63793 => 27347,
    63794 => 29200,
    63795 => 30439,
    63796 => 32769,
    63797 => 34310,
    63798 => 34396,
    63799 => 36335,
    63800 => 38706,
    63801 => 39791,
    63802 => 40442,
    63803 => 30860,
    63804 => 31103,
    63805 => 32160,
    63806 => 33737,
    63807 => 37636,
    63808 => 40575,
    63809 => 35542,
    63810 => 22751,
    63811 => 24324,
    63812 => 31840,
    63813 => 32894,
    63814 => 29282,
    63815 => 30922,
    63816 => 36034,
    63817 => 38647,
    63818 => 22744,
    63819 => 23650,
    63820 => 27155,
    63821 => 28122,
    63822 => 28431,
    63823 => 32047,
    63824 => 32311,
    63825 => 38475,
    63826 => 21202,
    63827 => 32907,
    63828 => 20956,
    63829 => 20940,
    63830 => 31260,
    63831 => 32190,
    63832 => 33777,
    63833 => 38517,
    63834 => 35712,
    63835 => 25295,
    63836 => 27138,
    63837 => 35582,
    63838 => 20025,
    63839 => 23527,
    63840 => 24594,
    63841 => 29575,
    63842 => 30064,
    63843 => 21271,
    63844 => 30971,
    63845 => 20415,
    63846 => 24489,
    63847 => 19981,
    63848 => 27852,
    63849 => 25976,
    63850 => 32034,
    63851 => 21443,
    63852 => 22622,
    63853 => 30465,
    63854 => 33865,
    63855 => 35498,
    63856 => 27578,
    63857 => 36784,
    63858 => 27784,
    63859 => 25342,
    63860 => 33509,
    63861 => 25504,
    63862 => 30053,
    63863 => 20142,
    63864 => 20841,
    63865 => 20937,
    63866 => 26753,
    63867 => 31975,
    63868 => 33391,
    63869 => 35538,
    63870 => 37327,
    63871 => 21237,
    63872 => 21570,
    63873 => 22899,
    63874 => 24300,
    63875 => 26053,
    63876 => 28670,
    63877 => 31018,
    63878 => 38317,
    63879 => 39530,
    63880 => 40599,
    63881 => 40654,
    63882 => 21147,
    63883 => 26310,
    63884 => 27511,
    63885 => 36706,
    63886 => 24180,
    63887 => 24976,
    63888 => 25088,
    63889 => 25754,
    63890 => 28451,
    63891 => 29001,
    63892 => 29833,
    63893 => 31178,
    63894 => 32244,
    63895 => 32879,
    63896 => 36646,
    63897 => 34030,
    63898 => 36899,
    63899 => 37706,
    63900 => 21015,
    63901 => 21155,
    63902 => 21693,
    63903 => 28872,
    63904 => 35010,
    63905 => 35498,
    63906 => 24265,
    63907 => 24565,
    63908 => 25467,
    63909 => 27566,
    63910 => 31806,
    63911 => 29557,
    63912 => 20196,
    63913 => 22265,
    63914 => 23527,
    63915 => 23994,
    63916 => 24604,
    63917 => 29618,
    63918 => 29801,
    63919 => 32666,
    63920 => 32838,
    63921 => 37428,
    63922 => 38646,
    63923 => 38728,
    63924 => 38936,
    63925 => 20363,
    63926 => 31150,
    63927 => 37300,
    63928 => 38584,
    63929 => 24801,
    63930 => 20102,
    63931 => 20698,
    63932 => 23534,
    63933 => 23615,
    63934 => 26009,
    63935 => 27138,
    63936 => 29134,
    63937 => 30274,
    63938 => 34044,
    63939 => 36988,
    63940 => 40845,
    63941 => 26248,
    63942 => 38446,
    63943 => 21129,
    63944 => 26491,
    63945 => 26611,
    63946 => 27969,
    63947 => 28316,
    63948 => 29705,
    63949 => 30041,
    63950 => 30827,
    63951 => 32016,
    63952 => 39006,
    63953 => 20845,
    63954 => 25134,
    63955 => 38520,
    63956 => 20523,
    63957 => 23833,
    63958 => 28138,
    63959 => 36650,
    63960 => 24459,
    63961 => 24900,
    63962 => 26647,
    63963 => 29575,
    63964 => 38534,
    63965 => 21033,
    63966 => 21519,
    63967 => 23653,
    63968 => 26131,
    63969 => 26446,
    63970 => 26792,
    63971 => 27877,
    63972 => 29702,
    63973 => 30178,
    63974 => 32633,
    63975 => 35023,
    63976 => 35041,
    63977 => 37324,
    63978 => 38626,
    63979 => 21311,
    63980 => 28346,
    63981 => 21533,
    63982 => 29136,
    63983 => 29848,
    63984 => 34298,
    63985 => 38563,
    63986 => 40023,
    63987 => 40607,
    63988 => 26519,
    63989 => 28107,
    63990 => 33256,
    63991 => 31435,
    63992 => 31520,
    63993 => 31890,
    63994 => 29376,
    63995 => 28825,
    63996 => 35672,
    63997 => 20160,
    63998 => 33590,
    63999 => 21050,
    64000 => 20999,
    64001 => 24230,
    64002 => 25299,
    64003 => 31958,
    64004 => 23429,
    64005 => 27934,
    64006 => 26292,
    64007 => 36667,
    64008 => 34892,
    64009 => 38477,
    64010 => 35211,
    64011 => 24275,
    64012 => 20800,
    64013 => 21952,
    64016 => 22618,
    64018 => 26228,
    64021 => 20958,
    64022 => 29482,
    64023 => 30410,
    64024 => 31036,
    64025 => 31070,
    64026 => 31077,
    64027 => 31119,
    64028 => 38742,
    64029 => 31934,
    64030 => 32701,
    64032 => 34322,
    64034 => 35576,
    64037 => 36920,
    64038 => 37117,
    64042 => 39151,
    64043 => 39164,
    64044 => 39208,
    64045 => 40372,
    64046 => 37086,
    64047 => 38583,
    64048 => 20398,
    64049 => 20711,
    64050 => 20813,
    64051 => 21193,
    64052 => 21220,
    64053 => 21329,
    64054 => 21917,
    64055 => 22022,
    64056 => 22120,
    64057 => 22592,
    64058 => 22696,
    64059 => 23652,
    64060 => 23662,
    64061 => 24724,
    64062 => 24936,
    64063 => 24974,
    64064 => 25074,
    64065 => 25935,
    64066 => 26082,
    64067 => 26257,
    64068 => 26757,
    64069 => 28023,
    64070 => 28186,
    64071 => 28450,
    64072 => 29038,
    64073 => 29227,
    64074 => 29730,
    64075 => 30865,
    64076 => 31038,
    64077 => 31049,
    64078 => 31048,
    64079 => 31056,
    64080 => 31062,
    64081 => 31069,
    64082 => 31117,
    64083 => 31118,
    64084 => 31296,
    64085 => 31361,
    64086 => 31680,
    64087 => 32244,
    64088 => 32265,
    64089 => 32321,
    64090 => 32626,
    64091 => 32773,
    64092 => 33261,
    64093 => 33401,
    64094 => 33401,
    64095 => 33879,
    64096 => 35088,
    64097 => 35222,
    64098 => 35585,
    64099 => 35641,
    64100 => 36051,
    64101 => 36104,
    64102 => 36790,
    64103 => 36920,
    64104 => 38627,
    64105 => 38911,
    64106 => 38971,
    64107 => 24693,
    64108 => 148206,
    64109 => 33304,
    64112 => 20006,
    64113 => 20917,
    64114 => 20840,
    64115 => 20352,
    64116 => 20805,
    64117 => 20864,
    64118 => 21191,
    64119 => 21242,
    64120 => 21917,
    64121 => 21845,
    64122 => 21913,
    64123 => 21986,
    64124 => 22618,
    64125 => 22707,
    64126 => 22852,
    64127 => 22868,
    64128 => 23138,
    64129 => 23336,
    64130 => 24274,
    64131 => 24281,
    64132 => 24425,
    64133 => 24493,
    64134 => 24792,
    64135 => 24910,
    64136 => 24840,
    64137 => 24974,
    64138 => 24928,
    64139 => 25074,
    64140 => 25140,
    64141 => 25540,
    64142 => 25628,
    64143 => 25682,
    64144 => 25942,
    64145 => 26228,
    64146 => 26391,
    64147 => 26395,
    64148 => 26454,
    64149 => 27513,
    64150 => 27578,
    64151 => 27969,
    64152 => 28379,
    64153 => 28363,
    64154 => 28450,
    64155 => 28702,
    64156 => 29038,
    64157 => 30631,
    64158 => 29237,
    64159 => 29359,
    64160 => 29482,
    64161 => 29809,
    64162 => 29958,
    64163 => 30011,
    64164 => 30237,
    64165 => 30239,
    64166 => 30410,
    64167 => 30427,
    64168 => 30452,
    64169 => 30538,
    64170 => 30528,
    64171 => 30924,
    64172 => 31409,
    64173 => 31680,
    64174 => 31867,
    64175 => 32091,
    64176 => 32244,
    64177 => 32574,
    64178 => 32773,
    64179 => 33618,
    64180 => 33775,
    64181 => 34681,
    64182 => 35137,
    64183 => 35206,
    64184 => 35222,
    64185 => 35519,
    64186 => 35576,
    64187 => 35531,
    64188 => 35585,
    64189 => 35582,
    64190 => 35565,
    64191 => 35641,
    64192 => 35722,
    64193 => 36104,
    64194 => 36664,
    64195 => 36978,
    64196 => 37273,
    64197 => 37494,
    64198 => 38524,
    64199 => 38627,
    64200 => 38742,
    64201 => 38875,
    64202 => 38911,
    64203 => 38923,
    64204 => 38971,
    64205 => 39698,
    64206 => 40860,
    64207 => 141386,
    64208 => 141380,
    64209 => 144341,
    64210 => 15261,
    64211 => 16408,
    64212 => 16441,
    64213 => 152137,
    64214 => 154832,
    64215 => 163539,
    64216 => 40771,
    64217 => 40846,
    64256 => [102, 102],
    64257 => [102, 105],
    64258 => [102, 108],
    64259 => [102, 102, 105],
    64260 => [102, 102, 108],
    64261 => [115, 116],
    64262 => [115, 116],
    64275 => [1396, 1398],
    64276 => [1396, 1381],
    64277 => [1396, 1387],
    64278 => [1406, 1398],
    64279 => [1396, 1389],
    64285 => [1497, 1460],
    64287 => [1522, 1463],
    64288 => 1506,
    64289 => 1488,
    64290 => 1491,
    64291 => 1492,
    64292 => 1499,
    64293 => 1500,
    64294 => 1501,
    64295 => 1512,
    64296 => 1514,
    64297 => 43,
    64298 => [1513, 1473],
    64299 => [1513, 1474],
    64300 => [1513, 1468, 1473],
    64301 => [1513, 1468, 1474],
    64302 => [1488, 1463],
    64303 => [1488, 1464],
    64304 => [1488, 1468],
    64305 => [1489, 1468],
    64306 => [1490, 1468],
    64307 => [1491, 1468],
    64308 => [1492, 1468],
    64309 => [1493, 1468],
    64310 => [1494, 1468],
    64312 => [1496, 1468],
    64313 => [1497, 1468],
    64314 => [1498, 1468],
    64315 => [1499, 1468],
    64316 => [1500, 1468],
    64318 => [1502, 1468],
    64320 => [1504, 1468],
    64321 => [1505, 1468],
    64323 => [1507, 1468],
    64324 => [1508, 1468],
    64326 => [1510, 1468],
    64327 => [1511, 1468],
    64328 => [1512, 1468],
    64329 => [1513, 1468],
    64330 => [1514, 1468],
    64331 => [1493, 1465],
    64332 => [1489, 1471],
    64333 => [1499, 1471],
    64334 => [1508, 1471],
    64335 => [1488, 1500],
    64336 => 1649,
    64337 => 1649,
    64338 => 1659,
    64339 => 1659,
    64340 => 1659,
    64341 => 1659,
    64342 => 1662,
    64343 => 1662,
    64344 => 1662,
    64345 => 1662,
    64346 => 1664,
    64347 => 1664,
    64348 => 1664,
    64349 => 1664,
    64350 => 1658,
    64351 => 1658,
    64352 => 1658,
    64353 => 1658,
    64354 => 1663,
    64355 => 1663,
    64356 => 1663,
    64357 => 1663,
    64358 => 1657,
    64359 => 1657,
    64360 => 1657,
    64361 => 1657,
    64362 => 1700,
    64363 => 1700,
    64364 => 1700,
    64365 => 1700,
    64366 => 1702,
    64367 => 1702,
    64368 => 1702,
    64369 => 1702,
    64370 => 1668,
    64371 => 1668,
    64372 => 1668,
    64373 => 1668,
    64374 => 1667,
    64375 => 1667,
    64376 => 1667,
    64377 => 1667,
    64378 => 1670,
    64379 => 1670,
    64380 => 1670,
    64381 => 1670,
    64382 => 1671,
    64383 => 1671,
    64384 => 1671,
    64385 => 1671,
    64386 => 1677,
    64387 => 1677,
    64388 => 1676,
    64389 => 1676,
    64390 => 1678,
    64391 => 1678,
    64392 => 1672,
    64393 => 1672,
    64394 => 1688,
    64395 => 1688,
    64396 => 1681,
    64397 => 1681,
    64398 => 1705,
    64399 => 1705,
    64400 => 1705,
    64401 => 1705,
    64402 => 1711,
    64403 => 1711,
    64404 => 1711,
    64405 => 1711,
    64406 => 1715,
    64407 => 1715,
    64408 => 1715,
    64409 => 1715,
    64410 => 1713,
    64411 => 1713,
    64412 => 1713,
    64413 => 1713,
    64414 => 1722,
    64415 => 1722,
    64416 => 1723,
    64417 => 1723,
    64418 => 1723,
    64419 => 1723,
    64420 => 1728,
    64421 => 1728,
    64422 => 1729,
    64423 => 1729,
    64424 => 1729,
    64425 => 1729,
    64426 => 1726,
    64427 => 1726,
    64428 => 1726,
    64429 => 1726,
    64430 => 1746,
    64431 => 1746,
    64432 => 1747,
    64433 => 1747,
    64467 => 1709,
    64468 => 1709,
    64469 => 1709,
    64470 => 1709,
    64471 => 1735,
    64472 => 1735,
    64473 => 1734,
    64474 => 1734,
    64475 => 1736,
    64476 => 1736,
    64477 => [1735, 1652],
    64478 => 1739,
    64479 => 1739,
    64480 => 1733,
    64481 => 1733,
    64482 => 1737,
    64483 => 1737,
    64484 => 1744,
    64485 => 1744,
    64486 => 1744,
    64487 => 1744,
    64488 => 1609,
    64489 => 1609,
    64490 => [1574, 1575],
    64491 => [1574, 1575],
    64492 => [1574, 1749],
    64493 => [1574, 1749],
    64494 => [1574, 1608],
    64495 => [1574, 1608],
    64496 => [1574, 1735],
    64497 => [1574, 1735],
    64498 => [1574, 1734],
    64499 => [1574, 1734],
    64500 => [1574, 1736],
    64501 => [1574, 1736],
    64502 => [1574, 1744],
    64503 => [1574, 1744],
    64504 => [1574, 1744],
    64505 => [1574, 1609],
    64506 => [1574, 1609],
    64507 => [1574, 1609],
    64508 => 1740,
    64509 => 1740,
    64510 => 1740,
    64511 => 1740,
    64512 => [1574, 1580],
    64513 => [1574, 1581],
    64514 => [1574, 1605],
    64515 => [1574, 1609],
    64516 => [1574, 1610],
    64517 => [1576, 1580],
    64518 => [1576, 1581],
    64519 => [1576, 1582],
    64520 => [1576, 1605],
    64521 => [1576, 1609],
    64522 => [1576, 1610],
    64523 => [1578, 1580],
    64524 => [1578, 1581],
    64525 => [1578, 1582],
    64526 => [1578, 1605],
    64527 => [1578, 1609],
    64528 => [1578, 1610],
    64529 => [1579, 1580],
    64530 => [1579, 1605],
    64531 => [1579, 1609],
    64532 => [1579, 1610],
    64533 => [1580, 1581],
    64534 => [1580, 1605],
    64535 => [1581, 1580],
    64536 => [1581, 1605],
    64537 => [1582, 1580],
    64538 => [1582, 1581],
    64539 => [1582, 1605],
    64540 => [1587, 1580],
    64541 => [1587, 1581],
    64542 => [1587, 1582],
    64543 => [1587, 1605],
    64544 => [1589, 1581],
    64545 => [1589, 1605],
    64546 => [1590, 1580],
    64547 => [1590, 1581],
    64548 => [1590, 1582],
    64549 => [1590, 1605],
    64550 => [1591, 1581],
    64551 => [1591, 1605],
    64552 => [1592, 1605],
    64553 => [1593, 1580],
    64554 => [1593, 1605],
    64555 => [1594, 1580],
    64556 => [1594, 1605],
    64557 => [1601, 1580],
    64558 => [1601, 1581],
    64559 => [1601, 1582],
    64560 => [1601, 1605],
    64561 => [1601, 1609],
    64562 => [1601, 1610],
    64563 => [1602, 1581],
    64564 => [1602, 1605],
    64565 => [1602, 1609],
    64566 => [1602, 1610],
    64567 => [1603, 1575],
    64568 => [1603, 1580],
    64569 => [1603, 1581],
    64570 => [1603, 1582],
    64571 => [1603, 1604],
    64572 => [1603, 1605],
    64573 => [1603, 1609],
    64574 => [1603, 1610],
    64575 => [1604, 1580],
    64576 => [1604, 1581],
    64577 => [1604, 1582],
    64578 => [1604, 1605],
    64579 => [1604, 1609],
    64580 => [1604, 1610],
    64581 => [1605, 1580],
    64582 => [1605, 1581],
    64583 => [1605, 1582],
    64584 => [1605, 1605],
    64585 => [1605, 1609],
    64586 => [1605, 1610],
    64587 => [1606, 1580],
    64588 => [1606, 1581],
    64589 => [1606, 1582],
    64590 => [1606, 1605],
    64591 => [1606, 1609],
    64592 => [1606, 1610],
    64593 => [1607, 1580],
    64594 => [1607, 1605],
    64595 => [1607, 1609],
    64596 => [1607, 1610],
    64597 => [1610, 1580],
    64598 => [1610, 1581],
    64599 => [1610, 1582],
    64600 => [1610, 1605],
    64601 => [1610, 1609],
    64602 => [1610, 1610],
    64603 => [1584, 1648],
    64604 => [1585, 1648],
    64605 => [1609, 1648],
    64606 => [32, 1612, 1617],
    64607 => [32, 1613, 1617],
    64608 => [32, 1614, 1617],
    64609 => [32, 1615, 1617],
    64610 => [32, 1616, 1617],
    64611 => [32, 1617, 1648],
    64612 => [1574, 1585],
    64613 => [1574, 1586],
    64614 => [1574, 1605],
    64615 => [1574, 1606],
    64616 => [1574, 1609],
    64617 => [1574, 1610],
    64618 => [1576, 1585],
    64619 => [1576, 1586],
    64620 => [1576, 1605],
    64621 => [1576, 1606],
    64622 => [1576, 1609],
    64623 => [1576, 1610],
    64624 => [1578, 1585],
    64625 => [1578, 1586],
    64626 => [1578, 1605],
    64627 => [1578, 1606],
    64628 => [1578, 1609],
    64629 => [1578, 1610],
    64630 => [1579, 1585],
    64631 => [1579, 1586],
    64632 => [1579, 1605],
    64633 => [1579, 1606],
    64634 => [1579, 1609],
    64635 => [1579, 1610],
    64636 => [1601, 1609],
    64637 => [1601, 1610],
    64638 => [1602, 1609],
    64639 => [1602, 1610],
    64640 => [1603, 1575],
    64641 => [1603, 1604],
    64642 => [1603, 1605],
    64643 => [1603, 1609],
    64644 => [1603, 1610],
    64645 => [1604, 1605],
    64646 => [1604, 1609],
    64647 => [1604, 1610],
    64648 => [1605, 1575],
    64649 => [1605, 1605],
    64650 => [1606, 1585],
    64651 => [1606, 1586],
    64652 => [1606, 1605],
    64653 => [1606, 1606],
    64654 => [1606, 1609],
    64655 => [1606, 1610],
    64656 => [1609, 1648],
    64657 => [1610, 1585],
    64658 => [1610, 1586],
    64659 => [1610, 1605],
    64660 => [1610, 1606],
    64661 => [1610, 1609],
    64662 => [1610, 1610],
    64663 => [1574, 1580],
    64664 => [1574, 1581],
    64665 => [1574, 1582],
    64666 => [1574, 1605],
    64667 => [1574, 1607],
    64668 => [1576, 1580],
    64669 => [1576, 1581],
    64670 => [1576, 1582],
    64671 => [1576, 1605],
    64672 => [1576, 1607],
    64673 => [1578, 1580],
    64674 => [1578, 1581],
    64675 => [1578, 1582],
    64676 => [1578, 1605],
    64677 => [1578, 1607],
    64678 => [1579, 1605],
    64679 => [1580, 1581],
    64680 => [1580, 1605],
    64681 => [1581, 1580],
    64682 => [1581, 1605],
    64683 => [1582, 1580],
    64684 => [1582, 1605],
    64685 => [1587, 1580],
    64686 => [1587, 1581],
    64687 => [1587, 1582],
    64688 => [1587, 1605],
    64689 => [1589, 1581],
    64690 => [1589, 1582],
    64691 => [1589, 1605],
    64692 => [1590, 1580],
    64693 => [1590, 1581],
    64694 => [1590, 1582],
    64695 => [1590, 1605],
    64696 => [1591, 1581],
    64697 => [1592, 1605],
    64698 => [1593, 1580],
    64699 => [1593, 1605],
    64700 => [1594, 1580],
    64701 => [1594, 1605],
    64702 => [1601, 1580],
    64703 => [1601, 1581],
    64704 => [1601, 1582],
    64705 => [1601, 1605],
    64706 => [1602, 1581],
    64707 => [1602, 1605],
    64708 => [1603, 1580],
    64709 => [1603, 1581],
    64710 => [1603, 1582],
    64711 => [1603, 1604],
    64712 => [1603, 1605],
    64713 => [1604, 1580],
    64714 => [1604, 1581],
    64715 => [1604, 1582],
    64716 => [1604, 1605],
    64717 => [1604, 1607],
    64718 => [1605, 1580],
    64719 => [1605, 1581],
    64720 => [1605, 1582],
    64721 => [1605, 1605],
    64722 => [1606, 1580],
    64723 => [1606, 1581],
    64724 => [1606, 1582],
    64725 => [1606, 1605],
    64726 => [1606, 1607],
    64727 => [1607, 1580],
    64728 => [1607, 1605],
    64729 => [1607, 1648],
    64730 => [1610, 1580],
    64731 => [1610, 1581],
    64732 => [1610, 1582],
    64733 => [1610, 1605],
    64734 => [1610, 1607],
    64735 => [1574, 1605],
    64736 => [1574, 1607],
    64737 => [1576, 1605],
    64738 => [1576, 1607],
    64739 => [1578, 1605],
    64740 => [1578, 1607],
    64741 => [1579, 1605],
    64742 => [1579, 1607],
    64743 => [1587, 1605],
    64744 => [1587, 1607],
    64745 => [1588, 1605],
    64746 => [1588, 1607],
    64747 => [1603, 1604],
    64748 => [1603, 1605],
    64749 => [1604, 1605],
    64750 => [1606, 1605],
    64751 => [1606, 1607],
    64752 => [1610, 1605],
    64753 => [1610, 1607],
    64754 => [1600, 1614, 1617],
    64755 => [1600, 1615, 1617],
    64756 => [1600, 1616, 1617],
    64757 => [1591, 1609],
    64758 => [1591, 1610],
    64759 => [1593, 1609],
    64760 => [1593, 1610],
    64761 => [1594, 1609],
    64762 => [1594, 1610],
    64763 => [1587, 1609],
    64764 => [1587, 1610],
    64765 => [1588, 1609],
    64766 => [1588, 1610],
    64767 => [1581, 1609],
    64768 => [1581, 1610],
    64769 => [1580, 1609],
    64770 => [1580, 1610],
    64771 => [1582, 1609],
    64772 => [1582, 1610],
    64773 => [1589, 1609],
    64774 => [1589, 1610],
    64775 => [1590, 1609],
    64776 => [1590, 1610],
    64777 => [1588, 1580],
    64778 => [1588, 1581],
    64779 => [1588, 1582],
    64780 => [1588, 1605],
    64781 => [1588, 1585],
    64782 => [1587, 1585],
    64783 => [1589, 1585],
    64784 => [1590, 1585],
    64785 => [1591, 1609],
    64786 => [1591, 1610],
    64787 => [1593, 1609],
    64788 => [1593, 1610],
    64789 => [1594, 1609],
    64790 => [1594, 1610],
    64791 => [1587, 1609],
    64792 => [1587, 1610],
    64793 => [1588, 1609],
    64794 => [1588, 1610],
    64795 => [1581, 1609],
    64796 => [1581, 1610],
    64797 => [1580, 1609],
    64798 => [1580, 1610],
    64799 => [1582, 1609],
    64800 => [1582, 1610],
    64801 => [1589, 1609],
    64802 => [1589, 1610],
    64803 => [1590, 1609],
    64804 => [1590, 1610],
    64805 => [1588, 1580],
    64806 => [1588, 1581],
    64807 => [1588, 1582],
    64808 => [1588, 1605],
    64809 => [1588, 1585],
    64810 => [1587, 1585],
    64811 => [1589, 1585],
    64812 => [1590, 1585],
    64813 => [1588, 1580],
    64814 => [1588, 1581],
    64815 => [1588, 1582],
    64816 => [1588, 1605],
    64817 => [1587, 1607],
    64818 => [1588, 1607],
    64819 => [1591, 1605],
    64820 => [1587, 1580],
    64821 => [1587, 1581],
    64822 => [1587, 1582],
    64823 => [1588, 1580],
    64824 => [1588, 1581],
    64825 => [1588, 1582],
    64826 => [1591, 1605],
    64827 => [1592, 1605],
    64828 => [1575, 1611],
    64829 => [1575, 1611],
    64848 => [1578, 1580, 1605],
    64849 => [1578, 1581, 1580],
    64850 => [1578, 1581, 1580],
    64851 => [1578, 1581, 1605],
    64852 => [1578, 1582, 1605],
    64853 => [1578, 1605, 1580],
    64854 => [1578, 1605, 1581],
    64855 => [1578, 1605, 1582],
    64856 => [1580, 1605, 1581],
    64857 => [1580, 1605, 1581],
    64858 => [1581, 1605, 1610],
    64859 => [1581, 1605, 1609],
    64860 => [1587, 1581, 1580],
    64861 => [1587, 1580, 1581],
    64862 => [1587, 1580, 1609],
    64863 => [1587, 1605, 1581],
    64864 => [1587, 1605, 1581],
    64865 => [1587, 1605, 1580],
    64866 => [1587, 1605, 1605],
    64867 => [1587, 1605, 1605],
    64868 => [1589, 1581, 1581],
    64869 => [1589, 1581, 1581],
    64870 => [1589, 1605, 1605],
    64871 => [1588, 1581, 1605],
    64872 => [1588, 1581, 1605],
    64873 => [1588, 1580, 1610],
    64874 => [1588, 1605, 1582],
    64875 => [1588, 1605, 1582],
    64876 => [1588, 1605, 1605],
    64877 => [1588, 1605, 1605],
    64878 => [1590, 1581, 1609],
    64879 => [1590, 1582, 1605],
    64880 => [1590, 1582, 1605],
    64881 => [1591, 1605, 1581],
    64882 => [1591, 1605, 1581],
    64883 => [1591, 1605, 1605],
    64884 => [1591, 1605, 1610],
    64885 => [1593, 1580, 1605],
    64886 => [1593, 1605, 1605],
    64887 => [1593, 1605, 1605],
    64888 => [1593, 1605, 1609],
    64889 => [1594, 1605, 1605],
    64890 => [1594, 1605, 1610],
    64891 => [1594, 1605, 1609],
    64892 => [1601, 1582, 1605],
    64893 => [1601, 1582, 1605],
    64894 => [1602, 1605, 1581],
    64895 => [1602, 1605, 1605],
    64896 => [1604, 1581, 1605],
    64897 => [1604, 1581, 1610],
    64898 => [1604, 1581, 1609],
    64899 => [1604, 1580, 1580],
    64900 => [1604, 1580, 1580],
    64901 => [1604, 1582, 1605],
    64902 => [1604, 1582, 1605],
    64903 => [1604, 1605, 1581],
    64904 => [1604, 1605, 1581],
    64905 => [1605, 1581, 1580],
    64906 => [1605, 1581, 1605],
    64907 => [1605, 1581, 1610],
    64908 => [1605, 1580, 1581],
    64909 => [1605, 1580, 1605],
    64910 => [1605, 1582, 1580],
    64911 => [1605, 1582, 1605],
    64914 => [1605, 1580, 1582],
    64915 => [1607, 1605, 1580],
    64916 => [1607, 1605, 1605],
    64917 => [1606, 1581, 1605],
    64918 => [1606, 1581, 1609],
    64919 => [1606, 1580, 1605],
    64920 => [1606, 1580, 1605],
    64921 => [1606, 1580, 1609],
    64922 => [1606, 1605, 1610],
    64923 => [1606, 1605, 1609],
    64924 => [1610, 1605, 1605],
    64925 => [1610, 1605, 1605],
    64926 => [1576, 1582, 1610],
    64927 => [1578, 1580, 1610],
    64928 => [1578, 1580, 1609],
    64929 => [1578, 1582, 1610],
    64930 => [1578, 1582, 1609],
    64931 => [1578, 1605, 1610],
    64932 => [1578, 1605, 1609],
    64933 => [1580, 1605, 1610],
    64934 => [1580, 1581, 1609],
    64935 => [1580, 1605, 1609],
    64936 => [1587, 1582, 1609],
    64937 => [1589, 1581, 1610],
    64938 => [1588, 1581, 1610],
    64939 => [1590, 1581, 1610],
    64940 => [1604, 1580, 1610],
    64941 => [1604, 1605, 1610],
    64942 => [1610, 1581, 1610],
    64943 => [1610, 1580, 1610],
    64944 => [1610, 1605, 1610],
    64945 => [1605, 1605, 1610],
    64946 => [1602, 1605, 1610],
    64947 => [1606, 1581, 1610],
    64948 => [1602, 1605, 1581],
    64949 => [1604, 1581, 1605],
    64950 => [1593, 1605, 1610],
    64951 => [1603, 1605, 1610],
    64952 => [1606, 1580, 1581],
    64953 => [1605, 1582, 1610],
    64954 => [1604, 1580, 1605],
    64955 => [1603, 1605, 1605],
    64956 => [1604, 1580, 1605],
    64957 => [1606, 1580, 1581],
    64958 => [1580, 1581, 1610],
    64959 => [1581, 1580, 1610],
    64960 => [1605, 1580, 1610],
    64961 => [1601, 1605, 1610],
    64962 => [1576, 1581, 1610],
    64963 => [1603, 1605, 1605],
    64964 => [1593, 1580, 1605],
    64965 => [1589, 1605, 1605],
    64966 => [1587, 1582, 1610],
    64967 => [1606, 1580, 1610],
    65008 => [1589, 1604, 1746],
    65009 => [1602, 1604, 1746],
    65010 => [1575, 1604, 1604, 1607],
    65011 => [1575, 1603, 1576, 1585],
    65012 => [1605, 1581, 1605, 1583],
    65013 => [1589, 1604, 1593, 1605],
    65014 => [1585, 1587, 1608, 1604],
    65015 => [1593, 1604, 1610, 1607],
    65016 => [1608, 1587, 1604, 1605],
    65017 => [1589, 1604, 1609],
    65018 => [1589, 1604, 1609, 32, 1575, 1604, 1604, 1607, 32, 1593, 1604, 1610, 1607, 32, 1608, 1587, 1604, 1605],
    65019 => [1580, 1604, 32, 1580, 1604, 1575, 1604, 1607],
    65020 => [1585, 1740, 1575, 1604],
    65024 => [],
    65025 => [],
    65026 => [],
    65027 => [],
    65028 => [],
    65029 => [],
    65030 => [],
    65031 => [],
    65032 => [],
    65033 => [],
    65034 => [],
    65035 => [],
    65036 => [],
    65037 => [],
    65038 => [],
    65039 => [],
    65040 => 44,
    65041 => 12289,
    65043 => 58,
    65044 => 59,
    65045 => 33,
    65046 => 63,
    65047 => 12310,
    65048 => 12311,
    65073 => 8212,
    65074 => 8211,
    65075 => 95,
    65076 => 95,
    65077 => 40,
    65078 => 41,
    65079 => 123,
    65080 => 125,
    65081 => 12308,
    65082 => 12309,
    65083 => 12304,
    65084 => 12305,
    65085 => 12298,
    65086 => 12299,
    65087 => 12296,
    65088 => 12297,
    65089 => 12300,
    65090 => 12301,
    65091 => 12302,
    65092 => 12303,
    65095 => 91,
    65096 => 93,
    65097 => [32, 773],
    65098 => [32, 773],
    65099 => [32, 773],
    65100 => [32, 773],
    65101 => 95,
    65102 => 95,
    65103 => 95,
    65104 => 44,
    65105 => 12289,
    65108 => 59,
    65109 => 58,
    65110 => 63,
    65111 => 33,
    65112 => 8212,
    65113 => 40,
    65114 => 41,
    65115 => 123,
    65116 => 125,
    65117 => 12308,
    65118 => 12309,
    65119 => 35,
    65120 => 38,
    65121 => 42,
    65122 => 43,
    65123 => 45,
    65124 => 60,
    65125 => 62,
    65126 => 61,
    65128 => 92,
    65129 => 36,
    65130 => 37,
    65131 => 64,
    65136 => [32, 1611],
    65137 => [1600, 1611],
    65138 => [32, 1612],
    65140 => [32, 1613],
    65142 => [32, 1614],
    65143 => [1600, 1614],
    65144 => [32, 1615],
    65145 => [1600, 1615],
    65146 => [32, 1616],
    65147 => [1600, 1616],
    65148 => [32, 1617],
    65149 => [1600, 1617],
    65150 => [32, 1618],
    65151 => [1600, 1618],
    65152 => 1569,
    65153 => 1570,
    65154 => 1570,
    65155 => 1571,
    65156 => 1571,
    65157 => 1572,
    65158 => 1572,
    65159 => 1573,
    65160 => 1573,
    65161 => 1574,
    65162 => 1574,
    65163 => 1574,
    65164 => 1574,
    65165 => 1575,
    65166 => 1575,
    65167 => 1576,
    65168 => 1576,
    65169 => 1576,
    65170 => 1576,
    65171 => 1577,
    65172 => 1577,
    65173 => 1578,
    65174 => 1578,
    65175 => 1578,
    65176 => 1578,
    65177 => 1579,
    65178 => 1579,
    65179 => 1579,
    65180 => 1579,
    65181 => 1580,
    65182 => 1580,
    65183 => 1580,
    65184 => 1580,
    65185 => 1581,
    65186 => 1581,
    65187 => 1581,
    65188 => 1581,
    65189 => 1582,
    65190 => 1582,
    65191 => 1582,
    65192 => 1582,
    65193 => 1583,
    65194 => 1583,
    65195 => 1584,
    65196 => 1584,
    65197 => 1585,
    65198 => 1585,
    65199 => 1586,
    65200 => 1586,
    65201 => 1587,
    65202 => 1587,
    65203 => 1587,
    65204 => 1587,
    65205 => 1588,
    65206 => 1588,
    65207 => 1588,
    65208 => 1588,
    65209 => 1589,
    65210 => 1589,
    65211 => 1589,
    65212 => 1589,
    65213 => 1590,
    65214 => 1590,
    65215 => 1590,
    65216 => 1590,
    65217 => 1591,
    65218 => 1591,
    65219 => 1591,
    65220 => 1591,
    65221 => 1592,
    65222 => 1592,
    65223 => 1592,
    65224 => 1592,
    65225 => 1593,
    65226 => 1593,
    65227 => 1593,
    65228 => 1593,
    65229 => 1594,
    65230 => 1594,
    65231 => 1594,
    65232 => 1594,
    65233 => 1601,
    65234 => 1601,
    65235 => 1601,
    65236 => 1601,
    65237 => 1602,
    65238 => 1602,
    65239 => 1602,
    65240 => 1602,
    65241 => 1603,
    65242 => 1603,
    65243 => 1603,
    65244 => 1603,
    65245 => 1604,
    65246 => 1604,
    65247 => 1604,
    65248 => 1604,
    65249 => 1605,
    65250 => 1605,
    65251 => 1605,
    65252 => 1605,
    65253 => 1606,
    65254 => 1606,
    65255 => 1606,
    65256 => 1606,
    65257 => 1607,
    65258 => 1607,
    65259 => 1607,
    65260 => 1607,
    65261 => 1608,
    65262 => 1608,
    65263 => 1609,
    65264 => 1609,
    65265 => 1610,
    65266 => 1610,
    65267 => 1610,
    65268 => 1610,
    65269 => [1604, 1570],
    65270 => [1604, 1570],
    65271 => [1604, 1571],
    65272 => [1604, 1571],
    65273 => [1604, 1573],
    65274 => [1604, 1573],
    65275 => [1604, 1575],
    65276 => [1604, 1575],
    65279 => [],
    65281 => 33,
    65282 => 34,
    65283 => 35,
    65284 => 36,
    65285 => 37,
    65286 => 38,
    65287 => 39,
    65288 => 40,
    65289 => 41,
    65290 => 42,
    65291 => 43,
    65292 => 44,
    65293 => 45,
    65294 => 46,
    65295 => 47,
    65296 => 48,
    65297 => 49,
    65298 => 50,
    65299 => 51,
    65300 => 52,
    65301 => 53,
    65302 => 54,
    65303 => 55,
    65304 => 56,
    65305 => 57,
    65306 => 58,
    65307 => 59,
    65308 => 60,
    65309 => 61,
    65310 => 62,
    65311 => 63,
    65312 => 64,
    65313 => 97,
    65314 => 98,
    65315 => 99,
    65316 => 100,
    65317 => 101,
    65318 => 102,
    65319 => 103,
    65320 => 104,
    65321 => 105,
    65322 => 106,
    65323 => 107,
    65324 => 108,
    65325 => 109,
    65326 => 110,
    65327 => 111,
    65328 => 112,
    65329 => 113,
    65330 => 114,
    65331 => 115,
    65332 => 116,
    65333 => 117,
    65334 => 118,
    65335 => 119,
    65336 => 120,
    65337 => 121,
    65338 => 122,
    65339 => 91,
    65340 => 92,
    65341 => 93,
    65342 => 94,
    65343 => 95,
    65344 => 96,
    65345 => 97,
    65346 => 98,
    65347 => 99,
    65348 => 100,
    65349 => 101,
    65350 => 102,
    65351 => 103,
    65352 => 104,
    65353 => 105,
    65354 => 106,
    65355 => 107,
    65356 => 108,
    65357 => 109,
    65358 => 110,
    65359 => 111,
    65360 => 112,
    65361 => 113,
    65362 => 114,
    65363 => 115,
    65364 => 116,
    65365 => 117,
    65366 => 118,
    65367 => 119,
    65368 => 120,
    65369 => 121,
    65370 => 122,
    65371 => 123,
    65372 => 124,
    65373 => 125,
    65374 => 126,
    65375 => 10629,
    65376 => 10630,
    65377 => 46,
    65378 => 12300,
    65379 => 12301,
    65380 => 12289,
    65381 => 12539,
    65382 => 12530,
    65383 => 12449,
    65384 => 12451,
    65385 => 12453,
    65386 => 12455,
    65387 => 12457,
    65388 => 12515,
    65389 => 12517,
    65390 => 12519,
    65391 => 12483,
    65392 => 12540,
    65393 => 12450,
    65394 => 12452,
    65395 => 12454,
    65396 => 12456,
    65397 => 12458,
    65398 => 12459,
    65399 => 12461,
    65400 => 12463,
    65401 => 12465,
    65402 => 12467,
    65403 => 12469,
    65404 => 12471,
    65405 => 12473,
    65406 => 12475,
    65407 => 12477,
    65408 => 12479,
    65409 => 12481,
    65410 => 12484,
    65411 => 12486,
    65412 => 12488,
    65413 => 12490,
    65414 => 12491,
    65415 => 12492,
    65416 => 12493,
    65417 => 12494,
    65418 => 12495,
    65419 => 12498,
    65420 => 12501,
    65421 => 12504,
    65422 => 12507,
    65423 => 12510,
    65424 => 12511,
    65425 => 12512,
    65426 => 12513,
    65427 => 12514,
    65428 => 12516,
    65429 => 12518,
    65430 => 12520,
    65431 => 12521,
    65432 => 12522,
    65433 => 12523,
    65434 => 12524,
    65435 => 12525,
    65436 => 12527,
    65437 => 12531,
    65438 => 12441,
    65439 => 12442,
    65441 => 4352,
    65442 => 4353,
    65443 => 4522,
    65444 => 4354,
    65445 => 4524,
    65446 => 4525,
    65447 => 4355,
    65448 => 4356,
    65449 => 4357,
    65450 => 4528,
    65451 => 4529,
    65452 => 4530,
    65453 => 4531,
    65454 => 4532,
    65455 => 4533,
    65456 => 4378,
    65457 => 4358,
    65458 => 4359,
    65459 => 4360,
    65460 => 4385,
    65461 => 4361,
    65462 => 4362,
    65463 => 4363,
    65464 => 4364,
    65465 => 4365,
    65466 => 4366,
    65467 => 4367,
    65468 => 4368,
    65469 => 4369,
    65470 => 4370,
    65474 => 4449,
    65475 => 4450,
    65476 => 4451,
    65477 => 4452,
    65478 => 4453,
    65479 => 4454,
    65482 => 4455,
    65483 => 4456,
    65484 => 4457,
    65485 => 4458,
    65486 => 4459,
    65487 => 4460,
    65490 => 4461,
    65491 => 4462,
    65492 => 4463,
    65493 => 4464,
    65494 => 4465,
    65495 => 4466,
    65498 => 4467,
    65499 => 4468,
    65500 => 4469,
    65504 => 162,
    65505 => 163,
    65506 => 172,
    65507 => [32, 772],
    65508 => 166,
    65509 => 165,
    65510 => 8361,
    65512 => 9474,
    65513 => 8592,
    65514 => 8593,
    65515 => 8594,
    65516 => 8595,
    65517 => 9632,
    65518 => 9675,
    66560 => 66600,
    66561 => 66601,
    66562 => 66602,
    66563 => 66603,
    66564 => 66604,
    66565 => 66605,
    66566 => 66606,
    66567 => 66607,
    66568 => 66608,
    66569 => 66609,
    66570 => 66610,
    66571 => 66611,
    66572 => 66612,
    66573 => 66613,
    66574 => 66614,
    66575 => 66615,
    66576 => 66616,
    66577 => 66617,
    66578 => 66618,
    66579 => 66619,
    66580 => 66620,
    66581 => 66621,
    66582 => 66622,
    66583 => 66623,
    66584 => 66624,
    66585 => 66625,
    66586 => 66626,
    66587 => 66627,
    66588 => 66628,
    66589 => 66629,
    66590 => 66630,
    66591 => 66631,
    66592 => 66632,
    66593 => 66633,
    66594 => 66634,
    66595 => 66635,
    66596 => 66636,
    66597 => 66637,
    66598 => 66638,
    66599 => 66639,
    66736 => 66776,
    66737 => 66777,
    66738 => 66778,
    66739 => 66779,
    66740 => 66780,
    66741 => 66781,
    66742 => 66782,
    66743 => 66783,
    66744 => 66784,
    66745 => 66785,
    66746 => 66786,
    66747 => 66787,
    66748 => 66788,
    66749 => 66789,
    66750 => 66790,
    66751 => 66791,
    66752 => 66792,
    66753 => 66793,
    66754 => 66794,
    66755 => 66795,
    66756 => 66796,
    66757 => 66797,
    66758 => 66798,
    66759 => 66799,
    66760 => 66800,
    66761 => 66801,
    66762 => 66802,
    66763 => 66803,
    66764 => 66804,
    66765 => 66805,
    66766 => 66806,
    66767 => 66807,
    66768 => 66808,
    66769 => 66809,
    66770 => 66810,
    66771 => 66811,
    68736 => 68800,
    68737 => 68801,
    68738 => 68802,
    68739 => 68803,
    68740 => 68804,
    68741 => 68805,
    68742 => 68806,
    68743 => 68807,
    68744 => 68808,
    68745 => 68809,
    68746 => 68810,
    68747 => 68811,
    68748 => 68812,
    68749 => 68813,
    68750 => 68814,
    68751 => 68815,
    68752 => 68816,
    68753 => 68817,
    68754 => 68818,
    68755 => 68819,
    68756 => 68820,
    68757 => 68821,
    68758 => 68822,
    68759 => 68823,
    68760 => 68824,
    68761 => 68825,
    68762 => 68826,
    68763 => 68827,
    68764 => 68828,
    68765 => 68829,
    68766 => 68830,
    68767 => 68831,
    68768 => 68832,
    68769 => 68833,
    68770 => 68834,
    68771 => 68835,
    68772 => 68836,
    68773 => 68837,
    68774 => 68838,
    68775 => 68839,
    68776 => 68840,
    68777 => 68841,
    68778 => 68842,
    68779 => 68843,
    68780 => 68844,
    68781 => 68845,
    68782 => 68846,
    68783 => 68847,
    68784 => 68848,
    68785 => 68849,
    68786 => 68850,
    71840 => 71872,
    71841 => 71873,
    71842 => 71874,
    71843 => 71875,
    71844 => 71876,
    71845 => 71877,
    71846 => 71878,
    71847 => 71879,
    71848 => 71880,
    71849 => 71881,
    71850 => 71882,
    71851 => 71883,
    71852 => 71884,
    71853 => 71885,
    71854 => 71886,
    71855 => 71887,
    71856 => 71888,
    71857 => 71889,
    71858 => 71890,
    71859 => 71891,
    71860 => 71892,
    71861 => 71893,
    71862 => 71894,
    71863 => 71895,
    71864 => 71896,
    71865 => 71897,
    71866 => 71898,
    71867 => 71899,
    71868 => 71900,
    71869 => 71901,
    71870 => 71902,
    71871 => 71903,
    113824 => [],
    113825 => [],
    113826 => [],
    113827 => [],
    119134 => [119127, 119141],
    119135 => [119128, 119141],
    119136 => [119128, 119141, 119150],
    119137 => [119128, 119141, 119151],
    119138 => [119128, 119141, 119152],
    119139 => [119128, 119141, 119153],
    119140 => [119128, 119141, 119154],
    119227 => [119225, 119141],
    119228 => [119226, 119141],
    119229 => [119225, 119141, 119150],
    119230 => [119226, 119141, 119150],
    119231 => [119225, 119141, 119151],
    119232 => [119226, 119141, 119151],
    119808 => 97,
    119809 => 98,
    119810 => 99,
    119811 => 100,
    119812 => 101,
    119813 => 102,
    119814 => 103,
    119815 => 104,
    119816 => 105,
    119817 => 106,
    119818 => 107,
    119819 => 108,
    119820 => 109,
    119821 => 110,
    119822 => 111,
    119823 => 112,
    119824 => 113,
    119825 => 114,
    119826 => 115,
    119827 => 116,
    119828 => 117,
    119829 => 118,
    119830 => 119,
    119831 => 120,
    119832 => 121,
    119833 => 122,
    119834 => 97,
    119835 => 98,
    119836 => 99,
    119837 => 100,
    119838 => 101,
    119839 => 102,
    119840 => 103,
    119841 => 104,
    119842 => 105,
    119843 => 106,
    119844 => 107,
    119845 => 108,
    119846 => 109,
    119847 => 110,
    119848 => 111,
    119849 => 112,
    119850 => 113,
    119851 => 114,
    119852 => 115,
    119853 => 116,
    119854 => 117,
    119855 => 118,
    119856 => 119,
    119857 => 120,
    119858 => 121,
    119859 => 122,
    119860 => 97,
    119861 => 98,
    119862 => 99,
    119863 => 100,
    119864 => 101,
    119865 => 102,
    119866 => 103,
    119867 => 104,
    119868 => 105,
    119869 => 106,
    119870 => 107,
    119871 => 108,
    119872 => 109,
    119873 => 110,
    119874 => 111,
    119875 => 112,
    119876 => 113,
    119877 => 114,
    119878 => 115,
    119879 => 116,
    119880 => 117,
    119881 => 118,
    119882 => 119,
    119883 => 120,
    119884 => 121,
    119885 => 122,
    119886 => 97,
    119887 => 98,
    119888 => 99,
    119889 => 100,
    119890 => 101,
    119891 => 102,
    119892 => 103,
    119894 => 105,
    119895 => 106,
    119896 => 107,
    119897 => 108,
    119898 => 109,
    119899 => 110,
    119900 => 111,
    119901 => 112,
    119902 => 113,
    119903 => 114,
    119904 => 115,
    119905 => 116,
    119906 => 117,
    119907 => 118,
    119908 => 119,
    119909 => 120,
    119910 => 121,
    119911 => 122,
    119912 => 97,
    119913 => 98,
    119914 => 99,
    119915 => 100,
    119916 => 101,
    119917 => 102,
    119918 => 103,
    119919 => 104,
    119920 => 105,
    119921 => 106,
    119922 => 107,
    119923 => 108,
    119924 => 109,
    119925 => 110,
    119926 => 111,
    119927 => 112,
    119928 => 113,
    119929 => 114,
    119930 => 115,
    119931 => 116,
    119932 => 117,
    119933 => 118,
    119934 => 119,
    119935 => 120,
    119936 => 121,
    119937 => 122,
    119938 => 97,
    119939 => 98,
    119940 => 99,
    119941 => 100,
    119942 => 101,
    119943 => 102,
    119944 => 103,
    119945 => 104,
    119946 => 105,
    119947 => 106,
    119948 => 107,
    119949 => 108,
    119950 => 109,
    119951 => 110,
    119952 => 111,
    119953 => 112,
    119954 => 113,
    119955 => 114,
    119956 => 115,
    119957 => 116,
    119958 => 117,
    119959 => 118,
    119960 => 119,
    119961 => 120,
    119962 => 121,
    119963 => 122,
    119964 => 97,
    119966 => 99,
    119967 => 100,
    119970 => 103,
    119973 => 106,
    119974 => 107,
    119977 => 110,
    119978 => 111,
    119979 => 112,
    119980 => 113,
    119982 => 115,
    119983 => 116,
    119984 => 117,
    119985 => 118,
    119986 => 119,
    119987 => 120,
    119988 => 121,
    119989 => 122,
    119990 => 97,
    119991 => 98,
    119992 => 99,
    119993 => 100,
    119995 => 102,
    119997 => 104,
    119998 => 105,
    119999 => 106,
    120000 => 107,
    120001 => 108,
    120002 => 109,
    120003 => 110,
    120005 => 112,
    120006 => 113,
    120007 => 114,
    120008 => 115,
    120009 => 116,
    120010 => 117,
    120011 => 118,
    120012 => 119,
    120013 => 120,
    120014 => 121,
    120015 => 122,
    120016 => 97,
    120017 => 98,
    120018 => 99,
    120019 => 100,
    120020 => 101,
    120021 => 102,
    120022 => 103,
    120023 => 104,
    120024 => 105,
    120025 => 106,
    120026 => 107,
    120027 => 108,
    120028 => 109,
    120029 => 110,
    120030 => 111,
    120031 => 112,
    120032 => 113,
    120033 => 114,
    120034 => 115,
    120035 => 116,
    120036 => 117,
    120037 => 118,
    120038 => 119,
    120039 => 120,
    120040 => 121,
    120041 => 122,
    120042 => 97,
    120043 => 98,
    120044 => 99,
    120045 => 100,
    120046 => 101,
    120047 => 102,
    120048 => 103,
    120049 => 104,
    120050 => 105,
    120051 => 106,
    120052 => 107,
    120053 => 108,
    120054 => 109,
    120055 => 110,
    120056 => 111,
    120057 => 112,
    120058 => 113,
    120059 => 114,
    120060 => 115,
    120061 => 116,
    120062 => 117,
    120063 => 118,
    120064 => 119,
    120065 => 120,
    120066 => 121,
    120067 => 122,
    120068 => 97,
    120069 => 98,
    120071 => 100,
    120072 => 101,
    120073 => 102,
    120074 => 103,
    120077 => 106,
    120078 => 107,
    120079 => 108,
    120080 => 109,
    120081 => 110,
    120082 => 111,
    120083 => 112,
    120084 => 113,
    120086 => 115,
    120087 => 116,
    120088 => 117,
    120089 => 118,
    120090 => 119,
    120091 => 120,
    120092 => 121,
    120094 => 97,
    120095 => 98,
    120096 => 99,
    120097 => 100,
    120098 => 101,
    120099 => 102,
    120100 => 103,
    120101 => 104,
    120102 => 105,
    120103 => 106,
    120104 => 107,
    120105 => 108,
    120106 => 109,
    120107 => 110,
    120108 => 111,
    120109 => 112,
    120110 => 113,
    120111 => 114,
    120112 => 115,
    120113 => 116,
    120114 => 117,
    120115 => 118,
    120116 => 119,
    120117 => 120,
    120118 => 121,
    120119 => 122,
    120120 => 97,
    120121 => 98,
    120123 => 100,
    120124 => 101,
    120125 => 102,
    120126 => 103,
    120128 => 105,
    120129 => 106,
    120130 => 107,
    120131 => 108,
    120132 => 109,
    120134 => 111,
    120138 => 115,
    120139 => 116,
    120140 => 117,
    120141 => 118,
    120142 => 119,
    120143 => 120,
    120144 => 121,
    120146 => 97,
    120147 => 98,
    120148 => 99,
    120149 => 100,
    120150 => 101,
    120151 => 102,
    120152 => 103,
    120153 => 104,
    120154 => 105,
    120155 => 106,
    120156 => 107,
    120157 => 108,
    120158 => 109,
    120159 => 110,
    120160 => 111,
    120161 => 112,
    120162 => 113,
    120163 => 114,
    120164 => 115,
    120165 => 116,
    120166 => 117,
    120167 => 118,
    120168 => 119,
    120169 => 120,
    120170 => 121,
    120171 => 122,
    120172 => 97,
    120173 => 98,
    120174 => 99,
    120175 => 100,
    120176 => 101,
    120177 => 102,
    120178 => 103,
    120179 => 104,
    120180 => 105,
    120181 => 106,
    120182 => 107,
    120183 => 108,
    120184 => 109,
    120185 => 110,
    120186 => 111,
    120187 => 112,
    120188 => 113,
    120189 => 114,
    120190 => 115,
    120191 => 116,
    120192 => 117,
    120193 => 118,
    120194 => 119,
    120195 => 120,
    120196 => 121,
    120197 => 122,
    120198 => 97,
    120199 => 98,
    120200 => 99,
    120201 => 100,
    120202 => 101,
    120203 => 102,
    120204 => 103,
    120205 => 104,
    120206 => 105,
    120207 => 106,
    120208 => 107,
    120209 => 108,
    120210 => 109,
    120211 => 110,
    120212 => 111,
    120213 => 112,
    120214 => 113,
    120215 => 114,
    120216 => 115,
    120217 => 116,
    120218 => 117,
    120219 => 118,
    120220 => 119,
    120221 => 120,
    120222 => 121,
    120223 => 122,
    120224 => 97,
    120225 => 98,
    120226 => 99,
    120227 => 100,
    120228 => 101,
    120229 => 102,
    120230 => 103,
    120231 => 104,
    120232 => 105,
    120233 => 106,
    120234 => 107,
    120235 => 108,
    120236 => 109,
    120237 => 110,
    120238 => 111,
    120239 => 112,
    120240 => 113,
    120241 => 114,
    120242 => 115,
    120243 => 116,
    120244 => 117,
    120245 => 118,
    120246 => 119,
    120247 => 120,
    120248 => 121,
    120249 => 122,
    120250 => 97,
    120251 => 98,
    120252 => 99,
    120253 => 100,
    120254 => 101,
    120255 => 102,
    120256 => 103,
    120257 => 104,
    120258 => 105,
    120259 => 106,
    120260 => 107,
    120261 => 108,
    120262 => 109,
    120263 => 110,
    120264 => 111,
    120265 => 112,
    120266 => 113,
    120267 => 114,
    120268 => 115,
    120269 => 116,
    120270 => 117,
    120271 => 118,
    120272 => 119,
    120273 => 120,
    120274 => 121,
    120275 => 122,
    120276 => 97,
    120277 => 98,
    120278 => 99,
    120279 => 100,
    120280 => 101,
    120281 => 102,
    120282 => 103,
    120283 => 104,
    120284 => 105,
    120285 => 106,
    120286 => 107,
    120287 => 108,
    120288 => 109,
    120289 => 110,
    120290 => 111,
    120291 => 112,
    120292 => 113,
    120293 => 114,
    120294 => 115,
    120295 => 116,
    120296 => 117,
    120297 => 118,
    120298 => 119,
    120299 => 120,
    120300 => 121,
    120301 => 122,
    120302 => 97,
    120303 => 98,
    120304 => 99,
    120305 => 100,
    120306 => 101,
    120307 => 102,
    120308 => 103,
    120309 => 104,
    120310 => 105,
    120311 => 106,
    120312 => 107,
    120313 => 108,
    120314 => 109,
    120315 => 110,
    120316 => 111,
    120317 => 112,
    120318 => 113,
    120319 => 114,
    120320 => 115,
    120321 => 116,
    120322 => 117,
    120323 => 118,
    120324 => 119,
    120325 => 120,
    120326 => 121,
    120327 => 122,
    120328 => 97,
    120329 => 98,
    120330 => 99,
    120331 => 100,
    120332 => 101,
    120333 => 102,
    120334 => 103,
    120335 => 104,
    120336 => 105,
    120337 => 106,
    120338 => 107,
    120339 => 108,
    120340 => 109,
    120341 => 110,
    120342 => 111,
    120343 => 112,
    120344 => 113,
    120345 => 114,
    120346 => 115,
    120347 => 116,
    120348 => 117,
    120349 => 118,
    120350 => 119,
    120351 => 120,
    120352 => 121,
    120353 => 122,
    120354 => 97,
    120355 => 98,
    120356 => 99,
    120357 => 100,
    120358 => 101,
    120359 => 102,
    120360 => 103,
    120361 => 104,
    120362 => 105,
    120363 => 106,
    120364 => 107,
    120365 => 108,
    120366 => 109,
    120367 => 110,
    120368 => 111,
    120369 => 112,
    120370 => 113,
    120371 => 114,
    120372 => 115,
    120373 => 116,
    120374 => 117,
    120375 => 118,
    120376 => 119,
    120377 => 120,
    120378 => 121,
    120379 => 122,
    120380 => 97,
    120381 => 98,
    120382 => 99,
    120383 => 100,
    120384 => 101,
    120385 => 102,
    120386 => 103,
    120387 => 104,
    120388 => 105,
    120389 => 106,
    120390 => 107,
    120391 => 108,
    120392 => 109,
    120393 => 110,
    120394 => 111,
    120395 => 112,
    120396 => 113,
    120397 => 114,
    120398 => 115,
    120399 => 116,
    120400 => 117,
    120401 => 118,
    120402 => 119,
    120403 => 120,
    120404 => 121,
    120405 => 122,
    120406 => 97,
    120407 => 98,
    120408 => 99,
    120409 => 100,
    120410 => 101,
    120411 => 102,
    120412 => 103,
    120413 => 104,
    120414 => 105,
    120415 => 106,
    120416 => 107,
    120417 => 108,
    120418 => 109,
    120419 => 110,
    120420 => 111,
    120421 => 112,
    120422 => 113,
    120423 => 114,
    120424 => 115,
    120425 => 116,
    120426 => 117,
    120427 => 118,
    120428 => 119,
    120429 => 120,
    120430 => 121,
    120431 => 122,
    120432 => 97,
    120433 => 98,
    120434 => 99,
    120435 => 100,
    120436 => 101,
    120437 => 102,
    120438 => 103,
    120439 => 104,
    120440 => 105,
    120441 => 106,
    120442 => 107,
    120443 => 108,
    120444 => 109,
    120445 => 110,
    120446 => 111,
    120447 => 112,
    120448 => 113,
    120449 => 114,
    120450 => 115,
    120451 => 116,
    120452 => 117,
    120453 => 118,
    120454 => 119,
    120455 => 120,
    120456 => 121,
    120457 => 122,
    120458 => 97,
    120459 => 98,
    120460 => 99,
    120461 => 100,
    120462 => 101,
    120463 => 102,
    120464 => 103,
    120465 => 104,
    120466 => 105,
    120467 => 106,
    120468 => 107,
    120469 => 108,
    120470 => 109,
    120471 => 110,
    120472 => 111,
    120473 => 112,
    120474 => 113,
    120475 => 114,
    120476 => 115,
    120477 => 116,
    120478 => 117,
    120479 => 118,
    120480 => 119,
    120481 => 120,
    120482 => 121,
    120483 => 122,
    120484 => 305,
    120485 => 567,
    120488 => 945,
    120489 => 946,
    120490 => 947,
    120491 => 948,
    120492 => 949,
    120493 => 950,
    120494 => 951,
    120495 => 952,
    120496 => 953,
    120497 => 954,
    120498 => 955,
    120499 => 956,
    120500 => 957,
    120501 => 958,
    120502 => 959,
    120503 => 960,
    120504 => 961,
    120505 => 952,
    120506 => 963,
    120507 => 964,
    120508 => 965,
    120509 => 966,
    120510 => 967,
    120511 => 968,
    120512 => 969,
    120513 => 8711,
    120514 => 945,
    120515 => 946,
    120516 => 947,
    120517 => 948,
    120518 => 949,
    120519 => 950,
    120520 => 951,
    120521 => 952,
    120522 => 953,
    120523 => 954,
    120524 => 955,
    120525 => 956,
    120526 => 957,
    120527 => 958,
    120528 => 959,
    120529 => 960,
    120530 => 961,
    120531 => 963,
    120532 => 963,
    120533 => 964,
    120534 => 965,
    120535 => 966,
    120536 => 967,
    120537 => 968,
    120538 => 969,
    120539 => 8706,
    120540 => 949,
    120541 => 952,
    120542 => 954,
    120543 => 966,
    120544 => 961,
    120545 => 960,
    120546 => 945,
    120547 => 946,
    120548 => 947,
    120549 => 948,
    120550 => 949,
    120551 => 950,
    120552 => 951,
    120553 => 952,
    120554 => 953,
    120555 => 954,
    120556 => 955,
    120557 => 956,
    120558 => 957,
    120559 => 958,
    120560 => 959,
    120561 => 960,
    120562 => 961,
    120563 => 952,
    120564 => 963,
    120565 => 964,
    120566 => 965,
    120567 => 966,
    120568 => 967,
    120569 => 968,
    120570 => 969,
    120571 => 8711,
    120572 => 945,
    120573 => 946,
    120574 => 947,
    120575 => 948,
    120576 => 949,
    120577 => 950,
    120578 => 951,
    120579 => 952,
    120580 => 953,
    120581 => 954,
    120582 => 955,
    120583 => 956,
    120584 => 957,
    120585 => 958,
    120586 => 959,
    120587 => 960,
    120588 => 961,
    120589 => 963,
    120590 => 963,
    120591 => 964,
    120592 => 965,
    120593 => 966,
    120594 => 967,
    120595 => 968,
    120596 => 969,
    120597 => 8706,
    120598 => 949,
    120599 => 952,
    120600 => 954,
    120601 => 966,
    120602 => 961,
    120603 => 960,
    120604 => 945,
    120605 => 946,
    120606 => 947,
    120607 => 948,
    120608 => 949,
    120609 => 950,
    120610 => 951,
    120611 => 952,
    120612 => 953,
    120613 => 954,
    120614 => 955,
    120615 => 956,
    120616 => 957,
    120617 => 958,
    120618 => 959,
    120619 => 960,
    120620 => 961,
    120621 => 952,
    120622 => 963,
    120623 => 964,
    120624 => 965,
    120625 => 966,
    120626 => 967,
    120627 => 968,
    120628 => 969,
    120629 => 8711,
    120630 => 945,
    120631 => 946,
    120632 => 947,
    120633 => 948,
    120634 => 949,
    120635 => 950,
    120636 => 951,
    120637 => 952,
    120638 => 953,
    120639 => 954,
    120640 => 955,
    120641 => 956,
    120642 => 957,
    120643 => 958,
    120644 => 959,
    120645 => 960,
    120646 => 961,
    120647 => 963,
    120648 => 963,
    120649 => 964,
    120650 => 965,
    120651 => 966,
    120652 => 967,
    120653 => 968,
    120654 => 969,
    120655 => 8706,
    120656 => 949,
    120657 => 952,
    120658 => 954,
    120659 => 966,
    120660 => 961,
    120661 => 960,
    120662 => 945,
    120663 => 946,
    120664 => 947,
    120665 => 948,
    120666 => 949,
    120667 => 950,
    120668 => 951,
    120669 => 952,
    120670 => 953,
    120671 => 954,
    120672 => 955,
    120673 => 956,
    120674 => 957,
    120675 => 958,
    120676 => 959,
    120677 => 960,
    120678 => 961,
    120679 => 952,
    120680 => 963,
    120681 => 964,
    120682 => 965,
    120683 => 966,
    120684 => 967,
    120685 => 968,
    120686 => 969,
    120687 => 8711,
    120688 => 945,
    120689 => 946,
    120690 => 947,
    120691 => 948,
    120692 => 949,
    120693 => 950,
    120694 => 951,
    120695 => 952,
    120696 => 953,
    120697 => 954,
    120698 => 955,
    120699 => 956,
    120700 => 957,
    120701 => 958,
    120702 => 959,
    120703 => 960,
    120704 => 961,
    120705 => 963,
    120706 => 963,
    120707 => 964,
    120708 => 965,
    120709 => 966,
    120710 => 967,
    120711 => 968,
    120712 => 969,
    120713 => 8706,
    120714 => 949,
    120715 => 952,
    120716 => 954,
    120717 => 966,
    120718 => 961,
    120719 => 960,
    120720 => 945,
    120721 => 946,
    120722 => 947,
    120723 => 948,
    120724 => 949,
    120725 => 950,
    120726 => 951,
    120727 => 952,
    120728 => 953,
    120729 => 954,
    120730 => 955,
    120731 => 956,
    120732 => 957,
    120733 => 958,
    120734 => 959,
    120735 => 960,
    120736 => 961,
    120737 => 952,
    120738 => 963,
    120739 => 964,
    120740 => 965,
    120741 => 966,
    120742 => 967,
    120743 => 968,
    120744 => 969,
    120745 => 8711,
    120746 => 945,
    120747 => 946,
    120748 => 947,
    120749 => 948,
    120750 => 949,
    120751 => 950,
    120752 => 951,
    120753 => 952,
    120754 => 953,
    120755 => 954,
    120756 => 955,
    120757 => 956,
    120758 => 957,
    120759 => 958,
    120760 => 959,
    120761 => 960,
    120762 => 961,
    120763 => 963,
    120764 => 963,
    120765 => 964,
    120766 => 965,
    120767 => 966,
    120768 => 967,
    120769 => 968,
    120770 => 969,
    120771 => 8706,
    120772 => 949,
    120773 => 952,
    120774 => 954,
    120775 => 966,
    120776 => 961,
    120777 => 960,
    120778 => 989,
    120779 => 989,
    120782 => 48,
    120783 => 49,
    120784 => 50,
    120785 => 51,
    120786 => 52,
    120787 => 53,
    120788 => 54,
    120789 => 55,
    120790 => 56,
    120791 => 57,
    120792 => 48,
    120793 => 49,
    120794 => 50,
    120795 => 51,
    120796 => 52,
    120797 => 53,
    120798 => 54,
    120799 => 55,
    120800 => 56,
    120801 => 57,
    120802 => 48,
    120803 => 49,
    120804 => 50,
    120805 => 51,
    120806 => 52,
    120807 => 53,
    120808 => 54,
    120809 => 55,
    120810 => 56,
    120811 => 57,
    120812 => 48,
    120813 => 49,
    120814 => 50,
    120815 => 51,
    120816 => 52,
    120817 => 53,
    120818 => 54,
    120819 => 55,
    120820 => 56,
    120821 => 57,
    120822 => 48,
    120823 => 49,
    120824 => 50,
    120825 => 51,
    120826 => 52,
    120827 => 53,
    120828 => 54,
    120829 => 55,
    120830 => 56,
    120831 => 57,
    125184 => 125218,
    125185 => 125219,
    125186 => 125220,
    125187 => 125221,
    125188 => 125222,
    125189 => 125223,
    125190 => 125224,
    125191 => 125225,
    125192 => 125226,
    125193 => 125227,
    125194 => 125228,
    125195 => 125229,
    125196 => 125230,
    125197 => 125231,
    125198 => 125232,
    125199 => 125233,
    125200 => 125234,
    125201 => 125235,
    125202 => 125236,
    125203 => 125237,
    125204 => 125238,
    125205 => 125239,
    125206 => 125240,
    125207 => 125241,
    125208 => 125242,
    125209 => 125243,
    125210 => 125244,
    125211 => 125245,
    125212 => 125246,
    125213 => 125247,
    125214 => 125248,
    125215 => 125249,
    125216 => 125250,
    125217 => 125251,
    126464 => 1575,
    126465 => 1576,
    126466 => 1580,
    126467 => 1583,
    126469 => 1608,
    126470 => 1586,
    126471 => 1581,
    126472 => 1591,
    126473 => 1610,
    126474 => 1603,
    126475 => 1604,
    126476 => 1605,
    126477 => 1606,
    126478 => 1587,
    126479 => 1593,
    126480 => 1601,
    126481 => 1589,
    126482 => 1602,
    126483 => 1585,
    126484 => 1588,
    126485 => 1578,
    126486 => 1579,
    126487 => 1582,
    126488 => 1584,
    126489 => 1590,
    126490 => 1592,
    126491 => 1594,
    126492 => 1646,
    126493 => 1722,
    126494 => 1697,
    126495 => 1647,
    126497 => 1576,
    126498 => 1580,
    126500 => 1607,
    126503 => 1581,
    126505 => 1610,
    126506 => 1603,
    126507 => 1604,
    126508 => 1605,
    126509 => 1606,
    126510 => 1587,
    126511 => 1593,
    126512 => 1601,
    126513 => 1589,
    126514 => 1602,
    126516 => 1588,
    126517 => 1578,
    126518 => 1579,
    126519 => 1582,
    126521 => 1590,
    126523 => 1594,
    126530 => 1580,
    126535 => 1581,
    126537 => 1610,
    126539 => 1604,
    126541 => 1606,
    126542 => 1587,
    126543 => 1593,
    126545 => 1589,
    126546 => 1602,
    126548 => 1588,
    126551 => 1582,
    126553 => 1590,
    126555 => 1594,
    126557 => 1722,
    126559 => 1647,
    126561 => 1576,
    126562 => 1580,
    126564 => 1607,
    126567 => 1581,
    126568 => 1591,
    126569 => 1610,
    126570 => 1603,
    126572 => 1605,
    126573 => 1606,
    126574 => 1587,
    126575 => 1593,
    126576 => 1601,
    126577 => 1589,
    126578 => 1602,
    126580 => 1588,
    126581 => 1578,
    126582 => 1579,
    126583 => 1582,
    126585 => 1590,
    126586 => 1592,
    126587 => 1594,
    126588 => 1646,
    126590 => 1697,
    126592 => 1575,
    126593 => 1576,
    126594 => 1580,
    126595 => 1583,
    126596 => 1607,
    126597 => 1608,
    126598 => 1586,
    126599 => 1581,
    126600 => 1591,
    126601 => 1610,
    126603 => 1604,
    126604 => 1605,
    126605 => 1606,
    126606 => 1587,
    126607 => 1593,
    126608 => 1601,
    126609 => 1589,
    126610 => 1602,
    126611 => 1585,
    126612 => 1588,
    126613 => 1578,
    126614 => 1579,
    126615 => 1582,
    126616 => 1584,
    126617 => 1590,
    126618 => 1592,
    126619 => 1594,
    126625 => 1576,
    126626 => 1580,
    126627 => 1583,
    126629 => 1608,
    126630 => 1586,
    126631 => 1581,
    126632 => 1591,
    126633 => 1610,
    126635 => 1604,
    126636 => 1605,
    126637 => 1606,
    126638 => 1587,
    126639 => 1593,
    126640 => 1601,
    126641 => 1589,
    126642 => 1602,
    126643 => 1585,
    126644 => 1588,
    126645 => 1578,
    126646 => 1579,
    126647 => 1582,
    126648 => 1584,
    126649 => 1590,
    126650 => 1592,
    126651 => 1594,
    127233 => [48, 44],
    127234 => [49, 44],
    127235 => [50, 44],
    127236 => [51, 44],
    127237 => [52, 44],
    127238 => [53, 44],
    127239 => [54, 44],
    127240 => [55, 44],
    127241 => [56, 44],
    127242 => [57, 44],
    127248 => [40, 97, 41],
    127249 => [40, 98, 41],
    127250 => [40, 99, 41],
    127251 => [40, 100, 41],
    127252 => [40, 101, 41],
    127253 => [40, 102, 41],
    127254 => [40, 103, 41],
    127255 => [40, 104, 41],
    127256 => [40, 105, 41],
    127257 => [40, 106, 41],
    127258 => [40, 107, 41],
    127259 => [40, 108, 41],
    127260 => [40, 109, 41],
    127261 => [40, 110, 41],
    127262 => [40, 111, 41],
    127263 => [40, 112, 41],
    127264 => [40, 113, 41],
    127265 => [40, 114, 41],
    127266 => [40, 115, 41],
    127267 => [40, 116, 41],
    127268 => [40, 117, 41],
    127269 => [40, 118, 41],
    127270 => [40, 119, 41],
    127271 => [40, 120, 41],
    127272 => [40, 121, 41],
    127273 => [40, 122, 41],
    127274 => [12308, 115, 12309],
    127275 => 99,
    127276 => 114,
    127277 => [99, 100],
    127278 => [119, 122],
    127280 => 97,
    127281 => 98,
    127282 => 99,
    127283 => 100,
    127284 => 101,
    127285 => 102,
    127286 => 103,
    127287 => 104,
    127288 => 105,
    127289 => 106,
    127290 => 107,
    127291 => 108,
    127292 => 109,
    127293 => 110,
    127294 => 111,
    127295 => 112,
    127296 => 113,
    127297 => 114,
    127298 => 115,
    127299 => 116,
    127300 => 117,
    127301 => 118,
    127302 => 119,
    127303 => 120,
    127304 => 121,
    127305 => 122,
    127306 => [104, 118],
    127307 => [109, 118],
    127308 => [115, 100],
    127309 => [115, 115],
    127310 => [112, 112, 118],
    127311 => [119, 99],
    127338 => [109, 99],
    127339 => [109, 100],
    127376 => [100, 106],
    127488 => [12411, 12363],
    127489 => [12467, 12467],
    127490 => 12469,
    127504 => 25163,
    127505 => 23383,
    127506 => 21452,
    127507 => 12487,
    127508 => 20108,
    127509 => 22810,
    127510 => 35299,
    127511 => 22825,
    127512 => 20132,
    127513 => 26144,
    127514 => 28961,
    127515 => 26009,
    127516 => 21069,
    127517 => 24460,
    127518 => 20877,
    127519 => 26032,
    127520 => 21021,
    127521 => 32066,
    127522 => 29983,
    127523 => 36009,
    127524 => 22768,
    127525 => 21561,
    127526 => 28436,
    127527 => 25237,
    127528 => 25429,
    127529 => 19968,
    127530 => 19977,
    127531 => 36938,
    127532 => 24038,
    127533 => 20013,
    127534 => 21491,
    127535 => 25351,
    127536 => 36208,
    127537 => 25171,
    127538 => 31105,
    127539 => 31354,
    127540 => 21512,
    127541 => 28288,
    127542 => 26377,
    127543 => 26376,
    127544 => 30003,
    127545 => 21106,
    127546 => 21942,
    127547 => 37197,
    127552 => [12308, 26412, 12309],
    127553 => [12308, 19977, 12309],
    127554 => [12308, 20108, 12309],
    127555 => [12308, 23433, 12309],
    127556 => [12308, 28857, 12309],
    127557 => [12308, 25171, 12309],
    127558 => [12308, 30423, 12309],
    127559 => [12308, 21213, 12309],
    127560 => [12308, 25943, 12309],
    127568 => 24471,
    127569 => 21487,
    194560 => 20029,
    194561 => 20024,
    194562 => 20033,
    194563 => 131362,
    194564 => 20320,
    194565 => 20398,
    194566 => 20411,
    194567 => 20482,
    194568 => 20602,
    194569 => 20633,
    194570 => 20711,
    194571 => 20687,
    194572 => 13470,
    194573 => 132666,
    194574 => 20813,
    194575 => 20820,
    194576 => 20836,
    194577 => 20855,
    194578 => 132380,
    194579 => 13497,
    194580 => 20839,
    194581 => 20877,
    194582 => 132427,
    194583 => 20887,
    194584 => 20900,
    194585 => 20172,
    194586 => 20908,
    194587 => 20917,
    194588 => 168415,
    194589 => 20981,
    194590 => 20995,
    194591 => 13535,
    194592 => 21051,
    194593 => 21062,
    194594 => 21106,
    194595 => 21111,
    194596 => 13589,
    194597 => 21191,
    194598 => 21193,
    194599 => 21220,
    194600 => 21242,
    194601 => 21253,
    194602 => 21254,
    194603 => 21271,
    194604 => 21321,
    194605 => 21329,
    194606 => 21338,
    194607 => 21363,
    194608 => 21373,
    194609 => 21375,
    194610 => 21375,
    194611 => 21375,
    194612 => 133676,
    194613 => 28784,
    194614 => 21450,
    194615 => 21471,
    194616 => 133987,
    194617 => 21483,
    194618 => 21489,
    194619 => 21510,
    194620 => 21662,
    194621 => 21560,
    194622 => 21576,
    194623 => 21608,
    194624 => 21666,
    194625 => 21750,
    194626 => 21776,
    194627 => 21843,
    194628 => 21859,
    194629 => 21892,
    194630 => 21892,
    194631 => 21913,
    194632 => 21931,
    194633 => 21939,
    194634 => 21954,
    194635 => 22294,
    194636 => 22022,
    194637 => 22295,
    194638 => 22097,
    194639 => 22132,
    194640 => 20999,
    194641 => 22766,
    194642 => 22478,
    194643 => 22516,
    194644 => 22541,
    194645 => 22411,
    194646 => 22578,
    194647 => 22577,
    194648 => 22700,
    194649 => 136420,
    194650 => 22770,
    194651 => 22775,
    194652 => 22790,
    194653 => 22810,
    194654 => 22818,
    194655 => 22882,
    194656 => 136872,
    194657 => 136938,
    194658 => 23020,
    194659 => 23067,
    194660 => 23079,
    194661 => 23000,
    194662 => 23142,
    194663 => 14062,
    194665 => 23304,
    194666 => 23358,
    194667 => 23358,
    194668 => 137672,
    194669 => 23491,
    194670 => 23512,
    194671 => 23527,
    194672 => 23539,
    194673 => 138008,
    194674 => 23551,
    194675 => 23558,
    194677 => 23586,
    194678 => 14209,
    194679 => 23648,
    194680 => 23662,
    194681 => 23744,
    194682 => 23693,
    194683 => 138724,
    194684 => 23875,
    194685 => 138726,
    194686 => 23918,
    194687 => 23915,
    194688 => 23932,
    194689 => 24033,
    194690 => 24034,
    194691 => 14383,
    194692 => 24061,
    194693 => 24104,
    194694 => 24125,
    194695 => 24169,
    194696 => 14434,
    194697 => 139651,
    194698 => 14460,
    194699 => 24240,
    194700 => 24243,
    194701 => 24246,
    194702 => 24266,
    194703 => 172946,
    194704 => 24318,
    194705 => 140081,
    194706 => 140081,
    194707 => 33281,
    194708 => 24354,
    194709 => 24354,
    194710 => 14535,
    194711 => 144056,
    194712 => 156122,
    194713 => 24418,
    194714 => 24427,
    194715 => 14563,
    194716 => 24474,
    194717 => 24525,
    194718 => 24535,
    194719 => 24569,
    194720 => 24705,
    194721 => 14650,
    194722 => 14620,
    194723 => 24724,
    194724 => 141012,
    194725 => 24775,
    194726 => 24904,
    194727 => 24908,
    194728 => 24910,
    194729 => 24908,
    194730 => 24954,
    194731 => 24974,
    194732 => 25010,
    194733 => 24996,
    194734 => 25007,
    194735 => 25054,
    194736 => 25074,
    194737 => 25078,
    194738 => 25104,
    194739 => 25115,
    194740 => 25181,
    194741 => 25265,
    194742 => 25300,
    194743 => 25424,
    194744 => 142092,
    194745 => 25405,
    194746 => 25340,
    194747 => 25448,
    194748 => 25475,
    194749 => 25572,
    194750 => 142321,
    194751 => 25634,
    194752 => 25541,
    194753 => 25513,
    194754 => 14894,
    194755 => 25705,
    194756 => 25726,
    194757 => 25757,
    194758 => 25719,
    194759 => 14956,
    194760 => 25935,
    194761 => 25964,
    194762 => 143370,
    194763 => 26083,
    194764 => 26360,
    194765 => 26185,
    194766 => 15129,
    194767 => 26257,
    194768 => 15112,
    194769 => 15076,
    194770 => 20882,
    194771 => 20885,
    194772 => 26368,
    194773 => 26268,
    194774 => 32941,
    194775 => 17369,
    194776 => 26391,
    194777 => 26395,
    194778 => 26401,
    194779 => 26462,
    194780 => 26451,
    194781 => 144323,
    194782 => 15177,
    194783 => 26618,
    194784 => 26501,
    194785 => 26706,
    194786 => 26757,
    194787 => 144493,
    194788 => 26766,
    194789 => 26655,
    194790 => 26900,
    194791 => 15261,
    194792 => 26946,
    194793 => 27043,
    194794 => 27114,
    194795 => 27304,
    194796 => 145059,
    194797 => 27355,
    194798 => 15384,
    194799 => 27425,
    194800 => 145575,
    194801 => 27476,
    194802 => 15438,
    194803 => 27506,
    194804 => 27551,
    194805 => 27578,
    194806 => 27579,
    194807 => 146061,
    194808 => 138507,
    194809 => 146170,
    194810 => 27726,
    194811 => 146620,
    194812 => 27839,
    194813 => 27853,
    194814 => 27751,
    194815 => 27926,
    194816 => 27966,
    194817 => 28023,
    194818 => 27969,
    194819 => 28009,
    194820 => 28024,
    194821 => 28037,
    194822 => 146718,
    194823 => 27956,
    194824 => 28207,
    194825 => 28270,
    194826 => 15667,
    194827 => 28363,
    194828 => 28359,
    194829 => 147153,
    194830 => 28153,
    194831 => 28526,
    194832 => 147294,
    194833 => 147342,
    194834 => 28614,
    194835 => 28729,
    194836 => 28702,
    194837 => 28699,
    194838 => 15766,
    194839 => 28746,
    194840 => 28797,
    194841 => 28791,
    194842 => 28845,
    194843 => 132389,
    194844 => 28997,
    194845 => 148067,
    194846 => 29084,
    194848 => 29224,
    194849 => 29237,
    194850 => 29264,
    194851 => 149000,
    194852 => 29312,
    194853 => 29333,
    194854 => 149301,
    194855 => 149524,
    194856 => 29562,
    194857 => 29579,
    194858 => 16044,
    194859 => 29605,
    194860 => 16056,
    194861 => 16056,
    194862 => 29767,
    194863 => 29788,
    194864 => 29809,
    194865 => 29829,
    194866 => 29898,
    194867 => 16155,
    194868 => 29988,
    194869 => 150582,
    194870 => 30014,
    194871 => 150674,
    194872 => 30064,
    194873 => 139679,
    194874 => 30224,
    194875 => 151457,
    194876 => 151480,
    194877 => 151620,
    194878 => 16380,
    194879 => 16392,
    194880 => 30452,
    194881 => 151795,
    194882 => 151794,
    194883 => 151833,
    194884 => 151859,
    194885 => 30494,
    194886 => 30495,
    194887 => 30495,
    194888 => 30538,
    194889 => 16441,
    194890 => 30603,
    194891 => 16454,
    194892 => 16534,
    194893 => 152605,
    194894 => 30798,
    194895 => 30860,
    194896 => 30924,
    194897 => 16611,
    194898 => 153126,
    194899 => 31062,
    194900 => 153242,
    194901 => 153285,
    194902 => 31119,
    194903 => 31211,
    194904 => 16687,
    194905 => 31296,
    194906 => 31306,
    194907 => 31311,
    194908 => 153980,
    194909 => 154279,
    194910 => 154279,
    194912 => 16898,
    194913 => 154539,
    194914 => 31686,
    194915 => 31689,
    194916 => 16935,
    194917 => 154752,
    194918 => 31954,
    194919 => 17056,
    194920 => 31976,
    194921 => 31971,
    194922 => 32000,
    194923 => 155526,
    194924 => 32099,
    194925 => 17153,
    194926 => 32199,
    194927 => 32258,
    194928 => 32325,
    194929 => 17204,
    194930 => 156200,
    194931 => 156231,
    194932 => 17241,
    194933 => 156377,
    194934 => 32634,
    194935 => 156478,
    194936 => 32661,
    194937 => 32762,
    194938 => 32773,
    194939 => 156890,
    194940 => 156963,
    194941 => 32864,
    194942 => 157096,
    194943 => 32880,
    194944 => 144223,
    194945 => 17365,
    194946 => 32946,
    194947 => 33027,
    194948 => 17419,
    194949 => 33086,
    194950 => 23221,
    194951 => 157607,
    194952 => 157621,
    194953 => 144275,
    194954 => 144284,
    194955 => 33281,
    194956 => 33284,
    194957 => 36766,
    194958 => 17515,
    194959 => 33425,
    194960 => 33419,
    194961 => 33437,
    194962 => 21171,
    194963 => 33457,
    194964 => 33459,
    194965 => 33469,
    194966 => 33510,
    194967 => 158524,
    194968 => 33509,
    194969 => 33565,
    194970 => 33635,
    194971 => 33709,
    194972 => 33571,
    194973 => 33725,
    194974 => 33767,
    194975 => 33879,
    194976 => 33619,
    194977 => 33738,
    194978 => 33740,
    194979 => 33756,
    194980 => 158774,
    194981 => 159083,
    194982 => 158933,
    194983 => 17707,
    194984 => 34033,
    194985 => 34035,
    194986 => 34070,
    194987 => 160714,
    194988 => 34148,
    194989 => 159532,
    194990 => 17757,
    194991 => 17761,
    194992 => 159665,
    194993 => 159954,
    194994 => 17771,
    194995 => 34384,
    194996 => 34396,
    194997 => 34407,
    194998 => 34409,
    194999 => 34473,
    195000 => 34440,
    195001 => 34574,
    195002 => 34530,
    195003 => 34681,
    195004 => 34600,
    195005 => 34667,
    195006 => 34694,
    195008 => 34785,
    195009 => 34817,
    195010 => 17913,
    195011 => 34912,
    195012 => 34915,
    195013 => 161383,
    195014 => 35031,
    195015 => 35038,
    195016 => 17973,
    195017 => 35066,
    195018 => 13499,
    195019 => 161966,
    195020 => 162150,
    195021 => 18110,
    195022 => 18119,
    195023 => 35488,
    195024 => 35565,
    195025 => 35722,
    195026 => 35925,
    195027 => 162984,
    195028 => 36011,
    195029 => 36033,
    195030 => 36123,
    195031 => 36215,
    195032 => 163631,
    195033 => 133124,
    195034 => 36299,
    195035 => 36284,
    195036 => 36336,
    195037 => 133342,
    195038 => 36564,
    195039 => 36664,
    195040 => 165330,
    195041 => 165357,
    195042 => 37012,
    195043 => 37105,
    195044 => 37137,
    195045 => 165678,
    195046 => 37147,
    195047 => 37432,
    195048 => 37591,
    195049 => 37592,
    195050 => 37500,
    195051 => 37881,
    195052 => 37909,
    195053 => 166906,
    195054 => 38283,
    195055 => 18837,
    195056 => 38327,
    195057 => 167287,
    195058 => 18918,
    195059 => 38595,
    195060 => 23986,
    195061 => 38691,
    195062 => 168261,
    195063 => 168474,
    195064 => 19054,
    195065 => 19062,
    195066 => 38880,
    195067 => 168970,
    195068 => 19122,
    195069 => 169110,
    195070 => 38923,
    195071 => 38923,
    195072 => 38953,
    195073 => 169398,
    195074 => 39138,
    195075 => 19251,
    195076 => 39209,
    195077 => 39335,
    195078 => 39362,
    195079 => 39422,
    195080 => 19406,
    195081 => 170800,
    195082 => 39698,
    195083 => 40000,
    195084 => 40189,
    195085 => 19662,
    195086 => 19693,
    195087 => 40295,
    195088 => 172238,
    195089 => 19704,
    195090 => 172293,
    195091 => 172558,
    195092 => 172689,
    195093 => 40635,
    195094 => 19798,
    195095 => 40697,
    195096 => 40702,
    195097 => 40709,
    195098 => 40719,
    195099 => 40726,
    195100 => 40763,
    195101 => 173568,
    917760 => [],
    917761 => [],
    917762 => [],
    917763 => [],
    917764 => [],
    917765 => [],
    917766 => [],
    917767 => [],
    917768 => [],
    917769 => [],
    917770 => [],
    917771 => [],
    917772 => [],
    917773 => [],
    917774 => [],
    917775 => [],
    917776 => [],
    917777 => [],
    917778 => [],
    917779 => [],
    917780 => [],
    917781 => [],
    917782 => [],
    917783 => [],
    917784 => [],
    917785 => [],
    917786 => [],
    917787 => [],
    917788 => [],
    917789 => [],
    917790 => [],
    917791 => [],
    917792 => [],
    917793 => [],
    917794 => [],
    917795 => [],
    917796 => [],
    917797 => [],
    917798 => [],
    917799 => [],
    917800 => [],
    917801 => [],
    917802 => [],
    917803 => [],
    917804 => [],
    917805 => [],
    917806 => [],
    917807 => [],
    917808 => [],
    917809 => [],
    917810 => [],
    917811 => [],
    917812 => [],
    917813 => [],
    917814 => [],
    917815 => [],
    917816 => [],
    917817 => [],
    917818 => [],
    917819 => [],
    917820 => [],
    917821 => [],
    917822 => [],
    917823 => [],
    917824 => [],
    917825 => [],
    917826 => [],
    917827 => [],
    917828 => [],
    917829 => [],
    917830 => [],
    917831 => [],
    917832 => [],
    917833 => [],
    917834 => [],
    917835 => [],
    917836 => [],
    917837 => [],
    917838 => [],
    917839 => [],
    917840 => [],
    917841 => [],
    917842 => [],
    917843 => [],
    917844 => [],
    917845 => [],
    917846 => [],
    917847 => [],
    917848 => [],
    917849 => [],
    917850 => [],
    917851 => [],
    917852 => [],
    917853 => [],
    917854 => [],
    917855 => [],
    917856 => [],
    917857 => [],
    917858 => [],
    917859 => [],
    917860 => [],
    917861 => [],
    917862 => [],
    917863 => [],
    917864 => [],
    917865 => [],
    917866 => [],
    917867 => [],
    917868 => [],
    917869 => [],
    917870 => [],
    917871 => [],
    917872 => [],
    917873 => [],
    917874 => [],
    917875 => [],
    917876 => [],
    917877 => [],
    917878 => [],
    917879 => [],
    917880 => [],
    917881 => [],
    917882 => [],
    917883 => [],
    917884 => [],
    917885 => [],
    917886 => [],
    917887 => [],
    917888 => [],
    917889 => [],
    917890 => [],
    917891 => [],
    917892 => [],
    917893 => [],
    917894 => [],
    917895 => [],
    917896 => [],
    917897 => [],
    917898 => [],
    917899 => [],
    917900 => [],
    917901 => [],
    917902 => [],
    917903 => [],
    917904 => [],
    917905 => [],
    917906 => [],
    917907 => [],
    917908 => [],
    917909 => [],
    917910 => [],
    917911 => [],
    917912 => [],
    917913 => [],
    917914 => [],
    917915 => [],
    917916 => [],
    917917 => [],
    917918 => [],
    917919 => [],
    917920 => [],
    917921 => [],
    917922 => [],
    917923 => [],
    917924 => [],
    917925 => [],
    917926 => [],
    917927 => [],
    917928 => [],
    917929 => [],
    917930 => [],
    917931 => [],
    917932 => [],
    917933 => [],
    917934 => [],
    917935 => [],
    917936 => [],
    917937 => [],
    917938 => [],
    917939 => [],
    917940 => [],
    917941 => [],
    917942 => [],
    917943 => [],
    917944 => [],
    917945 => [],
    917946 => [],
    917947 => [],
    917948 => [],
    917949 => [],
    917950 => [],
    917951 => [],
    917952 => [],
    917953 => [],
    917954 => [],
    917955 => [],
    917956 => [],
    917957 => [],
    917958 => [],
    917959 => [],
    917960 => [],
    917961 => [],
    917962 => [],
    917963 => [],
    917964 => [],
    917965 => [],
    917966 => [],
    917967 => [],
    917968 => [],
    917969 => [],
    917970 => [],
    917971 => [],
    917972 => [],
    917973 => [],
    917974 => [],
    917975 => [],
    917976 => [],
    917977 => [],
    917978 => [],
    917979 => [],
    917980 => [],
    917981 => [],
    917982 => [],
    917983 => [],
    917984 => [],
    917985 => [],
    917986 => [],
    917987 => [],
    917988 => [],
    917989 => [],
    917990 => [],
    917991 => [],
    917992 => [],
    917993 => [],
    917994 => [],
    917995 => [],
    917996 => [],
    917997 => [],
    917998 => [],
    917999 => [],
  }
end
