#!/bin/sh
have_distributed="false"
if test x"$1" = x"-distributed"; then
  have_distributed="true"
  shift
fi
numbering_list=$*
old_file="numbering_list.cc"
new_file="numbering_list.cc.new"

cat > ${new_file} << EOF1
// file automatically generated by: $0
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/numbering.h"
EOF1

for numbering in ${numbering_list}; do
 echo "#include \"${numbering}_numbering.h\"" >>  ${new_file}
done
if $have_distributed; then
 echo "#include \"Pk_numbering.h\"" >>  ${new_file}
 echo "#include \"Pkd_numbering.h\"" >>  ${new_file}
fi

cat >> ${new_file} << EOF2a
namespace rheolef {
using namespace std;

EOF2a

if $have_distributed; then
cat >> ${new_file} << EOF2b1
template <class T, class M>
numbering_rep<T,M>* 
numbering_rep<T,M>::make_ptr (string name) 
EOF2b1
else
cat >> ${new_file} << EOF2b2
numbering_rep* 
numbering_rep::make_ptr (string name) 
EOF2b2
fi

cat >> ${new_file} << EOF2c
{
  // TODO: use gperf instead of a long if-else test suite
  if (name == "") return 0;
EOF2c

for numbering in ${numbering_list}; do
  if test $numbering = "Pk" -o $numbering = "Pkd"; then
    # Pk is a special case, treated below
    continue;
  fi
  if $have_distributed; then
    echo "  if (name == \"${numbering}\") return new_macro((numbering_${numbering}<T,M>));" >>  ${new_file}
  else
    echo "  if (name == \"${numbering}_numbering\") return new_macro(numbering_${numbering});" >>  ${new_file}
  fi
done

if $have_distributed; then
  echo "  if (name == \"P0\" || (name[0] == 'P' && name[name.size()-1] == 'd')) return new_macro((numbering_Pkd<T,M>)(name));" >>  ${new_file}
  echo "  if (name[0] == 'P') return new_macro((numbering_Pk<T,M>)(name));" >>  ${new_file}
fi
cat >> ${new_file} << EOF3
  error_macro ("undefined numbering \`" << name << "'");
  return 0;
}
EOF3

if $have_distributed; then
cat >> ${new_file} << EOF4
// ----------------------------------------------------------------------------
// instanciation in library
// ----------------------------------------------------------------------------

template numbering_rep<Float,sequential>* numbering_rep<Float,sequential>::make_ptr (string name);

#ifdef _RHEOLEF_HAVE_MPI
template numbering_rep<Float,distributed>* numbering_rep<Float,distributed>::make_ptr (string name);
#endif // _RHEOLEF_HAVE_MPI
EOF4
fi

cat >> ${new_file} << EOF5

} // namespace rheolef
EOF5

if test ! -f ${old_file}; then
  mv ${new_file} ${old_file}
  echo "! file ${old_file} created." 1>&2
elif diff ${old_file} ${new_file} >/dev/null; then
  echo "! file ${old_file} unchanged." 1>&2
  rm -f ${new_file}
else
  mv ${new_file} ${old_file}
  echo "! file ${old_file} modified." 1>&2
fi

exit 0
