#! /bin/sh

# Test representation of a table with URLs

TMP_DIR="${TMPDIR}"

test -z "${LIB_DIR}" && LIB_DIR=lib

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

BASENAME=$(basename $0 .pm)

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

TMP_DB_MAIN="${TMP_DIR}/test4fk.db"
TMP_DB_META="${TMP_DIR}/restful.db"
TMP_DB_MAIN_ABS=$(cd $(dirname ${TMP_DB_MAIN}); pwd)/test4fk.db

sqlite3 ${TMP_DB_MAIN} < tests/inputs/samples-r92.sql
sqlite3 ${TMP_DB_MAIN} <<END
    insert into revision (id, uuid, timestamp)
        values (1, '55bb4b09-8daa-478e-8ad5-ddf20ac58bf3', '2000-01-01');
    insert into sample (id, SolsaID, uuid, name, revision_id)
        values (1, 'XX-TEST-0001', '55bb4b09-8daa-478e-8ad5-ddf20ac58bf3', 'test sample', 1);
END

sqlite3 ${TMP_DB_META} < sql/metatables.sql
sqlite3 ${TMP_DB_META} < tests/inputs/samples-metadata-r92.sql
sqlite3 ${TMP_DB_META} "update description set dbname = '${TMP_DB_MAIN_ABS}'"

export TMP_DB_MAIN

sqlite3 ${TMP_DB_MAIN} "select * from sample"

perl <<'END'
#! /usr/bin/env perl

# Test package that computes default database settings:

use strict;
use warnings;
use utf8;
use Data::Dumper;

use lib 'lib';
use Database;

binmode( STDOUT, "utf8" );

$Data::Dumper::Sortkeys = 1;
$Data::Dumper::Indent   = 1;

my $db_settings = {
    content_db => {
        DB => $ENV{TMP_DB_MAIN},
        engine => 'SQLite'            
    }
};

my $db = Database->new( $db_settings );
$db->connect();

my $data = $db->get_record_descriptions( 'sample', { record_id => 1 } );

$data->[0]{columns}{name}{value} = 'renamed test sample';
$db->modify_record_descriptions( $data );

print Dumper $db->get_record_descriptions( 'sample',
                                           { no_foreign => 1,
                                             no_related => 1 } );

END

sqlite3 ${TMP_DB_MAIN} "select * from sample"

# Temporary directory will be deleted by the trap.
