<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:php="http://php.net/xsl"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <!-- ************************************************** -->
    <!--                                                                             -->
    <!--               Basic Structure of the entry                        -->
    <!--                                                                             -->
    <!-- ************************************************** -->

    <xsl:template match="entry">
        <div class="entry">
            <xsl:comment>entry</xsl:comment>
            <h3>
                <xsl:value-of select="@citekey"/>
                <xsl:text> (</xsl:text>
                <xsl:value-of select="@type"/>
                <xsl:text>)</xsl:text>
            </h3>
            <p>
                <xsl:if test="part">
                    <xsl:comment>part</xsl:comment>
                    <xsl:apply-templates select="part"/>
                    <xsl:comment>/part</xsl:comment>
                </xsl:if>
                <xsl:comment>publication</xsl:comment>
                <xsl:apply-templates select="publication"/>
                <xsl:comment>/publication</xsl:comment>
                <xsl:if test="set">
                    <xsl:comment>set</xsl:comment>
                    <xsl:apply-templates select="set"/>
                    <xsl:comment>/set</xsl:comment>
                </xsl:if>
            </p>
            <xsl:if test="contents">
                <p>
                    <xsl:comment>contents</xsl:comment>
                    <xsl:apply-templates select="contents"/>
                    <xsl:comment>/contents</xsl:comment>
                </p>
            </xsl:if>
            <xsl:if test="libinfo">
                <p>
                    <xsl:comment>libinfo</xsl:comment>
                    <xsl:apply-templates select="libinfo"/>
                    <xsl:comment>/libinfo</xsl:comment>
                </p>
            </xsl:if>
            <xsl:comment>/part</xsl:comment>
        </div>
    </xsl:template>

<!--  ************************************ -->
    <!-- *** Import the entry subelements *** -->
    <!-- *********************************** -->

    <xsl:include href="refdb-entry-parts.xsl"/>

    </xsl:stylesheet>