<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:php="http://php.net/xsl"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <!-- ************************************************** -->
    <!--                                                                             -->
    <!--               Basic Structure of the entry                        -->
    <!--                                                                             -->
    <!-- ************************************************** -->

    <xsl:template match="entry">
        <div class="entry">
            <xsl:comment>entry</xsl:comment>
            <h3>
                <xsl:value-of select="@citekey"/>
                <xsl:text> (</xsl:text>
                <xsl:value-of select="@type"/>
                <xsl:text>)</xsl:text>
            </h3>
            <p><button name="sendQuery" type="submit" value="edit.{@id}">Edit
                    this entry</button>&#x00A0;<button name="sendQuery"
                    type="submit" value="delete.{@id}">Delete this
                entry</button>&#x00A0;<button type='submit' name='sendQuery'
            value='display.{@citekey}'>Display as</button>&#x00A0;<select name='format{@citekey}'><option value='ris'>RIS</option><option value='risx'>risx</option><option value='mods'>MODS</option><option value='bibtex'>bibtex</option><option value='db31'>DocBook SGML</option><option value='db31x'>DocBook 4 XML</option><option value='db50x'>DocBook 5 XML</option><option value='teix'>TEI P4</option><option value='tei5x'>TEI P5</option></select></p>
            <p>
                <xsl:if test="part">
                    <xsl:comment>part</xsl:comment>
                    <xsl:apply-templates select="part"/>
                    <xsl:comment>/part</xsl:comment>
                </xsl:if>
                <xsl:comment>publication</xsl:comment>
                <xsl:apply-templates select="publication"/>
                <xsl:comment>/publication</xsl:comment>
                <xsl:if test="set">
                    <xsl:comment>set</xsl:comment>
                    <xsl:apply-templates select="set"/>
                    <xsl:comment>/set</xsl:comment>
                </xsl:if>
            </p>
            <xsl:if test="contents">
                <p>
                    <xsl:comment>contents</xsl:comment>
                    <xsl:apply-templates select="contents"/>
                    <xsl:comment>/contents</xsl:comment>
                </p>
            </xsl:if>
            <xsl:if test="publication/pubinfo/link">
              <xsl:apply-templates select="publication/pubinfo/link"/>
            </xsl:if>
            <xsl:if test="libinfo">
                <p>
                    <xsl:comment>libinfo</xsl:comment>
                    <xsl:apply-templates select="libinfo"/>
                    <xsl:comment>/libinfo</xsl:comment>
                </p>
            </xsl:if>
            <xsl:comment>/part</xsl:comment>
        </div>
    </xsl:template>
    
    <!--  ************************************ -->
    <!-- *** Import the entry subelements *** -->
    <!-- *********************************** -->
    
    <xsl:include href="refdb-entry-parts.xsl"/>
</xsl:stylesheet>
