# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2024 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "DateTime.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.datetime

import raritan.rpc.idl


# interface
class DateTime(Interface):
    idlType = "datetime.DateTime:3.0.3"

    # structure
    class ZoneInfo(Structure):
        idlType = "datetime.DateTime_3_0_3.ZoneInfo:1.0.0"
        elements = ["id", "name", "hasDSTInfo"]

        def __init__(self, id=0, name="", hasDSTInfo=False):
            typecheck.is_int(id, AssertionError)
            typecheck.is_string(name, AssertionError)
            typecheck.is_bool(hasDSTInfo, AssertionError)

            self.id = id
            self.name = name
            self.hasDSTInfo = hasDSTInfo

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                id = json['id'] if 'id' in json or not useDefaults else 0,
                name = json['name'] if 'name' in json or not useDefaults else "",
                hasDSTInfo = json['hasDSTInfo'] if 'hasDSTInfo' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['id'] = self.id
            json['name'] = self.name
            json['hasDSTInfo'] = self.hasDSTInfo
            return json

    # structure
    class ZoneCfg(Structure):
        idlType = "datetime.DateTime_3_0_3.ZoneCfg:1.0.0"
        elements = ["id", "name", "enableAutoDST"]

        def __init__(self, id=0, name="", enableAutoDST=False):
            typecheck.is_int(id, AssertionError)
            typecheck.is_string(name, AssertionError)
            typecheck.is_bool(enableAutoDST, AssertionError)

            self.id = id
            self.name = name
            self.enableAutoDST = enableAutoDST

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                id = json['id'] if 'id' in json or not useDefaults else 0,
                name = json['name'] if 'name' in json or not useDefaults else "",
                enableAutoDST = json['enableAutoDST'] if 'enableAutoDST' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['id'] = self.id
            json['name'] = self.name
            json['enableAutoDST'] = self.enableAutoDST
            return json

    # enumeration
    class Protocol(Enumeration):
        idlType = "datetime.DateTime_3_0_3.Protocol:1.0.0"
        values = ["STATIC", "NTP"]

    Protocol.STATIC = Protocol(0)
    Protocol.NTP = Protocol(1)

    # structure
    class NtpCfg(Structure):
        idlType = "datetime.DateTime_3_0_3.NtpCfg:1.0.0"
        elements = ["server1", "server2"]

        def __init__(self, server1="", server2=""):
            typecheck.is_string(server1, AssertionError)
            typecheck.is_string(server2, AssertionError)

            self.server1 = server1
            self.server2 = server2

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                server1 = json['server1'] if 'server1' in json or not useDefaults else "",
                server2 = json['server2'] if 'server2' in json or not useDefaults else "",
            )
            return obj

        def encode(self):
            json = {}
            json['server1'] = self.server1
            json['server2'] = self.server2
            return json

    # structure
    class Cfg(Structure):
        idlType = "datetime.DateTime_3_0_3.Cfg:1.0.0"
        elements = ["zoneCfg", "protocol", "deviceTime", "ntpCfg"]

        def __init__(self, zoneCfg=None, protocol=None, deviceTime=None, ntpCfg=None):
            if zoneCfg is None:
                zoneCfg = raritan.rpc.datetime.DateTime.ZoneCfg()
            if protocol is None:
                protocol = raritan.rpc.datetime.DateTime.Protocol.STATIC
            if ntpCfg is None:
                ntpCfg = raritan.rpc.datetime.DateTime.NtpCfg()
            typecheck.is_struct(zoneCfg, raritan.rpc.datetime.DateTime.ZoneCfg, AssertionError)
            typecheck.is_enum(protocol, raritan.rpc.datetime.DateTime.Protocol, AssertionError)
            typecheck.is_time(deviceTime, AssertionError)
            typecheck.is_struct(ntpCfg, raritan.rpc.datetime.DateTime.NtpCfg, AssertionError)

            self.zoneCfg = zoneCfg
            self.protocol = protocol
            self.deviceTime = deviceTime
            self.ntpCfg = ntpCfg

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                zoneCfg = raritan.rpc.datetime.DateTime.ZoneCfg.decode(json['zoneCfg'], agent, useDefaults=useDefaults) if 'zoneCfg' in json or not useDefaults else raritan.rpc.datetime.DateTime.ZoneCfg(),
                protocol = raritan.rpc.datetime.DateTime.Protocol.decode(json['protocol']) if 'protocol' in json or not useDefaults else raritan.rpc.datetime.DateTime.Protocol.STATIC,
                deviceTime = raritan.rpc.Time.decode(json['deviceTime']) if 'deviceTime' in json or not useDefaults else None,
                ntpCfg = raritan.rpc.datetime.DateTime.NtpCfg.decode(json['ntpCfg'], agent, useDefaults=useDefaults) if 'ntpCfg' in json or not useDefaults else raritan.rpc.datetime.DateTime.NtpCfg(),
            )
            return obj

        def encode(self):
            json = {}
            json['zoneCfg'] = raritan.rpc.datetime.DateTime.ZoneCfg.encode(self.zoneCfg)
            json['protocol'] = raritan.rpc.datetime.DateTime.Protocol.encode(self.protocol)
            json['deviceTime'] = raritan.rpc.Time.encode(self.deviceTime)
            json['ntpCfg'] = raritan.rpc.datetime.DateTime.NtpCfg.encode(self.ntpCfg)
            return json

    # value object
    class ConfigurationChangedEvent(raritan.rpc.idl.Event):
        idlType = "datetime.DateTime_3_0_3.ConfigurationChangedEvent:1.0.0"

        def __init__(self, source=None):
            super(raritan.rpc.datetime.DateTime.ConfigurationChangedEvent, self).__init__(source)

        def encode(self):
            json = super(raritan.rpc.datetime.DateTime.ConfigurationChangedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.datetime.DateTime.ConfigurationChangedEvent, self).listElements()
            return elements

    # value object
    class ClockChangedEvent(raritan.rpc.idl.Event):
        idlType = "datetime.DateTime_3_0_3.ClockChangedEvent:1.0.0"

        def __init__(self, oldTime=None, newTime=None, source=None):
            super(raritan.rpc.datetime.DateTime.ClockChangedEvent, self).__init__(source)
            typecheck.is_time(oldTime, AssertionError)
            typecheck.is_time(newTime, AssertionError)

            self.oldTime = oldTime
            self.newTime = newTime

        def encode(self):
            json = super(raritan.rpc.datetime.DateTime.ClockChangedEvent, self).encode()
            json['oldTime'] = raritan.rpc.Time.encode(self.oldTime)
            json['newTime'] = raritan.rpc.Time.encode(self.newTime)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldTime = raritan.rpc.Time.decode(json['oldTime']) if 'oldTime' in json or not useDefaults else None,
                newTime = raritan.rpc.Time.decode(json['newTime']) if 'newTime' in json or not useDefaults else None,
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldTime", "newTime"]
            elements = elements + super(raritan.rpc.datetime.DateTime.ClockChangedEvent, self).listElements()
            return elements

    class _getZoneInfos(Interface.Method):
        name = 'getZoneInfos'

        @staticmethod
        def encode(useOlson):
            typecheck.is_bool(useOlson, AssertionError)
            args = {}
            args['useOlson'] = useOlson
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            zoneInfos = [raritan.rpc.datetime.DateTime.ZoneInfo.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['zoneInfos']]
            for x0 in zoneInfos:
                typecheck.is_struct(x0, raritan.rpc.datetime.DateTime.ZoneInfo, DecodeException)
            return zoneInfos

    class _checkNtpServer(Interface.Method):
        name = 'checkNtpServer'

        @staticmethod
        def encode(ntpServer):
            typecheck.is_string(ntpServer, AssertionError)
            args = {}
            args['ntpServer'] = ntpServer
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_bool(_ret_, DecodeException)
            return _ret_

    class _getActiveNtpServers(Interface.Method):
        name = 'getActiveNtpServers'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [x0 for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_string(x0, DecodeException)
            return _ret_

    class _getCfg(Interface.Method):
        name = 'getCfg'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            cfg = raritan.rpc.datetime.DateTime.Cfg.decode(rsp['cfg'], agent, useDefaults=useDefaults)
            typecheck.is_struct(cfg, raritan.rpc.datetime.DateTime.Cfg, DecodeException)
            return cfg

    class _setCfg(Interface.Method):
        name = 'setCfg'

        @staticmethod
        def encode(cfg):
            typecheck.is_struct(cfg, raritan.rpc.datetime.DateTime.Cfg, AssertionError)
            args = {}
            args['cfg'] = raritan.rpc.datetime.DateTime.Cfg.encode(cfg)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getTime(Interface.Method):
        name = 'getTime'

        @staticmethod
        def encode(useOlson):
            typecheck.is_bool(useOlson, AssertionError)
            args = {}
            args['useOlson'] = useOlson
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            zone = raritan.rpc.datetime.DateTime.ZoneInfo.decode(rsp['zone'], agent, useDefaults=useDefaults)
            dstEnabled = rsp['dstEnabled']
            utcOffset = rsp['utcOffset']
            currentTime = raritan.rpc.Time.decode(rsp['currentTime'])
            typecheck.is_struct(zone, raritan.rpc.datetime.DateTime.ZoneInfo, DecodeException)
            typecheck.is_bool(dstEnabled, DecodeException)
            typecheck.is_int(utcOffset, DecodeException)
            typecheck.is_time(currentTime, DecodeException)
            return (zone, dstEnabled, utcOffset, currentTime)
    def __init__(self, target, agent):
        super(DateTime, self).__init__(target, agent)
        self.getZoneInfos = DateTime._getZoneInfos(self)
        self.checkNtpServer = DateTime._checkNtpServer(self)
        self.getActiveNtpServers = DateTime._getActiveNtpServers(self)
        self.getCfg = DateTime._getCfg(self)
        self.setCfg = DateTime._setCfg(self)
        self.getTime = DateTime._getTime(self)
