// NOTE: Keep in sync with debug/p/debug_gdb.c (it isn't as of now)

#include "arch.h"

gdb_reg_t gdb_regs_x86_64[] = {
	{ "rax", 0, 8 },
	{ "rbx", 8, 8 },
	{ "rcx", 16, 8 },
	{ "rdx", 24, 8 },
	{ "rsi", 32, 8 },
	{ "rdi", 40, 8 },
	{ "rbp", 48, 8 },
	{ "rsp", 56, 8 },
	{ "r8", 64, 8 },
	{ "r9", 72, 8 },
	{ "r10", 80, 8 },
	{ "r11", 88, 8 },
	{ "r12", 96, 8 },
	{ "r13", 104, 8 },
	{ "r14", 112, 8 },
	{ "r15", 120, 8 },
	{ "rip", 128, 8 },
	{ "eflags", 136, 4 },
	{ "cs", 140, 4 },
	{ "ss", 144, 4 },
	{ "ds", 148, 4 },
	{ "es", 152, 4 },
	{ "fs", 156, 4 },
	{ "gs", 160, 4 },
/* Commented until the long registers are implemented
	{ "st0", 164, 10 },
	{ "st1", 174, 10 },
	{ "st2", 184, 10 },
	{ "st3", 194, 10 },
	{ "st4", 204, 10 },
	{ "st5", 214, 10 },
	{ "st6", 224, 10 },
	{ "st7", 234, 10 },
	{ "fctrl", 244, 4 },
	{ "fstat", 248, 4 },
	{ "ftag", 252, 4 },
	{ "fiseg", 256, 4 },
	{ "fioff", 260, 4 },
	{ "foseg", 264, 4 },
	{ "fooff", 268, 4 },
	{ "fop", 272, 4 },
	{ "xmm0", 276, 16 },
	{ "xmm1", 292, 16 },
	{ "xmm2", 308, 16 },
	{ "xmm3", 324, 16 },
	{ "xmm4", 340, 16 },
	{ "xmm5", 356, 16 },
	{ "xmm6", 372, 16 },
	{ "xmm7", 388, 16 },
	{ "xmm8", 404, 16 },
	{ "xmm9", 420, 16 },
	{ "xmm10", 436, 16 },
	{ "xmm11", 452, 16 },
	{ "xmm12", 468, 16 },
	{ "xmm13", 484, 16 },
	{ "xmm14", 500, 16 },
	{ "xmm15", 516, 16 },
	{ "mxcsr", 532, 4 },
*/
	{ "", 0, 0 }
};


gdb_reg_t gdb_regs_x86_32[] = {
	{ "eax", 0, 4 },
	{ "ecx", 4, 4 },
	{ "edx", 8, 4 },
	{ "ebx", 12, 4 },
	{ "esp", 16, 4 },
	{ "ebp", 20, 4 },
	{ "esi", 24, 4 },
	{ "edi", 28, 4 },
	{ "eip", 32, 4 },
	{ "eflags", 36, 4 },
	{ "cs", 40, 4 },
	{ "ss", 44, 4 },
	{ "ds", 48, 4 },
	{ "es", 52, 4 },
	{ "fs", 56, 4 },
	{ "gs", 60, 4 },
/* Commented until the long registers are implemented
	{ "st0", 64, 10 },
	{ "st1", 74, 10 },
	{ "st2", 84, 10 },
	{ "st3", 94, 10 },
	{ "st4", 104, 10 },
	{ "st5", 114, 10 },
	{ "st6", 124, 10 },
	{ "st7", 134, 10 },
	{ "fctrl", 144, 4 },
	{ "fstat", 148, 4 },
	{ "ftag", 152, 4 },
	{ "fiseg", 156, 4 },
	{ "fioff", 160, 4 },
	{ "foseg", 164, 4 },
	{ "fooff", 168, 4 },
	{ "fop", 172, 4 },
	{ "xmm0", 176, 16 },
	{ "xmm1", 192, 16 },
	{ "xmm2", 208, 16 },
	{ "xmm3", 224, 16 },
	{ "xmm4", 240, 16 },
	{ "xmm5", 256, 16 },
	{ "xmm6", 272, 16 },
	{ "xmm7", 288, 16 },
	{ "mxcsr", 304, 4 },
*/
	{ "", 0, 0 }
};

gdb_reg_t gdb_regs_arm32[] = {
	{ "r0", 0, 4 },
	{ "r1", 4, 4 },
	{ "r2", 8, 4 },
	{ "r3", 12, 4 },
	{ "r4", 16, 4 },
	{ "r5", 20, 4 },
	{ "r6", 24, 4 },
	{ "r7", 28, 4 },
	{ "r8", 32, 4 },
	{ "r9", 36, 4 },
	{ "r10", 40, 4 },
	{ "r11", 44, 4 },
	{ "r12", 48, 4 },
	{ "sp", 52, 4 },
	{ "lr", 56, 4 },
	{ "pc", 60, 4 },
	{ "f0", 64, 12 },
	{ "f1", 76, 12 },
	{ "f2", 88, 12 },
	{ "f3", 100, 12 },
	{ "f4", 112, 12 },
	{ "f5", 124, 12 },
	{ "f6", 136, 12 },
	{ "f7", 148, 12 },
	{ "fps", 160, 12 },
	{ "cpsr", 172, 4 },
	{ "", 0, 0 }
};

gdb_reg_t gdb_regs_aarch64[] = {
	{ "x0", 0, 8 },
	{ "x1", 8, 8 },
	{ "x2", 16, 8 },
	{ "x3", 24, 8 },
	{ "x4", 32, 8 },
	{ "x5", 40, 8 },
	{ "x6", 48, 8 },
	{ "x7", 56, 8 },
	{ "x8", 64, 8 },
	{ "x9", 72, 8 },
	{ "x10", 80, 8 },
	{ "x11", 88, 8 },
	{ "x12", 96, 8 },
	{ "x13", 104, 8 },
	{ "x14", 112, 8 },
	{ "x15", 120, 8 },
	{ "x16", 128, 8 },
	{ "x17", 136, 8 },
	{ "x18", 144, 8 },
	{ "x19", 152, 8 },
	{ "x20", 160, 8 },
	{ "x21", 168, 8 },
	{ "x22", 176, 8 },
	{ "x23", 184, 8 },
	{ "x24", 192, 8 },
	{ "x25", 200, 8 },
	{ "x26", 208, 8 },
	{ "x27", 216, 8 },
	{ "x28", 224, 8 },
	{ "x29", 232, 8 },
	{ "x30", 240, 8 },
	{ "sp", 248, 8 },
	{ "pc", 256, 8 },
	{ "cpsr", 264, 4 },
	{ "v0", 268, 16 },
	{ "v1", 284, 16 },
	{ "v2", 300, 16 },
	{ "v3", 316, 16 },
	{ "v4", 332, 16 },
	{ "v5", 348, 16 },
	{ "v6", 364, 16 },
	{ "v7", 380, 16 },
	{ "v8", 396, 16 },
	{ "v9", 412, 16 },
	{ "v10", 428, 16 },
	{ "v11", 444, 16 },
	{ "v12", 460, 16 },
	{ "v13", 476, 16 },
	{ "v14", 492, 16 },
	{ "v15", 508, 16 },
	{ "v16", 524, 16 },
	{ "v17", 540, 16 },
	{ "v18", 556, 16 },
	{ "v19", 572, 16 },
	{ "v20", 588, 16 },
	{ "v21", 604, 16 },
	{ "v22", 620, 16 },
	{ "v23", 636, 16 },
	{ "v24", 652, 16 },
	{ "v25", 668, 16 },
	{ "v26", 684, 16 },
	{ "v27", 700, 16 },
	{ "v28", 716, 16 },
	{ "v29", 732, 16 },
	{ "v30", 748, 16 },
	{ "v31", 764, 16 },
	{ "fpsr", 780, 4 },
	{ "fpcr", 784, 4 },
	{ "", 0, 0 }
};

gdb_reg_t gdb_regs_lm32[] = {
	{ "r0", 0, 4 },
	{ "r1", 4, 4 },
	{ "r2", 8, 4 },
	{ "r3", 12, 4 },
	{ "r4", 16, 4 },
	{ "r5", 20, 4 },
	{ "r6", 24, 4 },
	{ "r7", 28, 4 },
	{ "r8", 32, 4 },
	{ "r9", 36, 4 },
	{ "r10", 40, 4 },
	{ "r11", 44, 4 },
	{ "r12", 48, 4 },
	{ "r13", 52, 4 },
	{ "r14", 56, 4 },
	{ "r15", 60, 4 },
	{ "r16", 64, 4 },
	{ "r17", 68, 4 },
	{ "r18", 72, 4 },
	{ "r19", 76, 4 },
	{ "r20", 80, 4 },
	{ "r21", 84, 4 },
	{ "r22", 88, 4 },
	{ "r23", 92, 4 },
	{ "r24", 96, 4 },
	{ "r25", 100, 4 },
	{ "gp", 104, 4 },
	{ "fp", 108, 4 },
	{ "sp", 112, 4 },
	{ "ra", 116, 4 },
	{ "ea", 120, 4 },
	{ "ba", 124, 4 },
	{ "PC", 128, 4 },
	{ "EID", 132, 4 },
	{ "EBA", 136, 4 },
	{ "DEBA", 140, 4 },
	{ "IE", 144, 4 },
	{ "IM", 148, 4 },
	{ "IP", 152, 4 },
	{ "", 0, 0 }
};

gdb_reg_t gdb_regs_mips[] = {
	{ "zero", 0, 0 },
	{ "at", 4, 0 },
	{ "v0", 8, 0 },
	{ "v1", 12, 8 },
	{ "a0", 16, 8 },
	{ "a1", 20, 8 },
	{ "a2", 24, 8 },
	{ "a3", 28, 8 },
	{ "t0", 32, 8 },
	{ "t1", 36, 8 },
	{ "t2", 40, 8 },
	{ "t3", 44, 8 },
	{ "t4", 48, 8 },
	{ "t5", 52, 8 },
	{ "t6", 56, 8 },
	{ "t7", 60, 8 },
	{ "s0", 64, 8 },
	{ "s1", 68, 8 },
	{ "s2", 72, 8 },
	{ "s3", 76, 8 },
	{ "s4", 80, 8 },
	{ "s5", 84, 8 },
	{ "s6", 88, 8 },
	{ "s7", 92, 8 },
	{ "t8", 96, 8 },
	{ "t9", 100, 8 },
	{ "k0", 104, 8 },
	{ "k1", 108, 8 },
	{ "gp", 112, 8 },
	{ "sp", 116, 8 },
	{ "s8", 120, 8 },
	{ "ra", 124, 8 },
	{ "sr", 128, 8 },
	{ "lo", 132, 8 },
	{ "hi", 134, 8 },
	{ "bad", 140, 8 },
	{ "cause", 144, 8 },
	{ "pc", 148, 8 },
	{ "f0", 152, 8 },
	{ "f1", 156, 8 },
	{ "f2", 160, 8 },
	{ "f3", 164, 8 },
	{ "f4", 168, 8 },
	{ "f5", 172, 8 },
	{ "f6", 176, 8 },
	{ "f7", 180, 8 },
	{ "f8", 184, 8 },
	{ "f9", 188, 8 },
	{ "f10", 192, 8 },
	{ "f11", 196, 8 },
	{ "f12", 200, 8 },
	{ "f13", 204, 8 },
	{ "f14", 208, 8 },
	{ "f15", 212, 8 },
	{ "f16", 216, 8 },
	{ "f17", 220, 8 },
	{ "f18", 224, 8 },
	{ "f19", 228, 8 },
	{ "f20", 232, 8 },
	{ "f21", 236, 8 },
	{ "f22", 240, 8 },
	{ "f23", 244, 8 },
	{ "f24", 248, 8 },
	{ "f25", 252, 8 },
	{ "f26", 256, 8 },
	{ "f27", 260, 8 },
	{ "f28", 264, 8 },
	{ "f29", 268, 8 },
	{ "f30", 272, 8 },
	{ "f31", 276, 8 },
	{ "fsr", 280, 8 },
	{ "fir", 284, 8 },
	{ "unknw", 288, 8 },
	{ "", 0, 0 }
};

gdb_reg_t gdb_regs_avr[] = {
	{ "r0", 0, 1 },
	{ "r1", 1, 1 },
	{ "r2", 2, 1 },
	{ "r3", 3, 1 },
	{ "r4", 4, 1 },
	{ "r5", 5, 1 },
	{ "r6", 6, 1 },
	{ "r7", 7, 1 },
	{ "r8", 8, 1 },
	{ "r9", 9, 1 },
	{ "r10", 10, 1 },
	{ "r11", 11, 1 },
	{ "r12", 12, 1 },
	{ "r13", 13, 1 },
	{ "r14", 14, 1 },
	{ "r15", 15, 1 },
	{ "r16", 16, 1 },
	{ "r17", 17, 1 },
	{ "r18", 18, 1 },
	{ "r19", 19, 1 },
	{ "r20", 20, 1 },
	{ "r21", 21, 1 },
	{ "r22", 22, 1 },
	{ "r23", 23, 1 },
	{ "r24", 24, 1 },
	{ "r25", 25, 1 },
	{ "r26", 26, 1 },
	{ "r27", 27, 1 },
	{ "r28", 28, 1 },
	{ "r29", 29, 1 },
	{ "r30", 30, 1 },
	{ "r31", 31, 1 },
	{ "sreg", 32, 1 },
	{ "sp", 33, 2 },
	{ "pc2", 35, 4 },
	{ "pc", 39, 4 },
	{ "", 0, 0 }
};
