% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/split.r
\name{str_split}
\alias{str_split}
\alias{str_split_fixed}
\title{Split up a string into pieces.}
\usage{
str_split(string, pattern, n = Inf)

str_split_fixed(string, pattern, n)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{pattern}{Pattern to look for.

  The default interpretation is a regular expression, as described
  in \link[stringi]{stringi-search-regex}. Control options with
  \code{\link{regex}()}.

  Match a fixed string (i.e. by comparing only bytes), using
  \code{\link{fixed}(x)}. This is fast, but approximate. Generally,
  for matching human text, you'll want \code{\link{coll}(x)} which
  respects character matching rules for the specified locale.

  Match character, word, line and sentence boundaries with
  \code{\link{boundary}()}. An empty pattern, "", is equivalent to
  \code{boundary("character")}.}

\item{n}{number of pieces to return.  Default (Inf) uses all
  possible split positions.

  For \code{str_split_fixed}, if n is greater than the number of pieces,
  the result will be padded with empty strings.}
}
\value{
For \code{str_split_fixed}, a character matrix with \code{n} columns.
  For \code{str_split}, a list of character vectors.
}
\description{
Vectorised over \code{string} and \code{pattern}.
}
\examples{
fruits <- c(
  "apples and oranges and pears and bananas",
  "pineapples and mangos and guavas"
)

str_split(fruits, " and ")

# Specify n to restrict the number of possible matches
str_split(fruits, " and ", n = 3)
str_split(fruits, " and ", n = 2)
# If n greater than number of pieces, no padding occurs
str_split(fruits, " and ", n = 5)

# Use fixed to return a character matrix
str_split_fixed(fruits, " and ", 3)
str_split_fixed(fruits, " and ", 4)
}
\seealso{
\code{\link{stri_split}} for the underlying implementation.
}

