% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_zone.R
\name{stri_timezone_get}
\alias{stri_timezone_get}
\alias{stri_timezone_set}
\title{Set or Get Default Time Zone in \pkg{stringi}}
\usage{
stri_timezone_get()

stri_timezone_set(tz)
}
\arguments{
\item{tz}{single string; time zone identifier}
}
\value{
\code{stri_timezone_set} returns a string with
previously used timezone, invisibly.

\code{stri_timezone_get} returns a single string
with the current default time zone.
}
\description{
\code{stri_timezone_set} changes the current default time zone for all functions
in the \pkg{stringi} package, i.e., establishes the meaning of the
``\code{NULL} time zone'' argument to date/time processing functions.

\code{stri_timezone_get} gets the current default time zone.

For more information on time zone representation in \pkg{ICU}
and \pkg{stringi}, refer to \code{\link{stri_timezone_list}}.
}
\details{
Unless the default time zone has already been set using
\code{stri_timezone_set}, the default time zone is determined
by querying the OS with methods in \pkg{ICU}'s internal platform utilities.
}
\examples{
\dontrun{
oldtz <- stri_timezone_set("Europe/Warsaw")
# ... many time zone-dependent operations
stri_timezone_set(oldtz) # restore previous default time zone
}

}
\references{
\emph{TimeZone} class -- ICU API Documentation,
\url{http://www.icu-project.org/apiref/icu4c/classicu_1_1TimeZone.html}
}
\seealso{
Other datetime: 
\code{\link{stri_datetime_add}()},
\code{\link{stri_datetime_create}()},
\code{\link{stri_datetime_fields}()},
\code{\link{stri_datetime_format}()},
\code{\link{stri_datetime_fstr}()},
\code{\link{stri_datetime_now}()},
\code{\link{stri_datetime_symbols}()},
\code{\link{stri_timezone_info}()},
\code{\link{stri_timezone_list}()}

Other timezone: 
\code{\link{stri_timezone_info}()},
\code{\link{stri_timezone_list}()}
}
\concept{datetime}
\concept{timezone}
