% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_unload.R
\name{core_unload}
\alias{core_unload}
\title{Unload (delete) a core}
\usage{
core_unload(
  conn,
  name,
  deleteIndex = FALSE,
  deleteDataDir = FALSE,
  deleteInstanceDir = FALSE,
  async = NULL,
  raw = FALSE,
  callopts = list()
)
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{name}{(character) The name of the core to be created. Required}

\item{deleteIndex}{(logical) If \code{TRUE}, will remove the index when
unloading the core. Default: \code{FALSE}}

\item{deleteDataDir}{(logical)    If \code{TRUE}, removes the data directory
and all sub-directories. Default: \code{FALSE}}

\item{deleteInstanceDir}{(logical)    If \code{TRUE}, removes everything related to
the core, including the index directory, configuration files and other
related files. Default: \code{FALSE}}

\item{async}{(character) Request ID to track this action which will be
processed asynchronously}

\item{raw}{(logical) If \code{TRUE}, returns raw data}

\item{callopts}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Unload (delete) a core
}
\examples{
\dontrun{
# start Solr with Schemaless mode via the schemaless eg:
#   bin/solr start -e schemaless

# connect
(conn <- SolrClient$new())

# Create a core
conn$core_create(name = "books")

# Unload a core
conn$core_unload(name = "books")
## not found
# conn$core_unload(name = "books")
# > Error: 400 - Cannot unload non-existent core [books]
}
}
