% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{withProgress}
\alias{withProgress}
\alias{setProgress}
\alias{incProgress}
\title{Reporting progress (functional API)}
\usage{
withProgress(
  expr,
  min = 0,
  max = 1,
  value = min + (max - min) * 0.1,
  message = NULL,
  detail = NULL,
  style = getShinyOption("progress.style", default = "notification"),
  session = getDefaultReactiveDomain(),
  env = parent.frame(),
  quoted = FALSE
)

setProgress(
  value = NULL,
  message = NULL,
  detail = NULL,
  session = getDefaultReactiveDomain()
)

incProgress(
  amount = 0.1,
  message = NULL,
  detail = NULL,
  session = getDefaultReactiveDomain()
)
}
\arguments{
\item{expr}{The work to be done. This expression should contain calls to
\code{setProgress}.}

\item{min}{The value that represents the starting point of the progress bar.
Must be less tham \code{max}. Default is 0.}

\item{max}{The value that represents the end of the progress bar. Must be
greater than \code{min}. Default is 1.}

\item{value}{Single-element numeric vector; the value at which to set the
progress bar, relative to \code{min} and \code{max}.}

\item{message}{A single-element character vector; the message to be displayed
to the user, or \code{NULL} to hide the current message (if any).}

\item{detail}{A single-element character vector; the detail message to be
displayed to the user, or \code{NULL} to hide the current detail message
(if any). The detail message will be shown with a de-emphasized appearance
relative to \code{message}.}

\item{style}{Progress display style. If \code{"notification"} (the default),
the progress indicator will show using Shiny's notification API. If
\code{"old"}, use the same HTML and CSS used in Shiny 0.13.2 and below
(this is for backward-compatibility).}

\item{session}{The Shiny session object, as provided by \code{shinyServer} to
the server function. The default is to automatically find the session by
using the current reactive domain.}

\item{env}{The environment in which \code{expr} should be evaluated.}

\item{quoted}{Whether \code{expr} is a quoted expression (this is not
common).}

\item{amount}{For \code{incProgress}, the amount to increment the status bar.
Default is 0.1.}
}
\description{
Reports progress to the user during long-running operations.
}
\details{
This package exposes two distinct programming APIs for working with progress.
Using \code{withProgress} with \code{incProgress} or \code{setProgress}
provide a simple function-based interface, while the \code{\link[=Progress]{Progress()}}
reference class provides an object-oriented API.

Use \code{withProgress} to wrap the scope of your work; doing so will cause a
new progress panel to be created, and it will be displayed the first time
\code{incProgress} or \code{setProgress} are called. When \code{withProgress}
exits, the corresponding progress panel will be removed.

The \code{incProgress} function increments the status bar by a specified
amount, whereas the \code{setProgress} function sets it to a specific value,
and can also set the text displayed.

Generally, \code{withProgress}/\code{incProgress}/\code{setProgress} should
be sufficient; the exception is if the work to be done is asynchronous (this
is not common) or otherwise cannot be encapsulated by a single scope. In that
case, you can use the \code{Progress} reference class.

As of version 0.14, the progress indicators use Shiny's new notification API.
If you want to use the old styling (for example, you may have used customized
CSS), you can use \code{style="old"} each time you call
\code{withProgress()}. If you don't want to set the style each time
\code{withProgress} is called, you can instead call
\code{\link[=shinyOptions]{shinyOptions(progress.style="old")}} just once, inside the server
function.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {
options(device.ask.default = FALSE)

ui <- fluidPage(
  plotOutput("plot")
)

server <- function(input, output) {
  output$plot <- renderPlot({
    withProgress(message = 'Calculation in progress',
                 detail = 'This may take a while...', value = 0, {
      for (i in 1:15) {
        incProgress(1/15)
        Sys.sleep(0.25)
      }
    })
    plot(cars)
  })
}

shinyApp(ui, server)
}
}
\seealso{
\code{\link[=Progress]{Progress()}}
}
