% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration5.R
\name{HarmonyIntegration}
\alias{HarmonyIntegration}
\title{Harmony Integration}
\usage{
HarmonyIntegration(
  object,
  orig,
  features = NULL,
  scale.layer = "scale.data",
  new.reduction = "harmony",
  layers = NULL,
  npcs = 50L,
  key = "harmony_",
  theta = NULL,
  lambda = NULL,
  sigma = 0.1,
  nclust = NULL,
  tau = 0,
  block.size = 0.05,
  max.iter.harmony = 10L,
  max.iter.cluster = 20L,
  epsilon.cluster = 1e-05,
  epsilon.harmony = 1e-04,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{An \code{\link[SeuratObject]{Assay5}} object}

\item{orig}{A \link[SeuratObject:DimReduc]{dimensional reduction} to correct}

\item{features}{Ignored}

\item{scale.layer}{Ignored}

\item{new.reduction}{Name of new integrated dimensional reduction}

\item{layers}{Ignored}

\item{npcs}{If doing PCA on input matrix, number of PCs to compute}

\item{key}{Key for Harmony dimensional reduction}

\item{theta}{Diversity clustering penalty parameter}

\item{lambda}{Ridge regression penalty parameter}

\item{sigma}{Width of soft kmeans clusters}

\item{nclust}{Number of clusters in model}

\item{tau}{Protection against overclustering small datasets with large ones}

\item{block.size}{What proportion of cells to update during clustering}

\item{max.iter.harmony}{Maximum number of rounds to run Harmony}

\item{max.iter.cluster}{Maximum number of rounds to run clustering at each round of Harmony}

\item{epsilon.cluster}{Convergence tolerance for clustering round of Harmony}

\item{epsilon.harmony}{Convergence tolerance for Harmony}

\item{verbose}{Whether to print progress messages. TRUE to print, FALSE to suppress}

\item{...}{Ignored}
}
\value{
...
}
\description{
Harmony Integration
}
\note{
This function requires the
\href{https://cran.r-project.org/package=harmony}{\pkg{harmony}} package
to be installed
}
\examples{
\dontrun{
# Preprocessing
obj <- SeuratData::LoadData("pbmcsca")
obj[["RNA"]] <- split(obj[["RNA"]], f = obj$Method)
obj <- NormalizeData(obj)
obj <- FindVariableFeatures(obj)
obj <- ScaleData(obj)
obj <- RunPCA(obj)

# After preprocessing, we integrate layers with added parameters specific to Harmony:
obj <- IntegrateLayers(object = obj, method = HarmonyIntegration, orig.reduction = "pca",
  new.reduction = 'harmony', verbose = FALSE)

# Modifying Parameters
# We can also add arguments specific to Harmony such as theta, to give more diverse clusters
obj <- IntegrateLayers(object = obj, method = HarmonyIntegration, orig.reduction = "pca",
  new.reduction = 'harmony', verbose = FALSE, theta = 3)
# Integrating SCTransformed data
obj <- SCTransform(object = obj)
obj <- IntegrateLayers(object = obj, method = HarmonyIntegration,
  orig.reduction = "pca", new.reduction = 'harmony',
  assay = "SCT", verbose = FALSE)
}


}
\seealso{
\code{\link[harmony:HarmonyMatrix]{harmony::HarmonyMatrix}()}
}
\concept{integration}
