% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.R
\name{df_arrange}
\alias{df_arrange}
\title{Arrange Rows by Column Values}
\usage{
df_arrange(data, ..., vars = NULL, .by_group = FALSE)
}
\arguments{
\item{data}{a data frame}

\item{...}{One or more unquoted expressions (or variable names) separated by
commas. Used to select a variable of interest. Use
\code{\link[dplyr]{desc}()} to sort a variable in descending order.}

\item{vars}{a character vector containing the variable names of interest.}

\item{.by_group}{If TRUE, will sort first by grouping variable. Applies to
grouped data frames only.}
}
\value{
a data frame
}
\description{
Order the rows of a data frame by values of specified columns.
  Wrapper arround the \code{\link[dplyr]{arrange}()} function. Supports
  standard and non standard evaluation.
}
\examples{
df <- head(ToothGrowth)
df

# Select column using standard evaluation
df \%>\% df_arrange(vars = c("dose", "len"))

# Select column using non-standard evaluation
df \%>\% df_arrange(dose, desc(len))
}
