% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reprex-addin.R
\name{reprex_addin}
\alias{reprex_addin}
\alias{reprex_selection}
\title{Render a reprex, conveniently}
\usage{
reprex_addin()

reprex_selection(venue = getOption("reprex.venue", "gh"))
}
\arguments{
\item{venue}{Character. Must be one of the following (case insensitive):
\itemize{
\item "gh" for \href{https://github.github.com/gfm/}{GitHub-Flavored Markdown}, the
default
\item "r" for a runnable R script, with commented output interleaved. Also useful
for \href{https://slack.com/intl/en-ca/slack-tips/share-code-snippets}{Slack code snippets};
select "R" from the "Type" drop-down menu to enjoy nice syntax
highlighting.
\item "rtf" for
\href{https://en.wikipedia.org/wiki/Rich_Text_Format}{Rich Text Format}
(not supported for un-reprexing)
\item "html" for an HTML fragment suitable for inclusion in a larger HTML
document (not supported for un-reprexing)
\item "slack" for pasting into a Slack message. Optimized for people who opt out
of Slack's WYSIWYG interface. Go to
\strong{Preferences > Advanced > Input options} and select "Format messages with
markup". (If there is demand for a second Slack venue optimized for use
with WYSIWYG, please open an issue to discuss.)
\item "so" for
\href{https://stackoverflow.com/editing-help#syntax-highlighting}{Stack Overflow Markdown}.
Note: this is just an alias for "gh", since Stack Overflow started to
support CommonMark-style fenced code blocks in January 2019.
\item "ds" for Discourse, e.g.,
\href{https://forum.posit.co/}{forum.posit.co}. Note: this is
currently just an alias for "gh".
}}
}
\description{
\code{reprex_addin()} opens an \href{https://shiny.rstudio.com/articles/gadgets.html}{RStudio gadget} and
\href{https://rstudio.github.io/rstudioaddins/}{addin} that allows you to say
where the reprex source is (clipboard? current selection? active file?
other file?) and to control a few other arguments. Appears as "Render
reprex" in the RStudio Addins menu.

\code{reprex_selection()} is an
\href{https://docs.posit.co/ide/user/ide/guide/productivity/add-ins.html}{addin} that reprexes the current
selection, optionally customised by options. Appears as "Reprex selection"
in the RStudio Addins menu. Heavy users might want to \href{https://docs.posit.co/ide/user/ide/guide/productivity/custom-shortcuts.html}{create a keyboard shortcut}.
Suggested shortcut: Cmd + Shift + R (macOS) or Ctrl + Shift + R (Windows).
}
