% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler_progress.R
\name{handler_progress}
\alias{handler_progress}
\title{Progression Handler: Progress Reported via 'progress' Progress Bars (Text) in the Terminal}
\usage{
handler_progress(
  format = ":spin [:bar] :percent :message",
  show_after = 0,
  intrusiveness = getOption("progressr.intrusiveness.terminal", 1),
  target = "terminal",
  ...
)
}
\arguments{
\item{format}{(character string) The format of the progress bar.}

\item{show_after}{(numeric) Number of seconds to wait before displaying
the progress bar.}

\item{intrusiveness}{(numeric) A non-negative scalar on how intrusive
(disruptive) the reporter to the user.}

\item{target}{(character vector) Specifies where progression updates are
rendered.}

\item{\ldots}{Additional arguments passed to \code{\link[=make_progression_handler]{make_progression_handler()}}.}
}
\description{
A progression handler for \code{\link[progress:progress_bar]{progress::progress_bar()}}.
}
\section{Requirements}{

This progression handler requires the \pkg{progress} package.
}

\section{Appearance}{

Below are a few examples on how to use and customize this progress handler.
In all cases, we use \code{handlers(global = TRUE)}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{handlers("progress")
y <- slow_sum(1:25)
}\if{html}{\out{</div>}}

\if{html}{\figure{handler_progress-default.svg}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{handlers(handler_progress(complete = "#"))
y <- slow_sum(1:25)
}\if{html}{\out{</div>}}

\if{html}{\figure{handler_progress-complete.svg}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{handlers(handler_progress(format = ":spin [:bar] :percent :message"))
y <- slow_sum(1:25)
}\if{html}{\out{</div>}}

\if{html}{\figure{handler_progress-format-1.svg}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{handlers(handler_progress(format = ":percent [:bar] :eta :message"))
y <- slow_sum(1:25)
}\if{html}{\out{</div>}}

\if{html}{\figure{handler_progress-format-2.svg}}
}

\examples{
if (requireNamespace("progress", quietly = TRUE)) {

  handlers(handler_progress(format = ":spin [:bar] :percent :message"))
  with_progress({ y <- slow_sum(1:10) })
  print(y)
  
}
}
