% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptPath_getter.R
\name{getOptPathY}
\alias{getOptPathY}
\title{Get y-vector or y-matrix from the optimization path.}
\usage{
getOptPathY(op, names, dob, eol, drop = TRUE)
}
\arguments{
\item{op}{\link{OptPath}\cr
Optimization path.}

\item{names}{\link{character}\cr
Names of performance measure.
Default is all performance measures in path.}

\item{dob}{\link{integer}\cr
Vector of date-of-birth values to further subset the result.
Only elements with a date-of-birth included in \code{dob} are selected.
Default is all.}

\item{eol}{\link{integer}\cr
Vector of end-of-life values to further subset the result.
Only elements with an end-of-life included in \code{eol} are selected.
Default is all.}

\item{drop}{(\code{logical(1)})\cr
Return vector instead of matrix when only one y-column was selected?
Default is \code{TRUE}.}
}
\value{
(\code{numeric} | \code{matrix}). The columns of the matrix are always named.
}
\description{
Get y-vector or y-matrix from the optimization path.
}
\seealso{
Other optpath: 
\code{\link{OptPath}},
\code{\link{addOptPathEl}()},
\code{\link{getOptPathBestIndex}()},
\code{\link{getOptPathCols}()},
\code{\link{getOptPathCol}()},
\code{\link{getOptPathDOB}()},
\code{\link{getOptPathEOL}()},
\code{\link{getOptPathEl}()},
\code{\link{getOptPathErrorMessages}()},
\code{\link{getOptPathExecTimes}()},
\code{\link{getOptPathLength}()},
\code{\link{getOptPathParetoFront}()},
\code{\link{getOptPathX}()},
\code{\link{setOptPathElDOB}()},
\code{\link{setOptPathElEOL}()}
}
\concept{optpath}
