% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R
\name{display.parameters_model}
\alias{display.parameters_model}
\title{Print tables in different output formats}
\usage{
\method{display}{parameters_model}(object, format = "markdown", ...)
}
\arguments{
\item{object}{An object returned by one of the package's function, for example
\code{\link[=model_parameters]{model_parameters()}}, \code{\link[=simulate_parameters]{simulate_parameters()}}, \code{\link[=equivalence_test]{equivalence_test()}} or
\code{\link[=principal_components]{principal_components()}}.}

\item{format}{String, indicating the output format. Can be \code{"markdown"}
\code{"html"}, or \code{"tt"}. \code{format = "tt"} creates a \code{tinytable} object, which is
either printed as markdown or HTML table, depending on the environment. See
\code{\link[insight:export_table]{insight::export_table()}} for details.}

\item{...}{Arguments passed to the underlying functions, such as \code{print_md()}
or \code{print_html()}.}
}
\value{
If \code{format = "markdown"}, the return value will be a character
vector in markdown-table format. If \code{format = "html"}, an object of
class \code{gt_tbl}. If \code{format = "tt"}, an object of class \code{tinytable}.
}
\description{
Prints tables (i.e. data frame) in different output formats.
\code{print_md()} is an alias for \code{display(format = "markdown")} and
\code{print_html()} is an alias for \code{display(format = "html")}. A third option is
\code{display(format = "tt")}, which returns a \code{tinytable} object, which is either
printed as markdown or HTML table, depending on the environment.
}
\details{
\code{display()} is useful when the table-output from functions,
which is usually printed as formatted text-table to console, should
be formatted for pretty table-rendering in markdown documents, or if
knitted from rmarkdown to PDF or Word files. See
\href{https://easystats.github.io/parameters/articles/model_parameters_formatting.html}{vignette}
for examples.
}
\examples{
\dontshow{if (require("gt", quietly = TRUE)) withAutoprint(\{ # examplesIf}
model <- lm(mpg ~ wt + cyl, data = mtcars)
mp <- model_parameters(model)
display(mp)

\donttest{
data(iris)
lm1 <- lm(Sepal.Length ~ Species, data = iris)
lm2 <- lm(Sepal.Length ~ Species + Petal.Length, data = iris)
lm3 <- lm(Sepal.Length ~ Species * Petal.Length, data = iris)
out <- compare_parameters(lm1, lm2, lm3)

print_html(
  out,
  select = "{coef}{stars}|({ci})",
  column_labels = c("Estimate", "95\% CI")
)

# line break, unicode minus-sign
print_html(
  out,
  select = "{estimate}{stars}<br>({ci_low} \u2212 {ci_high})",
  column_labels = c("Est. (95\% CI)")
)
}
\dontshow{\}) # examplesIf}
\dontshow{if (all(insight::check_if_installed(c("glmmTMB", "lme4", "tinytable"), quietly = TRUE))) withAutoprint(\{ # examplesIf}
\donttest{
data(iris)
data(Salamanders, package = "glmmTMB")
m1 <- lm(Sepal.Length ~ Species * Petal.Length, data = iris)
m2 <- lme4::lmer(
  Sepal.Length ~ Petal.Length + Petal.Width + (1 | Species),
  data = iris
)
m3 <- glmmTMB::glmmTMB(
  count ~ spp + mined + (1 | site),
  ziformula = ~mined,
  family = poisson(),
  data = Salamanders
)
out <- compare_parameters(m1, m2, m3, effects = "all", component = "all")

display(out, format = "tt")

display(out, select = "{estimate}|{ci}", format = "tt")
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=print.parameters_model]{print.parameters_model()}} and \code{\link[=print.compare_parameters]{print.compare_parameters()}}
}
