% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allPerm.R
\name{allPerm}
\alias{allPerm}
\title{Generate and return all permutations of a multiset}
\usage{
allPerm(mcObj)
}
\arguments{
\item{mcObj}{an object of class mc - usually generated by \code{initMC}}
}
\value{
A matrix with each row being a different permutation of the multiset
}
\description{
This function will return all permutations of a multiset
}
\details{
This function will return all permutations of a multiset. It makes no check
to see if this is a sensible thing to do. Users are advised to check how
many permutations are possible using the \code{multinom} function in this
package.
}
\note{
This function does not warn the user that the requested set of
permutations may be very large. In addition, all working is handled entirely
in memory, and so this may cause it to crash if the request is
execeptionally large.
}
\examples{

## a small numeric example with 6 permuations
x = c(1,1,2,2)
m = initMC(x)
allPerm(m)

## a large character example - 60 possibilities
x = rep(letters[1:3], 3:1)
multinom(x) ## calculate the number of permutations
m = initMC(x)
allPerm(m)

}
\seealso{
\code{\link{initMC}}, \code{\link{multinom}}
}
\author{
James M. Curran
}
\keyword{permutations}
