% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux.R
\name{fico}
\alias{fico}
\title{Fraction of incomplete cases among cases with observed}
\usage{
fico(data)
}
\arguments{
\item{data}{A data frame or a matrix containing the incomplete data.  Missing
values are coded as NA's.}
}
\value{
A vector of length \code{ncol(data)} of FICO statistics.
}
\description{
FICO is an outbound statistic defined by the fraction of incomplete cases
among cases with \code{Yj} observed (White and Carlin, 2010).
}
\references{
Van Buuren, S. (2018).
\href{https://stefvanbuuren.name/fimd/missing-data-pattern.html#sec:flux}{\emph{Flexible Imputation of Missing Data. Second Edition.}}
Chapman & Hall/CRC. Boca Raton, FL.

White, I.R., Carlin, J.B. (2010). Bias and efficiency of multiple imputation
compared with complete-case analysis for missing covariate values.
\emph{Statistics in Medicine}, \emph{29}, 2920-2931.
}
\seealso{
\code{\link{fluxplot}}, \code{\link{flux}}, \code{\link{md.pattern}}
}
\author{
Stef van Buuren, 2012
}
\keyword{misc}
