% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information_retrieval.R
\name{f1}
\alias{f1}
\title{F1 Score}
\usage{
f1(actual, predicted)
}
\arguments{
\item{actual}{The ground truth vector of relevant documents. The vector can contain
any numeric or character values, order does not matter, and the
vector does not need to be the same length as \code{predicted}.}

\item{predicted}{The predicted vector of retrieved documents. The vector can contain
any numeric or character values, order does not matter, and the
vector does not need to be the same length as \code{actual}.}
}
\description{
\code{f1} computes the F1 Score in the context of information retrieval problems.
}
\details{
\code{f1} is defined as \eqn{2 * precision * recall / (precision + recall)}. In the
context of information retrieval problems, precision is the proportion of retrieved
documents that are relevant to a query and recall is the proportion of relevant
documents that are successfully retrieved by a query. If there are zero relevant
documents that are retrieved, zero relevant documents, or zero predicted documents,
\code{f1} is defined as \code{0}.
}
\examples{
actual <- c('a', 'c', 'd')
predicted <- c('d', 'e')
f1(actual, predicted)
}
\seealso{
\code{\link{apk}} \code{\link{mapk}}
}
