% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{sample_}
\alias{sample_}
\title{Sample from a random graph model}
\usage{
sample_(...)
}
\arguments{
\item{...}{Parameters, see details below.}
}
\description{
Generic function for sampling from network models.
}
\details{
\code{sample_()} is a generic function for creating graphs.
For every graph constructor in igraph that has a \code{sample_} prefix,
there is a corresponding function without the prefix: e.g.
for \code{\link[=sample_pa]{sample_pa()}} there is also \code{\link[=pa]{pa()}}, etc.

The same is true for the deterministic graph samplers, i.e. for each
constructor with a \code{make_} prefix, there is a corresponding
function without that prefix.

These shorter forms can be used together with \code{sample_()}.
The advantage of this form is that the user can specify constructor
modifiers which work with all constructors. E.g. the
\code{\link[=with_vertex_]{with_vertex_()}} modifier adds vertex attributes
to the newly created graphs.

See the examples and the various constructor modifiers below.
}
\examples{
pref_matrix <- cbind(c(0.8, 0.1), c(0.1, 0.7))
blocky <- sample_(sbm(
  n = 20, pref.matrix = pref_matrix,
  block.sizes = c(10, 10)
))

blocky2 <- pref_matrix \%>\%
  sample_sbm(n = 20, block.sizes = c(10, 10))

## Arguments are passed on from sample_ to sample_sbm
blocky3 <- pref_matrix \%>\%
  sample_(sbm(), n = 20, block.sizes = c(10, 10))
}
\seealso{
Random graph models (games)
\code{\link{erdos.renyi.game}()},
\code{\link{sample_bipartite}()},
\code{\link{sample_chung_lu}()},
\code{\link{sample_correlated_gnp}()},
\code{\link{sample_correlated_gnp_pair}()},
\code{\link{sample_degseq}()},
\code{\link{sample_dot_product}()},
\code{\link{sample_fitness}()},
\code{\link{sample_fitness_pl}()},
\code{\link{sample_forestfire}()},
\code{\link{sample_gnm}()},
\code{\link{sample_gnp}()},
\code{\link{sample_grg}()},
\code{\link{sample_growing}()},
\code{\link{sample_hierarchical_sbm}()},
\code{\link{sample_islands}()},
\code{\link{sample_k_regular}()},
\code{\link{sample_last_cit}()},
\code{\link{sample_pa}()},
\code{\link{sample_pa_age}()},
\code{\link{sample_pref}()},
\code{\link{sample_sbm}()},
\code{\link{sample_smallworld}()},
\code{\link{sample_traits_callaway}()},
\code{\link{sample_tree}()}

Constructor modifiers (and related functions)
\code{\link{make_}()},
\code{\link{simplified}()},
\code{\link{with_edge_}()},
\code{\link{with_graph_}()},
\code{\link{with_vertex_}()},
\code{\link{without_attr}()},
\code{\link{without_loops}()},
\code{\link{without_multiples}()}
}
\concept{constructor modifiers}
\concept{games}
