% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-build.R
\name{ggplot_build}
\alias{ggplot_build}
\alias{layer_data}
\alias{layer_scales}
\alias{layer_grob}
\title{Build ggplot for rendering.}
\usage{
ggplot_build(plot)

layer_data(plot = last_plot(), i = 1L)

layer_scales(plot = last_plot(), i = 1L, j = 1L)

layer_grob(plot = last_plot(), i = 1L)
}
\arguments{
\item{plot}{ggplot object}

\item{i}{An integer. In \code{layer_data()}, the data to return (in the order added to the
plot). In \code{layer_grob()}, the grob to return (in the order added to the
plot). In \code{layer_scales()}, the row of a facet to return scales for.}

\item{j}{An integer. In \code{layer_scales()}, the column of a facet to return
scales for.}
}
\description{
\code{ggplot_build()} takes the plot object, and performs all steps necessary
to produce an object that can be rendered.  This function outputs two pieces:
a list of data frames (one for each layer), and a panel object, which
contain all information about axis limits, breaks etc.
}
\details{
\code{layer_data()}, \code{layer_grob()}, and \code{layer_scales()} are helper
functions that return the data, grob, or scales associated with a given
layer. These are useful for tests.
}
\seealso{
\code{\link[=print.ggplot]{print.ggplot()}} and \code{\link[=benchplot]{benchplot()}} for
functions that contain the complete set of steps for generating
a ggplot2 plot.
}
\keyword{internal}
