% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_list.r
\name{normalize_function_list}
\alias{normalize_function_list}
\title{Normalize a List of Functions}
\usage{
normalize_function_list(funs)
}
\arguments{
\item{funs}{Valid list or vector of function names and/or functions.}
}
\value{
Named list or character vector of functions.
}
\description{
Takes a list of functions and function names
(or a vector of function names) and names it.
Requires all entries with functions to be named and
adds names to functions that were specified as names.
}
\examples{
normalize_function_list(c(value = 'mean'))
normalize_function_list(c('median', n = 'length'))
normalize_function_list(list('median', n = length))
normalize_function_list(list(Sum = sum, Custom = function(x) sum(nchar(as.character(x)))))

}
