#' @rdname eta_squared
#' @export
cohens_f <- function(model) {
  UseMethod("cohens_f")
}



#' @export
cohens_f.aov <- function(model) {
  if (!inherits(model, c("Gam", "aov", "anova", "anova.rms"))) model <- stats::anova(model)
  m <- .cohens_f(model)
  class(m) <- c("cohens_f", class(m))
  m
}

#' @export
cohens_f.anova <- cohens_f.aov

#' @export
cohens_f.lm <- cohens_f.aov

#' @export
cohens_f.glm <- cohens_f.aov


#' @export
cohens_f.aovlist <- function(model) {
  stop("Cohen's f not implemented yet for repeated-measures ANOVAs.")
}



#' @keywords internal
.cohens_f <- function(model) {
  params <- as.data.frame(parameters::model_parameters(model))
  values <- .values_aov(params)

  if (!"Residuals" %in% params$Parameter) {
    stop("No residuals data found. Eta squared can only be computed for simple `aov` models.")
  }

  .extract_cohens_f(params, values)
}


#' @keywords internal
.extract_cohens_f <- function(params, values) {
  params$Cohens_f <- params$Sum_Squares / (params$Sum_Squares + values$Sum_Squares_residuals)
  params$Cohens_f <- sqrt(params$Cohens_f / (1 - params$Cohens_f))
  params[params$Parameter == "Residuals", "Cohens_f"] <- NA

  params[, intersect(c("Group", "Parameter", "Cohens_f"), names(params)), drop = FALSE]
}
