% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by_scaleBy.R
\name{scaleBy}
\alias{scaleBy}
\alias{scale_by}
\title{Group-wise scaling of data}
\usage{
scaleBy(formula, data = parent.frame(), center = TRUE, scale = TRUE)

scale_by(data, formula, center = TRUE, scale = TRUE)
}
\arguments{
\item{formula}{Grouping structure: a formula, character vector, or variables as \code{as.quoted}.}

\item{data}{A data frame or matrix.}

\item{center}{Logical; if TRUE, center the variables.}

\item{scale}{Logical; if TRUE, scale the variables.}
}
\value{
A list of data frames or matrices (same class as input), one per group.
}
\description{
Splits a data frame or matrix by grouping variables and scales numeric variables within each group.
}
\examples{
scale_by(iris, ~Species)
scale_by(iris, ~1)

## Combine result into one data frame:
a <- scale_by(iris, ~Species)
d <- do.call(rbind, a)

## Old interface
scaleBy(~Species, data = iris, center = TRUE, scale = FALSE)
scaleBy(~1, data = iris)

}
\seealso{
\code{\link{summaryBy}}, \code{\link{transformBy}}, \code{\link{orderBy}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
