% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has_color.r
\name{num_colors}
\alias{num_colors}
\title{Number of colors the terminal supports}
\usage{
num_colors(forget = FALSE)
}
\arguments{
\item{forget}{Whether to forget the cached result of the color check.}
}
\value{
Numeric scalar, the number of colors the terminal supports.
}
\description{
Number of colors the terminal supports
}
\details{
If the \code{crayon.colors} option is set, then we
just use that. It should be an integer number. You can use this
option as a workaround if crayon does not detect the number of
colors accurately.

In Emacs, we report eight colors.

Otherwise, we use the \code{tput} shell command to detect the
number of colors. If \code{tput} is not available,
but we think that the terminal supports colors, then
eigth colors are assumed.

If tput returns 8, but TERM is xterm, we return 256, as most xterm
compatible terminals in fact do support 256 colors.
There is some discussion about this here:
\url{https://github.com/r-lib/crayon/issues/17}

For efficiency, \code{num_colors()} caches its result. To
re-check the number of colors, set the \code{forget} argument to
\code{TRUE}. The cached value is only used if no sinks are active,
see also \code{\link[=has_color]{has_color()}} for more information about sinks.
}
\examples{
num_colors()
}
