% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-glm-tidiers.R
\name{tidy.glm}
\alias{tidy.glm}
\title{Tidy a(n) glm object}
\usage{
\method{tidy}{glm}(x, ...)
}
\arguments{
\item{x}{A \code{glm} object returned from \code{\link[stats:glm]{stats::glm()}}.}

\item{...}{
  Arguments passed on to \code{\link[=tidy.lm]{tidy.lm}}
  \describe{
    \item{\code{conf.int}}{Logical indicating whether or not to include a confidence
interval in the tidied output. Defaults to \code{FALSE}.}
    \item{\code{conf.level}}{The confidence level to use for the confidence interval
if \code{conf.int = TRUE}. Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}
    \item{\code{quick}}{Logical indiciating if the only the \code{term} and \code{estimate}
columns should be returned. Often useful to avoid time consuming
covariance and standard error calculations. Defaults to \code{FALSE}.}
    \item{\code{exponentiate}}{Logical indicating whether or not to exponentiate the
the coefficient estimates. This is typical for logistic and multinomial
regressions, but a bad idea if there is no log or logit link. Defaults
to \code{FALSE}.}
  }}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with one row for each term in the
regression. The tibble has columns:

\item{term}{The name of the regression term.}
\item{estimate}{The estimated value of the regression term.}
\item{std.error}{The standard error of the regression term.}
\item{statistic}{The value of a statistic, almost always a T-statistic,
to use in a hypothesis that the regression term is non-zero.}
\item{p.value}{The two-sided p-value associated with the observed
statistic.}
\item{conf.low}{The low end of a confidence interval for the regression
term. Included only if \code{conf.int = TRUE}.}
\item{conf.high}{The high end of a confidence interval for the regression
term. Included only if \code{conf.int = TRUE}.}

If the linear model is an \code{mlm} object (multiple linear model),
there is an additional column:

\item{response}{Which response column the coefficients correspond to
(typically Y1, Y2, etc)}
}
\description{
This method wraps \code{\link[=tidy.lm]{tidy.lm()}}.
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[=tidy.lm]{tidy.lm()}}

\code{\link[stats:glm]{stats::glm()}}

Other lm tidiers: 
\code{\link{augment.glm}()},
\code{\link{augment.lm}()},
\code{\link{glance.glm}()},
\code{\link{glance.lm}()},
\code{\link{tidy.lm}()}
}
\concept{lm tidiers}
