% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{finish_glance}
\alias{finish_glance}
\title{Add logLik, AIC, BIC, and other common measurements to a glance of
a prediction}
\usage{
finish_glance(ret, x)
}
\arguments{
\item{ret}{a one-row data frame (a partially complete glance)}

\item{x}{the prediction model}
}
\value{
a one-row data frame with additional columns added, such as
\item{logLik}{log likelihoods}
\item{AIC}{Akaike Information Criterion}
\item{BIC}{Bayesian Information Criterion}
\item{deviance}{deviance}
\item{df.residual}{residual degrees of freedom}

Each of these are produced by the corresponding generics
}
\description{
A helper function for several functions in the glance generic. Methods
such as logLik, AIC, and BIC are defined for many prediction
objects, such as lm, glm, and nls. This is a helper function that adds
them to a glance data.frame can be performed. If any of them cannot be
computed, it fails quietly.
}
\details{
In one special case, deviance for objects of the
\code{lmerMod} class from lme4 is computed with
\code{deviance(x, REML=FALSE)}.
}
