% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_outer.R
\name{beta.draws.bma}
\alias{beta.draws.bma}
\title{Coefficients of the Best Models}
\usage{
beta.draws.bma(bmao, stdev = FALSE)
}
\arguments{
\item{bmao}{a 'bma' object (as e.g. resulting from \code{\link{bms}})}

\item{stdev}{if \code{stdev=FALSE} then \code{beta.draws.bma} returns the
(conditional) posterior expected values of the coefficients (i.e. 'Bayesian
coefficients'). If \code{stdev=TRUE} it returns their posterior standard
deviations.}
}
\value{
Each column presents the coefficients for the model indicated by its
column name. The zero coefficients are the excluded covariates per model.
Note that the coefficients returned are only those of the best (100) models
encountered by the \code{bma} object (cf. argument \code{nmodels} of
\code{\link{bms}}).

For aggregate coefficients please refer to \code{\link{coef.bma}}.
}
\description{
Returns a matrix whose columns are the (expected value or standard
deviations of) coefficients for the best models in a bma object.
}
\note{
Note that the elements of \code{beta.draws.bma(bmao)} correspond to
\code{bmao$topmod$betas()}
}
\examples{


  #sample a bma object:
  data(datafls)
  mm=bms(datafls,burn=500,iter=5000,nmodel=20)
  
  #coefficients for all
  beta.draws.bma(mm) 
  
  #standard deviations for the fourth- to eight best models
  beta.draws.bma(mm[4:8],TRUE); 

}
\seealso{
\code{\link{bms}} for creating bms objects, \code{\link{coef.bma}}
for aggregate coefficients

Check \url{http://bms.zeugner.eu} for additional help.
}
\keyword{utilities}
