% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Interface.R
\name{read_airr}
\alias{read_airr}
\title{Read an AIRR Data Model file in YAML or JSON format}
\usage{
read_airr(
  file,
  format = c("auto", "yaml", "json"),
  validate = TRUE,
  model = TRUE
)
}
\arguments{
\item{file}{path to the input file.}

\item{format}{format of the input file. Must be one of \code{"auto"}, \code{"yaml"}, or 
\code{"json"}. If \code{"auto"} (default), the format will be 
detected from the \code{file} extension.}

\item{validate}{run schema validation if \code{TRUE}.}

\item{model}{if \code{TRUE} validate only AIRR DataFile defined objects. If \code{FALSE} 
attempt validation of all objects in \code{data}.
Ignored if \code{validate=FALSE}}
}
\value{
A named nested \code{list} contained in the AIRR Data Model with the top-level
          names reflecting the individual AIRR objects.
}
\description{
\code{read_airr} loads a YAML or JSON file containing AIRR Data Model records.
}
\examples{
# Get path to the Reportoire and GermlineSet example files
f1 <- system.file("extdata", "repertoire-example.yaml", package="airr")
f2 <- system.file("extdata", "germline-example.json", package="airr")

# Load data files
repertoire <- read_airr(f1)
germline <- read_airr(f2)

}
\seealso{
See \link{Schema} for the AIRR schema definition objects.
See \link{write_airr} for writing AIRR Data Model records in YAML or JSON format.
}
