% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot,MotifEnrichmentReport,missing-method}
\alias{plot,MotifEnrichmentReport,missing-method}
\title{Plot the motif enrichment report}
\usage{
\S4method{plot}{MotifEnrichmentReport,missing}(
  x,
  y,
  fontsize = 14,
  id.fontsize = fontsize,
  header.fontsize = fontsize,
  widths = NULL,
  ...
)
}
\arguments{
\item{x}{a MotifEnrichmentReport object}

\item{y}{unused}

\item{fontsize}{font size to use in the plot}

\item{id.fontsize}{font size to use for the motif IDs}

\item{header.fontsize}{font size of the header}

\item{widths}{the relative widths of columns}

\item{...}{unused
if(requireNamespace("PWMEnrich.Dmelanogaster.background")){
   ###
   # load the pre-compiled lognormal background
   data(PWMLogn.dm3.MotifDb.Dmel, package = "PWMEnrich.Dmelanogaster.background")

   # scan two sequences for motif enrichment
   sequences = list(DNAString("GAAGTATCAAGTGACCAGTAAGTCCCAGATGA"), DNAString("AGGTAGATAGAACAGTAGGCAATGAAGCCGATG"))

   res = motifEnrichment(sequences, PWMLogn.dm3.MotifDb.Dmel)

   # produce a report for all sequences taken together
   r = groupReport(res)

   # plot the top 10 most enriched motifs
   plot(r[1:10])

}}
}
\description{
Plots a graphical version of the motif enrichment report. Note that all values are plotted, if you want to plot only a subset of
a report, first select this subset (see examples).
}
