% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_variance_explained.R
\name{calculate_variance_explained}
\alias{calculate_variance_explained}
\title{Calculate variance explained by the model}
\usage{
calculate_variance_explained(
  object,
  views = "all",
  groups = "all",
  factors = "all"
)
}
\arguments{
\item{object}{a \code{\link{MOFA}} object.}

\item{views}{character vector with the view names, or numeric vector with view indexes. Default is 'all'}

\item{groups}{character vector with the group names, or numeric vector with group indexes. Default is 'all'}

\item{factors}{character vector with the factor names, or numeric vector with the factor indexes. Default is 'all'}
}
\value{
a list with matrices with the amount of variation explained per factor and view.
}
\description{
This function takes a trained MOFA model as input and calculates the proportion of variance explained 
(i.e. the coefficient of determinations (R^2)) by the MOFA factors across the different views.
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)

# Calculate variance explained (R2)
r2 <- calculate_variance_explained(model)

# Plot variance explained values (view as x-axis, and factor as y-axis)
plot_variance_explained(model, x="view", y="factor")

# Plot variance explained values (view as x-axis, and group as y-axis)
plot_variance_explained(model, x="view", y="group")

# Plot variance explained values for factors 1 to 3
plot_variance_explained(model, x="view", y="group", factors=1:3)

# Scale R2 values
plot_variance_explained(model, max_r2 = 0.25)
}
