% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{nwalign}
\alias{nwalign}
\title{Needleman-Wunsch alignment.}
\usage{
nwalign(
  s1,
  s2,
  match = getDadaOpt("MATCH"),
  mismatch = getDadaOpt("MISMATCH"),
  gap = getDadaOpt("GAP_PENALTY"),
  homo_gap = NULL,
  band = -1,
  endsfree = TRUE,
  vec = FALSE
)
}
\arguments{
\item{s1}{(Required). \code{character(1)}. The first sequence to align. A/C/G/T only.}

\item{s2}{(Required). \code{character(1)}. The second sequence to align. A/C/G/T only.}

\item{match}{(Optional). \code{numeric(1)}. Default is getDadaOpt("MATCH").
The score of a match in the alignment.}

\item{mismatch}{(Optional). \code{numeric(1)}. Default is getDadaOpt("MISMATCH").
The score of a mismatch in the alignment.}

\item{gap}{(Optional). \code{numeric(1)}. Default is getDadaOpt("GAP_PENALTY").
The alignment gap penalty. Should be negative.}

\item{homo_gap}{(Optional). \code{numeric(1)}. Default NULL (no special homopolymer penalty).
The alignment gap penalty within homopolymer regions. Should be negative.}

\item{band}{(Optional). \code{numeric(1)}.  Default -1 (no banding).
The Needleman-Wunsch alignment can be banded. This value specifies the radius of that band.
Set \code{band = -1} to turn off banding.}

\item{endsfree}{(Optional). \code{logical(1)}. Default TRUE.
Allow unpenalized gaps at the ends of the alignment.}

\item{vec}{(Optional). \code{logical(1)}. Default FALSE.
Use DADA2's vectorized aligner instead of standard DP matrix. Not intended for long sequences (>1kb).}
}
\value{
\code{character(2)}. The aligned sequences.
}
\description{
This function performs a Needleman-Wunsch alignment between two sequences.
}
\examples{
 sq1 <- "CTAATACATGCAAGTCGAGCGAGTCTGCCTTGAAGATCGGAGTGCTTGCACTCTGTGAAACAAGATA"
 sq2 <- "TTAACACATGCAAGTCGAACGGAAAGGCCAGTGCTTGCACTGGTACTCGAGTGGCGAACGGGTGAGT"
 nwalign(sq1, sq2)
 nwalign(sq1, sq2, band=16)

}
