% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequenceIO.R
\name{uniquesToFasta}
\alias{uniquesToFasta}
\title{Write a uniques vector to a FASTA file}
\usage{
uniquesToFasta(unqs, fout, ids = NULL, mode = "w", width = 20000, ...)
}
\arguments{
\item{unqs}{(Required).
A \code{\link{uniques-vector}} or any object that can be coerced
into one with \code{\link{getUniques}}.}

\item{fout}{(Required).
The file path of the output file.}

\item{ids}{(Optional). \code{character}. Default NULL.
A vector of sequence ids, one for each element in \code{unqs}.
If NULL, a uchime-compatible ID is assigned.}

\item{mode}{(Optional). Default "w".
Passed on to \code{\link[ShortRead]{writeFasta}}
indicating the type of file writing mode. Default is \code{"w"}.}

\item{width}{(Optional). Default 20000.
The number of characters per line in the file. Default is effectively one line
per sequence. Passed on to \code{\link[ShortRead]{writeFasta}}.}

\item{...}{Additional parameters passed on to \code{\link[ShortRead]{writeFasta}}.}
}
\value{
NULL.
}
\description{
A wrapper for writeFastq in the ShortRead package.
Default output format is compatible with uchime.
}
\examples{
derep1 = derepFastq(system.file("extdata", "sam1F.fastq.gz", package="dada2"))
outfile <- tempfile(fileext=".fasta")
uniquesToFasta(derep1, outfile)
uniquesToFasta(derep1, outfile, ids=paste0("Sequence", seq(length(getSequences(derep1)))))

}
