; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; This test check if redundant truncate for eq/ne cmp is skipped during code gen.
;RUN: llc -mtriple=thumbv7-eabi < %s | FileCheck %s

define void @test_zero(i16 signext %x) optsize {
; CHECK-LABEL: test_zero:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    cbz r0, .LBB0_2
; CHECK-NEXT:  @ %bb.1: @ %if.then
; CHECK-NEXT:    b foo1
; CHECK-NEXT:  .LBB0_2: @ %if.else
; CHECK-NEXT:    b foo2
entry:
  %tobool = icmp eq i16 %x, 0
  br i1 %tobool, label %if.else, label %if.then
if.then:                                          ; preds = %entry
  tail call void @foo1()
  br label %if.end

if.else:                                          ; preds = %entry
  tail call void @foo2()
  br label %if.end

if.end:                                           ; preds = %if.else, %if.then
  ret void
}

define void @test_i8_nonzero(i18 signext %x) optsize {
; CHECK-LABEL: test_i8_nonzero:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    cmp r0, #150
; CHECK-NEXT:    it eq
; CHECK-NEXT:    beq foo2
; CHECK-NEXT:  .LBB1_1: @ %if.then
; CHECK-NEXT:    b foo1
entry:
  %tobool = icmp eq i18 %x, 150
  br i1 %tobool, label %if.else, label %if.then
if.then:                                          ; preds = %entry
  tail call void @foo1()
  br label %if.end

if.else:                                          ; preds = %entry
  tail call void @foo2()
  br label %if.end

if.end:                                           ; preds = %if.else, %if.then
  ret void
}

define void @test_i8_i16(i8 signext %x) optsize {
; CHECK-LABEL: test_i8_i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    cmp.w r0, #300
; CHECK-NEXT:    it eq
; CHECK-NEXT:    beq foo2
; CHECK-NEXT:  .LBB2_1: @ %if.then
; CHECK-NEXT:    b foo1
entry:
  %x16 = sext i8 %x to i16
  %tobool = icmp eq i16 %x16, 300
  br i1 %tobool, label %if.else, label %if.then
if.then:                                          ; preds = %entry
  tail call void @foo1()
  br label %if.end

if.else:                                          ; preds = %entry
  tail call void @foo2()
  br label %if.end

if.end:                                           ; preds = %if.else, %if.then
  ret void
}

define void @test_i16_i8(i16 signext %x) optsize {
; CHECK-LABEL: test_i16_i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    uxtb r0, r0
; CHECK-NEXT:    cmp r0, #128
; CHECK-NEXT:    it eq
; CHECK-NEXT:    beq foo2
; CHECK-NEXT:  .LBB3_1: @ %if.then
; CHECK-NEXT:    b foo1
entry:
  %x8 = trunc i16 %x to i8
  %tobool = icmp eq i8 %x8, 128
  br i1 %tobool, label %if.else, label %if.then
if.then:                                          ; preds = %entry
  tail call void @foo1()
  br label %if.end

if.else:                                          ; preds = %entry
  tail call void @foo2()
  br label %if.end

if.end:                                           ; preds = %if.else, %if.then
  ret void
}

define void @test_zext_zero(i16 zeroext %x) optsize {
; CHECK-LABEL: test_zext_zero:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    cbz r0, .LBB4_2
; CHECK-NEXT:  @ %bb.1: @ %if.then
; CHECK-NEXT:    b foo1
; CHECK-NEXT:  .LBB4_2: @ %if.else
; CHECK-NEXT:    b foo2
entry:
  %tobool = icmp eq i16 %x, 0
  br i1 %tobool, label %if.else, label %if.then
if.then:                                          ; preds = %entry
  tail call void @foo1()
  br label %if.end

if.else:                                          ; preds = %entry
  tail call void @foo2()
  br label %if.end

if.end:                                           ; preds = %if.else, %if.then
  ret void
}

declare void @foo1(...)
declare void @foo2(...)
