#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Bookwalker: Thief of Tales
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251014.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='the-bookwalker'
GAME_NAME='The Bookwalker: Thief of Tales'

ARCHIVE_BASE_0_NAME='setup_the_bookwalker_thief_of_tales_23.6.10_(64bit)_(65490).exe'
ARCHIVE_BASE_0_MD5='4a160b7b5ea64fc9bbaab587220ecb24'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_the_bookwalker_thief_of_tales_23.6.10_(64bit)_(65490)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='50db6380d7984fe2dea7aa60f70859ff'
ARCHIVE_BASE_0_PART2_NAME='setup_the_bookwalker_thief_of_tales_23.6.10_(64bit)_(65490)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='bd1116363f9aab14fb97a276f7c8c55a'
ARCHIVE_BASE_0_SIZE='12511430'
ARCHIVE_BASE_0_VERSION='23.6.10-gog65490'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_bookwalker_thief_of_tales'

UNITY3D_NAME='the bookwalker'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_DATA_SHAREDASSETS_1_FILES="
${UNITY3D_NAME}_data/sharedassets[0-9].assets*
${UNITY3D_NAME}_data/sharedassets[1-5][0-9].assets*"
CONTENT_GAME_DATA_SHAREDASSETS_2_FILES="
${UNITY3D_NAME}_data/sharedassets[7-9][6-9].assets*
${UNITY3D_NAME}_data/sharedassets1[0-2][0-9].assets*"

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/DoMyBest/The Bookwalker'

PACKAGES_LIST='
PKG_BIN
PKG_DATA_SHAREDASSETS_1
PKG_DATA_SHAREDASSETS_2
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
PKG_DATA_DEPENDENCIES_SIBLINGS='
PKG_DATA_SHAREDASSETS_1
PKG_DATA_SHAREDASSETS_2'

PKG_DATA_SHAREDASSETS_ID="${PKG_DATA_ID}-shardeassets"
PKG_DATA_SHAREDASSETS_1_ID="${PKG_DATA_SHAREDASSETS_ID}-1"
PKG_DATA_SHAREDASSETS_2_ID="${PKG_DATA_SHAREDASSETS_ID}-2"
PKG_DATA_SHAREDASSETS_DESCRIPTION="$PKG_DATA_DESCRIPTION - shared assets"
PKG_DATA_SHAREDASSETS_1_DESCRIPTION="$PKG_DATA_SHAREDASSETS_DESCRIPTION - 1"
PKG_DATA_SHAREDASSETS_2_DESCRIPTION="$PKG_DATA_SHAREDASSETS_DESCRIPTION - 2"

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
