/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.util.Context;
import writer2latex.latex.util.StyleMap;
import writer2latex.office.OfficeReader;
import writer2latex.util.Misc;

public class BlockConverter
extends ConverterHelper {
    public BlockConverter(OfficeReader ofr, LaTeXConfig config, ConverterPalette palette) {
        super(ofr, config, palette);
    }

    @Override
    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
    }

    public void traverseBlockText(Element node, LaTeXDocumentPortion ldp, Context oc) {
        Context ic = (Context)oc.clone();
        StyleMap blockMap = this.config.getParBlockStyleMap();
        String sBlockName = null;
        if (node.hasChildNodes()) {
            NodeList list = node.getChildNodes();
            int nLen = list.getLength();
            for (int i = 0; i < nLen; ++i) {
                Node childNode = list.item(i);
                if (childNode.getNodeType() != 1) continue;
                Element child = (Element)childNode;
                String sTagName = child.getTagName();
                if (!ic.isInTable()) {
                    if (sTagName.equals("text:p")) {
                        String sStyleName = this.ofr.getParStyles().getDisplayName(child.getAttribute("text:style-name"));
                        if (sBlockName != null && !blockMap.isNext(sBlockName, sStyleName)) {
                            String sAfter = blockMap.getAfter(sBlockName);
                            if (sAfter.length() > 0) {
                                ldp.append(sAfter).nl();
                            }
                            sBlockName = null;
                            ic.setVerbatim(false);
                        }
                        if (sBlockName == null && blockMap.contains(sStyleName)) {
                            sBlockName = sStyleName;
                            String sBefore = blockMap.getBefore(sBlockName);
                            if (sBefore.length() > 0) {
                                ldp.append(sBefore).nl();
                            }
                            ic.setVerbatim(blockMap.getVerbatim(sStyleName));
                        }
                    } else if (sBlockName != null) {
                        String sAfter = blockMap.getAfter(sBlockName);
                        if (sAfter.length() > 0) {
                            ldp.append(sAfter).nl();
                        }
                        sBlockName = null;
                        ic.setVerbatim(false);
                    }
                }
                this.palette.getFieldCv().flushReferenceMarks(ldp, ic);
                this.palette.getIndexCv().flushIndexMarks(ldp, ic);
                this.palette.getInfo().addDebugInfo(child, ldp);
                if (sTagName.equals("text:p")) {
                    String sSequence = this.ofr.getSequenceName(child);
                    if (this.ofr.isFigureSequenceName(sSequence)) {
                        this.palette.getDrawCv().handleCaption(child, ldp, ic);
                        continue;
                    }
                    if (this.ofr.isTableSequenceName(sSequence)) {
                        if (i + 1 < nLen && Misc.isElement(list.item(i + 1), "table:table")) {
                            this.palette.getTableCv().handleTable((Element)list.item(++i), child, true, ldp, ic);
                            continue;
                        }
                        this.palette.getTableCv().handleCaption(child, ldp, ic);
                        continue;
                    }
                    this.palette.getParCv().handleParagraph(child, ldp, ic, i == nLen - 1);
                    continue;
                }
                if (sTagName.equals("text:h")) {
                    this.palette.getHeadingCv().handleHeading(child, ldp, ic);
                    continue;
                }
                if (sTagName.equals("text:list")) {
                    this.palette.getListCv().handleList(child, ldp, ic);
                    continue;
                }
                if (sTagName.equals("text:unordered-list")) {
                    this.palette.getListCv().handleList(child, ldp, ic);
                    continue;
                }
                if (sTagName.equals("text:ordered-list")) {
                    this.palette.getListCv().handleList(child, ldp, ic);
                    continue;
                }
                if (sTagName.equals("table:table")) {
                    if (i + 1 < nLen && Misc.isElement(list.item(i + 1), "text:p") && this.ofr.isTableSequenceName(this.ofr.getSequenceName((Element)list.item(i + 1)))) {
                        this.palette.getTableCv().handleTable(child, (Element)list.item(++i), false, ldp, oc);
                        continue;
                    }
                    this.palette.getTableCv().handleTable(child, null, false, ldp, oc);
                    continue;
                }
                if (sTagName.equals("table:sub-table")) {
                    this.palette.getTableCv().handleTable(child, null, true, ldp, ic);
                    continue;
                }
                if (sTagName.equals("text:section")) {
                    this.palette.getSectionCv().handleSection(child, ldp, ic);
                    continue;
                }
                if (sTagName.startsWith("draw:")) {
                    this.palette.getDrawCv().handleDrawElement(child, ldp, ic);
                    continue;
                }
                if (sTagName.equals("text:table-of-content")) {
                    this.palette.getIndexCv().handleTOC(child, ldp, ic);
                    continue;
                }
                if (sTagName.equals("text:illustration-index")) {
                    this.palette.getIndexCv().handleLOF(child, ldp, ic);
                    continue;
                }
                if (sTagName.equals("text:table-index")) {
                    this.palette.getIndexCv().handleLOT(child, ldp, ic);
                    continue;
                }
                if (sTagName.equals("text:object-index")) {
                    this.palette.getIndexCv().handleObjectIndex(child, ldp, ic);
                    continue;
                }
                if (sTagName.equals("text:user-index")) {
                    this.palette.getIndexCv().handleUserIndex(child, ldp, ic);
                    continue;
                }
                if (sTagName.equals("text:alphabetical-index")) {
                    this.palette.getIndexCv().handleAlphabeticalIndex(child, ldp, ic);
                    continue;
                }
                if (sTagName.equals("text:bibliography")) {
                    this.palette.getBibCv().handleBibliography(child, ldp, ic);
                    continue;
                }
                if (!sTagName.equals("text:sequence-decls")) continue;
                this.palette.getFieldCv().handleSequenceDecls(child);
            }
        }
        if (!oc.isInTable() && sBlockName != null) {
            String sAfter = blockMap.getAfter(sBlockName);
            if (sAfter.length() > 0) {
                ldp.append(sAfter).nl();
            }
            sBlockName = null;
        }
        this.palette.getFieldCv().flushReferenceMarks(ldp, ic);
        this.palette.getIndexCv().flushIndexMarks(ldp, ic);
    }
}

