---
myst:
  html_meta:
    keywords: LaTeX, LaTeX, domaines spécialisés, mathématiques, équations, 
              disposition d'équations, systèmes d'équations, eqnarray, align
---

# Quels sont les arguments contre l'utilisation d’`eqnarray` ?

L'environnement `eqnarray` paraît attractif pour les utilisateurs occasionnels
de mathématiques dans des documents LaTeX : 
il semble permettre d'alignement de systèmes d'équations.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\begin{eqnarray}
  a & = & b + c \\
  x & = & y - z
\end{eqnarray}
\end{document}
```

Et, en effet, il *fournit* cette fonctionnalité d'alignement... 
mais en gérant l'espacement de façon douteuse.

Ce sujet est discuté en détail dans un article en anglais du 
[PracTeX journal paper](https://tug.org/pracjourn/2006-4/madsen/madsen.pdf) 
de Lars Madsen ; Stefan Kottwitz a également rédigé un 
[billet du TeX blog](https://texblog.net/latex-archive/maths/eqnarray-align-environment/) 
en anglais qui inclut des copies d'écran illustrant clairement 
les problèmes associés à `eqnarray`. La présente page se limite 
à trois arguments importants, déjà largement suffisants pour montrer
le caractère obsolète de cet environnement.


## Les principaux arguments

### L'espacement autour du symbole de relation

Typographiquement, `eqnarray` rajoute beaucoup d'espacement autour du symbole
de relation, de façon injustifiée et incohérente avec les autres environnements
mathématiques (ci-dessous `equation`, `eqnarray` puis `align`).

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\begin{equation*}
  x = y
\end{equation*}
\vspace*{-0.8cm}
\begin{eqnarray*}
  x & = & y
\end{eqnarray*}
\vspace*{-1cm}
\begin{align*}
  x & = y
\end{align*}
\end{document}
```

De fait, dans l'environnement `eqnarray`, les espaces autour du symbole `=` 
ne sont pas ceux définis par les métriques de la fonte. 
Ils sont définis par `\arraycolsep`, 
qui peut être arbitrairement fixé à des valeurs utiles aux véritables tables 
présentes dans le document.


### La gestion du numéro d'équation

Quand l'équation occupe toute la largeur de la page, 
`eqnarray` ne s'en rend pas compte et place le numéro d'équation 
en surimpression sur le texte. Les autres environnements standard, 
comme `equation`, ne présentent pas ce problème et placent la numérotation
de l'équation en-dessous (pour les deux premières lignes ci-dessous, 
est utilisé `eqnarray` avec `\setlength\arraycolsep{2pt}` ; 
pour les deux suivantes, `align`).

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\setlength\arraycolsep{2pt}
\begin{eqnarray}
  a & = & b \\
    & = & cdefghijklmnopqrstuvwxyzcdefghijklmnopqrstuvwxyzcdeghijklmno
\end{eqnarray}
\vspace*{-0.5cm}
\begin{align}
  a & = b \\
    & = cdefghijklmnopqrstuvwxyzcdefghijklmnopqrstuvwxyzcdeghijklmno
\end{align}
\end{document}
```


### Des incomptabilités avec <ctanpkg:mathtools>

Par ailleurs, `eqnarray` ne fonctionne pas correctement avec les commandes 
de l'extension <ctanpkg:mathtools> (ou <ctanpkg:amsmath>), incontournable 
pour composer les mathématiques. Par exemple, les commandes `\tag` 
et `\intertext` fonctionnent avec tous les environnements sauf `eqnarray`.


## Ce qu'il existe pour la remplacer

### L'environnement `align`

L'environnement `eqnarray` peut être avantageusement remplacé 
par les environnements de <ctanpkg:mathtools> (ou de <ctanpkg:amsmath>), 
notamment `align` défini pour répondre aux besoins des mathématiciens 
dont voici la syntaxe pour corriger l'exemple ci-dessus :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\begin{align}
  a & = b + c \\
  x & = y - z
\end{align}
\end{document}
```


### Un correctif ancien et partiel

:::{warning}
Ce qui suit est informatif et n'est conservé que pour historiser la méthode. 
L'utilisation de l'environnement `eqnarray` n'étant pas recommandé, 
cette astuce ne l'est pas plus.

```{noedit}
\makeatletter
\newlength{\earraycolsep}
\setlength{\earraycolsep}{2pt}
 
\def\eqnarray{\stepcounter{equation}%
  \let\@currentlabel%
  \theequation
  \global\@eqnswtrue\m@th
  \global\@eqcnt\z@\tabskip\@centering
  \let\\\@eqncr
  $$\halign to\displaywidth\bgroup\@eqnsel
  \hskip\@centering
  $\displaystyle\tabskip\z@{##}$&
  \global\@eqcnt\@ne\hskip 2\earraycolsep 
  \hfil$\displaystyle{##}$\hfil
  &\global\@eqcnt\tw@ \hskip 2\earraycolsep
  $\displaystyle\tabskip\z@{##}$\hfil
  \tabskip\@centering&\llap{##}\tabskip\z@\cr}
\makeatother
```
:::