/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.List;
import java.util.Vector;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.ContentCollection;
import org.chefproject.core.ContentCollectionEdit;
import org.chefproject.core.ContentResource;
import org.chefproject.core.ContentResourceEdit;
import org.chefproject.core.Resource;
import org.chefproject.core.StorageUser;
import org.chefproject.service.component.BaseContentService;
import org.chefproject.service.component.BaseXmlFileStorage;
import org.chefproject.util.StringUtil;

public class XmlFileContentService
extends BaseContentService {
    protected String m_storagePath = null;
    protected String m_storagePathR = null;
    protected String m_storagePathC = null;

    public void init(RunData data) throws InitializationException {
        super.init(data);
        this.m_storagePath = data.getServletContext().getRealPath(this.getProperties().getProperty("path", "db/content.xml"));
        this.m_storagePathC = data.getServletContext().getRealPath(this.getProperties().getProperty("pathc", "db/content_c.xml"));
        this.m_storagePathR = data.getServletContext().getRealPath(this.getProperties().getProperty("pathr", "db/content_r.xml"));
        Log.debug("chef", this + ".init(RunData): storage path: " + this.m_storagePath);
    }

    public void init() throws InitializationException {
        super.init();
        this.m_cache.disable();
    }

    protected BaseContentService.Storage newStorage() {
        return new XmlFileStorage(new BaseContentService.CollectionStorageUser(), new BaseContentService.ResourceStorageUser());
    }

    protected class XmlFileStorage
    implements BaseContentService.Storage {
        protected BaseXmlFileStorage m_collectionStore = null;
        protected BaseXmlFileStorage m_resourceStore = null;

        public XmlFileStorage(StorageUser collectionUser, StorageUser resourceUser) {
            this.m_collectionStore = new BaseXmlFileStorage(XmlFileContentService.this.m_storagePathC, "content", null, "collection", collectionUser);
            this.m_resourceStore = new BaseXmlFileStorage(XmlFileContentService.this.m_storagePathR, "content", null, "resource", resourceUser);
        }

        public void open() {
            this.m_collectionStore.open();
            this.m_resourceStore.open();
        }

        public void close() {
            this.m_collectionStore.close();
            this.m_resourceStore.close();
        }

        public boolean checkCollection(String id) {
            return this.m_collectionStore.checkResource(null, id);
        }

        public ContentCollection getCollection(String id) {
            return (ContentCollection)this.m_collectionStore.getResource(null, id);
        }

        public List getCollections(ContentCollection collection) {
            Vector<Resource> rv = new Vector<Resource>();
            String target = collection.getId();
            List all = this.m_collectionStore.getAllResources(null);
            int i = 0;
            while (i < all.size()) {
                Resource res = (Resource)all.get(i);
                if (StringUtil.referencePath(res.getId()).equals(target)) {
                    rv.add(res);
                }
                ++i;
            }
            return rv;
        }

        public ContentCollectionEdit putCollection(String id) {
            return (ContentCollectionEdit)this.m_collectionStore.putResource(null, id, null);
        }

        public ContentCollectionEdit editCollection(String id) {
            return (ContentCollectionEdit)this.m_collectionStore.editResource(null, id);
        }

        public void commitCollection(ContentCollectionEdit edit) {
            this.m_collectionStore.commitResource(null, edit);
        }

        public void cancelCollection(ContentCollectionEdit edit) {
            this.m_collectionStore.cancelResource(null, edit);
        }

        public void removeCollection(ContentCollectionEdit edit) {
            this.m_collectionStore.removeResource(null, edit);
        }

        public boolean checkResource(String id) {
            return this.m_resourceStore.checkResource(null, id);
        }

        public ContentResource getResource(String id) {
            return (ContentResource)this.m_resourceStore.getResource(null, id);
        }

        public List getResources(ContentCollection collection) {
            Vector<Resource> rv = new Vector<Resource>();
            String target = collection.getId();
            List all = this.m_resourceStore.getAllResources(null);
            int i = 0;
            while (i < all.size()) {
                Resource res = (Resource)all.get(i);
                if (StringUtil.referencePath(res.getId()).equals(target)) {
                    rv.add(res);
                }
                ++i;
            }
            return rv;
        }

        public ContentResourceEdit putResource(String id) {
            return (ContentResourceEdit)this.m_resourceStore.putResource(null, id, null);
        }

        public ContentResourceEdit editResource(String id) {
            return (ContentResourceEdit)this.m_resourceStore.editResource(null, id);
        }

        public void commitResource(ContentResourceEdit edit) {
            this.m_resourceStore.commitResource(null, edit);
        }

        public void cancelResource(ContentResourceEdit edit) {
            this.m_resourceStore.cancelResource(null, edit);
        }

        public void removeResource(ContentResourceEdit edit) {
            this.m_resourceStore.removeResource(null, edit);
        }

        public byte[] getResourceBody(ContentResource resource) {
            return null;
        }
    }
}

