// license:BSD-3-Clause
// copyright-holders:Ryan Holtz

/***************************************************************************

  Netlist (tank) included from atarittl.cpp

***************************************************************************/

#include "netlist/devices/net_lib.h"

NETLIST_START(tank)
{

	SOLVER(Solver, 16000)
	PARAM(Solver.ACCURACY, 5e-4)
	PARAM(Solver.DYNAMIC_TS, 1)
	PARAM(Solver.DYNAMIC_LTE, 1e-2)
	PARAM(Solver.DYNAMIC_MIN_TIMESTEP, 1e-7)

	ANALOG_INPUT(V5, 5)
	ANALOG_INPUT(V12, 12)
	//ANALOG_INPUT(VM12, GND)
	ALIAS(VCC, V5)
	ALIAS(P, V5)

	RES(R4, RES_K(3.3))
	RES(R5, RES_K(3.3))
	RES(R6, RES_K(3.3))
	RES(R7, RES_K(3.3))
	RES(R7V, 680)
	RES(R8, RES_K(3.3))
	RES(R8A, 470)
	RES(R9, RES_K(3.3))
	RES(R9A, 470)
	RES(R10, RES_K(3.3))
	RES(R10A, 470)
	RES(R11, RES_K(3.3))
	RES(R11A, 470)
	RES(R3V, 560)
	RES(R4V, RES_K(1))
	RES(R5V, RES_K(1))
	RES(R6V, RES_K(1))
	RES(R13, RES_K(4.7))
	RES(R15, RES_K(47))
	RES(R16, RES_K(33))
	RES(R19, RES_K(1)) // Guess; VGLTank.pdf doesn't say.
	RES(R20, RES_K(1)) // Guess; VGLTank.pdf doesn't say.
	RES(R21, RES_K(1)) // Guess; VGLTank.pdf doesn't say.
	RES(R22, RES_K(1)) // Guess; VGLTank.pdf doesn't say.
	RES(R23, RES_K(1)) // Guess; VGLTank.pdf doesn't say.
	RES(R24, RES_K(1)) // Guess; VGLTank.pdf doesn't say.
	RES(R25, RES_K(1)) // Guess; VGLTank.pdf doesn't say.
	RES(R26, RES_K(1)) // Guess; VGLTank.pdf doesn't say.
	RES(R27, 470)
	RES(R28, RES_M(1.8))
	RES(R29, RES_M(1.8))
	RES(R32, 470)
	RES(R34V, 560)
	//RES(R35M2, RES_K(100))
	//RES(R36M1, RES_K(100))
	RES(R37A, RES_K(100))
	RES(R38, RES_K(100))
	RES(R40, RES_K(4.7))
	RES(R41, RES_K(4.7))
	RES(R42, 100)
	RES(R43, 100)
	//RES(R48A, 560)
	RES(R48B, RES_K(4.7))
	RES(R49B, RES_K(4.7))
	RES(R50B, RES_K(4.7))
	RES(R51B, RES_K(4.7))
	RES(R52B, 100)
	RES(R53A, RES_K(220))
	RES(R53B, 100)
	RES(R54A, RES_K(680))
	RES(R54B, 100)
	RES(R55A, RES_K(10))
	RES(R55B, 100)
	RES(R56A, RES_K(100))
	RES(R56B, RES_K(4.7))
	RES(R57, RES_K(4.7))
	RES(R58, RES_K(4.7))
	RES(R59A, RES_K(180))
	RES(R59B, RES_K(4.7))
	RES(R60A, RES_M(1))
	RES(R60B, 100)
	RES(R61, 100)
	RES(R62, 100)
	RES(R63A, RES_M(2.2))
	RES(R63B, 100)
	RES(R64A, RES_K(180))
	//RES(R64M2, RES_K(4.7))
	//RES(R65M2, RES_K(3.9))
	//RES(R66M2, RES_K(1))
	//RES(R67M2, RES_K(10))
	//RES(R68M2, RES_K(33))
	RES(R69, RES_K(470))
	//RES(R69M2, RES_K(180))
	RES(R70A, RES_M(1))
	//RES(R70M2, RES_K(330))
	RES(R71A, RES_K(680))
	//RES(R71M2, RES_K(680))
	RES(R72A, RES_K(180))
	//RES(R72M2, RES_K(22))
	RES(R73A, RES_M(1))
	//RES(R73M1, RES_K(22))
	//RES(R74M1, RES_K(180))
	//RES(R75M1, RES_K(330))
	//RES(R76M1, RES_K(680))
	//RES(R77M1, RES_K(10))
	//RES(R78M1, RES_K(33))
	//RES(R79M1, RES_K(3.9))
	//RES(R80M1, RES_K(1))
	//RES(R81M1, RES_K(4.7))
	//RES(R100M1, RES_K(1))
	//RES(R101M1, 680)
	//RES(R102M2, RES_K(1))
	//RES(R103M2, 680)
	RES(R102MX, RES_K(33))
	RES(R103MX, RES_K(33))
	RES(R104MX, RES_K(33))
	RES(R106MX, RES_K(33))
	RES(R107MX, RES_K(33))
	RES(R108MX, RES_K(33))
	RES(RUNK1, RES_K(47))

	CAP(C2, CAP_U(0.1))
	CAP(C4, CAP_U(0.001))
	CAP(C5, CAP_U(0.001))
	CAP(C6, CAP_U(0.001))
	CAP(C7, CAP_U(0.001))
	CAP(C8, CAP_U(100))
	CAP(C9, CAP_U(22))
	CAP(C11, CAP_U(47))
	CAP(C12, CAP_U(22))
	CAP(C15, CAP_U(0.01))
	CAP(C16, CAP_U(0.01))
	CAP(C17, CAP_P(100))
	CAP(C18, CAP_U(1))
	CAP(C19, CAP_U(1))
	CAP(C21, CAP_P(100))
	CAP(C23, CAP_P(100))
	CAP(C24, CAP_U(0.1))
	CAP(C25, CAP_U(100))
	CAP(C26, CAP_U(0.1))
	CAP(C27, CAP_U(0.1))
	CAP(C27A, CAP_U(0.001))
	CAP(C28A, CAP_U(1))
	//CAP(C29, CAP_U(10))
	CAP(C30, CAP_U(0.1))
	CAP(C30A, CAP_U(0.001))
	CAP(C31, CAP_U(0.1))
	CAP(C31A, CAP_U(1))
	CAP(C32A, CAP_U(0.1))
	CAP(C33C, CAP_U(0.1))
	CAP(C34C, CAP_U(0.1))
	// CAP(C34A, CAP_U(0.01)) Decoupling
	CAP(C35C, CAP_U(0.1))
	CAP(C35A, CAP_U(5))
	CAP(C36C, CAP_U(0.1))
	CAP(C36A, CAP_U(0.1))
	CAP(C38A, CAP_U(5))
	CAP(C39, CAP_U(0.1))
	CAP(C39A, CAP_U(0.001))
	CAP(C40, CAP_U(0.1))
	CAP(C40A, CAP_U(0.1))
	CAP(C41, CAP_U(0.1))
	CAP(C41A, CAP_U(5))
	CAP(C42, CAP_U(0.1))
	CAP(C43A, CAP_P(220))
	//CAP(C43M2, CAP_U(0.001))
	//CAP(C44M2, CAP_U(5))
	//CAP(C47M2, CAP_U(0.001))
	//CAP(C48M2, CAP_U(0.1))
	//CAP(C49M2, CAP_U(10))
	//CAP(C50M2, CAP_U(22))
	//CAP(C51M1, CAP_U(22))
	//CAP(C52M1, CAP_U(0.001))
	//CAP(C53M1, CAP_U(0.1))
	//CAP(C54M1, CAP_U(10))
	//CAP(C55M1, CAP_U(0.001))
	//CAP(C56M1, CAP_U(5))
	CAP(C100, CAP_U(0.001))
	CAP(C101, CAP_U(1))
	CAP(C106, CAP_U(1))
	CAP(C110, CAP_U(0.001))
	CAP(C111, CAP_U(0.001))

	POT(SHOT_NOISE_VOL, RES_K(50))
	POT(BOOM_NOISE_VOL, RES_K(50))
	//POT(MOTOR1_VOL, RES_K(10))
	//POT(MOTOR1_VOL2, RES_K(100))
	//POT(MOTOR2_VOL, RES_K(10))
	//POT(MOTOR2_VOL2, RES_K(100))
	POT(PLAYTIME, RES_M(1))
	POT(FIRE1_ADJUST, RES_K(50))

	SWITCH(P1_LEFT_UP)
	SWITCH(P1_LEFT_DOWN)
	SWITCH(P1_RIGHT_UP)
	SWITCH(P1_RIGHT_DOWN)
	SWITCH(P1_FIRE)
	SWITCH(P2_LEFT_UP)
	SWITCH(P2_LEFT_DOWN)
	SWITCH(P2_RIGHT_UP)
	SWITCH(P2_RIGHT_DOWN)
	SWITCH(P2_FIRE)

	SWITCH2(COIN1)
	SWITCH2(COIN2)

	DIODE(CR1, "1N914")
	DIODE(CR2, "1N914")
	DIODE(CR3, "1N914")
	DIODE(CR5, "1N914")
	DIODE(CR6, "1N914")
	DIODE(CR7, "1N914")
	DIODE(CR8, "1N914")
	DIODE(CR9, "1N914")
	DIODE(CR10, "1N914")
	DIODE(CR11, "1N914")
	DIODE(CR12, "1N914")
	//DIODE(CR13M2, "1N914")
	//DIODE(CR14M1, "1N914")
	DIODE(CR19, "1N914")
	DIODE(CR22, "1N914")

	QBJT_EB(Q2, "2N3644")
	QBJT_EB(Q3, "2N3643")
	QBJT_EB(Q4, "2N3643")
	QBJT_EB(Q6, "2N3644")
	QBJT_EB(Q7, "2N3644")
// Currently not used
//  QBJT_EB(Q27, "2N3643")
//  QBJT_EB(Q28, "2N3644")
//  QBJT_EB(Q29, "2N3643")
//  QBJT_EB(Q30, "2N3644")
//  QBJT_EB(Q31, "2N3643")
//  QBJT_EB(Q32, "2N3644")
//  QBJT_EB(Q33, "2N3643")
//  QBJT_EB(Q34, "2N3644")

	TTL_7404_DIP(IC_H3)
	TTL_7400_DIP(IC_B6)
	TTL_7402_DIP(IC_D6)
	TTL_74107_DIP(IC_E6)
	TTL_7474_DIP(IC_J6)
	TTL_7402_DIP(IC_N6)
	TTL_7404_DIP(IC_A7)
	NET_C(VCC, IC_H3.14, IC_B6.14, IC_D6.14, IC_E6.14, IC_J6.14, IC_N6.14, IC_A7.14, IC_J6.4, IC_J6.10)
	NET_C(GND, IC_H3.7,  IC_B6.7,  IC_D6.7,  IC_E6.7,  IC_J6.7,  IC_N6.7,  IC_A7.7)

	TTL_7408_DIP(IC_A11)
	TTL_7402_DIP(IC_B11)
	TTL_7410_DIP(IC_B12)
	TTL_74107_DIP(IC_C12)
	TTL_9316_DIP(IC_D12)
	TTL_9316_DIP(IC_E12)
	TTL_7493_DIP(IC_F12)
	TTL_7493_DIP(IC_H12)
	NET_C(VCC, IC_A11.14, IC_B11.14, IC_B12.14, IC_C12.14, IC_D12.16, IC_E12.16, IC_F12.5,  IC_H12.5)
	NET_C(GND, IC_A11.7,  IC_B11.7,  IC_B12.7,  IC_C12.7,  IC_D12.8,  IC_E12.8,  IC_F12.10, IC_H12.10)

	TTL_74107_DIP(IC_J12)
	TTL_7474_DIP(IC_K12)
	TTL_7402_DIP(IC_A13)
	TTL_7420_DIP(IC_D13)
	TTL_7404_DIP(IC_E13)
	TTL_7400_DIP(IC_J13)
	TTL_7410_DIP(IC_A14)
	TTL_7400_DIP(IC_B14)
	NET_C(VCC, IC_J12.14, IC_K12.14, IC_A13.14, IC_D13.14, IC_E13.14, IC_J13.14, IC_A14.14, IC_B14.14)
	NET_C(GND, IC_J12.7,  IC_K12.7,  IC_A13.7,  IC_D13.7,  IC_E13.7,  IC_J13.7,  IC_A14.7,  IC_B14.7)

	TTL_7400_DIP(IC_B13)
	TTL_7410_DIP(IC_C13)
	TTL_7400_DIP(IC_E14)
	TTL_7474_DIP(IC_L12)
	TTL_7474_DIP(IC_L9)
	TTL_7408_DIP(IC_L8)
	TTL_7400_DIP(IC_K8)
	NET_C(VCC, IC_B13.14, IC_C13.14, IC_E14.14, IC_L12.14, IC_L9.14, IC_L8.14, IC_K8.14)
	NET_C(GND, IC_B13.7,  IC_C13.7,  IC_E14.7,  IC_L12.7,  IC_L9.7,  IC_L8.7,  IC_K8.7)

	TTL_7474_DIP(IC_K9)
	SUBMODEL(NE556_DIP, IC_C11)
	TTL_7492_DIP(IC_A12)
	TTL_7404_DIP(IC_M13)
	TTL_7402_DIP(IC_E15)
	TTL_7410_DIP(IC_F14)
	TTL_7427_DIP(IC_K13)
	TTL_7400_DIP(IC_L13)
	NET_C(VCC, IC_K9.14, IC_C11.14, IC_A12.5,  IC_M13.14, IC_E15.14, IC_F14.14, IC_K13.14, IC_L13.14)
	NET_C(GND, IC_K9.7,  IC_C11.7,  IC_A12.10, IC_M13.7,  IC_E15.7,  IC_F14.7,  IC_K13.7,  IC_L13.7)

	TTL_74107_DIP(IC_D8)
	TTL_74193_DIP(IC_H10)
	TTL_7408_DIP(IC_H11)
	TTL_7410_DIP(IC_C14)
	TTL_9316_DIP(IC_H14)
	TTL_7493_DIP(IC_J14)
	TTL_7402_DIP(IC_D15)
	TTL_7400_DIP(IC_D14)
	NET_C(VCC, IC_D8.14, IC_H10.16, IC_H11.14, IC_C14.14, IC_H14.16, IC_J14.5,  IC_D15.14, IC_D14.14)
	NET_C(GND, IC_D8.7,  IC_H10.8,  IC_H11.7,  IC_C14.7,  IC_H14.8,  IC_J14.10, IC_D15.7,  IC_D14.7)

	TTL_7493_DIP(IC_L14)
	TTL_9316_DIP(IC_K14)
	TTL_74193_DIP(IC_F11)
	TTL_7486_DIP(IC_E8)
	TTL_7402_DIP(IC_N7)
	TTL_7400_DIP(IC_B15)
	TTL_7402_DIP(IC_B9)
	TTL_7408_DIP(IC_B7)
	NET_C(VCC, IC_L14.5,  IC_K14.16, IC_F11.16, IC_E8.14, IC_N7.14, IC_B15.14, IC_B9.14, IC_B7.14)
	NET_C(GND, IC_L14.10, IC_K14.8,  IC_F11.8,  IC_E8.7,  IC_N7.7,  IC_B15.7,  IC_B9.7,  IC_B7.7)

	TTL_7404_DIP(IC_B10)
	TTL_9602_DIP(IC_C9)
	TTL_7474_DIP(IC_A8)
	TTL_7474_DIP(IC_A15)
	TTL_7400_DIP(IC_A9)
	TTL_9602_DIP(IC_C8)
	TTL_7402_DIP(IC_B8)
	TTL_7474_DIP(IC_J8)
	NET_C(VCC, IC_B10.14, IC_C9.16, IC_A8.14, IC_A15.14, IC_A9.14, IC_C8.16, IC_B8.14, IC_J8.14)
	NET_C(GND, IC_B10.7,  IC_C9.8,  IC_A8.7,  IC_A15.7,  IC_A9.7,  IC_C8.8,  IC_B8.7,  IC_J8.7)

	TTL_7493_DIP(IC_C10)
	TTL_7493_DIP(IC_D11)
	TTL_7493_DIP(IC_E11)
	TTL_7402_DIP(IC_J7)
	TTL_7404_DIP(IC_D11V)
	TTL_7402_DIP(IC_L7)
	TTL_7402_DIP(IC_D7)
	TTL_74165_DIP(IC_N10)
	NET_C(VCC, IC_C10.5,  IC_D11.5,  IC_E11.5,  IC_J7.14, IC_D11V.14, IC_L7.14, IC_D7.14, IC_N10.16)
	NET_C(GND, IC_C10.10, IC_D11.10, IC_E11.10, IC_J7.7,  IC_D11V.7,  IC_L7.7,  IC_D7.7,  IC_N10.8)

	NE555_DIP(IC_H6)
	NET_C(VCC, IC_H6.8)
	NET_C(GND, IC_H6.1)

	// Coin Handling
	NET_C(COIN1.1, COIN1_NC)
	NET_C(COIN1.2, COIN1_NO)
	NET_C(COIN2.1, COIN2_NC)
	NET_C(COIN2.2, COIN2_NO)
	NET_C(GND, COIN1.Q, COIN2.Q)

	ALIAS(COIN1_NO, IC_B6.5)
	ALIAS(COIN1_NC, IC_B6.1)
	ALIAS(COIN2_NO, IC_B6.9)
	ALIAS(COIN2_NC, IC_B6.13)

	NET_C(IC_B6.2, IC_B6.6, IC_D6.9)
	NET_C(IC_B6.4, IC_B6.3, IC_N6.5)
	NET_C(IC_B6.12, IC_B6.8, IC_D6.8)
	NET_C(IC_B6.10, IC_B6.11, IC_N6.6)

	NET_C(IC_D6.10, IC_D6.11)
	NET_C(ATTRACTQ, IC_D6.12)

	NET_C(IC_D6.13, IC_J6.12, IC_J6.13, IC_J6.1)
	NET_C(IC_J6.9, IC_J6.2)
	NET_C(V128, IC_J6.3, IC_J6.11, IC_E6.9)
	NET_C(IC_J6.5, IC_E6.12)
	NET_C(VCC, IC_E6.1, IC_E6.4)
	ALIAS(COIN, IC_J6.5)
	ALIAS(COINQ, IC_J6.6)

	NET_C(IC_E6.3, IC_N6.3)
	NET_C(IC_N6.4, IC_N6.2)

	NET_C(GND, IC_D6.3)
	NET_C(COINQ, IC_D6.2)
	ALIAS(START, IC_D6.1)

	// Game Timer / Attract
	NET_C(V5, PLAYTIME.2, PLAYTIME.3)
	NET_C(PLAYTIME.1, R54A.1, R53A.1)
	NET_C(R54A.2, IC_H6.6, IC_H6.7, R53A.2, R60A.1, C25.1)
	NET_C(R60A.2, Q2.B)
	NET_C(GND, C25.2, Q3.E, Q4.E, C24.2)
	NET_C(IC_H6.5, C24.1, R59A.1)
	NET_C(R59A.2, R63A.1, Q2.E)
	NET_C(V5, R56A.1, R55A.1)
	NET_C(R56A.2, Q3.C, Q4.B)
	NET_C(R63A.2, R55A.2, Q4.C, IC_H3.5)
	ALIAS(GNE, IC_H3.6)
	NET_C(IC_H6.4, ATTRACTQ)
	NET_C(IC_H6.3, IC_D6.5)
	NET_C(IC_D6.4, IC_E6.11)
	NET_C(V5, IC_E6.10) // No antenna to spark, so we pretend we never get a spark
	ALIAS(ATTRACT, IC_E6.6)
	NET_C(IC_D6.6, ATTRACT)
	ALIAS(ATTRACTQ, IC_E6.5)
	NET_C(IC_N6.9, ATTRACTQ)
	NET_C(GND, IC_N6.8) // No antenna to spark, so we pretend we never get a spark
	NET_C(IC_N6.10, IC_E6.13)
	NET_C(START, IC_E6.8, IC_H3.3)
	NET_C(IC_H3.4, IC_H6.2)
	ALIAS(STARTQ, IC_H3.4)

	// H Info
	NET_C(H128, IC_A13.12)
	NET_C(H_SYNC, IC_A13.8)
	NET_C(IC_A13.10, IC_A13.11)
	NET_C(IC_A13.13, IC_A13.9)
	ALIAS(H_INFO, IC_A13.13)
	ALIAS(H_INFOQ, IC_A13.10)

	// V Info
	NET_C(V16, IC_J13.9)
	NET_C(V64, IC_J13.10)
	NET_C(V512Q, IC_J13.2)
	NET_C(IC_J13.8, IC_J13.12)
	NET_C(IC_J13.3, IC_J13.13)
	NET_C(IC_J13.11, IC_J13.1)
	ALIAS(V_INFO, IC_J13.3)
	ALIAS(V_INFOQ, IC_J13.11)

	// Reset 2
	NET_C(H256, IC_A11.2)
	NET_C(H452, IC_A11.1)
	ALIAS(RESET2, IC_A11.3)

	// Main Timing & Sync
	CLOCK(CLK, 14318000)
	NET_C(VCC, CLK.VCC)
	NET_C(GND, CLK.GND)

	NET_C(CLK.Q, IC_A7.1, IC_A7.3)
	ALIAS(CLOCKQ, IC_A7.4)

	// Horizontal Timing
	NET_C(IC_A7.2, IC_K12.3, IC_E12.2, IC_D12.2)
	NET_C(V5, IC_E12.7, IC_E12.10, IC_E12.9, IC_D12.10, IC_D12.9, IC_C12.1, IC_C12.4, IC_C12.8, IC_C12.11, IC_C12.10, IC_K12.4, IC_K12.1)
	ALIAS(H1, IC_E12.14)
	ALIAS(H2, IC_E12.13)
	ALIAS(H4, IC_E12.12)
	ALIAS(H8, IC_E12.11)
	NET_C(IC_E12.15, IC_D12.7)
	ALIAS(H16, IC_D12.14)
	ALIAS(H32, IC_D12.13)
	ALIAS(H64, IC_D12.12)
	ALIAS(H128, IC_D12.11)
	NET_C(IC_D12.15, IC_C12.12)
	NET_C(IC_C12.3, IC_C12.9)
	ALIAS(H256, IC_C12.3)
	ALIAS(H256Q, IC_C12.2)
	ALIAS(H452, IC_C12.5)
	NET_C(IC_C12.6, IC_B12.5)
	ALIAS(H452Q, IC_C12.6)
	NET_C(H256, IC_D13.1)
	NET_C(H128, IC_D13.4)
	NET_C(H64, IC_D13.5)
	NET_C(H2, IC_D13.2)
	NET_C(IC_D13.6, IC_K12.2)
	NET_C(IC_E12.1, IC_D12.1, IC_C12.13, IC_B12.3, IC_K12.5, IC_B14.5)
	ALIAS(H_RESETQ, IC_K12.5)
	ALIAS(H_RESET, IC_K12.6)
	NET_C(H32Q, IC_B14.1)
	NET_C(IC_B14.6, IC_B14.2)
	NET_C(IC_B14.3, IC_B14.4)
	ALIAS(H_BLANK, IC_B14.6)
	NET_C(H_BLANK, IC_B12.4)
	NET_C(H4, IC_E13.9)
	NET_C(H16, IC_E13.11)
	NET_C(H32, IC_E13.13)
	NET_C(H64, IC_E13.5)
	ALIAS(H4Q, IC_E13.8)
	ALIAS(H16Q, IC_E13.10)
	ALIAS(H32Q, IC_E13.12)
	ALIAS(H64Q, IC_E13.6)
	ALIAS(H_SYNCQ, IC_B12.6)
	NET_C(H_SYNCQ, IC_E13.3, IC_A14.10)
	NET_C(H_INFO, IC_A14.11)
	NET_C(H64Q, IC_A14.9)
	NET_C(IC_A14.8, IC_A14.3, IC_A14.4, IC_A14.5)
	NET_C(IC_A14.6, IC_B11.5)
	NET_C(H8, IC_B11.3)
	NET_C(H16, IC_B11.2)
	NET_C(IC_B11.1, IC_B12.2)
	NET_C(H2, IC_B12.13)
	NET_C(IC_E13.4, IC_B12.1)
	ALIAS(H_SYNC, IC_E13.4)
	ALIAS(H_COUNTQ, IC_B12.12)

	// Vertical Timing
	NET_C(V8, IC_J13.5)
	NET_C(V512, IC_J13.4)
	NET_C(IC_J13.6, IC_K12.12)
	NET_C(H_RESET, IC_K12.11)
	NET_C(VCC, IC_K12.10, IC_K12.13)
	ALIAS(V_RESETQ, IC_K12.9)
	ALIAS(V_RESET, IC_K12.8)
	NET_C(V_RESET, IC_F12.2, IC_F12.3, IC_H12.2, IC_H12.3, IC_B11.12)
	NET_C(H_BLANK, IC_F12.14)
	NET_C(IC_F12.12, IC_F12.1)
	NET_C(IC_F12.11, IC_H12.14)
	NET_C(IC_H12.12, IC_H12.1)
	NET_C(IC_H12.11, IC_J12.12)
	NET_C(VCC, IC_J12.1, IC_J12.4, IC_J12.8, IC_J12.11)
	NET_C(IC_J12.3, IC_J12.9)
	NET_C(V_RESETQ, IC_J12.13, IC_J12.10)
	ALIAS(V1, IC_F12.12)
	ALIAS(V2, IC_F12.9)
	ALIAS(V4, IC_F12.8)
	ALIAS(V8, IC_F12.11)
	ALIAS(V16, IC_H12.12)
	ALIAS(V32, IC_H12.9)
	ALIAS(V64, IC_H12.8)
	ALIAS(V128, IC_H12.11)
	ALIAS(V256, IC_J12.3)
	ALIAS(V256Q, IC_J12.2)
	ALIAS(V512, IC_J12.5)
	ALIAS(V512Q, IC_J12.6)
	NET_C(V8, IC_B11.8)
	NET_C(IC_B11.10, IC_B11.11)
	NET_C(IC_B11.13, IC_B11.9)
	ALIAS(V_SYNC, IC_B11.10)
	NET_C(V_SYNC, IC_B11.6)
	ALIAS(COMP_SYNC, IC_B11.4)

	// Out-of-Bounds Detection
	NET_C(RESET2, IC_D13.10)
	NET_C(H16, IC_D13.12)
	NET_C(H128, IC_D13.9, IC_C13.4)
	NET_C(H32, IC_D13.13, IC_C13.3)
	NET_C(H452Q, IC_C13.5)
	NET_C(IC_D13.8, IC_B13.9)
	NET_C(IC_C13.6, IC_B13.12)
	NET_C(IC_B13.8, IC_B13.13)
	NET_C(IC_B13.11, IC_B13.10, IC_E14.5)
	NET_C(V_INFOQ, IC_E14.4)
	ALIAS(OOB, IC_E14.6)

	// Tank Resets
	NET_C(OOB, IC_K8.1, IC_K8.12)
	NET_C(TANK2, IC_K8.2)
	NET_C(STARTQ, IC_L8.1, IC_L8.13)
	NET_C(IC_K8.3, IC_L8.2)
	NET_C(IC_L8.3, IC_L12.1, IC_L12.13)
	NET_C(VCC, IC_L12.2, IC_L12.4, IC_L12.10, IC_L12.12)
	NET_C(RESET2, IC_L12.3)
	NET_C(V256, IC_L12.11)
	ALIAS(HRST2Q, IC_L12.5)
	ALIAS(VRST2Q, IC_L12.9)

	NET_C(TANK1, IC_K8.13)
	NET_C(IC_K8.11, IC_L8.12)
	NET_C(IC_L8.11, IC_L9.1, IC_L9.13)
	NET_C(VCC, IC_L9.2, IC_L9.4, IC_L9.10, IC_L9.12)
	NET_C(H_INFOQ, IC_L9.11)
	NET_C(V_RESET, IC_L9.3)
	ALIAS(HRST1Q, IC_L9.9)
	ALIAS(VRST1Q, IC_L9.5)

	// HMCE
	NET_C(GND, IC_K9.12)
	NET_C(VCC, IC_K9.4, IC_K9.13, IC_K9.1)
	NET_C(VLD2, IC_K9.11)
	NET_C(H452Q, IC_K9.3)
	NET_C(IC_K9.5, IC_K9.10)
	NET_C(IC_K9.9, IC_K9.2)
	ALIAS(HMCEQ, IC_K9.5)
	ALIAS(HMCE, IC_K9.6)

	// Blo-Up 1 & Blo-Up 2
	NET_C(V5, R28.1, R29.1)
	NET_C(GND, C19.2, C18.2, C15.2, C16.2)
	NET_C(R28.2, IC_C11.2, IC_C11.1, C19.1)
	NET_C(R29.2, IC_C11.12, IC_C11.13, C18.1)
	NET_C(C15.1, IC_C11.3)
	NET_C(C16.1, IC_C11.11)
	NET_C(HT1Q, IC_C11.4, IC_C11.6)
	NET_C(HT2Q, IC_C11.8, IC_C11.10)
	ALIAS(BLO_UP1, IC_C11.5)
	ALIAS(BLO_UP2, IC_C11.9)

	// Flash & TM1
	NET_C(GND, IC_A12.6, IC_A12.7)
	NET_C(V_RESETQ, IC_A12.14)
	NET_C(IC_A12.12, IC_A12.1, IC_B12.10)
	NET_C(IC_A12.11, IC_B12.9)
	HINT(IC_A12.9, NC)
	NET_C(VLD2, IC_B12.11)
	NET_C(ATTRACTQ, IC_M13.1)
	NET_C(IC_M13.2, IC_A13.2)
	NET_C(IC_B12.8, IC_A13.3)
	ALIAS(FLASH, IC_A12.8)
	ALIAS(TM1, IC_A13.1)

	// Tank 1 Control
	NET_C(GND, P1_RIGHT_UP.1, P1_RIGHT_DOWN.1, P1_LEFT_UP.1, P1_LEFT_DOWN.1)
	NET_C(GND, C39.2, C40.2, C41.2, C42.2)
	NET_C(VCC, R56B.1, R57.1, R58.1, R59B.1, CR9.K, CR10.K, CR11.K, CR12.K)

	NET_C(P1_RIGHT_UP.2, R63B.1)
	NET_C(R63B.2, R59B.2, CR9.A, C42.1, IC_E15.2, IC_E15.12)
	NET_C(P1_RIGHT_DOWN.2, R61.1)
	NET_C(R61.2, R57.2, CR11.A, C40.1, IC_E15.6, IC_E15.9)
	NET_C(P1_LEFT_UP.2, R62.1)
	NET_C(R62.2, R58.2, CR10.A, C41.1, IC_E15.8, IC_E15.3)
	NET_C(P1_LEFT_DOWN.2, R60B.1)
	NET_C(R60B.2, R56B.2, CR12.A, C39.1, IC_E15.11, IC_E15.5)

	ALIAS(ACC1, IC_E15.1)
	ALIAS(STOP1, IC_E15.4)
	ALIAS(RR1, IC_E15.10)
	ALIAS(RL1, IC_E15.13)

	NET_C(TM1, IC_E14.2, IC_C14.10, IC_E14.12, IC_E14.9)
	NET_C(STOP1, IC_E14.1)
	NET_C(ACC1, IC_C14.11)
	NET_C(RR1, IC_E14.13)
	NET_C(RL1, IC_E14.10)

	NET_C(BOUNCE1Q, IC_F14.5)
	NET_C(ATTRACTQ, IC_F14.4)
	NET_C(IC_E14.3, IC_F14.3)
	NET_C(IC_F14.6, IC_J14.2, IC_J14.3)
	NET_C(IC_C14.8, IC_J14.1)
	NET_C(IC_J14.9, IC_K13.9, IC_H14.4)
	NET_C(IC_J14.8, IC_K13.10, IC_L13.9, IC_H14.5)
	NET_C(IC_J14.11, IC_K13.11, IC_L13.10, IC_H14.6)
	NET_C(IC_L13.8, IC_C14.9)

	NET_C(GND, IC_H14.3)
	NET_C(VCC, IC_H14.10, IC_H14.7)
	NET_C(VLD1, IC_H14.2)
	NET_C(IC_K13.8, IC_M13.5)
	NET_C(IC_M13.6, IC_H14.1)
	NET_C(IC_H14.15, IC_M13.11)
	NET_C(IC_H14.9, IC_M13.10, IC_L13.4)
	NET_C(BOUNCE1Q, IC_L13.5)
	ALIAS(G01, IC_L13.6)

	NET_C(HIT2Q, IC_H11.5)
	NET_C(IC_E14.11, IC_H11.4)
	NET_C(IC_H11.6, IC_H10.5)
	NET_C(IC_E14.8, IC_H10.4)
	NET_C(STARTQ, IC_H10.11)
	NET_C(VCC, IC_H10.9)
	NET_C(GND, IC_H10.15, IC_H10.1, IC_H10.10, IC_H10.14)
	NET_C(IC_H10.12, IC_H11.10)
	NET_C(IC_H10.13, IC_H11.9)
	NET_C(IC_H11.8, IC_D8.12)
	NET_C(VCC, IC_D8.1, IC_D8.4)
	NET_C(STARTQ, IC_D8.13)
	HINT(IC_D8.3, NC)
	ALIAS(P1D0, IC_H10.3)
	ALIAS(P1D1, IC_H10.2)
	ALIAS(P1D2, IC_H10.6)
	ALIAS(P1D3, IC_H10.7)
	ALIAS(P1D4, IC_D8.2)
	ALIAS(P1SP0, IC_J14.9)
	ALIAS(P1SP1, IC_J14.8)
	ALIAS(P1SP2, IC_J14.11)

	// Tank 2 Control
	NET_C(GND, P2_RIGHT_UP.1, P2_RIGHT_DOWN.1, P2_LEFT_UP.1, P2_LEFT_DOWN.1)
	NET_C(GND, C33C.2, C34C.2, C35C.2, C36C.2)
	NET_C(VCC, R48B.1, R49B.1, R50B.1, R51B.1, CR5.K, CR6.K, CR7.K, CR8.K)

	NET_C(P2_RIGHT_UP.2, R55B.1)
	NET_C(R55B.2, R51B.2, CR5.A, C36C.1, IC_D15.2, IC_D15.12)
	NET_C(P2_RIGHT_DOWN.2, R53B.1)
	NET_C(R53B.2, R49B.2, CR7.A, C34C.1, IC_D15.6, IC_D15.9)
	NET_C(P2_LEFT_UP.2, R54B.1)
	NET_C(R54B.2, R50B.2, CR6.A, C35C.1, IC_D15.8, IC_D15.3)
	NET_C(P2_LEFT_DOWN.2, R52B.1)
	NET_C(R52B.2, R48B.2, CR8.A, C33C.1, IC_D15.11, IC_D15.5)

	ALIAS(ACC2, IC_D15.1)
	ALIAS(STOP2, IC_D15.4)
	ALIAS(RR2, IC_D15.10)
	ALIAS(RL2, IC_D15.13)

	NET_C(TM1, IC_D14.2, IC_C14.4, IC_D14.12, IC_D14.9)
	NET_C(STOP2, IC_D14.1)
	NET_C(ACC2, IC_C14.3)
	NET_C(RR2, IC_D14.13)
	NET_C(RL2, IC_D14.10)

	NET_C(BOUNCE2Q, IC_F14.9)
	NET_C(ATTRACTQ, IC_F14.10)
	NET_C(IC_D14.3, IC_F14.11)
	NET_C(IC_F14.8, IC_L14.2, IC_L14.3)
	NET_C(IC_C14.6, IC_L14.1)
	NET_C(IC_L14.9, IC_K13.4, IC_K14.4)
	NET_C(IC_L14.8, IC_K13.5, IC_L13.12, IC_K14.5)
	NET_C(IC_L14.11, IC_K13.3, IC_L13.13, IC_K14.6)
	NET_C(IC_L13.11, IC_C14.5)

	NET_C(GND, IC_K14.3)
	NET_C(VCC, IC_K14.10, IC_K14.7)
	NET_C(VLD2, IC_K14.2)
	NET_C(IC_K13.6, IC_M13.9)
	NET_C(IC_M13.8, IC_K14.1)
	NET_C(IC_K14.15, IC_M13.13)
	NET_C(IC_K14.9, IC_M13.12, IC_L13.2)
	NET_C(BOUNCE2Q, IC_L13.1)
	ALIAS(G02, IC_L13.3)

	NET_C(HIT1Q, IC_H11.2)
	NET_C(IC_D14.11, IC_H11.1)
	NET_C(IC_H11.3, IC_F11.5)
	NET_C(IC_D14.8, IC_F11.4)
	NET_C(STARTQ, IC_F11.11)
	NET_C(VCC, IC_F11.9)
	NET_C(GND, IC_F11.15, IC_F11.1, IC_F11.10, IC_F11.14)
	NET_C(IC_F11.12, IC_H11.12)
	NET_C(IC_F11.13, IC_H11.13)
	NET_C(IC_H11.11, IC_D8.9)
	NET_C(VCC, IC_D8.8, IC_D8.11)
	NET_C(STARTQ, IC_D8.10)
	HINT(IC_D8.6, NC)
	ALIAS(P2D0, IC_F11.3)
	ALIAS(P2D1, IC_F11.2)
	ALIAS(P2D2, IC_F11.6)
	ALIAS(P2D3, IC_F11.7)
	NET_C(IC_D8.5, IC_E8.10)
	ALIAS(P2D4, IC_D8.5)
	NET_C(BOUNCE2, IC_E8.9)
	ALIAS(P2D4S, IC_E8.8)
	ALIAS(P2SP0, IC_L14.9)
	ALIAS(P2SP1, IC_L14.8)
	ALIAS(P2SP2, IC_L14.11)

	// Shell 1 Control
	NET_C(GND, P1_FIRE.1, C31.2, C100.2, IC_C9.12, IC_C9.4)
	NET_C(P1_FIRE.2, R43.1)
	NET_C(R43.2, C31.1, R41.2, CR2.A, IC_B15.1)
	NET_C(VCC, R41.1, CR2.K)
	NET_C(BLO_UP2, IC_N7.5)
	NET_C(SRS1, IC_N7.6)
	NET_C(IC_N7.4, IC_A15.1)
	NET_C(HMCEQ, IC_A15.3)
	NET_C(ATTRACTQ, IC_A15.2)
	NET_C(VCC, IC_A15.4, RUNK1.2, FIRE1_ADJUST.3, FIRE1_ADJUST.2, IC_C9.3, IC_A8.1, IC_A8.4)
	NET_C(V_RESET, IC_A8.3, IC_A8.11)
	NET_C(IC_A15.5, IC_B15.13)
	NET_C(IC_B15.11, IC_C9.11, IC_B15.2)
	NET_C(IC_B15.3, IC_B15.12)
	NET_C(PLAYFIELD, IC_B9.8, IC_B7.4, C100.1)
	NET_C(SHELL1, IC_B7.5)
	NET_C(IC_B7.6, IC_B9.6)
	NET_C(HIT2, IC_B9.5)
	NET_C(IC_B9.4, IC_C9.13)
	NET_C(C11.1, IC_C9.15)
	NET_C(C11.2, IC_C9.14, FIRE1_ADJUST.1)
	NET_C(C12.1, IC_C9.1)
	NET_C(C12.2, IC_C9.2, RUNK1.1)
	NET_C(IC_C9.10, IC_C9.5)
	ALIAS(FIRE1, IC_C9.10)
	ALIAS(FIRE1Q, IC_C9.9)
	ALIAS(EXPL1, IC_C9.6)
	ALIAS(EXPL1Q, IC_C9.7)
	NET_C(TANK2, IC_B9.9)
	NET_C(IC_B9.10, IC_B9.11)
	NET_C(TANK1, IC_B10.9)
	NET_C(IC_B10.8, IC_B9.12)
	ALIAS(TANK1Q, IC_B10.8)
	NET_C(HT1Q, IC_B10.5)
	NET_C(IC_B10.6, IC_B9.2)
	NET_C(IC_B9.13, IC_B9.3)
	NET_C(IC_B9.1, IC_A9.1)
	NET_C(IC_A9.3, IC_A9.12, IC_A8.2)
	NET_C(IC_A9.11, IC_A9.2)
	NET_C(IC_A8.5, IC_E8.5)
	ALIAS(BOUNCE1, IC_A8.5)
	NET_C(IC_A8.6, IC_A9.13)
	ALIAS(BOUNCE1Q, IC_A8.6)
	NET_C(P1D4, IC_E8.4)
	ALIAS(P1D4S, IC_E8.6)

	// Shell 2 Control
	NET_C(GND, P2_FIRE.1, C30.2, IC_C8.12, IC_C8.4)
	NET_C(P2_FIRE.2, R42.1)
	NET_C(R42.2, C30.1, R40.2, CR3.A, IC_B15.4)
	NET_C(VCC, R40.1, CR3.K)
	NET_C(BLO_UP1, IC_N7.3)
	NET_C(SRS2, IC_N7.2)
	NET_C(IC_N7.1, IC_A15.13)
	NET_C(HMCEQ, IC_A15.11)
	NET_C(ATTRACTQ, IC_A15.12)
	NET_C(VCC, IC_A15.10, R16.2, R15.2, IC_C8.3, IC_A8.10, IC_A8.13)
	NET_C(IC_A15.9, IC_B15.10)
	NET_C(IC_B15.8, IC_C8.11, IC_B15.5)
	NET_C(IC_B15.6, IC_B15.9)
	NET_C(PLAYFIELD, IC_B8.8, IC_B7.1)
	NET_C(SHELL2, IC_B7.2)
	NET_C(IC_B7.3, IC_B8.6)
	NET_C(HIT1, IC_B8.5)
	NET_C(IC_B8.4, IC_C8.13)
	NET_C(C8.1, IC_C8.15)
	NET_C(C8.2, IC_C8.14, R16.1)
	NET_C(C9.1, IC_C8.1)
	NET_C(C9.2, IC_C8.2, R15.1)
	NET_C(IC_C8.10, IC_C8.5)
	ALIAS(FIRE2, IC_C8.10)
	ALIAS(FIRE2Q, IC_C8.9)
	ALIAS(EXPL2, IC_C8.6)
	ALIAS(EXPL2Q, IC_C8.7)
	NET_C(TANK1, IC_B8.9)
	NET_C(IC_B8.10, IC_B8.12)
	NET_C(TANK2, IC_B10.11)
	NET_C(IC_B10.10, IC_B8.11)
	ALIAS(TANK2Q, IC_B10.10)
	NET_C(HT2Q, IC_B10.3)
	NET_C(IC_B10.4, IC_B8.2)
	NET_C(IC_B8.13, IC_B8.3)
	NET_C(IC_B8.1, IC_A9.4)
	NET_C(IC_A9.6, IC_A9.9, IC_A8.12)
	NET_C(IC_A9.8, IC_A9.5)
	ALIAS(BOUNCE2, IC_A8.9)
	NET_C(IC_A8.8, IC_A9.10)
	ALIAS(BOUNCE2Q, IC_A8.8)

	// Score
	NET_C(VCC, IC_J8.1, IC_J8.13)
	NET_C(GND, IC_J8.2, IC_J8.12)
	NET_C(TANK2, IC_K8.4)
	NET_C(SHELL1, IC_K8.5)
	NET_C(IC_K8.6, IC_J8.4)
	NET_C(V_RESET, IC_J8.3, IC_J8.11)
	NET_C(IC_J8.5, IC_J7.2)
	NET_C(MTK2, IC_J7.3)
	NET_C(IC_J7.1, IC_C10.14)
	NET_C(START, IC_C10.2, IC_C10.3, IC_D11.2, IC_D11.3, IC_E11.2, IC_E11.3)
	ALIAS(HIT2, IC_J8.5)
	ALIAS(HIT2Q, IC_J8.6)
	ALIAS(HIT1, IC_J8.9)
	ALIAS(HIT1Q, IC_J8.8)
	ALIAS(HT1Q, IC_J7.13)
	ALIAS(HT2Q, IC_J7.1)
	NET_C(IC_C10.12, IC_C10.1)
	ALIAS(SCR1A, IC_C10.12)
	ALIAS(SCR1B, IC_C10.9)
	ALIAS(SCR1C, IC_C10.8)
	ALIAS(SCR1D, IC_C10.11)
	NET_C(TANK1, IC_K8.10)
	NET_C(SHELL2, IC_K8.9)
	NET_C(IC_K8.8, IC_J8.10)
	NET_C(IC_J8.9, IC_J7.12)
	NET_C(MTK1, IC_J7.11)
	NET_C(IC_J7.13, IC_D11.1)
	NET_C(SCR1D, IC_D11.14)
	NET_C(IC_D11.12, IC_E11.1)
	NET_C(IC_D11.11, IC_E11.14)
	ALIAS(SCR1E, IC_D11.11)
	ALIAS(SCR2A, IC_D11.9)
	ALIAS(SCR2B, IC_D11.8)
	ALIAS(SCR2C, IC_D11.11)
	ALIAS(SCR1F, IC_E11.12)
	ALIAS(SCR2D, IC_E11.9)
	ALIAS(SCR2E, IC_E11.8)
	ALIAS(SCR2F, IC_E11.11)

	// Memory
	TTL_9322_DIP(IC_F10)
	TTL_9322_DIP(IC_F8)
	TTL_9322_DIP(IC_D10)
	TTL_9322_DIP(IC_E10)
	NET_C(VCC, IC_F10.16, IC_F8.16, IC_D10.16, IC_E10.16)
	NET_C(GND, IC_F10.8,  IC_F8.8,  IC_D10.8,  IC_E10.8, IC_F10.15, IC_F8.15, IC_D10.15, IC_E10.15)

	TTL_7400_DIP(IC_H8)
	NET_C(VCC, IC_H8.14)
	NET_C(GND, IC_H8.7)

	NET_C(H64, IC_F10.1, IC_F8.1, IC_H8.2)
	NET_C(H64Q, IC_H8.12)
	NET_C(H452Q, IC_D10.1, IC_E10.1)
	NET_C(P1D0, IC_F10.2)
	NET_C(P2D0, IC_F10.3)
	NET_C(P1D1, IC_F10.5)
	NET_C(P2D1, IC_F10.6)
	NET_C(P1D2, IC_F10.14)
	NET_C(P2D2, IC_F10.13)
	NET_C(P1D3, IC_F10.11)
	NET_C(P2D3, IC_F10.10)

	NET_C(P1D4, IC_F8.2)
	NET_C(P2D4, IC_F8.3)
	NET_C(P1D4S, IC_F8.5)
	NET_C(P2D4S, IC_F8.6)
	NET_C(P1T2, IC_F8.14)
	NET_C(P2T2, IC_F8.13)
	NET_C(P1T3, IC_F8.11)
	NET_C(P2T3, IC_F8.10)

	NET_C(P1T4, IC_H8.13)
	NET_C(P2T4, IC_H8.1)
	NET_C(IC_H8.11, IC_H8.10)
	NET_C(IC_H8.3, IC_H8.9)

	NET_C(SCR1A, IC_D10.2)
	NET_C(SCR2A, IC_D10.3)
	NET_C(SCR1B, IC_D10.5)
	NET_C(SCR2B, IC_D10.6)
	NET_C(SCR1C, IC_D10.14)
	NET_C(SCR2C, IC_D10.13)
	NET_C(SCR1D, IC_D10.11)
	NET_C(SCR2D, IC_D10.10)

	NET_C(SCR1E, IC_E10.2)
	NET_C(SCR2E, IC_E10.3)
	NET_C(SCR1F, IC_E10.5)
	NET_C(SCR2F, IC_E10.6)
	NET_C(GND, IC_E10.14, IC_E10.13, IC_E10.11, IC_E10.10)

	ALIAS(D0, IC_F10.4)
	ALIAS(D1, IC_F10.7)
	ALIAS(D2, IC_F10.12)
	ALIAS(D3, IC_F10.9)

	ALIAS(D4, IC_F8.4)
	ALIAS(D4S, IC_F8.7)
	ALIAS(T2, IC_F8.12)
	ALIAS(T3, IC_F8.9)

	ALIAS(T4, IC_H8.8)

	ALIAS(SCRA, IC_D10.4)
	ALIAS(SCRB, IC_D10.7)
	ALIAS(SCRC, IC_D10.12)
	ALIAS(SCRD, IC_D10.9)

	ALIAS(SCRE, IC_E10.4)
	ALIAS(SCRF, IC_E10.7)
	HINT(IC_E10.12, NC)
	HINT(IC_E10.9, NC)

	TTL_74153_DIP(IC_D9)
	TTL_74153_DIP(IC_E9)
	TTL_74153_DIP(IC_J9)
	TTL_74153_DIP(IC_H9)
	TTL_74153_DIP(IC_F9)
	NET_C(VCC, IC_D9.16, IC_E9.16, IC_J9.16, IC_H9.16, IC_F9.16)
	NET_C(GND, IC_D9.8,  IC_E9.8,  IC_J9.8,  IC_H9.8,  IC_F9.8)
	NET_C(GND, IC_D9.1,  IC_E9.1,  IC_J9.1,  IC_H9.1,  IC_F9.1)
	NET_C(GND, IC_D9.15, IC_E9.15, IC_J9.15, IC_H9.15, IC_F9.15)

	NET_C(VCC, R13.1)

	NET_C(R13.2, IC_D9.6)
	NET_C(GND,   IC_D9.5)
	NET_C(VCC,   IC_D9.4)
	NET_C(R13.2, IC_D9.3)
	NET_C(V256,  IC_D9.10)
	NET_C(SCRF,  IC_D9.11)
	NET_C(D3,    IC_D9.12)
	NET_C(V256,  IC_D9.13)

	NET_C(V128,  IC_E9.6)
	NET_C(SCRE,  IC_E9.5)
	NET_C(D2,    IC_E9.4)
	NET_C(V128,  IC_E9.3)
	NET_C(V64,   IC_E9.10)
	NET_C(SCRD,  IC_E9.11)
	NET_C(D1,    IC_E9.12)
	NET_C(V64,   IC_E9.13)

	NET_C(GND,   IC_J9.6)
	NET_C(SCRC,  IC_J9.5)
	NET_C(D0,    IC_J9.4)
	NET_C(V32,   IC_J9.3)
	NET_C(D4S,   IC_J9.10)
	NET_C(SCRB,  IC_J9.11)
	NET_C(H32Q,  IC_J9.12)
	NET_C(V16,   IC_J9.13)

	NET_C(D3,    IC_H9.6)
	NET_C(SCRA,  IC_H9.5)
	NET_C(D4,    IC_H9.4)
	NET_C(H452,  IC_H9.3)
	NET_C(D2,    IC_H9.10)
	NET_C(V16,   IC_H9.11)
	NET_C(T4,    IC_H9.12)
	NET_C(H256,  IC_H9.13)

	NET_C(D1,    IC_F9.6)
	NET_C(V8,    IC_F9.5)
	NET_C(T3,    IC_F9.4)
	NET_C(H128,  IC_F9.3)
	NET_C(D0,    IC_F9.10)
	NET_C(V4,    IC_F9.11)
	NET_C(T2,    IC_F9.12)
	NET_C(H64,   IC_F9.13)

	NET_C(H_INFOQ, IC_D9.14, IC_E9.14, IC_J9.14, IC_H9.14, IC_F9.14, IC_E8.13)
	NET_C(V_INFOQ, IC_D9.2,  IC_E9.2,  IC_J9.2,  IC_H9.2,  IC_F9.2,  IC_E8.12)

	PROM_MK28000_DIP(IC_R10)
	PARAM(IC_R10.ROM, "gfx")
	NET_C(VCC, IC_R10.1, IC_R10.14, IC_R10.24)
	NET_C(GND, IC_R10.9)
	NET_C(H16, IC_R10.13)
	NET_C(IC_E8.11, IC_R10.15)
	NET_C(IC_D9.7, IC_R10.8)
	NET_C(IC_D9.9, IC_R10.10)
	NET_C(IC_E9.7, IC_R10.11)
	NET_C(IC_E9.9, IC_R10.12)
	NET_C(IC_J9.7, IC_R10.7)
	NET_C(IC_J9.9, IC_R10.6)
	NET_C(IC_H9.7, IC_R10.5)
	NET_C(IC_H9.9, IC_R10.4)
	NET_C(IC_F9.7, IC_R10.3)
	NET_C(IC_F9.9, IC_R10.2)

	TTL_7406_DIP(IC_M10)
	TTL_7406_DIP(IC_N13)
	NET_C(VCC, IC_M10.14, IC_N13.14)
	NET_C(GND, IC_M10.7)
	NET_C(GND, IC_N13.7, R19.2, R20.2, R21.2, R22.2, R23.2, R24.2, R25.2, R26.2)
	NET_C(IC_R10.16, R19.1, IC_M10.9)
	NET_C(IC_R10.17, R20.1, IC_M10.5)
	NET_C(IC_R10.18, R21.1, IC_M10.11)
	NET_C(IC_R10.19, R22.1, IC_M10.13)
	NET_C(IC_R10.20, R23.1, IC_M10.1)
	NET_C(IC_R10.21, R24.1, IC_M10.3)
	NET_C(IC_R10.22, R25.1, IC_N13.11)
	NET_C(IC_R10.23, R26.1, IC_N13.9)
	ALIAS(ROM_D7, IC_M10.8)
	ALIAS(ROM_D6, IC_M10.6)
	ALIAS(ROM_D5, IC_M10.10)
	ALIAS(ROM_D4, IC_M10.12)
	ALIAS(ROM_D3, IC_M10.2)
	ALIAS(ROM_D2, IC_M10.4)
	ALIAS(ROM_D1, IC_N13.10)
	ALIAS(ROM_D0, IC_N13.8)

	// Video Summing
	NET_C(VCC, IC_N10.10)
	NET_C(GND, IC_N10.15)
	NET_C(H4Q, IC_N10.2)
	NET_C(PFLDQ, IC_N10.1)
	ALIAS(FIELD, IC_N10.7)
	NET_C(ROM_D0, IC_N10.11)
	NET_C(ROM_D1, IC_N10.12)
	NET_C(ROM_D2, IC_N10.13)
	NET_C(ROM_D3, IC_N10.14)
	NET_C(ROM_D4, IC_N10.3)
	NET_C(ROM_D5, IC_N10.4)
	NET_C(ROM_D6, IC_N10.5)
	NET_C(ROM_D7, IC_N10.6)

	NET_C(IC_N10.9, IC_K13.2)
	NET_C(V512, IC_K13.13)
	NET_C(MINEFIELD, IC_K13.1)
	ALIAS(PLAYFIELD, IC_K13.12)

	NET_C(GNE, IC_C14.2)
	NET_C(V_INFO, IC_C14.1)
	NET_C(FLASH, IC_C14.13)

	NET_C(IC_K13.12, IC_A11.4)
	NET_C(IC_C14.12, IC_A11.5)
	ALIAS(PLAYFIELD_VIDEO, IC_A11.6)

	NET_C(PLAYFIELD_VIDEO, IC_F14.13, IC_D11V.9)
	NET_C(TANK1Q, IC_B10.1)
	NET_C(V_INFO, IC_F14.1)
	NET_C(H452Q,IC_F14.2)
	NET_C(SHELL1, IC_L7.11)
	NET_C(BLAST1, IC_L7.12)
	NET_C(IC_L7.13, IC_H8.5)
	NET_C(IC_D11V.8, IC_H8.4)
	NET_C(TANK2, IC_D7.12)
	NET_C(MINE, IC_D7.11)
	NET_C(SHELL2, IC_N7.8)
	NET_C(BLAST2, IC_N7.9)
	NET_C(IC_D7.13, IC_B7.10)
	NET_C(IC_N7.10, IC_B7.9)

	NET_C(IC_B10.2, R5V.1)
	NET_C(IC_F14.12, R34V.1)
	NET_C(IC_H8.6, R6V.1)
	NET_C(IC_B7.8, R4V.1)

	NET_C(VCC, R7V.1)
	NET_C(R7V.2, R3V.1, C2.1)
	NET_C(GND, C2.2)
	NET_C(R5V.2, R34V.2, R6V.2, R3V.2, R4V.2, CR1.A, RVID.1)
	NET_C(CR1.K, COMP_SYNC)
	//RES(RPROBE, 220)
	//NET_C(RPROBE.2, RVID.1)
	//ALIAS(VIDEO_PROBE, RPROBE.1)
	RES(RVID, RES_K(10))
	NET_C(RVID.2, GND)
	ALIAS(VIDEO_OUT, RVID.1)

	// Video Probe
	//NET_C(PFLDQ, VIDEO_PROBE)
	//TTL_7404_GATE(PROBE_BUF1)
	//TTL_7404_GATE(PROBE_BUF2)
	//NET_C(VCC, PROBE_BUF1.VCC, PROBE_BUF2.VCC)
	//NET_C(GND, PROBE_BUF1.GND, PROBE_BUF2.GND)

	// Playfield & Score Load
	NET_C(V_INFO, IC_H13.1)
	NET_C(V32, IC_H13.2)
	NET_C(H256, C23.1)
	NET_C(C23.2, R32.1, IC_H13.13)
	NET_C(V_INFOQ, IC_A10.2)
	NET_C(H32, C17.1)
	NET_C(C17.2, R27.1, IC_A10.1)
	NET_C(GND, R32.2, R27.2)
	NET_C(IC_H13.12, IC_A10.5)
	NET_C(IC_A10.3, IC_A10.4)
	NET_C(IC_A10.6, IC_A10.9)
	NET_C(H_INFOQ, IC_A10.10)
	ALIAS(PFLDQ, IC_A10.8)

	// Mine Matrix
	TTL_7400_DIP(IC_A10)
	TTL_7486_DIP(IC_F13)
	NET_C(VCC, IC_A10.14, IC_F13.14)
	NET_C(GND, IC_A10.7,  IC_F13.7)

	NET_C(V8, IC_A10.13)
	NET_C(H8, IC_A10.12)
	ALIAS(SQUARES, IC_A10.11)
	NET_C(V4, IC_F13.10)
	NET_C(V2, IC_F13.9)
	NET_C(H4, IC_F13.12)
	NET_C(H2, IC_F13.13)
	NET_C(IC_F13.8, IC_F13.5)
	NET_C(IC_F13.11, IC_F13.4)
	ALIAS(CHECKERBOARD, IC_F13.6)
	NET_C(SQUARES, IC_D7.3)
	NET_C(CHECKERBOARD, IC_D7.2)
	ALIAS(MINE_MATRIX, IC_D7.1)

	// Minefield
	TTL_7410_DIP(IC_H13)
	NET_C(VCC, IC_H13.14)
	NET_C(GND, IC_H13.7)

	NET_C(V256Q, IC_H13.5)
	NET_C(V128, IC_H13.4, IC_H13.10)
	NET_C(V32, IC_H13.3, IC_H13.11)
	NET_C(V256, IC_A11.12)
	NET_C(H_SYNC, IC_A11.13)
	NET_C(IC_A11.11, IC_H13.9)
	NET_C(H452, IC_C13.9)
	NET_C(H452Q, IC_C13.1)
	NET_C(H256, IC_C13.2)
	NET_C(H128, IC_C13.10, IC_C13.13)
	NET_C(H16, IC_C13.11)
	NET_C(IC_H13.6, IC_B14.9)
	NET_C(IC_H13.8, IC_B14.13)
	ALIAS(MEV, IC_B14.8)
	ALIAS(MEVQ, IC_B14.11)
	NET_C(MEV, IC_B14.12)
	NET_C(IC_C13.8, IC_B13.5)
	NET_C(IC_C13.12, IC_B13.2)
	ALIAS(MEH, IC_B13.3)
	ALIAS(MEHQ, IC_B13.6)
	NET_C(MEH, IC_B13.4)
	NET_C(MEVQ, IC_B14.10, IC_A13.5)
	NET_C(MEHQ, IC_B13.1, IC_A13.6)
	ALIAS(MINEFIELD, IC_A13.4)

	// Mine Control
	TTL_7400_DIP(IC_K7)
	TTL_7420_DIP(IC_E7)
	TTL_7474_DIP(IC_H7)
	TTL_8277_DIP(IC_F7)
	NET_C(VCC, IC_K7.14, IC_E7.14, IC_H7.14, IC_F7.16, IC_F7.12, IC_F7.6)
	NET_C(GND, IC_K7.7,  IC_E7.7,  IC_H7.7,  IC_F7.8,  IC_H7.2,  IC_H7.12, IC_F7.7, IC_F7.10, IC_F7.5, IC_F7.11)

	NET_C(IC_F7.3, IC_F7.13)
	NET_C(MEV, IC_A11.10)
	NET_C(V8, IC_A11.9)
	NET_C(IC_A11.8, IC_F7.9, IC_H7.3, IC_H7.11)
	NET_C(STARTQ, IC_H7.1, IC_H7.13, IC_F7.1)
	NET_C(TANK1, IC_K7.13)
	NET_C(TANK2, IC_K7.1)
	NET_C(MINE, IC_K7.12, IC_K7.2)
	NET_C(IC_K7.11, IC_H7.4)
	NET_C(IC_K7.3, IC_H7.10)
	ALIAS(MTK1, IC_H7.5)
	ALIAS(MTK1Q, IC_H7.6)
	ALIAS(MTK2, IC_H7.9)
	ALIAS(MTK2Q, IC_H7.8)

	NET_C(MTK1Q, IC_K7.10)
	NET_C(MTK2Q, IC_K7.9)
	NET_C(IC_K7.8, IC_J7.8)
	NET_C(IC_F7.14, IC_J7.9)
	NET_C(IC_J7.10, IC_F7.4, IC_E7.5)
	NET_C(FIELD, IC_E7.4)
	NET_C(MINE_MATRIX, IC_E7.2)
	NET_C(MINEFIELD, IC_E7.1)
	NET_C(IC_E7.6, IC_E7.9, IC_E7.10, IC_E7.12, IC_E7.13)
	ALIAS(MINE, IC_E7.8)

	// Horizontal & Vertical Load
	TTL_7404_DIP(IC_J11)
	TTL_7402_DIP(IC_K11)
	TTL_9321_DIP(IC_L11)
	NET_C(VCC, IC_J11.14, IC_K11.14, IC_L11.16)
	NET_C(GND, IC_J11.7,  IC_K11.7,  IC_L11.8, C21.2)

	NET_C(V_RESET, IC_K11.8)
	NET_C(V2, IC_K11.12)
	NET_C(IC_K11.10, IC_K11.11)
	NET_C(IC_K11.13, IC_K11.9, IC_J11.3)
	NET_C(IC_J11.4, IC_K11.5, IC_K11.2)
	NET_C(H16, IC_D14.5)
	NET_C(H_INFO, IC_D14.4)
	NET_C(IC_D14.6, IC_L11.1)
	NET_C(H32, IC_L11.2)
	NET_C(H64, IC_L11.3)
	NET_C(IC_L11.4, C21.1)
	NET_C(IC_L11.5, IC_K11.6)
	NET_C(IC_L11.7, IC_K11.3)
	ALIAS(LDH2BQ, IC_L11.7)
	ALIAS(LDH2AQ, IC_L11.6)
	ALIAS(LDH1BQ, IC_L11.5)
	ALIAS(LDH1AQ, IC_L11.4)
	NET_C(IC_K11.4, IC_J11.5)
	NET_C(IC_K11.1, IC_J11.1)
	ALIAS(VLD1, IC_K11.4)
	ALIAS(VLD1Q, IC_J11.6)
	ALIAS(VLD2, IC_K11.1)
	ALIAS(VLD2Q, IC_J11.2)

	// Horizontal & Vertical Motion Latches
	TTL_7474_DIP(IC_M8)
	TTL_7474_DIP(IC_N8)
	TTL_7474_DIP(IC_M12)
	TTL_7474_DIP(IC_N12)
	TTL_7474_DIP(IC_M9)
	TTL_7474_DIP(IC_N9)
	TTL_7474_DIP(IC_M11)
	TTL_7474_DIP(IC_N11)
	NET_C(VCC, IC_M8.14, IC_N8.14, IC_M12.14, IC_N12.14, IC_M9.14, IC_N9.14, IC_M11.14, IC_N11.14)
	NET_C(GND, IC_M8.7,  IC_N8.7,  IC_M12.7,  IC_N12.7,  IC_M9.7,  IC_N9.7,  IC_M11.7,  IC_N11.7)
	NET_C(VCC, IC_M8.10, IC_M8.4, IC_N8.10, IC_N8.4, IC_M12.10, IC_M12.4, IC_N12.10, IC_N12.4, IC_N9.4)
	NET_C(VCC, IC_M9.13, IC_M9.1, IC_N9.13, IC_M11.13, IC_M11.1, IC_N11.13, IC_N11.4)

	NET_C(VLD1Q, IC_M8.11, IC_M8.3, IC_N8.11, IC_N8.3, IC_M9.11, IC_M9.3, IC_N9.11, IC_N9.3)
	NET_C(VLD2Q, IC_M12.11, IC_M12.3, IC_N12.11, IC_N12.3, IC_M11.11, IC_M11.3, IC_N11.11, IC_N11.3)
	NET_C(G01, IC_L8.5, IC_M9.10, IC_M9.4, IC_N9.10, IC_N9.1)
	NET_C(G02, IC_L8.9, IC_M11.10, IC_M11.4, IC_N11.10, IC_N11.1)
	NET_C(H_COUNTQ, IC_L8.4, IC_L8.10)
	NET_C(IC_L8.6, IC_M8.13, IC_M8.1, IC_N8.13, IC_N8.1)
	NET_C(IC_L8.8, IC_M12.13, IC_M12.1, IC_N12.13, IC_N12.1)
	NET_C(ROM_D0, IC_M8.12, IC_M12.12)
	NET_C(ROM_D1, IC_M8.2, IC_M12.2)
	NET_C(ROM_D2, IC_N8.12, IC_N12.12)
	NET_C(ROM_D3, IC_N8.2, IC_N12.2)
	NET_C(ROM_D4, IC_M9.12, IC_M11.12)
	NET_C(ROM_D5, IC_M9.2, IC_M11.2)
	NET_C(ROM_D6, IC_N9.12, IC_N11.12)
	NET_C(ROM_D7, IC_N9.2, IC_N11.2)

	ALIAS(HA1, IC_M8.9)
	ALIAS(HB1, IC_M8.5)
	ALIAS(HC1, IC_N8.9)
	ALIAS(HD1, IC_N8.5)
	ALIAS(HA2, IC_M12.9)
	ALIAS(HB2, IC_M12.5)
	ALIAS(HC2, IC_N12.9)
	ALIAS(HD2, IC_N12.5)

	ALIAS(VA1, IC_M9.9)
	ALIAS(VB1, IC_M9.5)
	ALIAS(VC1, IC_N9.9)
	ALIAS(VD1, IC_N9.5)
	ALIAS(VA2, IC_M11.9)
	ALIAS(VB2, IC_M11.5)
	ALIAS(VC2, IC_N11.9)
	ALIAS(VD2, IC_N11.5)

	// Tank 1 Motion
	TTL_9316_DIP(IC_A1)
	TTL_9316_DIP(IC_B1)
	TTL_9316_DIP(IC_A2)
	TTL_9316_DIP(IC_B2)
	TTL_9316_DIP(IC_C2)
	TTL_74165_DIP(IC_A3)
	TTL_74165_DIP(IC_B3)
	TTL_74107_DIP(IC_N1)
	NET_C(VCC, IC_A1.16, IC_B1.16, IC_A2.16, IC_B2.16, IC_C2.16, IC_A3.16, IC_B3.16, IC_N1.14)
	NET_C(GND, IC_A1.8,  IC_B1.8,  IC_A2.8,  IC_B2.8,  IC_C2.8,  IC_A3.8,  IC_B3.8,  IC_N1.7)

	TTL_7420_DIP(IC_M1)
	TTL_7410_DIP(IC_M2)
	TTL_7400_DIP(IC_C1)
	TTL_7404_DIP(IC_J3)
	TTL_7404_DIP(IC_A6)
	TTL_7486_DIP(IC_K3)
	TTL_7402_DIP(IC_L3)
	TTL_7474_DIP(IC_F3)
	NET_C(VCC, IC_M1.14, IC_M2.14, IC_C1.14, IC_J3.14, IC_A6.14, IC_K3.14, IC_L3.14, IC_F3.14)
	NET_C(GND, IC_M1.7,  IC_M2.7,  IC_C1.7,  IC_J3.7,  IC_A6.7,  IC_K3.7,  IC_L3.7,  IC_F3.7)

	NET_C(HA1, IC_A1.3)
	NET_C(HB1, IC_A1.4)
	NET_C(HC1, IC_A1.5)
	NET_C(HD1, IC_A1.6)

	NET_C(VA1, IC_A2.3)
	NET_C(VB1, IC_A2.4)
	NET_C(VC1, IC_A2.5)
	NET_C(VD1, IC_A2.6)

	NET_C(HRST1Q, IC_A1.1, IC_B1.1, IC_N1.10, IC_N1.13)
	NET_C(VRST1Q, IC_A2.1, IC_B2.1, IC_C2.1)

	NET_C(CLOCKQ, IC_A6.9)
	NET_C(IC_A6.8, IC_A1.2, IC_B1.2, IC_A3.2, IC_B3.2, IC_F3.11)
	ALIAS(CLOCK1, IC_A6.8)

	NET_C(H_COUNTQ, IC_A6.1)
	NET_C(IC_A6.2, IC_A2.2, IC_B2.2, IC_C2.2)
	ALIAS(H_COUNT1, IC_A6.2)

	NET_C(VCC, IC_A1.7, IC_A1.10, IC_B1.10, IC_B1.3, IC_B1.4, IC_B1.5)
	NET_C(VCC, IC_N1.1, IC_N1.4, IC_N1.8, IC_N1.11)
	NET_C(VCC, IC_A2.7, IC_A2.10, IC_B2.10, IC_B2.3, IC_B2.4, IC_B2.5, IC_B2.6, IC_C2.3, IC_C2.5, IC_C2.6)
	NET_C(VCC, IC_F3.13, IC_A3.10)
	NET_C(GND, IC_B1.6, IC_C2.4)

	NET_C(IC_A1.15, IC_B1.7, IC_M1.5)
	NET_C(IC_B1.15, IC_N1.12, IC_M2.5, IC_M1.1)
	NET_C(IC_N1.3, IC_N1.9, IC_M2.4, IC_M1.2)
	NET_C(IC_N1.6, IC_M2.3, IC_M1.4)
	NET_C(IC_M1.6, IC_A1.9, IC_B1.9)
	ALIAS(THR1Q, IC_M1.6)
	ALIAS(THW1Q, IC_M2.6)

	NET_C(IC_A2.15, IC_B2.7, IC_C2.7, IC_C1.12)
	NET_C(IC_B2.15, IC_C2.10)
	NET_C(IC_C2.15, IC_C1.13, IC_F3.10)
	NET_C(IC_C1.11, IC_A2.9, IC_B2.9, IC_C2.9)
	ALIAS(TVR1Q, IC_C1.11)

	NET_C(THW1Q, IC_F3.12)
	ALIAS(WINDO1, IC_F3.8)
	NET_C(IC_F3.9, IC_A3.15, IC_B3.15, IC_L3.11)
	NET_C(IC_A3.9, IC_B3.10)
	NET_C(IC_B3.7, IC_K3.1)

	NET_C(FLASH, IC_C1.10, IC_J3.3)
	NET_C(BLO_UP1, IC_C1.9)
	ALIAS(FLASHQ, IC_J3.4)
	NET_C(IC_C1.8, IC_K3.2)
	NET_C(IC_K3.3, IC_L3.12)
	ALIAS(TANK1, IC_L3.13)

	NET_C(LDH1AQ, IC_A3.1)
	NET_C(LDH1BQ, IC_B3.1)

	NET_C(ROM_D0, IC_A3.11, IC_B3.11)
	NET_C(ROM_D1, IC_A3.12, IC_B3.12)
	NET_C(ROM_D2, IC_A3.13, IC_B3.13)
	NET_C(ROM_D3, IC_A3.14, IC_B3.14)
	NET_C(ROM_D4, IC_A3.3, IC_B3.3)
	NET_C(ROM_D5, IC_A3.4, IC_B3.4)
	NET_C(ROM_D6, IC_A3.5, IC_B3.5)
	NET_C(ROM_D7, IC_A3.6, IC_B3.6)

	ALIAS(P1T2, IC_A2.13)
	ALIAS(P1T3, IC_A2.12)
	ALIAS(P1T4, IC_A2.11)

	// Tank 2 Motion Circuit
	TTL_9316_DIP(IC_A5)
	TTL_9316_DIP(IC_B5)
	TTL_9316_DIP(IC_A4)
	TTL_9316_DIP(IC_B4)
	TTL_9316_DIP(IC_C4)
	TTL_74165_DIP(IC_C3)
	TTL_74165_DIP(IC_D3)
	TTL_74107_DIP(IC_N5)
	NET_C(VCC, IC_A5.16, IC_B5.16, IC_A4.16, IC_B4.16, IC_C4.16, IC_C3.16, IC_D3.16, IC_N5.14)
	NET_C(GND, IC_A5.8,  IC_B5.8,  IC_A4.8,  IC_B4.8,  IC_C4.8,  IC_C3.8,  IC_D3.8,  IC_N5.7)

	TTL_7402_DIP(IC_C6)
	TTL_7420_DIP(IC_M5)
	TTL_7410_DIP(IC_M4)
	TTL_7400_DIP(IC_C5)
	NET_C(VCC, IC_C6.14, IC_M5.14, IC_M4.14, IC_C5.14)
	NET_C(GND, IC_C6.7,  IC_M5.7,  IC_M4.7,  IC_C5.7)

	NET_C(CLOCKQ, IC_A6.5)
	ALIAS(CLOCK2, IC_A6.5)
	NET_C(IC_A6.6, IC_A5.2, IC_B5.2, IC_F3.3, IC_C3.2, IC_D3.2)
	NET_C(HRST2Q, IC_A5.1, IC_B5.1, IC_N5.10, IC_N5.13)
	NET_C(VCC, IC_B5.10, IC_B5.3, IC_B5.4, IC_B5.5, IC_N5.1, IC_N5.4, IC_N5.8, IC_N5.11, IC_C3.10, IC_F3.1, IC_A5.7, IC_A5.10)
	NET_C(GND, IC_B5.6)

	NET_C(IC_B4.15, IC_C4.10)
	NET_C(IC_C3.9, IC_D3.10)
	NET_C(THW2Q, IC_F3.2)
	NET_C(TVW2, IC_F3.4)

	NET_C(IC_F3.5, IC_C3.15, IC_D3.15, IC_C6.3)

	NET_C(HA2, IC_A5.3)
	NET_C(HB2, IC_A5.4)
	NET_C(HC2, IC_A5.5)
	NET_C(HD2, IC_A5.6)
	NET_C(IC_A5.15, IC_B5.7, IC_M5.1)
	NET_C(IC_B5.15, IC_N5.12, IC_M5.2, IC_M4.5)
	NET_C(IC_N5.3, IC_N5.9, IC_M5.5, IC_M4.3)
	NET_C(IC_N5.6, IC_M5.4, IC_M4.4)
	ALIAS(THR2Q, IC_M5.6)
	ALIAS(THW2Q, IC_M4.6)
	NET_C(THR2Q, IC_A5.9, IC_B5.9)

	NET_C(ROM_D0, IC_C3.11, IC_D3.11)
	NET_C(ROM_D1, IC_C3.12, IC_D3.12)
	NET_C(ROM_D2, IC_C3.13, IC_D3.13)
	NET_C(ROM_D3, IC_C3.14, IC_D3.14)
	NET_C(ROM_D4, IC_C3.3, IC_D3.3)
	NET_C(ROM_D5, IC_C3.4, IC_D3.4)
	NET_C(ROM_D6, IC_C3.5, IC_D3.5)
	NET_C(ROM_D7, IC_C3.6, IC_D3.6)

	ALIAS(WINDO2, IC_F3.6)
	NET_C(LDH2AQ, IC_C3.1)
	NET_C(LDH2BQ, IC_D3.1)

	NET_C(BLO_UP2, IC_C5.13)
	NET_C(FLASH, IC_C5.12)
	NET_C(IC_C5.11, IC_K3.10)
	NET_C(IC_D3.9, IC_K3.9)
	NET_C(IC_K3.2, IC_C6.2)
	ALIAS(TANK2, IC_C6.1)

	NET_C(VA2, IC_A4.3)
	NET_C(VB2, IC_A4.4)
	NET_C(VC2, IC_A4.5)
	NET_C(VD2, IC_A4.6)

	NET_C(VCC, IC_A4.7, IC_A4.10, IC_B4.10, IC_B4.3, IC_B4.4, IC_B4.5, IC_B4.6, IC_C4.3, IC_C4.5, IC_C4.6)
	NET_C(GND, IC_C4.4)

	NET_C(H_COUNTQ, IC_A6.3)
	NET_C(IC_A6.4, IC_A4.2, IC_B4.2, IC_C4.2)
	ALIAS(HCOUNT2, IC_A6.4)

	NET_C(VRST2Q, IC_A4.1, IC_B4.1, IC_C4.1)
	ALIAS(P2T2, IC_A4.13)
	ALIAS(P2T3, IC_A4.12)
	ALIAS(P2T4, IC_A4.11)

	NET_C(IC_A4.15, IC_B4.7, IC_C4.7, IC_C5.10)
	NET_C(IC_C4.15, IC_C5.9)
	NET_C(IC_C5.8, IC_A4.9, IC_B4.9, IC_C4.9)
	ALIAS(TVR2Q, IC_C5.8)
	ALIAS(TVW2, IC_C4.15)

	// Shell 1 Motion
	TTL_7474_DIP(IC_D1)
	TTL_7474_DIP(IC_E1)
	TTL_9316_DIP(IC_H1)
	TTL_9316_DIP(IC_J1)
	TTL_9316_DIP(IC_F1)
	TTL_9316_DIP(IC_H2)
	TTL_9316_DIP(IC_J2)
	TTL_74107_DIP(IC_L1)
	TTL_7408_DIP(IC_F2)
	NET_C(VCC, IC_D1.14, IC_E1.14, IC_H1.16, IC_J1.16, IC_F1.16, IC_H2.16, IC_J2.16, IC_L1.14, IC_F2.14, IC_F1.1)
	NET_C(GND, IC_D1.7,  IC_E1.7,  IC_H1.8,  IC_J1.8,  IC_F1.8,  IC_H2.8,  IC_J2.8,  IC_L1.7,  IC_F2.7)

	TTL_7402_DIP(IC_K1)
	TTL_7404_DIP(IC_N4)
	TTL_7420_DIP(IC_L2)
	TTL_7486_DIP(IC_K2)
	TTL_7474_DIP(IC_N3)
	TTL_7408_DIP(IC_M3)
	TTL_7474_DIP(IC_D2)
	TTL_7474_DIP(IC_E2)
	NET_C(VCC, IC_K1.14, IC_N4.14, IC_L2.14, IC_K2.14, IC_N3.14, IC_M3.14, IC_D2.14, IC_E2.14)
	NET_C(GND, IC_K1.7,  IC_N4.7,  IC_L2.7,  IC_K2.7,  IC_N3.7,  IC_M3.7,  IC_D2.7,  IC_E2.7)

	NET_C(VCC, R4.1, R5.1, R6.1, R7.1, R8.1, R9.1, R10.1, R11.1)
	NET_C(VCC, IC_H2.7, IC_H2.10, IC_J2.10, IC_J2.3, IC_J2.4, IC_J2.5, IC_L1.1, IC_L1.4, IC_L1.8, IC_L1.11, IC_N3.1)
	NET_C(VCC, IC_F1.7, IC_F1.10, IC_H1.10, IC_H1.3, IC_H1.4, IC_H1.5, IC_H1.6, IC_J1.3, IC_J1.5, IC_J1.6)
	NET_C(VCC, IC_D1.1, IC_D1.13, IC_E1.1, IC_H2.1, IC_J2.1, IC_D2.4, IC_D2.10, IC_E2.4, IC_E2.10, IC_E1.10)
	NET_C(VCC, IC_H1.1, IC_J1.1)
	NET_C(GND, C110.2, IC_N3.2, IC_J2.6, IC_J1.4)

	NET_C(VLD1, IC_M2.1, IC_M2.2)
	NET_C(FIRE1Q, IC_M2.13)
	NET_C(IC_M2.12, IC_D2.3, IC_D2.11, IC_E2.3, IC_E2.11, IC_D1.3, IC_D1.11, IC_E1.3, IC_E1.11)
	NET_C(EXPL1, IC_J3.13)
	NET_C(IC_J3.12, IC_D2.1, IC_D2.13, IC_E2.1, IC_E2.13, IC_D1.4, IC_D1.10, IC_E1.4, IC_E1.13)
	NET_C(HMCE, IC_F2.12, IC_F2.5, IC_F2.9, IC_C1.1)
	NET_C(IC_D2.5, IC_F2.13)
	NET_C(IC_E2.5, IC_F2.4)
	NET_C(IC_D2.9, IC_F2.10)
	NET_C(IC_E2.9, IC_C1.2)

	NET_C(FIRE1Q, C110.1, IC_C1.4)
	NET_C(EXPL1Q, IC_C1.5)
	ALIAS(FPE1, IC_C1.6)
	NET_C(IC_C1.6, IC_L3.2)
	NET_C(THW1Q, IC_L3.3)
	NET_C(IC_L3.1, IC_J3.1)
	NET_C(IC_J3.2, IC_M3.4, IC_N3.4)
	NET_C(IC_M3.6, IC_H2.9, IC_J2.9)
	NET_C(IC_M1.8, IC_M3.5)

	NET_C(IC_F2.11, IC_H2.3)
	NET_C(IC_F2.6, IC_H2.4)
	NET_C(IC_F2.8, IC_H2.5)
	NET_C(IC_C1.3, IC_H2.6)

	NET_C(CLOCK1, IC_H2.2, IC_J2.2)
	NET_C(H_COUNT1, IC_F1.2, IC_H1.2, IC_J1.2)

	NET_C(IC_H2.15, IC_J2.7, IC_M1.13, IC_N3.3)
	NET_C(IC_J2.15, IC_L1.12, IC_M1.12, IC_M2.9)
	NET_C(IC_L1.3, IC_L1.9, IC_M1.10, IC_M2.10)
	NET_C(IC_L1.5, IC_M1.9, IC_M2.11)
	NET_C(IC_N3.6, IC_L1.10, IC_L1.13)

	NET_C(IC_D1.5, IC_F1.3)
	NET_C(IC_D1.9, IC_F1.4)
	NET_C(IC_E1.5, IC_F1.5)
	NET_C(IC_E1.9, IC_F1.6)

	NET_C(IC_F1.15, IC_H1.7, IC_J1.7, IC_F2.2)
	NET_C(IC_H1.15, IC_J1.10)
	NET_C(IC_J1.15, IC_J3.11, IC_F2.1)
	NET_C(IC_F2.3, IC_K1.12)
	NET_C(FPE1, IC_K1.9)
	NET_C(TVR1Q, IC_K1.8)
	ALIAS(SRS1, IC_K1.10)
	NET_C(IC_K1.10, IC_K1.11)
	NET_C(IC_K1.13, IC_J1.9, IC_H1.9, IC_F1.9)

	NET_C(IC_J3.10, IC_L3.5)
	NET_C(IC_M2.8, IC_L3.6)
	NET_C(IC_L3.4, IC_L2.1, IC_L2.9)
	NET_C(FIRE1Q, IC_J3.5)
	NET_C(IC_J3.6, IC_L2.2)
	NET_C(S4V1, IC_L3.9)
	NET_C(S8H1, IC_L3.8)
	NET_C(IC_L3.10, IC_L2.4)
	NET_C(S4H1, IC_M3.9)
	NET_C(S8V1, IC_M3.10)
	NET_C(IC_M3.8, IC_L2.5)
	NET_C(IC_L2.6, IC_N4.5)
	ALIAS(SHELL1, IC_N4.6)

	NET_C(S4V1, IC_K2.5)
	NET_C(S8V1, IC_K2.4)
	NET_C(S4H1, IC_K2.10)
	NET_C(S8H1, IC_K2.9)
	NET_C(S2V1, IC_K2.12)
	NET_C(S2H1, IC_K2.13)
	NET_C(IC_K2.6, IC_K2.2, IC_K1.2)
	NET_C(IC_K2.8, IC_K2.1, IC_K1.3)
	NET_C(FLASHQ, IC_K3.4)
	NET_C(IC_K3.3, IC_K3.5)
	NET_C(IC_K3.6, IC_L2.12)
	NET_C(IC_K1.1, IC_K1.6)
	NET_C(IC_K2.11, IC_K1.5)
	NET_C(IC_K1.4, IC_L2.13)
	NET_C(EXPL1, IC_L2.10)
	NET_C(IC_L2.8, IC_N4.9)
	ALIAS(BLAST1, IC_N4.8)

	ALIAS(S2H1, IC_H2.13)
	ALIAS(S4H1, IC_H2.12)
	ALIAS(S8H1, IC_H2.11)

	ALIAS(S2V1, IC_F1.13)
	ALIAS(S4V1, IC_F1.12)
	ALIAS(S8V1, IC_F1.11)

	NET_C(ROM_D0, R4.2, IC_D2.2)
	NET_C(ROM_D1, R6.2, IC_E2.2)
	NET_C(ROM_D2, R8.2, IC_E2.12)
	NET_C(ROM_D3, R10.2, IC_D2.12)
	NET_C(ROM_D4, R11.2, IC_D1.2)
	NET_C(ROM_D5, R9.2, IC_D1.12)
	NET_C(ROM_D6, R7.2, IC_E1.2)
	NET_C(ROM_D7, R5.2, IC_E1.12)

	// Shell 2 Motion
	TTL_7474_DIP(IC_E4)
	TTL_7474_DIP(IC_D4)
	TTL_7474_DIP(IC_D5)
	TTL_7474_DIP(IC_E5)
	TTL_9316_DIP(IC_H4)
	TTL_9316_DIP(IC_J4)
	TTL_9316_DIP(IC_F5)
	TTL_9316_DIP(IC_H5)
	TTL_9316_DIP(IC_J5)
	NET_C(VCC, IC_E4.14, IC_D4.14, IC_D5.14, IC_E5.14, IC_H4.16, IC_J4.16, IC_F5.16, IC_H5.16, IC_J5.16)
	NET_C(GND, IC_E4.7,  IC_D4.7,  IC_D5.7,  IC_E5.7,  IC_H4.8,  IC_J4.8,  IC_F5.8,  IC_H5.8,  IC_J5.8)

	TTL_74107_DIP(IC_L5)
	TTL_7486_DIP(IC_K4)
	TTL_7402_DIP(IC_K5)
	TTL_7408_DIP(IC_F4)
	TTL_7420_DIP(IC_L4)
	NET_C(VCC, IC_L5.14, IC_K4.14, IC_K5.14, IC_F4.14, IC_L4.14)
	NET_C(GND, IC_L5.7,  IC_K4.7,  IC_K5.7,  IC_F4.7,  IC_L4.7)

	NET_C(VCC, IC_E4.4, IC_D4.4, IC_E4.10, IC_D4.10, IC_D5.1, IC_D5.13, IC_E5.1)
	NET_C(VCC, IC_J4.10, IC_J4.3, IC_J4.4, IC_J4.5, IC_H5.10, IC_H5.3, IC_H5.4, IC_H5.5, IC_H5.6, IC_J5.3, IC_J5.5, IC_J5.6)
	NET_C(VCC, IC_H4.1, IC_H4.7, IC_H4.10, IC_J4.1, IC_F5.1, IC_F5.7, IC_F5.10, IC_H5.1, IC_J5.1, IC_N3.13, IC_L5.8, IC_L5.11, IC_L5.1, IC_L5.4, IC_E5.10)
	NET_C(GND, C111.2, IC_J4.6, IC_J5.4, IC_N3.12)

	NET_C(FIRE2Q, IC_M4.1, IC_M4.2)
	NET_C(VLD2, IC_M4.13)
	NET_C(IC_M4.12, IC_E4.3, IC_D4.3, IC_E4.11, IC_D4.11, IC_D5.3, IC_D5.11, IC_E5.3, IC_E5.11)

	NET_C(EXPL2, IC_H3.11)
	NET_C(IC_H3.10, IC_E4.1, IC_D4.1, IC_E4.13, IC_D4.13, IC_E5.13, IC_D5.4, IC_D5.10, IC_E5.4)

	NET_C(IC_E4.5, IC_F4.2)
	NET_C(IC_D4.5, IC_F4.5)
	NET_C(IC_E4.9, IC_F4.9)
	NET_C(IC_D4.9, IC_C5.5)
	NET_C(HMCE, IC_F4.1, IC_F4.4, IC_F4.10, IC_C5.4)

	NET_C(IC_F4.3, IC_H4.3)
	NET_C(IC_F4.6, IC_H4.4)
	NET_C(IC_F4.8, IC_H4.5)
	NET_C(IC_C5.6, IC_H4.6)

	NET_C(HCOUNT2, IC_F5.2, IC_H5.2, IC_J5.2)
	NET_C(IC_H5.15, IC_J5.10)
	NET_C(IC_J5.15, IC_H3.13, IC_F4.12)
	NET_C(IC_F5.15, IC_H5.7, IC_J5.7, IC_F4.13)
	NET_C(IC_F4.11, IC_C6.12)
	NET_C(FPE2, IC_C6.8)
	NET_C(TVR2Q, IC_C6.9)
	NET_C(IC_C6.10, IC_C6.11)
	ALIAS(SRS2, IC_C6.10)
	NET_C(IC_C6.13, IC_F5.9, IC_H5.9, IC_J5.9)

	NET_C(IC_D5.5, IC_F5.3)
	NET_C(IC_D5.9, IC_F5.4)
	NET_C(IC_E5.5, IC_F5.5)
	NET_C(IC_E5.9, IC_F5.6)

	NET_C(CLOCK2, IC_H4.2, IC_J4.2)
	NET_C(IC_H4.15, IC_J4.7, IC_M5.9, IC_N3.11)
	NET_C(IC_J4.15, IC_L5.9, IC_M5.10, IC_M4.11)
	NET_C(IC_L5.5, IC_L5.12, IC_M5.12, IC_M4.10)
	NET_C(IC_L5.3, IC_M5.13, IC_M4.9)
	NET_C(IC_M4.8, IC_K5.11)
	NET_C(IC_H3.12, IC_K5.12)

	NET_C(FIRE2Q, C111.1, IC_C5.1)
	NET_C(EXPL2Q, IC_C5.2)
	NET_C(IC_C5.3, IC_C6.6)
	ALIAS(FPE2, IC_C5.3)
	NET_C(THW2Q, IC_C6.5)
	NET_C(IC_C6.4, IC_H3.1)
	NET_C(IC_H3.2, IC_N3.10, IC_M3.2)
	NET_C(IC_M5.8, IC_M3.1)
	NET_C(IC_M3.3, IC_H4.9, IC_J4.9)
	NET_C(IC_N3.8, IC_L5.10, IC_L5.13)

	NET_C(S4H2, IC_M3.12)
	NET_C(S8V2, IC_M3.13)
	NET_C(S4V2, IC_K5.3)
	NET_C(S8H2, IC_K5.2)
	NET_C(IC_M3.11, IC_L4.5)
	NET_C(IC_K5.1, IC_L4.2)
	NET_C(FIRE2Q, IC_H3.9)
	NET_C(IC_H3.8, IC_L4.4)

	NET_C(IC_K5.13, IC_L4.13, IC_L4.1)
	NET_C(IC_L4.6, IC_N4.11)
	ALIAS(SHELL2, IC_N4.10)

	NET_C(S4V2, IC_K4.1)
	NET_C(S8V2, IC_K4.2)
	NET_C(S4H2, IC_K4.10)
	NET_C(S8H2, IC_K4.9)
	NET_C(S2H2, IC_K4.12)
	NET_C(S2V2, IC_K4.13)
	NET_C(IC_K4.3, IC_K4.4, IC_K5.6)
	NET_C(IC_K4.8, IC_K4.5, IC_K5.5)
	NET_C(FLASHQ, IC_K3.12)
	NET_C(IC_K4.6, IC_K3.13)
	NET_C(IC_K5.4, IC_K5.9)
	NET_C(IC_K5.11, IC_K5.8)
	NET_C(IC_K3.11, IC_L4.12)
	NET_C(IC_K5.10, IC_L4.10)
	NET_C(EXPL2, IC_L4.9)
	NET_C(IC_L4.8, IC_N4.13)
	ALIAS(BLAST2, IC_N4.12)

	ALIAS(S2H2, IC_H4.13)
	ALIAS(S4H2, IC_H4.12)
	ALIAS(S8H2, IC_H4.11)
	ALIAS(S2V2, IC_F5.13)
	ALIAS(S4V2, IC_F5.12)
	ALIAS(S8V2, IC_F5.11)

	NET_C(ROM_D0, IC_E4.2)
	NET_C(ROM_D1, IC_D4.2)
	NET_C(ROM_D2, IC_E4.12)
	NET_C(ROM_D3, IC_D4.12)
	NET_C(ROM_D4, IC_D5.2)
	NET_C(ROM_D5, IC_D5.12)
	NET_C(ROM_D6, IC_E5.2)
	NET_C(ROM_D7, IC_E5.12)

	// Boom Com
	TTL_9602_DIP(IC_N14)
	NET_C(VCC, IC_N14.16, IC_N14.3, IC_N14.5, IC_N14.13, R38.2)
	NET_C(GND, IC_N14.8, R10A.2, R9A.2)
	NET_C(MTK1, IC_L7.5)
	NET_C(EXPL1, C5.1)
	NET_C(C5.2, R10A.1, IC_L7.6)
	NET_C(MTK2, IC_L7.9)
	NET_C(EXPL2, C6.1)
	NET_C(C6.2, R9A.1, IC_L7.8)
	NET_C(IC_L7.4, IC_K7.4)
	NET_C(IC_L7.10, IC_K7.5)
	NET_C(IC_K7.6, IC_N14.4)
	NET_C(IC_N14.1, C27.1)
	NET_C(IC_N14.2, C27.2, R38.1)
	NET_C(IC_N14.6, IC_N13.5)
	ALIAS(BOOM_COM, IC_N13.6)

	// HLE Noise Gen
	CLOCK(NOISE_CLOCK, 10000)
	NET_C(NOISE_CLOCK.GND, GND)
	NET_C(NOISE_CLOCK.VCC, V12)

	SYS_NOISE_MT_N(HLE_NOISE, 0.05)
	NET_C(HLE_NOISE.I, NOISE_CLOCK.Q)

	// Noise Generation
	OPAMP(IC_NOISE_OP, "UA741")
	NET_C(V12, IC_NOISE_OP.VCC, R71A.1, R70A.1)
	NET_C(R71A.2, C40A.1, HLE_NOISE.1)
	NET_C(C40A.2, C43A.1, R70A.2, R73A.1, IC_NOISE_OP.GND)
	NET_C(GND, HLE_NOISE.2, C43A.2, R73A.2, C38A.1)
	NET_C(C38A.2, R69.1, C39A.1, IC_NOISE_OP.MINUS)
	NET_C(IC_NOISE_OP.PLUS, R69.2, C39A.2)
	ALIAS(NOISE, IC_NOISE_OP.OUT)

	// Shot Sound
	MC3340_DIP(IC_K6)
	NET_C(V12, IC_K6.8)
	NET_C(GND, SHOT_NOISE_VOL.1, C32A.2, IC_K6.3, C27A.2, C28A.2, Q7.C)
	NET_C(NOISE, SHOT_NOISE_VOL.3)
	NET_C(SHOT_NOISE_VOL.2, C32A.1, C31A.1)
	NET_C(C31A.2, IC_K6.2)
	NET_C(IC_K6.6, C27A.1)
	NET_C(VCC, R64A.1)
	NET_C(SHOT_COM, CR19.K)
	NET_C(CR19.A, R64A.2, Q7.B, C28A.1)
	NET_C(IC_K6.2, Q7.E)
	ALIAS(SHOT, IC_K6.7)

	// Shot Com
	NET_C(FIRE1, C7.1)
	NET_C(FIRE2, C4.1)
	NET_C(C7.2, R8A.1, IC_L7.2)
	NET_C(C4.2, R11A.1, IC_L7.3)
	NET_C(GND, IC_N14.12, R8A.2, R11A.2)
	NET_C(IC_L7.1, IC_N14.11)
	NET_C(IC_N14.15, C26.1)
	NET_C(IC_N14.14, C26.2, R37A.1)
	NET_C(R37A.2, VCC)
	NET_C(IC_N14.10, IC_N13.3)
	ALIAS(SHOT_COM, IC_N13.4)

	// Boom Sound
	MC3340_DIP(IC_L6)
	NET_C(V12, IC_L6.8)
	NET_C(NOISE, BOOM_NOISE_VOL.3)
	NET_C(GND, BOOM_NOISE_VOL.1, C36A.2, C41A.2, Q6.C, C30A.2)
	NET_C(BOOM_NOISE_VOL.2, C36A.1, C35A.1)
	NET_C(C35A.2, IC_L6.1)
	NET_C(BOOM_COM, CR22.K)
	NET_C(CR22.A, R72A.2, C41A.1, Q6.B)
	NET_C(V5, R72A.1)
	NET_C(Q6.E, IC_L6.2)
	NET_C(IC_L6.6, C30A.1)
	ALIAS(BOOM, IC_L6.7)

	// Motor 1 Sound
	/*TTL_7406_DIP(IC_K15)
	NE555_DIP(IC_L15)
	NE566_DIP(IC_M15)
	MC3340_DIP(IC_N15)
	NET_C(VCC, IC_K15.14, IC_L15.8, IC_L15.4, Q29.C)
	NET_C(V12, IC_M15.8, IC_N15.8, R73M1.1, Q27.C, R100M1.1, Q30.E, R36M1.1)
	NET_C(GND, IC_K15.7, C54M1.2, C51M1.2, C53M1.2, C55M1.2, R78M1.2, IC_L15.1)
	NET_C(P1SP2, IC_K15.13)
	NET_C(P1SP1, IC_K15.11)
	NET_C(P1SP0, IC_K15.9)
	NET_C(IC_K15.12, R74M1.2)
	NET_C(IC_K15.10, R75M1.2)
	NET_C(IC_K15.8, R76M1.2)
	NET_C(R73M1.2, R74M1.1, R75M1.1, R76M1.1, C54M1.1, Q27.B)
	NET_C(C54M1.2, MOTOR1_VOL.1)
	NET_C(MOTOR1_VOL.3, Q27.E, Q28.B, C52M1.1, IC_M15.5)
	NET_C(R100M1.2, MOTOR1_VOL2.3, MOTOR1_VOL2.2)
	NET_C(MOTOR1_VOL2.1, Q28.E)
	NET_C(MOTOR1_VOL.2, R101M1.1)
	NET_C(CR14M1.A, IC_L15.2)
	NET_C(Q28.C, R77M1.1, IC_L15.7)
	NET_C(IC_L15.6, C51M1.1, CR14M1.K, R77M1.2, Q29.B)
	NET_C(Q29.E, R78M1.1, C56M1.2)
	NET_C(C56M1.1, IC_N15.3)
	NET_C(IC_M15.7, C53M1.1)
	NET_C(C52M1.2, R36M1.2, IC_M15.6)
	NET_C(IC_M15.4, R80M1.1, R79M1.1)
	NET_C(R80M1.2, GND)
	NET_C(R101M1.2, R79M1.2, Q30.C, IC_N15.2)
	NET_C(ATTRACT, IC_N13.1)
	NET_C(IC_N13.2, R81M1.1)
	NET_C(R81M1.2, Q30.B)
	NET_C(IC_N15.6, C55M1.1)
	RES(R555OUT1, RES_K(1))
	NET_C(R555OUT1.1, IC_L15.3)
	NET_C(GND, R555OUT1.2)
	ALIAS(MOTOR1, IC_N15.7)*/
	ALIAS(MOTOR1, GND)

	// Motor 2 Sound
	/*NE555_DIP(IC_J15)
	NE566_DIP(IC_H15)
	MC3340_DIP(IC_F15)
	NET_C(VCC, IC_J15.8, IC_J15.4, Q33.C)
	NET_C(V12, IC_H15.8, IC_F15.8, R72M2.1, Q31.C, R102M2.1, R35M2.1)
	NET_C(GND, C49M2.2, C50M2.2, C48M2.2, C43M2.2, R68M2.2, IC_J15.1)
	NET_C(P2SP2, IC_K15.1)
	NET_C(P2SP1, IC_K15.3)
	NET_C(P2SP0, IC_K15.5)
	NET_C(IC_K15.2, R69M2.2)
	NET_C(IC_K15.4, R70M2.2)
	NET_C(IC_K15.6, R71M2.2)
	NET_C(R72M2.2, R71M2.1, R70M2.1, R69M2.1, C49M2.1, Q31.B)
	NET_C(C49M2.2, MOTOR2_VOL.1)
	NET_C(MOTOR2_VOL.3, Q31.E, Q32.B, C47M2.1, IC_H15.5)
	NET_C(R102M2.2, MOTOR2_VOL2.3, MOTOR2_VOL2.2)
	NET_C(MOTOR2_VOL2.1, Q32.E)
	NET_C(MOTOR2_VOL.2, R103M2.1)
	NET_C(CR13M2.A, IC_J15.2)
	NET_C(Q32.C, R67M2.1, IC_J15.7)
	NET_C(IC_J15.6, C50M2.1, CR13M2.K, R67M2.2, Q33.B)
	NET_C(Q33.E, R68M2.1, C44M2.2)
	NET_C(C44M2.1, IC_F15.3)
	NET_C(IC_H15.7, C48M2.1)
	NET_C(C47M2.2, R35M2.2, IC_H15.6)
	NET_C(IC_H15.4, R66M2.1, R65M2.1)
	NET_C(GND, R66M2.2)
	NET_C(R103M2.2, R65M2.2, Q34.C, IC_F15.2)
	NET_C(ATTRACT, IC_N13.13)
	NET_C(IC_N13.12, R64M2.1)
	NET_C(R64M2.2, Q34.B)
	NET_C(IC_F15.6, C43M2.1)
	RES(R555OUT2, RES_K(1))
	NET_C(R555OUT2.1, IC_J15.3)
	NET_C(GND, R555OUT2.2)
	ALIAS(MOTOR2, IC_F15.7)*/
	ALIAS(MOTOR2, GND)

	// Mixer
	NET_C(MOTOR1, R102MX.1)
	NET_C(MOTOR2, R106MX.1)
	NET_C(BOOM, R103MX.1, R107MX.1)
	NET_C(SHOT, R104MX.1, R108MX.1)
	NET_C(R102MX.2, R103MX.2, R104MX.2, C101.1)
	NET_C(R106MX.2, R107MX.2, R108MX.2, C106.1)
	ALIAS(OUT1, C101.2)
	ALIAS(OUT2, C106.2)
	NET_C(C101.2, GND)
	NET_C(C106.2, GND)

	// Unused Gates / Pins
	NET_C(GND, IC_E8.1, IC_E8.2)
	NET_C(GND, IC_E13.1)
	NET_C(GND, IC_A7.5, IC_A7.9, IC_A7.11, IC_A7.13)
	NET_C(GND, IC_J14.14)
	NET_C(GND, IC_E12.3, IC_E12.4, IC_E12.5, IC_E12.6)
	NET_C(GND, IC_D12.3, IC_D12.4, IC_D12.5, IC_D12.6)
	NET_C(GND, IC_N7.11, IC_N7.12)
	NET_C(GND, IC_B7.12, IC_B7.13)
	NET_C(GND, IC_D7.5, IC_D7.6, IC_D7.8, IC_D7.9)
	NET_C(GND, IC_L14.14)
	NET_C(GND, IC_A14.1, IC_A14.2, IC_A14.13)
	NET_C(GND, IC_B10.13)
	NET_C(GND, IC_D11V.1, IC_D11V.3, IC_D11V.5, IC_D11V.11, IC_D11V.13)
	NET_C(GND, IC_M13.3)
	NET_C(GND, IC_L11.13, IC_L11.14)
	NET_C(VCC, IC_L11.15)
	NET_C(GND, IC_N4.1, IC_N4.3)
	NET_C(GND, IC_A6.11, IC_A6.13)
	NET_C(GND, IC_N6.11, IC_N6.12)
	NET_C(GND, IC_J7.5, IC_J7.6)
	NET_C(GND, IC_F13.1, IC_F13.2)
	NET_C(VCC, IC_J11.9, IC_J11.11, IC_J11.13)
	NET_C(VCC, IC_J3.9)
	NET_C(VCC, IC_N13.1, IC_N13.13)
}
