#include "tempstream.ih"

TempStream::TempStream(string const &base)
{
    char *buf = new char[base.length() + 6 + 1];

    strcpy(buf + base.length(), "XXXXXX");      // 6 x 'X': required by 
                                                // mkostemp
    base.copy(buf, string::npos);

    int fd = mkostemp(buf, O_RDWR);

    if (fd == -1)
        throw Exception{} << "TempStream: " << buf << " fails: " << 
                                                        errnodescr;
    d_filename = buf;
    delete[] buf;
    ::close(fd);

    open(d_filename, ios::out | ios::in);
}
