// Copyright 2009 the Sputnik authors.  All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
info: Check operator x << y in distinct points
es5id: 11.7.1_A4_T4
description: ShiftExpression = 2^n - 1, n = 16...31
---*/

//CHECK

if (0 << 16 !== 0) { 
  throw new Test262Error('#513: 0 << 16 === 0. Actual: ' + (0 << 16)); 
} 


if (1 << 16 !== 65536) { 
  throw new Test262Error('#514: 1 << 16 === 65536. Actual: ' + (1 << 16)); 
} 


if (3 << 16 !== 196608) { 
  throw new Test262Error('#515: 3 << 16 === 196608. Actual: ' + (3 << 16)); 
} 


if (7 << 16 !== 458752) { 
  throw new Test262Error('#516: 7 << 16 === 458752. Actual: ' + (7 << 16)); 
} 


if (15 << 16 !== 983040) { 
  throw new Test262Error('#517: 15 << 16 === 983040. Actual: ' + (15 << 16)); 
} 


if (31 << 16 !== 2031616) { 
  throw new Test262Error('#518: 31 << 16 === 2031616. Actual: ' + (31 << 16)); 
} 


if (63 << 16 !== 4128768) { 
  throw new Test262Error('#519: 63 << 16 === 4128768. Actual: ' + (63 << 16)); 
} 


if (127 << 16 !== 8323072) { 
  throw new Test262Error('#520: 127 << 16 === 8323072. Actual: ' + (127 << 16)); 
} 


if (255 << 16 !== 16711680) { 
  throw new Test262Error('#521: 255 << 16 === 16711680. Actual: ' + (255 << 16)); 
} 


if (511 << 16 !== 33488896) { 
  throw new Test262Error('#522: 511 << 16 === 33488896. Actual: ' + (511 << 16)); 
} 


if (1023 << 16 !== 67043328) { 
  throw new Test262Error('#523: 1023 << 16 === 67043328. Actual: ' + (1023 << 16)); 
} 


if (2047 << 16 !== 134152192) { 
  throw new Test262Error('#524: 2047 << 16 === 134152192. Actual: ' + (2047 << 16)); 
} 


if (4095 << 16 !== 268369920) { 
  throw new Test262Error('#525: 4095 << 16 === 268369920. Actual: ' + (4095 << 16)); 
} 


if (8191 << 16 !== 536805376) { 
  throw new Test262Error('#526: 8191 << 16 === 536805376. Actual: ' + (8191 << 16)); 
} 


if (16383 << 16 !== 1073676288) { 
  throw new Test262Error('#527: 16383 << 16 === 1073676288. Actual: ' + (16383 << 16)); 
} 


if (32767 << 16 !== 2147418112) { 
  throw new Test262Error('#528: 32767 << 16 === 2147418112. Actual: ' + (32767 << 16)); 
} 


if (65535 << 16 !== -65536) { 
  throw new Test262Error('#529: 65535 << 16 === -65536. Actual: ' + (65535 << 16)); 
} 


if (131071 << 16 !== -65536) { 
  throw new Test262Error('#530: 131071 << 16 === -65536. Actual: ' + (131071 << 16)); 
} 


if (262143 << 16 !== -65536) { 
  throw new Test262Error('#531: 262143 << 16 === -65536. Actual: ' + (262143 << 16)); 
} 


if (524287 << 16 !== -65536) { 
  throw new Test262Error('#532: 524287 << 16 === -65536. Actual: ' + (524287 << 16)); 
} 


if (1048575 << 16 !== -65536) { 
  throw new Test262Error('#533: 1048575 << 16 === -65536. Actual: ' + (1048575 << 16)); 
} 


if (2097151 << 16 !== -65536) { 
  throw new Test262Error('#534: 2097151 << 16 === -65536. Actual: ' + (2097151 << 16)); 
} 


if (4194303 << 16 !== -65536) { 
  throw new Test262Error('#535: 4194303 << 16 === -65536. Actual: ' + (4194303 << 16)); 
} 


if (8388607 << 16 !== -65536) { 
  throw new Test262Error('#536: 8388607 << 16 === -65536. Actual: ' + (8388607 << 16)); 
} 


if (16777215 << 16 !== -65536) { 
  throw new Test262Error('#537: 16777215 << 16 === -65536. Actual: ' + (16777215 << 16)); 
} 


if (33554431 << 16 !== -65536) { 
  throw new Test262Error('#538: 33554431 << 16 === -65536. Actual: ' + (33554431 << 16)); 
} 


if (67108863 << 16 !== -65536) { 
  throw new Test262Error('#539: 67108863 << 16 === -65536. Actual: ' + (67108863 << 16)); 
} 


if (134217727 << 16 !== -65536) { 
  throw new Test262Error('#540: 134217727 << 16 === -65536. Actual: ' + (134217727 << 16)); 
} 


if (268435455 << 16 !== -65536) { 
  throw new Test262Error('#541: 268435455 << 16 === -65536. Actual: ' + (268435455 << 16)); 
} 


if (536870911 << 16 !== -65536) { 
  throw new Test262Error('#542: 536870911 << 16 === -65536. Actual: ' + (536870911 << 16)); 
} 


if (1073741823 << 16 !== -65536) { 
  throw new Test262Error('#543: 1073741823 << 16 === -65536. Actual: ' + (1073741823 << 16)); 
} 


if (2147483647 << 16 !== -65536) { 
  throw new Test262Error('#544: 2147483647 << 16 === -65536. Actual: ' + (2147483647 << 16)); 
} 


if (0 << 17 !== 0) { 
  throw new Test262Error('#545: 0 << 17 === 0. Actual: ' + (0 << 17)); 
} 


if (1 << 17 !== 131072) { 
  throw new Test262Error('#546: 1 << 17 === 131072. Actual: ' + (1 << 17)); 
} 


if (3 << 17 !== 393216) { 
  throw new Test262Error('#547: 3 << 17 === 393216. Actual: ' + (3 << 17)); 
} 


if (7 << 17 !== 917504) { 
  throw new Test262Error('#548: 7 << 17 === 917504. Actual: ' + (7 << 17)); 
} 


if (15 << 17 !== 1966080) { 
  throw new Test262Error('#549: 15 << 17 === 1966080. Actual: ' + (15 << 17)); 
} 


if (31 << 17 !== 4063232) { 
  throw new Test262Error('#550: 31 << 17 === 4063232. Actual: ' + (31 << 17)); 
} 


if (63 << 17 !== 8257536) { 
  throw new Test262Error('#551: 63 << 17 === 8257536. Actual: ' + (63 << 17)); 
} 


if (127 << 17 !== 16646144) { 
  throw new Test262Error('#552: 127 << 17 === 16646144. Actual: ' + (127 << 17)); 
} 


if (255 << 17 !== 33423360) { 
  throw new Test262Error('#553: 255 << 17 === 33423360. Actual: ' + (255 << 17)); 
} 


if (511 << 17 !== 66977792) { 
  throw new Test262Error('#554: 511 << 17 === 66977792. Actual: ' + (511 << 17)); 
} 


if (1023 << 17 !== 134086656) { 
  throw new Test262Error('#555: 1023 << 17 === 134086656. Actual: ' + (1023 << 17)); 
} 


if (2047 << 17 !== 268304384) { 
  throw new Test262Error('#556: 2047 << 17 === 268304384. Actual: ' + (2047 << 17)); 
} 


if (4095 << 17 !== 536739840) { 
  throw new Test262Error('#557: 4095 << 17 === 536739840. Actual: ' + (4095 << 17)); 
} 


if (8191 << 17 !== 1073610752) { 
  throw new Test262Error('#558: 8191 << 17 === 1073610752. Actual: ' + (8191 << 17)); 
} 


if (16383 << 17 !== 2147352576) { 
  throw new Test262Error('#559: 16383 << 17 === 2147352576. Actual: ' + (16383 << 17)); 
} 


if (32767 << 17 !== -131072) { 
  throw new Test262Error('#560: 32767 << 17 === -131072. Actual: ' + (32767 << 17)); 
} 


if (65535 << 17 !== -131072) { 
  throw new Test262Error('#561: 65535 << 17 === -131072. Actual: ' + (65535 << 17)); 
} 


if (131071 << 17 !== -131072) { 
  throw new Test262Error('#562: 131071 << 17 === -131072. Actual: ' + (131071 << 17)); 
} 


if (262143 << 17 !== -131072) { 
  throw new Test262Error('#563: 262143 << 17 === -131072. Actual: ' + (262143 << 17)); 
} 


if (524287 << 17 !== -131072) { 
  throw new Test262Error('#564: 524287 << 17 === -131072. Actual: ' + (524287 << 17)); 
} 


if (1048575 << 17 !== -131072) { 
  throw new Test262Error('#565: 1048575 << 17 === -131072. Actual: ' + (1048575 << 17)); 
} 


if (2097151 << 17 !== -131072) { 
  throw new Test262Error('#566: 2097151 << 17 === -131072. Actual: ' + (2097151 << 17)); 
} 


if (4194303 << 17 !== -131072) { 
  throw new Test262Error('#567: 4194303 << 17 === -131072. Actual: ' + (4194303 << 17)); 
} 


if (8388607 << 17 !== -131072) { 
  throw new Test262Error('#568: 8388607 << 17 === -131072. Actual: ' + (8388607 << 17)); 
} 


if (16777215 << 17 !== -131072) { 
  throw new Test262Error('#569: 16777215 << 17 === -131072. Actual: ' + (16777215 << 17)); 
} 


if (33554431 << 17 !== -131072) { 
  throw new Test262Error('#570: 33554431 << 17 === -131072. Actual: ' + (33554431 << 17)); 
} 


if (67108863 << 17 !== -131072) { 
  throw new Test262Error('#571: 67108863 << 17 === -131072. Actual: ' + (67108863 << 17)); 
} 


if (134217727 << 17 !== -131072) { 
  throw new Test262Error('#572: 134217727 << 17 === -131072. Actual: ' + (134217727 << 17)); 
} 


if (268435455 << 17 !== -131072) { 
  throw new Test262Error('#573: 268435455 << 17 === -131072. Actual: ' + (268435455 << 17)); 
} 


if (536870911 << 17 !== -131072) { 
  throw new Test262Error('#574: 536870911 << 17 === -131072. Actual: ' + (536870911 << 17)); 
} 


if (1073741823 << 17 !== -131072) { 
  throw new Test262Error('#575: 1073741823 << 17 === -131072. Actual: ' + (1073741823 << 17)); 
} 


if (2147483647 << 17 !== -131072) { 
  throw new Test262Error('#576: 2147483647 << 17 === -131072. Actual: ' + (2147483647 << 17)); 
} 


if (0 << 18 !== 0) { 
  throw new Test262Error('#577: 0 << 18 === 0. Actual: ' + (0 << 18)); 
} 


if (1 << 18 !== 262144) { 
  throw new Test262Error('#578: 1 << 18 === 262144. Actual: ' + (1 << 18)); 
} 


if (3 << 18 !== 786432) { 
  throw new Test262Error('#579: 3 << 18 === 786432. Actual: ' + (3 << 18)); 
} 


if (7 << 18 !== 1835008) { 
  throw new Test262Error('#580: 7 << 18 === 1835008. Actual: ' + (7 << 18)); 
} 


if (15 << 18 !== 3932160) { 
  throw new Test262Error('#581: 15 << 18 === 3932160. Actual: ' + (15 << 18)); 
} 


if (31 << 18 !== 8126464) { 
  throw new Test262Error('#582: 31 << 18 === 8126464. Actual: ' + (31 << 18)); 
} 


if (63 << 18 !== 16515072) { 
  throw new Test262Error('#583: 63 << 18 === 16515072. Actual: ' + (63 << 18)); 
} 


if (127 << 18 !== 33292288) { 
  throw new Test262Error('#584: 127 << 18 === 33292288. Actual: ' + (127 << 18)); 
} 


if (255 << 18 !== 66846720) { 
  throw new Test262Error('#585: 255 << 18 === 66846720. Actual: ' + (255 << 18)); 
} 


if (511 << 18 !== 133955584) { 
  throw new Test262Error('#586: 511 << 18 === 133955584. Actual: ' + (511 << 18)); 
} 


if (1023 << 18 !== 268173312) { 
  throw new Test262Error('#587: 1023 << 18 === 268173312. Actual: ' + (1023 << 18)); 
} 


if (2047 << 18 !== 536608768) { 
  throw new Test262Error('#588: 2047 << 18 === 536608768. Actual: ' + (2047 << 18)); 
} 


if (4095 << 18 !== 1073479680) { 
  throw new Test262Error('#589: 4095 << 18 === 1073479680. Actual: ' + (4095 << 18)); 
} 


if (8191 << 18 !== 2147221504) { 
  throw new Test262Error('#590: 8191 << 18 === 2147221504. Actual: ' + (8191 << 18)); 
} 


if (16383 << 18 !== -262144) { 
  throw new Test262Error('#591: 16383 << 18 === -262144. Actual: ' + (16383 << 18)); 
} 


if (32767 << 18 !== -262144) { 
  throw new Test262Error('#592: 32767 << 18 === -262144. Actual: ' + (32767 << 18)); 
} 


if (65535 << 18 !== -262144) { 
  throw new Test262Error('#593: 65535 << 18 === -262144. Actual: ' + (65535 << 18)); 
} 


if (131071 << 18 !== -262144) { 
  throw new Test262Error('#594: 131071 << 18 === -262144. Actual: ' + (131071 << 18)); 
} 


if (262143 << 18 !== -262144) { 
  throw new Test262Error('#595: 262143 << 18 === -262144. Actual: ' + (262143 << 18)); 
} 


if (524287 << 18 !== -262144) { 
  throw new Test262Error('#596: 524287 << 18 === -262144. Actual: ' + (524287 << 18)); 
} 


if (1048575 << 18 !== -262144) { 
  throw new Test262Error('#597: 1048575 << 18 === -262144. Actual: ' + (1048575 << 18)); 
} 


if (2097151 << 18 !== -262144) { 
  throw new Test262Error('#598: 2097151 << 18 === -262144. Actual: ' + (2097151 << 18)); 
} 


if (4194303 << 18 !== -262144) { 
  throw new Test262Error('#599: 4194303 << 18 === -262144. Actual: ' + (4194303 << 18)); 
} 


if (8388607 << 18 !== -262144) { 
  throw new Test262Error('#600: 8388607 << 18 === -262144. Actual: ' + (8388607 << 18)); 
} 


if (16777215 << 18 !== -262144) { 
  throw new Test262Error('#601: 16777215 << 18 === -262144. Actual: ' + (16777215 << 18)); 
} 


if (33554431 << 18 !== -262144) { 
  throw new Test262Error('#602: 33554431 << 18 === -262144. Actual: ' + (33554431 << 18)); 
} 


if (67108863 << 18 !== -262144) { 
  throw new Test262Error('#603: 67108863 << 18 === -262144. Actual: ' + (67108863 << 18)); 
} 


if (134217727 << 18 !== -262144) { 
  throw new Test262Error('#604: 134217727 << 18 === -262144. Actual: ' + (134217727 << 18)); 
} 


if (268435455 << 18 !== -262144) { 
  throw new Test262Error('#605: 268435455 << 18 === -262144. Actual: ' + (268435455 << 18)); 
} 


if (536870911 << 18 !== -262144) { 
  throw new Test262Error('#606: 536870911 << 18 === -262144. Actual: ' + (536870911 << 18)); 
} 


if (1073741823 << 18 !== -262144) { 
  throw new Test262Error('#607: 1073741823 << 18 === -262144. Actual: ' + (1073741823 << 18)); 
} 


if (2147483647 << 18 !== -262144) { 
  throw new Test262Error('#608: 2147483647 << 18 === -262144. Actual: ' + (2147483647 << 18)); 
} 


if (0 << 19 !== 0) { 
  throw new Test262Error('#609: 0 << 19 === 0. Actual: ' + (0 << 19)); 
} 


if (1 << 19 !== 524288) { 
  throw new Test262Error('#610: 1 << 19 === 524288. Actual: ' + (1 << 19)); 
} 


if (3 << 19 !== 1572864) { 
  throw new Test262Error('#611: 3 << 19 === 1572864. Actual: ' + (3 << 19)); 
} 


if (7 << 19 !== 3670016) { 
  throw new Test262Error('#612: 7 << 19 === 3670016. Actual: ' + (7 << 19)); 
} 


if (15 << 19 !== 7864320) { 
  throw new Test262Error('#613: 15 << 19 === 7864320. Actual: ' + (15 << 19)); 
} 


if (31 << 19 !== 16252928) { 
  throw new Test262Error('#614: 31 << 19 === 16252928. Actual: ' + (31 << 19)); 
} 


if (63 << 19 !== 33030144) { 
  throw new Test262Error('#615: 63 << 19 === 33030144. Actual: ' + (63 << 19)); 
} 


if (127 << 19 !== 66584576) { 
  throw new Test262Error('#616: 127 << 19 === 66584576. Actual: ' + (127 << 19)); 
} 


if (255 << 19 !== 133693440) { 
  throw new Test262Error('#617: 255 << 19 === 133693440. Actual: ' + (255 << 19)); 
} 


if (511 << 19 !== 267911168) { 
  throw new Test262Error('#618: 511 << 19 === 267911168. Actual: ' + (511 << 19)); 
} 


if (1023 << 19 !== 536346624) { 
  throw new Test262Error('#619: 1023 << 19 === 536346624. Actual: ' + (1023 << 19)); 
} 


if (2047 << 19 !== 1073217536) { 
  throw new Test262Error('#620: 2047 << 19 === 1073217536. Actual: ' + (2047 << 19)); 
} 


if (4095 << 19 !== 2146959360) { 
  throw new Test262Error('#621: 4095 << 19 === 2146959360. Actual: ' + (4095 << 19)); 
} 


if (8191 << 19 !== -524288) { 
  throw new Test262Error('#622: 8191 << 19 === -524288. Actual: ' + (8191 << 19)); 
} 


if (16383 << 19 !== -524288) { 
  throw new Test262Error('#623: 16383 << 19 === -524288. Actual: ' + (16383 << 19)); 
} 


if (32767 << 19 !== -524288) { 
  throw new Test262Error('#624: 32767 << 19 === -524288. Actual: ' + (32767 << 19)); 
} 


if (65535 << 19 !== -524288) { 
  throw new Test262Error('#625: 65535 << 19 === -524288. Actual: ' + (65535 << 19)); 
} 


if (131071 << 19 !== -524288) { 
  throw new Test262Error('#626: 131071 << 19 === -524288. Actual: ' + (131071 << 19)); 
} 


if (262143 << 19 !== -524288) { 
  throw new Test262Error('#627: 262143 << 19 === -524288. Actual: ' + (262143 << 19)); 
} 


if (524287 << 19 !== -524288) { 
  throw new Test262Error('#628: 524287 << 19 === -524288. Actual: ' + (524287 << 19)); 
} 


if (1048575 << 19 !== -524288) { 
  throw new Test262Error('#629: 1048575 << 19 === -524288. Actual: ' + (1048575 << 19)); 
} 


if (2097151 << 19 !== -524288) { 
  throw new Test262Error('#630: 2097151 << 19 === -524288. Actual: ' + (2097151 << 19)); 
} 


if (4194303 << 19 !== -524288) { 
  throw new Test262Error('#631: 4194303 << 19 === -524288. Actual: ' + (4194303 << 19)); 
} 


if (8388607 << 19 !== -524288) { 
  throw new Test262Error('#632: 8388607 << 19 === -524288. Actual: ' + (8388607 << 19)); 
} 


if (16777215 << 19 !== -524288) { 
  throw new Test262Error('#633: 16777215 << 19 === -524288. Actual: ' + (16777215 << 19)); 
} 


if (33554431 << 19 !== -524288) { 
  throw new Test262Error('#634: 33554431 << 19 === -524288. Actual: ' + (33554431 << 19)); 
} 


if (67108863 << 19 !== -524288) { 
  throw new Test262Error('#635: 67108863 << 19 === -524288. Actual: ' + (67108863 << 19)); 
} 


if (134217727 << 19 !== -524288) { 
  throw new Test262Error('#636: 134217727 << 19 === -524288. Actual: ' + (134217727 << 19)); 
} 


if (268435455 << 19 !== -524288) { 
  throw new Test262Error('#637: 268435455 << 19 === -524288. Actual: ' + (268435455 << 19)); 
} 


if (536870911 << 19 !== -524288) { 
  throw new Test262Error('#638: 536870911 << 19 === -524288. Actual: ' + (536870911 << 19)); 
} 


if (1073741823 << 19 !== -524288) { 
  throw new Test262Error('#639: 1073741823 << 19 === -524288. Actual: ' + (1073741823 << 19)); 
} 


if (2147483647 << 19 !== -524288) { 
  throw new Test262Error('#640: 2147483647 << 19 === -524288. Actual: ' + (2147483647 << 19)); 
} 


if (0 << 20 !== 0) { 
  throw new Test262Error('#641: 0 << 20 === 0. Actual: ' + (0 << 20)); 
} 


if (1 << 20 !== 1048576) { 
  throw new Test262Error('#642: 1 << 20 === 1048576. Actual: ' + (1 << 20)); 
} 


if (3 << 20 !== 3145728) { 
  throw new Test262Error('#643: 3 << 20 === 3145728. Actual: ' + (3 << 20)); 
} 


if (7 << 20 !== 7340032) { 
  throw new Test262Error('#644: 7 << 20 === 7340032. Actual: ' + (7 << 20)); 
} 


if (15 << 20 !== 15728640) { 
  throw new Test262Error('#645: 15 << 20 === 15728640. Actual: ' + (15 << 20)); 
} 


if (31 << 20 !== 32505856) { 
  throw new Test262Error('#646: 31 << 20 === 32505856. Actual: ' + (31 << 20)); 
} 


if (63 << 20 !== 66060288) { 
  throw new Test262Error('#647: 63 << 20 === 66060288. Actual: ' + (63 << 20)); 
} 


if (127 << 20 !== 133169152) { 
  throw new Test262Error('#648: 127 << 20 === 133169152. Actual: ' + (127 << 20)); 
} 


if (255 << 20 !== 267386880) { 
  throw new Test262Error('#649: 255 << 20 === 267386880. Actual: ' + (255 << 20)); 
} 


if (511 << 20 !== 535822336) { 
  throw new Test262Error('#650: 511 << 20 === 535822336. Actual: ' + (511 << 20)); 
} 


if (1023 << 20 !== 1072693248) { 
  throw new Test262Error('#651: 1023 << 20 === 1072693248. Actual: ' + (1023 << 20)); 
} 


if (2047 << 20 !== 2146435072) { 
  throw new Test262Error('#652: 2047 << 20 === 2146435072. Actual: ' + (2047 << 20)); 
} 


if (4095 << 20 !== -1048576) { 
  throw new Test262Error('#653: 4095 << 20 === -1048576. Actual: ' + (4095 << 20)); 
} 


if (8191 << 20 !== -1048576) { 
  throw new Test262Error('#654: 8191 << 20 === -1048576. Actual: ' + (8191 << 20)); 
} 


if (16383 << 20 !== -1048576) { 
  throw new Test262Error('#655: 16383 << 20 === -1048576. Actual: ' + (16383 << 20)); 
} 


if (32767 << 20 !== -1048576) { 
  throw new Test262Error('#656: 32767 << 20 === -1048576. Actual: ' + (32767 << 20)); 
} 


if (65535 << 20 !== -1048576) { 
  throw new Test262Error('#657: 65535 << 20 === -1048576. Actual: ' + (65535 << 20)); 
} 


if (131071 << 20 !== -1048576) { 
  throw new Test262Error('#658: 131071 << 20 === -1048576. Actual: ' + (131071 << 20)); 
} 


if (262143 << 20 !== -1048576) { 
  throw new Test262Error('#659: 262143 << 20 === -1048576. Actual: ' + (262143 << 20)); 
} 


if (524287 << 20 !== -1048576) { 
  throw new Test262Error('#660: 524287 << 20 === -1048576. Actual: ' + (524287 << 20)); 
} 


if (1048575 << 20 !== -1048576) { 
  throw new Test262Error('#661: 1048575 << 20 === -1048576. Actual: ' + (1048575 << 20)); 
} 


if (2097151 << 20 !== -1048576) { 
  throw new Test262Error('#662: 2097151 << 20 === -1048576. Actual: ' + (2097151 << 20)); 
} 


if (4194303 << 20 !== -1048576) { 
  throw new Test262Error('#663: 4194303 << 20 === -1048576. Actual: ' + (4194303 << 20)); 
} 


if (8388607 << 20 !== -1048576) { 
  throw new Test262Error('#664: 8388607 << 20 === -1048576. Actual: ' + (8388607 << 20)); 
} 


if (16777215 << 20 !== -1048576) { 
  throw new Test262Error('#665: 16777215 << 20 === -1048576. Actual: ' + (16777215 << 20)); 
} 


if (33554431 << 20 !== -1048576) { 
  throw new Test262Error('#666: 33554431 << 20 === -1048576. Actual: ' + (33554431 << 20)); 
} 


if (67108863 << 20 !== -1048576) { 
  throw new Test262Error('#667: 67108863 << 20 === -1048576. Actual: ' + (67108863 << 20)); 
} 


if (134217727 << 20 !== -1048576) { 
  throw new Test262Error('#668: 134217727 << 20 === -1048576. Actual: ' + (134217727 << 20)); 
} 


if (268435455 << 20 !== -1048576) { 
  throw new Test262Error('#669: 268435455 << 20 === -1048576. Actual: ' + (268435455 << 20)); 
} 


if (536870911 << 20 !== -1048576) { 
  throw new Test262Error('#670: 536870911 << 20 === -1048576. Actual: ' + (536870911 << 20)); 
} 


if (1073741823 << 20 !== -1048576) { 
  throw new Test262Error('#671: 1073741823 << 20 === -1048576. Actual: ' + (1073741823 << 20)); 
} 


if (2147483647 << 20 !== -1048576) { 
  throw new Test262Error('#672: 2147483647 << 20 === -1048576. Actual: ' + (2147483647 << 20)); 
} 


if (0 << 21 !== 0) { 
  throw new Test262Error('#673: 0 << 21 === 0. Actual: ' + (0 << 21)); 
} 


if (1 << 21 !== 2097152) { 
  throw new Test262Error('#674: 1 << 21 === 2097152. Actual: ' + (1 << 21)); 
} 


if (3 << 21 !== 6291456) { 
  throw new Test262Error('#675: 3 << 21 === 6291456. Actual: ' + (3 << 21)); 
} 


if (7 << 21 !== 14680064) { 
  throw new Test262Error('#676: 7 << 21 === 14680064. Actual: ' + (7 << 21)); 
} 


if (15 << 21 !== 31457280) { 
  throw new Test262Error('#677: 15 << 21 === 31457280. Actual: ' + (15 << 21)); 
} 


if (31 << 21 !== 65011712) { 
  throw new Test262Error('#678: 31 << 21 === 65011712. Actual: ' + (31 << 21)); 
} 


if (63 << 21 !== 132120576) { 
  throw new Test262Error('#679: 63 << 21 === 132120576. Actual: ' + (63 << 21)); 
} 


if (127 << 21 !== 266338304) { 
  throw new Test262Error('#680: 127 << 21 === 266338304. Actual: ' + (127 << 21)); 
} 


if (255 << 21 !== 534773760) { 
  throw new Test262Error('#681: 255 << 21 === 534773760. Actual: ' + (255 << 21)); 
} 


if (511 << 21 !== 1071644672) { 
  throw new Test262Error('#682: 511 << 21 === 1071644672. Actual: ' + (511 << 21)); 
} 


if (1023 << 21 !== 2145386496) { 
  throw new Test262Error('#683: 1023 << 21 === 2145386496. Actual: ' + (1023 << 21)); 
} 


if (2047 << 21 !== -2097152) { 
  throw new Test262Error('#684: 2047 << 21 === -2097152. Actual: ' + (2047 << 21)); 
} 


if (4095 << 21 !== -2097152) { 
  throw new Test262Error('#685: 4095 << 21 === -2097152. Actual: ' + (4095 << 21)); 
} 


if (8191 << 21 !== -2097152) { 
  throw new Test262Error('#686: 8191 << 21 === -2097152. Actual: ' + (8191 << 21)); 
} 


if (16383 << 21 !== -2097152) { 
  throw new Test262Error('#687: 16383 << 21 === -2097152. Actual: ' + (16383 << 21)); 
} 


if (32767 << 21 !== -2097152) { 
  throw new Test262Error('#688: 32767 << 21 === -2097152. Actual: ' + (32767 << 21)); 
} 


if (65535 << 21 !== -2097152) { 
  throw new Test262Error('#689: 65535 << 21 === -2097152. Actual: ' + (65535 << 21)); 
} 


if (131071 << 21 !== -2097152) { 
  throw new Test262Error('#690: 131071 << 21 === -2097152. Actual: ' + (131071 << 21)); 
} 


if (262143 << 21 !== -2097152) { 
  throw new Test262Error('#691: 262143 << 21 === -2097152. Actual: ' + (262143 << 21)); 
} 


if (524287 << 21 !== -2097152) { 
  throw new Test262Error('#692: 524287 << 21 === -2097152. Actual: ' + (524287 << 21)); 
} 


if (1048575 << 21 !== -2097152) { 
  throw new Test262Error('#693: 1048575 << 21 === -2097152. Actual: ' + (1048575 << 21)); 
} 


if (2097151 << 21 !== -2097152) { 
  throw new Test262Error('#694: 2097151 << 21 === -2097152. Actual: ' + (2097151 << 21)); 
} 


if (4194303 << 21 !== -2097152) { 
  throw new Test262Error('#695: 4194303 << 21 === -2097152. Actual: ' + (4194303 << 21)); 
} 


if (8388607 << 21 !== -2097152) { 
  throw new Test262Error('#696: 8388607 << 21 === -2097152. Actual: ' + (8388607 << 21)); 
} 


if (16777215 << 21 !== -2097152) { 
  throw new Test262Error('#697: 16777215 << 21 === -2097152. Actual: ' + (16777215 << 21)); 
} 


if (33554431 << 21 !== -2097152) { 
  throw new Test262Error('#698: 33554431 << 21 === -2097152. Actual: ' + (33554431 << 21)); 
} 


if (67108863 << 21 !== -2097152) { 
  throw new Test262Error('#699: 67108863 << 21 === -2097152. Actual: ' + (67108863 << 21)); 
} 


if (134217727 << 21 !== -2097152) { 
  throw new Test262Error('#700: 134217727 << 21 === -2097152. Actual: ' + (134217727 << 21)); 
} 


if (268435455 << 21 !== -2097152) { 
  throw new Test262Error('#701: 268435455 << 21 === -2097152. Actual: ' + (268435455 << 21)); 
} 


if (536870911 << 21 !== -2097152) { 
  throw new Test262Error('#702: 536870911 << 21 === -2097152. Actual: ' + (536870911 << 21)); 
} 


if (1073741823 << 21 !== -2097152) { 
  throw new Test262Error('#703: 1073741823 << 21 === -2097152. Actual: ' + (1073741823 << 21)); 
} 


if (2147483647 << 21 !== -2097152) { 
  throw new Test262Error('#704: 2147483647 << 21 === -2097152. Actual: ' + (2147483647 << 21)); 
} 


if (0 << 22 !== 0) { 
  throw new Test262Error('#705: 0 << 22 === 0. Actual: ' + (0 << 22)); 
} 


if (1 << 22 !== 4194304) { 
  throw new Test262Error('#706: 1 << 22 === 4194304. Actual: ' + (1 << 22)); 
} 


if (3 << 22 !== 12582912) { 
  throw new Test262Error('#707: 3 << 22 === 12582912. Actual: ' + (3 << 22)); 
} 


if (7 << 22 !== 29360128) { 
  throw new Test262Error('#708: 7 << 22 === 29360128. Actual: ' + (7 << 22)); 
} 


if (15 << 22 !== 62914560) { 
  throw new Test262Error('#709: 15 << 22 === 62914560. Actual: ' + (15 << 22)); 
} 


if (31 << 22 !== 130023424) { 
  throw new Test262Error('#710: 31 << 22 === 130023424. Actual: ' + (31 << 22)); 
} 


if (63 << 22 !== 264241152) { 
  throw new Test262Error('#711: 63 << 22 === 264241152. Actual: ' + (63 << 22)); 
} 


if (127 << 22 !== 532676608) { 
  throw new Test262Error('#712: 127 << 22 === 532676608. Actual: ' + (127 << 22)); 
} 


if (255 << 22 !== 1069547520) { 
  throw new Test262Error('#713: 255 << 22 === 1069547520. Actual: ' + (255 << 22)); 
} 


if (511 << 22 !== 2143289344) { 
  throw new Test262Error('#714: 511 << 22 === 2143289344. Actual: ' + (511 << 22)); 
} 


if (1023 << 22 !== -4194304) { 
  throw new Test262Error('#715: 1023 << 22 === -4194304. Actual: ' + (1023 << 22)); 
} 


if (2047 << 22 !== -4194304) { 
  throw new Test262Error('#716: 2047 << 22 === -4194304. Actual: ' + (2047 << 22)); 
} 


if (4095 << 22 !== -4194304) { 
  throw new Test262Error('#717: 4095 << 22 === -4194304. Actual: ' + (4095 << 22)); 
} 


if (8191 << 22 !== -4194304) { 
  throw new Test262Error('#718: 8191 << 22 === -4194304. Actual: ' + (8191 << 22)); 
} 


if (16383 << 22 !== -4194304) { 
  throw new Test262Error('#719: 16383 << 22 === -4194304. Actual: ' + (16383 << 22)); 
} 


if (32767 << 22 !== -4194304) { 
  throw new Test262Error('#720: 32767 << 22 === -4194304. Actual: ' + (32767 << 22)); 
} 


if (65535 << 22 !== -4194304) { 
  throw new Test262Error('#721: 65535 << 22 === -4194304. Actual: ' + (65535 << 22)); 
} 


if (131071 << 22 !== -4194304) { 
  throw new Test262Error('#722: 131071 << 22 === -4194304. Actual: ' + (131071 << 22)); 
} 


if (262143 << 22 !== -4194304) { 
  throw new Test262Error('#723: 262143 << 22 === -4194304. Actual: ' + (262143 << 22)); 
} 


if (524287 << 22 !== -4194304) { 
  throw new Test262Error('#724: 524287 << 22 === -4194304. Actual: ' + (524287 << 22)); 
} 


if (1048575 << 22 !== -4194304) { 
  throw new Test262Error('#725: 1048575 << 22 === -4194304. Actual: ' + (1048575 << 22)); 
} 


if (2097151 << 22 !== -4194304) { 
  throw new Test262Error('#726: 2097151 << 22 === -4194304. Actual: ' + (2097151 << 22)); 
} 


if (4194303 << 22 !== -4194304) { 
  throw new Test262Error('#727: 4194303 << 22 === -4194304. Actual: ' + (4194303 << 22)); 
} 


if (8388607 << 22 !== -4194304) { 
  throw new Test262Error('#728: 8388607 << 22 === -4194304. Actual: ' + (8388607 << 22)); 
} 


if (16777215 << 22 !== -4194304) { 
  throw new Test262Error('#729: 16777215 << 22 === -4194304. Actual: ' + (16777215 << 22)); 
} 


if (33554431 << 22 !== -4194304) { 
  throw new Test262Error('#730: 33554431 << 22 === -4194304. Actual: ' + (33554431 << 22)); 
} 


if (67108863 << 22 !== -4194304) { 
  throw new Test262Error('#731: 67108863 << 22 === -4194304. Actual: ' + (67108863 << 22)); 
} 


if (134217727 << 22 !== -4194304) { 
  throw new Test262Error('#732: 134217727 << 22 === -4194304. Actual: ' + (134217727 << 22)); 
} 


if (268435455 << 22 !== -4194304) { 
  throw new Test262Error('#733: 268435455 << 22 === -4194304. Actual: ' + (268435455 << 22)); 
} 


if (536870911 << 22 !== -4194304) { 
  throw new Test262Error('#734: 536870911 << 22 === -4194304. Actual: ' + (536870911 << 22)); 
} 


if (1073741823 << 22 !== -4194304) { 
  throw new Test262Error('#735: 1073741823 << 22 === -4194304. Actual: ' + (1073741823 << 22)); 
} 


if (2147483647 << 22 !== -4194304) { 
  throw new Test262Error('#736: 2147483647 << 22 === -4194304. Actual: ' + (2147483647 << 22)); 
} 


if (0 << 23 !== 0) { 
  throw new Test262Error('#737: 0 << 23 === 0. Actual: ' + (0 << 23)); 
} 


if (1 << 23 !== 8388608) { 
  throw new Test262Error('#738: 1 << 23 === 8388608. Actual: ' + (1 << 23)); 
} 


if (3 << 23 !== 25165824) { 
  throw new Test262Error('#739: 3 << 23 === 25165824. Actual: ' + (3 << 23)); 
} 


if (7 << 23 !== 58720256) { 
  throw new Test262Error('#740: 7 << 23 === 58720256. Actual: ' + (7 << 23)); 
} 


if (15 << 23 !== 125829120) { 
  throw new Test262Error('#741: 15 << 23 === 125829120. Actual: ' + (15 << 23)); 
} 


if (31 << 23 !== 260046848) { 
  throw new Test262Error('#742: 31 << 23 === 260046848. Actual: ' + (31 << 23)); 
} 


if (63 << 23 !== 528482304) { 
  throw new Test262Error('#743: 63 << 23 === 528482304. Actual: ' + (63 << 23)); 
} 


if (127 << 23 !== 1065353216) { 
  throw new Test262Error('#744: 127 << 23 === 1065353216. Actual: ' + (127 << 23)); 
} 


if (255 << 23 !== 2139095040) { 
  throw new Test262Error('#745: 255 << 23 === 2139095040. Actual: ' + (255 << 23)); 
} 


if (511 << 23 !== -8388608) { 
  throw new Test262Error('#746: 511 << 23 === -8388608. Actual: ' + (511 << 23)); 
} 


if (1023 << 23 !== -8388608) { 
  throw new Test262Error('#747: 1023 << 23 === -8388608. Actual: ' + (1023 << 23)); 
} 


if (2047 << 23 !== -8388608) { 
  throw new Test262Error('#748: 2047 << 23 === -8388608. Actual: ' + (2047 << 23)); 
} 


if (4095 << 23 !== -8388608) { 
  throw new Test262Error('#749: 4095 << 23 === -8388608. Actual: ' + (4095 << 23)); 
} 


if (8191 << 23 !== -8388608) { 
  throw new Test262Error('#750: 8191 << 23 === -8388608. Actual: ' + (8191 << 23)); 
} 


if (16383 << 23 !== -8388608) { 
  throw new Test262Error('#751: 16383 << 23 === -8388608. Actual: ' + (16383 << 23)); 
} 


if (32767 << 23 !== -8388608) { 
  throw new Test262Error('#752: 32767 << 23 === -8388608. Actual: ' + (32767 << 23)); 
} 


if (65535 << 23 !== -8388608) { 
  throw new Test262Error('#753: 65535 << 23 === -8388608. Actual: ' + (65535 << 23)); 
} 


if (131071 << 23 !== -8388608) { 
  throw new Test262Error('#754: 131071 << 23 === -8388608. Actual: ' + (131071 << 23)); 
} 


if (262143 << 23 !== -8388608) { 
  throw new Test262Error('#755: 262143 << 23 === -8388608. Actual: ' + (262143 << 23)); 
} 


if (524287 << 23 !== -8388608) { 
  throw new Test262Error('#756: 524287 << 23 === -8388608. Actual: ' + (524287 << 23)); 
} 


if (1048575 << 23 !== -8388608) { 
  throw new Test262Error('#757: 1048575 << 23 === -8388608. Actual: ' + (1048575 << 23)); 
} 


if (2097151 << 23 !== -8388608) { 
  throw new Test262Error('#758: 2097151 << 23 === -8388608. Actual: ' + (2097151 << 23)); 
} 


if (4194303 << 23 !== -8388608) { 
  throw new Test262Error('#759: 4194303 << 23 === -8388608. Actual: ' + (4194303 << 23)); 
} 


if (8388607 << 23 !== -8388608) { 
  throw new Test262Error('#760: 8388607 << 23 === -8388608. Actual: ' + (8388607 << 23)); 
} 


if (16777215 << 23 !== -8388608) { 
  throw new Test262Error('#761: 16777215 << 23 === -8388608. Actual: ' + (16777215 << 23)); 
} 


if (33554431 << 23 !== -8388608) { 
  throw new Test262Error('#762: 33554431 << 23 === -8388608. Actual: ' + (33554431 << 23)); 
} 


if (67108863 << 23 !== -8388608) { 
  throw new Test262Error('#763: 67108863 << 23 === -8388608. Actual: ' + (67108863 << 23)); 
} 


if (134217727 << 23 !== -8388608) { 
  throw new Test262Error('#764: 134217727 << 23 === -8388608. Actual: ' + (134217727 << 23)); 
} 


if (268435455 << 23 !== -8388608) { 
  throw new Test262Error('#765: 268435455 << 23 === -8388608. Actual: ' + (268435455 << 23)); 
} 


if (536870911 << 23 !== -8388608) { 
  throw new Test262Error('#766: 536870911 << 23 === -8388608. Actual: ' + (536870911 << 23)); 
} 


if (1073741823 << 23 !== -8388608) { 
  throw new Test262Error('#767: 1073741823 << 23 === -8388608. Actual: ' + (1073741823 << 23)); 
} 


if (2147483647 << 23 !== -8388608) { 
  throw new Test262Error('#768: 2147483647 << 23 === -8388608. Actual: ' + (2147483647 << 23)); 
} 


if (0 << 24 !== 0) { 
  throw new Test262Error('#769: 0 << 24 === 0. Actual: ' + (0 << 24)); 
} 


if (1 << 24 !== 16777216) { 
  throw new Test262Error('#770: 1 << 24 === 16777216. Actual: ' + (1 << 24)); 
} 


if (3 << 24 !== 50331648) { 
  throw new Test262Error('#771: 3 << 24 === 50331648. Actual: ' + (3 << 24)); 
} 


if (7 << 24 !== 117440512) { 
  throw new Test262Error('#772: 7 << 24 === 117440512. Actual: ' + (7 << 24)); 
} 


if (15 << 24 !== 251658240) { 
  throw new Test262Error('#773: 15 << 24 === 251658240. Actual: ' + (15 << 24)); 
} 


if (31 << 24 !== 520093696) { 
  throw new Test262Error('#774: 31 << 24 === 520093696. Actual: ' + (31 << 24)); 
} 


if (63 << 24 !== 1056964608) { 
  throw new Test262Error('#775: 63 << 24 === 1056964608. Actual: ' + (63 << 24)); 
} 


if (127 << 24 !== 2130706432) { 
  throw new Test262Error('#776: 127 << 24 === 2130706432. Actual: ' + (127 << 24)); 
} 


if (255 << 24 !== -16777216) { 
  throw new Test262Error('#777: 255 << 24 === -16777216. Actual: ' + (255 << 24)); 
} 


if (511 << 24 !== -16777216) { 
  throw new Test262Error('#778: 511 << 24 === -16777216. Actual: ' + (511 << 24)); 
} 


if (1023 << 24 !== -16777216) { 
  throw new Test262Error('#779: 1023 << 24 === -16777216. Actual: ' + (1023 << 24)); 
} 


if (2047 << 24 !== -16777216) { 
  throw new Test262Error('#780: 2047 << 24 === -16777216. Actual: ' + (2047 << 24)); 
} 


if (4095 << 24 !== -16777216) { 
  throw new Test262Error('#781: 4095 << 24 === -16777216. Actual: ' + (4095 << 24)); 
} 


if (8191 << 24 !== -16777216) { 
  throw new Test262Error('#782: 8191 << 24 === -16777216. Actual: ' + (8191 << 24)); 
} 


if (16383 << 24 !== -16777216) { 
  throw new Test262Error('#783: 16383 << 24 === -16777216. Actual: ' + (16383 << 24)); 
} 


if (32767 << 24 !== -16777216) { 
  throw new Test262Error('#784: 32767 << 24 === -16777216. Actual: ' + (32767 << 24)); 
} 


if (65535 << 24 !== -16777216) { 
  throw new Test262Error('#785: 65535 << 24 === -16777216. Actual: ' + (65535 << 24)); 
} 


if (131071 << 24 !== -16777216) { 
  throw new Test262Error('#786: 131071 << 24 === -16777216. Actual: ' + (131071 << 24)); 
} 


if (262143 << 24 !== -16777216) { 
  throw new Test262Error('#787: 262143 << 24 === -16777216. Actual: ' + (262143 << 24)); 
} 


if (524287 << 24 !== -16777216) { 
  throw new Test262Error('#788: 524287 << 24 === -16777216. Actual: ' + (524287 << 24)); 
} 


if (1048575 << 24 !== -16777216) { 
  throw new Test262Error('#789: 1048575 << 24 === -16777216. Actual: ' + (1048575 << 24)); 
} 


if (2097151 << 24 !== -16777216) { 
  throw new Test262Error('#790: 2097151 << 24 === -16777216. Actual: ' + (2097151 << 24)); 
} 


if (4194303 << 24 !== -16777216) { 
  throw new Test262Error('#791: 4194303 << 24 === -16777216. Actual: ' + (4194303 << 24)); 
} 


if (8388607 << 24 !== -16777216) { 
  throw new Test262Error('#792: 8388607 << 24 === -16777216. Actual: ' + (8388607 << 24)); 
} 


if (16777215 << 24 !== -16777216) { 
  throw new Test262Error('#793: 16777215 << 24 === -16777216. Actual: ' + (16777215 << 24)); 
} 


if (33554431 << 24 !== -16777216) { 
  throw new Test262Error('#794: 33554431 << 24 === -16777216. Actual: ' + (33554431 << 24)); 
} 


if (67108863 << 24 !== -16777216) { 
  throw new Test262Error('#795: 67108863 << 24 === -16777216. Actual: ' + (67108863 << 24)); 
} 


if (134217727 << 24 !== -16777216) { 
  throw new Test262Error('#796: 134217727 << 24 === -16777216. Actual: ' + (134217727 << 24)); 
} 


if (268435455 << 24 !== -16777216) { 
  throw new Test262Error('#797: 268435455 << 24 === -16777216. Actual: ' + (268435455 << 24)); 
} 


if (536870911 << 24 !== -16777216) { 
  throw new Test262Error('#798: 536870911 << 24 === -16777216. Actual: ' + (536870911 << 24)); 
} 


if (1073741823 << 24 !== -16777216) { 
  throw new Test262Error('#799: 1073741823 << 24 === -16777216. Actual: ' + (1073741823 << 24)); 
} 


if (2147483647 << 24 !== -16777216) { 
  throw new Test262Error('#800: 2147483647 << 24 === -16777216. Actual: ' + (2147483647 << 24)); 
} 


if (0 << 25 !== 0) { 
  throw new Test262Error('#801: 0 << 25 === 0. Actual: ' + (0 << 25)); 
} 


if (1 << 25 !== 33554432) { 
  throw new Test262Error('#802: 1 << 25 === 33554432. Actual: ' + (1 << 25)); 
} 


if (3 << 25 !== 100663296) { 
  throw new Test262Error('#803: 3 << 25 === 100663296. Actual: ' + (3 << 25)); 
} 


if (7 << 25 !== 234881024) { 
  throw new Test262Error('#804: 7 << 25 === 234881024. Actual: ' + (7 << 25)); 
} 


if (15 << 25 !== 503316480) { 
  throw new Test262Error('#805: 15 << 25 === 503316480. Actual: ' + (15 << 25)); 
} 


if (31 << 25 !== 1040187392) { 
  throw new Test262Error('#806: 31 << 25 === 1040187392. Actual: ' + (31 << 25)); 
} 


if (63 << 25 !== 2113929216) { 
  throw new Test262Error('#807: 63 << 25 === 2113929216. Actual: ' + (63 << 25)); 
} 


if (127 << 25 !== -33554432) { 
  throw new Test262Error('#808: 127 << 25 === -33554432. Actual: ' + (127 << 25)); 
} 


if (255 << 25 !== -33554432) { 
  throw new Test262Error('#809: 255 << 25 === -33554432. Actual: ' + (255 << 25)); 
} 


if (511 << 25 !== -33554432) { 
  throw new Test262Error('#810: 511 << 25 === -33554432. Actual: ' + (511 << 25)); 
} 


if (1023 << 25 !== -33554432) { 
  throw new Test262Error('#811: 1023 << 25 === -33554432. Actual: ' + (1023 << 25)); 
} 


if (2047 << 25 !== -33554432) { 
  throw new Test262Error('#812: 2047 << 25 === -33554432. Actual: ' + (2047 << 25)); 
} 


if (4095 << 25 !== -33554432) { 
  throw new Test262Error('#813: 4095 << 25 === -33554432. Actual: ' + (4095 << 25)); 
} 


if (8191 << 25 !== -33554432) { 
  throw new Test262Error('#814: 8191 << 25 === -33554432. Actual: ' + (8191 << 25)); 
} 


if (16383 << 25 !== -33554432) { 
  throw new Test262Error('#815: 16383 << 25 === -33554432. Actual: ' + (16383 << 25)); 
} 


if (32767 << 25 !== -33554432) { 
  throw new Test262Error('#816: 32767 << 25 === -33554432. Actual: ' + (32767 << 25)); 
} 


if (65535 << 25 !== -33554432) { 
  throw new Test262Error('#817: 65535 << 25 === -33554432. Actual: ' + (65535 << 25)); 
} 


if (131071 << 25 !== -33554432) { 
  throw new Test262Error('#818: 131071 << 25 === -33554432. Actual: ' + (131071 << 25)); 
} 


if (262143 << 25 !== -33554432) { 
  throw new Test262Error('#819: 262143 << 25 === -33554432. Actual: ' + (262143 << 25)); 
} 


if (524287 << 25 !== -33554432) { 
  throw new Test262Error('#820: 524287 << 25 === -33554432. Actual: ' + (524287 << 25)); 
} 


if (1048575 << 25 !== -33554432) { 
  throw new Test262Error('#821: 1048575 << 25 === -33554432. Actual: ' + (1048575 << 25)); 
} 


if (2097151 << 25 !== -33554432) { 
  throw new Test262Error('#822: 2097151 << 25 === -33554432. Actual: ' + (2097151 << 25)); 
} 


if (4194303 << 25 !== -33554432) { 
  throw new Test262Error('#823: 4194303 << 25 === -33554432. Actual: ' + (4194303 << 25)); 
} 


if (8388607 << 25 !== -33554432) { 
  throw new Test262Error('#824: 8388607 << 25 === -33554432. Actual: ' + (8388607 << 25)); 
} 


if (16777215 << 25 !== -33554432) { 
  throw new Test262Error('#825: 16777215 << 25 === -33554432. Actual: ' + (16777215 << 25)); 
} 


if (33554431 << 25 !== -33554432) { 
  throw new Test262Error('#826: 33554431 << 25 === -33554432. Actual: ' + (33554431 << 25)); 
} 


if (67108863 << 25 !== -33554432) { 
  throw new Test262Error('#827: 67108863 << 25 === -33554432. Actual: ' + (67108863 << 25)); 
} 


if (134217727 << 25 !== -33554432) { 
  throw new Test262Error('#828: 134217727 << 25 === -33554432. Actual: ' + (134217727 << 25)); 
} 


if (268435455 << 25 !== -33554432) { 
  throw new Test262Error('#829: 268435455 << 25 === -33554432. Actual: ' + (268435455 << 25)); 
} 


if (536870911 << 25 !== -33554432) { 
  throw new Test262Error('#830: 536870911 << 25 === -33554432. Actual: ' + (536870911 << 25)); 
} 


if (1073741823 << 25 !== -33554432) { 
  throw new Test262Error('#831: 1073741823 << 25 === -33554432. Actual: ' + (1073741823 << 25)); 
} 


if (2147483647 << 25 !== -33554432) { 
  throw new Test262Error('#832: 2147483647 << 25 === -33554432. Actual: ' + (2147483647 << 25)); 
} 


if (0 << 26 !== 0) { 
  throw new Test262Error('#833: 0 << 26 === 0. Actual: ' + (0 << 26)); 
} 


if (1 << 26 !== 67108864) { 
  throw new Test262Error('#834: 1 << 26 === 67108864. Actual: ' + (1 << 26)); 
} 


if (3 << 26 !== 201326592) { 
  throw new Test262Error('#835: 3 << 26 === 201326592. Actual: ' + (3 << 26)); 
} 


if (7 << 26 !== 469762048) { 
  throw new Test262Error('#836: 7 << 26 === 469762048. Actual: ' + (7 << 26)); 
} 


if (15 << 26 !== 1006632960) { 
  throw new Test262Error('#837: 15 << 26 === 1006632960. Actual: ' + (15 << 26)); 
} 


if (31 << 26 !== 2080374784) { 
  throw new Test262Error('#838: 31 << 26 === 2080374784. Actual: ' + (31 << 26)); 
} 


if (63 << 26 !== -67108864) { 
  throw new Test262Error('#839: 63 << 26 === -67108864. Actual: ' + (63 << 26)); 
} 


if (127 << 26 !== -67108864) { 
  throw new Test262Error('#840: 127 << 26 === -67108864. Actual: ' + (127 << 26)); 
} 


if (255 << 26 !== -67108864) { 
  throw new Test262Error('#841: 255 << 26 === -67108864. Actual: ' + (255 << 26)); 
} 


if (511 << 26 !== -67108864) { 
  throw new Test262Error('#842: 511 << 26 === -67108864. Actual: ' + (511 << 26)); 
} 


if (1023 << 26 !== -67108864) { 
  throw new Test262Error('#843: 1023 << 26 === -67108864. Actual: ' + (1023 << 26)); 
} 


if (2047 << 26 !== -67108864) { 
  throw new Test262Error('#844: 2047 << 26 === -67108864. Actual: ' + (2047 << 26)); 
} 


if (4095 << 26 !== -67108864) { 
  throw new Test262Error('#845: 4095 << 26 === -67108864. Actual: ' + (4095 << 26)); 
} 


if (8191 << 26 !== -67108864) { 
  throw new Test262Error('#846: 8191 << 26 === -67108864. Actual: ' + (8191 << 26)); 
} 


if (16383 << 26 !== -67108864) { 
  throw new Test262Error('#847: 16383 << 26 === -67108864. Actual: ' + (16383 << 26)); 
} 


if (32767 << 26 !== -67108864) { 
  throw new Test262Error('#848: 32767 << 26 === -67108864. Actual: ' + (32767 << 26)); 
} 


if (65535 << 26 !== -67108864) { 
  throw new Test262Error('#849: 65535 << 26 === -67108864. Actual: ' + (65535 << 26)); 
} 


if (131071 << 26 !== -67108864) { 
  throw new Test262Error('#850: 131071 << 26 === -67108864. Actual: ' + (131071 << 26)); 
} 


if (262143 << 26 !== -67108864) { 
  throw new Test262Error('#851: 262143 << 26 === -67108864. Actual: ' + (262143 << 26)); 
} 


if (524287 << 26 !== -67108864) { 
  throw new Test262Error('#852: 524287 << 26 === -67108864. Actual: ' + (524287 << 26)); 
} 


if (1048575 << 26 !== -67108864) { 
  throw new Test262Error('#853: 1048575 << 26 === -67108864. Actual: ' + (1048575 << 26)); 
} 


if (2097151 << 26 !== -67108864) { 
  throw new Test262Error('#854: 2097151 << 26 === -67108864. Actual: ' + (2097151 << 26)); 
} 


if (4194303 << 26 !== -67108864) { 
  throw new Test262Error('#855: 4194303 << 26 === -67108864. Actual: ' + (4194303 << 26)); 
} 


if (8388607 << 26 !== -67108864) { 
  throw new Test262Error('#856: 8388607 << 26 === -67108864. Actual: ' + (8388607 << 26)); 
} 


if (16777215 << 26 !== -67108864) { 
  throw new Test262Error('#857: 16777215 << 26 === -67108864. Actual: ' + (16777215 << 26)); 
} 


if (33554431 << 26 !== -67108864) { 
  throw new Test262Error('#858: 33554431 << 26 === -67108864. Actual: ' + (33554431 << 26)); 
} 


if (67108863 << 26 !== -67108864) { 
  throw new Test262Error('#859: 67108863 << 26 === -67108864. Actual: ' + (67108863 << 26)); 
} 


if (134217727 << 26 !== -67108864) { 
  throw new Test262Error('#860: 134217727 << 26 === -67108864. Actual: ' + (134217727 << 26)); 
} 


if (268435455 << 26 !== -67108864) { 
  throw new Test262Error('#861: 268435455 << 26 === -67108864. Actual: ' + (268435455 << 26)); 
} 


if (536870911 << 26 !== -67108864) { 
  throw new Test262Error('#862: 536870911 << 26 === -67108864. Actual: ' + (536870911 << 26)); 
} 


if (1073741823 << 26 !== -67108864) { 
  throw new Test262Error('#863: 1073741823 << 26 === -67108864. Actual: ' + (1073741823 << 26)); 
} 


if (2147483647 << 26 !== -67108864) { 
  throw new Test262Error('#864: 2147483647 << 26 === -67108864. Actual: ' + (2147483647 << 26)); 
} 


if (0 << 27 !== 0) { 
  throw new Test262Error('#865: 0 << 27 === 0. Actual: ' + (0 << 27)); 
} 


if (1 << 27 !== 134217728) { 
  throw new Test262Error('#866: 1 << 27 === 134217728. Actual: ' + (1 << 27)); 
} 


if (3 << 27 !== 402653184) { 
  throw new Test262Error('#867: 3 << 27 === 402653184. Actual: ' + (3 << 27)); 
} 


if (7 << 27 !== 939524096) { 
  throw new Test262Error('#868: 7 << 27 === 939524096. Actual: ' + (7 << 27)); 
} 


if (15 << 27 !== 2013265920) { 
  throw new Test262Error('#869: 15 << 27 === 2013265920. Actual: ' + (15 << 27)); 
} 


if (31 << 27 !== -134217728) { 
  throw new Test262Error('#870: 31 << 27 === -134217728. Actual: ' + (31 << 27)); 
} 


if (63 << 27 !== -134217728) { 
  throw new Test262Error('#871: 63 << 27 === -134217728. Actual: ' + (63 << 27)); 
} 


if (127 << 27 !== -134217728) { 
  throw new Test262Error('#872: 127 << 27 === -134217728. Actual: ' + (127 << 27)); 
} 


if (255 << 27 !== -134217728) { 
  throw new Test262Error('#873: 255 << 27 === -134217728. Actual: ' + (255 << 27)); 
} 


if (511 << 27 !== -134217728) { 
  throw new Test262Error('#874: 511 << 27 === -134217728. Actual: ' + (511 << 27)); 
} 


if (1023 << 27 !== -134217728) { 
  throw new Test262Error('#875: 1023 << 27 === -134217728. Actual: ' + (1023 << 27)); 
} 


if (2047 << 27 !== -134217728) { 
  throw new Test262Error('#876: 2047 << 27 === -134217728. Actual: ' + (2047 << 27)); 
} 


if (4095 << 27 !== -134217728) { 
  throw new Test262Error('#877: 4095 << 27 === -134217728. Actual: ' + (4095 << 27)); 
} 


if (8191 << 27 !== -134217728) { 
  throw new Test262Error('#878: 8191 << 27 === -134217728. Actual: ' + (8191 << 27)); 
} 


if (16383 << 27 !== -134217728) { 
  throw new Test262Error('#879: 16383 << 27 === -134217728. Actual: ' + (16383 << 27)); 
} 


if (32767 << 27 !== -134217728) { 
  throw new Test262Error('#880: 32767 << 27 === -134217728. Actual: ' + (32767 << 27)); 
} 


if (65535 << 27 !== -134217728) { 
  throw new Test262Error('#881: 65535 << 27 === -134217728. Actual: ' + (65535 << 27)); 
} 


if (131071 << 27 !== -134217728) { 
  throw new Test262Error('#882: 131071 << 27 === -134217728. Actual: ' + (131071 << 27)); 
} 


if (262143 << 27 !== -134217728) { 
  throw new Test262Error('#883: 262143 << 27 === -134217728. Actual: ' + (262143 << 27)); 
} 


if (524287 << 27 !== -134217728) { 
  throw new Test262Error('#884: 524287 << 27 === -134217728. Actual: ' + (524287 << 27)); 
} 


if (1048575 << 27 !== -134217728) { 
  throw new Test262Error('#885: 1048575 << 27 === -134217728. Actual: ' + (1048575 << 27)); 
} 


if (2097151 << 27 !== -134217728) { 
  throw new Test262Error('#886: 2097151 << 27 === -134217728. Actual: ' + (2097151 << 27)); 
} 


if (4194303 << 27 !== -134217728) { 
  throw new Test262Error('#887: 4194303 << 27 === -134217728. Actual: ' + (4194303 << 27)); 
} 


if (8388607 << 27 !== -134217728) { 
  throw new Test262Error('#888: 8388607 << 27 === -134217728. Actual: ' + (8388607 << 27)); 
} 


if (16777215 << 27 !== -134217728) { 
  throw new Test262Error('#889: 16777215 << 27 === -134217728. Actual: ' + (16777215 << 27)); 
} 


if (33554431 << 27 !== -134217728) { 
  throw new Test262Error('#890: 33554431 << 27 === -134217728. Actual: ' + (33554431 << 27)); 
} 


if (67108863 << 27 !== -134217728) { 
  throw new Test262Error('#891: 67108863 << 27 === -134217728. Actual: ' + (67108863 << 27)); 
} 


if (134217727 << 27 !== -134217728) { 
  throw new Test262Error('#892: 134217727 << 27 === -134217728. Actual: ' + (134217727 << 27)); 
} 


if (268435455 << 27 !== -134217728) { 
  throw new Test262Error('#893: 268435455 << 27 === -134217728. Actual: ' + (268435455 << 27)); 
} 


if (536870911 << 27 !== -134217728) { 
  throw new Test262Error('#894: 536870911 << 27 === -134217728. Actual: ' + (536870911 << 27)); 
} 


if (1073741823 << 27 !== -134217728) { 
  throw new Test262Error('#895: 1073741823 << 27 === -134217728. Actual: ' + (1073741823 << 27)); 
} 


if (2147483647 << 27 !== -134217728) { 
  throw new Test262Error('#896: 2147483647 << 27 === -134217728. Actual: ' + (2147483647 << 27)); 
} 


if (0 << 28 !== 0) { 
  throw new Test262Error('#897: 0 << 28 === 0. Actual: ' + (0 << 28)); 
} 


if (1 << 28 !== 268435456) { 
  throw new Test262Error('#898: 1 << 28 === 268435456. Actual: ' + (1 << 28)); 
} 


if (3 << 28 !== 805306368) { 
  throw new Test262Error('#899: 3 << 28 === 805306368. Actual: ' + (3 << 28)); 
} 


if (7 << 28 !== 1879048192) { 
  throw new Test262Error('#900: 7 << 28 === 1879048192. Actual: ' + (7 << 28)); 
} 


if (15 << 28 !== -268435456) { 
  throw new Test262Error('#901: 15 << 28 === -268435456. Actual: ' + (15 << 28)); 
} 


if (31 << 28 !== -268435456) { 
  throw new Test262Error('#902: 31 << 28 === -268435456. Actual: ' + (31 << 28)); 
} 


if (63 << 28 !== -268435456) { 
  throw new Test262Error('#903: 63 << 28 === -268435456. Actual: ' + (63 << 28)); 
} 


if (127 << 28 !== -268435456) { 
  throw new Test262Error('#904: 127 << 28 === -268435456. Actual: ' + (127 << 28)); 
} 


if (255 << 28 !== -268435456) { 
  throw new Test262Error('#905: 255 << 28 === -268435456. Actual: ' + (255 << 28)); 
} 


if (511 << 28 !== -268435456) { 
  throw new Test262Error('#906: 511 << 28 === -268435456. Actual: ' + (511 << 28)); 
} 


if (1023 << 28 !== -268435456) { 
  throw new Test262Error('#907: 1023 << 28 === -268435456. Actual: ' + (1023 << 28)); 
} 


if (2047 << 28 !== -268435456) { 
  throw new Test262Error('#908: 2047 << 28 === -268435456. Actual: ' + (2047 << 28)); 
} 


if (4095 << 28 !== -268435456) { 
  throw new Test262Error('#909: 4095 << 28 === -268435456. Actual: ' + (4095 << 28)); 
} 


if (8191 << 28 !== -268435456) { 
  throw new Test262Error('#910: 8191 << 28 === -268435456. Actual: ' + (8191 << 28)); 
} 


if (16383 << 28 !== -268435456) { 
  throw new Test262Error('#911: 16383 << 28 === -268435456. Actual: ' + (16383 << 28)); 
} 


if (32767 << 28 !== -268435456) { 
  throw new Test262Error('#912: 32767 << 28 === -268435456. Actual: ' + (32767 << 28)); 
} 


if (65535 << 28 !== -268435456) { 
  throw new Test262Error('#913: 65535 << 28 === -268435456. Actual: ' + (65535 << 28)); 
} 


if (131071 << 28 !== -268435456) { 
  throw new Test262Error('#914: 131071 << 28 === -268435456. Actual: ' + (131071 << 28)); 
} 


if (262143 << 28 !== -268435456) { 
  throw new Test262Error('#915: 262143 << 28 === -268435456. Actual: ' + (262143 << 28)); 
} 


if (524287 << 28 !== -268435456) { 
  throw new Test262Error('#916: 524287 << 28 === -268435456. Actual: ' + (524287 << 28)); 
} 


if (1048575 << 28 !== -268435456) { 
  throw new Test262Error('#917: 1048575 << 28 === -268435456. Actual: ' + (1048575 << 28)); 
} 


if (2097151 << 28 !== -268435456) { 
  throw new Test262Error('#918: 2097151 << 28 === -268435456. Actual: ' + (2097151 << 28)); 
} 


if (4194303 << 28 !== -268435456) { 
  throw new Test262Error('#919: 4194303 << 28 === -268435456. Actual: ' + (4194303 << 28)); 
} 


if (8388607 << 28 !== -268435456) { 
  throw new Test262Error('#920: 8388607 << 28 === -268435456. Actual: ' + (8388607 << 28)); 
} 


if (16777215 << 28 !== -268435456) { 
  throw new Test262Error('#921: 16777215 << 28 === -268435456. Actual: ' + (16777215 << 28)); 
} 


if (33554431 << 28 !== -268435456) { 
  throw new Test262Error('#922: 33554431 << 28 === -268435456. Actual: ' + (33554431 << 28)); 
} 


if (67108863 << 28 !== -268435456) { 
  throw new Test262Error('#923: 67108863 << 28 === -268435456. Actual: ' + (67108863 << 28)); 
} 


if (134217727 << 28 !== -268435456) { 
  throw new Test262Error('#924: 134217727 << 28 === -268435456. Actual: ' + (134217727 << 28)); 
} 


if (268435455 << 28 !== -268435456) { 
  throw new Test262Error('#925: 268435455 << 28 === -268435456. Actual: ' + (268435455 << 28)); 
} 


if (536870911 << 28 !== -268435456) { 
  throw new Test262Error('#926: 536870911 << 28 === -268435456. Actual: ' + (536870911 << 28)); 
} 


if (1073741823 << 28 !== -268435456) { 
  throw new Test262Error('#927: 1073741823 << 28 === -268435456. Actual: ' + (1073741823 << 28)); 
} 


if (2147483647 << 28 !== -268435456) { 
  throw new Test262Error('#928: 2147483647 << 28 === -268435456. Actual: ' + (2147483647 << 28)); 
} 


if (0 << 29 !== 0) { 
  throw new Test262Error('#929: 0 << 29 === 0. Actual: ' + (0 << 29)); 
} 


if (1 << 29 !== 536870912) { 
  throw new Test262Error('#930: 1 << 29 === 536870912. Actual: ' + (1 << 29)); 
} 


if (3 << 29 !== 1610612736) { 
  throw new Test262Error('#931: 3 << 29 === 1610612736. Actual: ' + (3 << 29)); 
} 


if (7 << 29 !== -536870912) { 
  throw new Test262Error('#932: 7 << 29 === -536870912. Actual: ' + (7 << 29)); 
} 


if (15 << 29 !== -536870912) { 
  throw new Test262Error('#933: 15 << 29 === -536870912. Actual: ' + (15 << 29)); 
} 


if (31 << 29 !== -536870912) { 
  throw new Test262Error('#934: 31 << 29 === -536870912. Actual: ' + (31 << 29)); 
} 


if (63 << 29 !== -536870912) { 
  throw new Test262Error('#935: 63 << 29 === -536870912. Actual: ' + (63 << 29)); 
} 


if (127 << 29 !== -536870912) { 
  throw new Test262Error('#936: 127 << 29 === -536870912. Actual: ' + (127 << 29)); 
} 


if (255 << 29 !== -536870912) { 
  throw new Test262Error('#937: 255 << 29 === -536870912. Actual: ' + (255 << 29)); 
} 


if (511 << 29 !== -536870912) { 
  throw new Test262Error('#938: 511 << 29 === -536870912. Actual: ' + (511 << 29)); 
} 


if (1023 << 29 !== -536870912) { 
  throw new Test262Error('#939: 1023 << 29 === -536870912. Actual: ' + (1023 << 29)); 
} 


if (2047 << 29 !== -536870912) { 
  throw new Test262Error('#940: 2047 << 29 === -536870912. Actual: ' + (2047 << 29)); 
} 


if (4095 << 29 !== -536870912) { 
  throw new Test262Error('#941: 4095 << 29 === -536870912. Actual: ' + (4095 << 29)); 
} 


if (8191 << 29 !== -536870912) { 
  throw new Test262Error('#942: 8191 << 29 === -536870912. Actual: ' + (8191 << 29)); 
} 


if (16383 << 29 !== -536870912) { 
  throw new Test262Error('#943: 16383 << 29 === -536870912. Actual: ' + (16383 << 29)); 
} 


if (32767 << 29 !== -536870912) { 
  throw new Test262Error('#944: 32767 << 29 === -536870912. Actual: ' + (32767 << 29)); 
} 


if (65535 << 29 !== -536870912) { 
  throw new Test262Error('#945: 65535 << 29 === -536870912. Actual: ' + (65535 << 29)); 
} 


if (131071 << 29 !== -536870912) { 
  throw new Test262Error('#946: 131071 << 29 === -536870912. Actual: ' + (131071 << 29)); 
} 


if (262143 << 29 !== -536870912) { 
  throw new Test262Error('#947: 262143 << 29 === -536870912. Actual: ' + (262143 << 29)); 
} 


if (524287 << 29 !== -536870912) { 
  throw new Test262Error('#948: 524287 << 29 === -536870912. Actual: ' + (524287 << 29)); 
} 


if (1048575 << 29 !== -536870912) { 
  throw new Test262Error('#949: 1048575 << 29 === -536870912. Actual: ' + (1048575 << 29)); 
} 


if (2097151 << 29 !== -536870912) { 
  throw new Test262Error('#950: 2097151 << 29 === -536870912. Actual: ' + (2097151 << 29)); 
} 


if (4194303 << 29 !== -536870912) { 
  throw new Test262Error('#951: 4194303 << 29 === -536870912. Actual: ' + (4194303 << 29)); 
} 


if (8388607 << 29 !== -536870912) { 
  throw new Test262Error('#952: 8388607 << 29 === -536870912. Actual: ' + (8388607 << 29)); 
} 


if (16777215 << 29 !== -536870912) { 
  throw new Test262Error('#953: 16777215 << 29 === -536870912. Actual: ' + (16777215 << 29)); 
} 


if (33554431 << 29 !== -536870912) { 
  throw new Test262Error('#954: 33554431 << 29 === -536870912. Actual: ' + (33554431 << 29)); 
} 


if (67108863 << 29 !== -536870912) { 
  throw new Test262Error('#955: 67108863 << 29 === -536870912. Actual: ' + (67108863 << 29)); 
} 


if (134217727 << 29 !== -536870912) { 
  throw new Test262Error('#956: 134217727 << 29 === -536870912. Actual: ' + (134217727 << 29)); 
} 


if (268435455 << 29 !== -536870912) { 
  throw new Test262Error('#957: 268435455 << 29 === -536870912. Actual: ' + (268435455 << 29)); 
} 


if (536870911 << 29 !== -536870912) { 
  throw new Test262Error('#958: 536870911 << 29 === -536870912. Actual: ' + (536870911 << 29)); 
} 


if (1073741823 << 29 !== -536870912) { 
  throw new Test262Error('#959: 1073741823 << 29 === -536870912. Actual: ' + (1073741823 << 29)); 
} 


if (2147483647 << 29 !== -536870912) { 
  throw new Test262Error('#960: 2147483647 << 29 === -536870912. Actual: ' + (2147483647 << 29)); 
} 


if (0 << 30 !== 0) { 
  throw new Test262Error('#961: 0 << 30 === 0. Actual: ' + (0 << 30)); 
} 


if (1 << 30 !== 1073741824) { 
  throw new Test262Error('#962: 1 << 30 === 1073741824. Actual: ' + (1 << 30)); 
} 


if (3 << 30 !== -1073741824) { 
  throw new Test262Error('#963: 3 << 30 === -1073741824. Actual: ' + (3 << 30)); 
} 


if (7 << 30 !== -1073741824) { 
  throw new Test262Error('#964: 7 << 30 === -1073741824. Actual: ' + (7 << 30)); 
} 


if (15 << 30 !== -1073741824) { 
  throw new Test262Error('#965: 15 << 30 === -1073741824. Actual: ' + (15 << 30)); 
} 


if (31 << 30 !== -1073741824) { 
  throw new Test262Error('#966: 31 << 30 === -1073741824. Actual: ' + (31 << 30)); 
} 


if (63 << 30 !== -1073741824) { 
  throw new Test262Error('#967: 63 << 30 === -1073741824. Actual: ' + (63 << 30)); 
} 


if (127 << 30 !== -1073741824) { 
  throw new Test262Error('#968: 127 << 30 === -1073741824. Actual: ' + (127 << 30)); 
} 


if (255 << 30 !== -1073741824) { 
  throw new Test262Error('#969: 255 << 30 === -1073741824. Actual: ' + (255 << 30)); 
} 


if (511 << 30 !== -1073741824) { 
  throw new Test262Error('#970: 511 << 30 === -1073741824. Actual: ' + (511 << 30)); 
} 


if (1023 << 30 !== -1073741824) { 
  throw new Test262Error('#971: 1023 << 30 === -1073741824. Actual: ' + (1023 << 30)); 
} 


if (2047 << 30 !== -1073741824) { 
  throw new Test262Error('#972: 2047 << 30 === -1073741824. Actual: ' + (2047 << 30)); 
} 


if (4095 << 30 !== -1073741824) { 
  throw new Test262Error('#973: 4095 << 30 === -1073741824. Actual: ' + (4095 << 30)); 
} 


if (8191 << 30 !== -1073741824) { 
  throw new Test262Error('#974: 8191 << 30 === -1073741824. Actual: ' + (8191 << 30)); 
} 


if (16383 << 30 !== -1073741824) { 
  throw new Test262Error('#975: 16383 << 30 === -1073741824. Actual: ' + (16383 << 30)); 
} 


if (32767 << 30 !== -1073741824) { 
  throw new Test262Error('#976: 32767 << 30 === -1073741824. Actual: ' + (32767 << 30)); 
} 


if (65535 << 30 !== -1073741824) { 
  throw new Test262Error('#977: 65535 << 30 === -1073741824. Actual: ' + (65535 << 30)); 
} 


if (131071 << 30 !== -1073741824) { 
  throw new Test262Error('#978: 131071 << 30 === -1073741824. Actual: ' + (131071 << 30)); 
} 


if (262143 << 30 !== -1073741824) { 
  throw new Test262Error('#979: 262143 << 30 === -1073741824. Actual: ' + (262143 << 30)); 
} 


if (524287 << 30 !== -1073741824) { 
  throw new Test262Error('#980: 524287 << 30 === -1073741824. Actual: ' + (524287 << 30)); 
} 


if (1048575 << 30 !== -1073741824) { 
  throw new Test262Error('#981: 1048575 << 30 === -1073741824. Actual: ' + (1048575 << 30)); 
} 


if (2097151 << 30 !== -1073741824) { 
  throw new Test262Error('#982: 2097151 << 30 === -1073741824. Actual: ' + (2097151 << 30)); 
} 


if (4194303 << 30 !== -1073741824) { 
  throw new Test262Error('#983: 4194303 << 30 === -1073741824. Actual: ' + (4194303 << 30)); 
} 


if (8388607 << 30 !== -1073741824) { 
  throw new Test262Error('#984: 8388607 << 30 === -1073741824. Actual: ' + (8388607 << 30)); 
} 


if (16777215 << 30 !== -1073741824) { 
  throw new Test262Error('#985: 16777215 << 30 === -1073741824. Actual: ' + (16777215 << 30)); 
} 


if (33554431 << 30 !== -1073741824) { 
  throw new Test262Error('#986: 33554431 << 30 === -1073741824. Actual: ' + (33554431 << 30)); 
} 


if (67108863 << 30 !== -1073741824) { 
  throw new Test262Error('#987: 67108863 << 30 === -1073741824. Actual: ' + (67108863 << 30)); 
} 


if (134217727 << 30 !== -1073741824) { 
  throw new Test262Error('#988: 134217727 << 30 === -1073741824. Actual: ' + (134217727 << 30)); 
} 


if (268435455 << 30 !== -1073741824) { 
  throw new Test262Error('#989: 268435455 << 30 === -1073741824. Actual: ' + (268435455 << 30)); 
} 


if (536870911 << 30 !== -1073741824) { 
  throw new Test262Error('#990: 536870911 << 30 === -1073741824. Actual: ' + (536870911 << 30)); 
} 


if (1073741823 << 30 !== -1073741824) { 
  throw new Test262Error('#991: 1073741823 << 30 === -1073741824. Actual: ' + (1073741823 << 30)); 
} 


if (2147483647 << 30 !== -1073741824) { 
  throw new Test262Error('#992: 2147483647 << 30 === -1073741824. Actual: ' + (2147483647 << 30)); 
} 


if (0 << 31 !== 0) { 
  throw new Test262Error('#993: 0 << 31 === 0. Actual: ' + (0 << 31)); 
} 


if (1 << 31 !== -2147483648) { 
  throw new Test262Error('#994: 1 << 31 === -2147483648. Actual: ' + (1 << 31)); 
} 


if (3 << 31 !== -2147483648) { 
  throw new Test262Error('#995: 3 << 31 === -2147483648. Actual: ' + (3 << 31)); 
} 


if (7 << 31 !== -2147483648) { 
  throw new Test262Error('#996: 7 << 31 === -2147483648. Actual: ' + (7 << 31)); 
} 


if (15 << 31 !== -2147483648) { 
  throw new Test262Error('#997: 15 << 31 === -2147483648. Actual: ' + (15 << 31)); 
} 


if (31 << 31 !== -2147483648) { 
  throw new Test262Error('#998: 31 << 31 === -2147483648. Actual: ' + (31 << 31)); 
} 


if (63 << 31 !== -2147483648) { 
  throw new Test262Error('#999: 63 << 31 === -2147483648. Actual: ' + (63 << 31)); 
} 


if (127 << 31 !== -2147483648) { 
  throw new Test262Error('#1000: 127 << 31 === -2147483648. Actual: ' + (127 << 31)); 
} 


if (255 << 31 !== -2147483648) { 
  throw new Test262Error('#1001: 255 << 31 === -2147483648. Actual: ' + (255 << 31)); 
} 


if (511 << 31 !== -2147483648) { 
  throw new Test262Error('#1002: 511 << 31 === -2147483648. Actual: ' + (511 << 31)); 
} 


if (1023 << 31 !== -2147483648) { 
  throw new Test262Error('#1003: 1023 << 31 === -2147483648. Actual: ' + (1023 << 31)); 
} 


if (2047 << 31 !== -2147483648) { 
  throw new Test262Error('#1004: 2047 << 31 === -2147483648. Actual: ' + (2047 << 31)); 
} 


if (4095 << 31 !== -2147483648) { 
  throw new Test262Error('#1005: 4095 << 31 === -2147483648. Actual: ' + (4095 << 31)); 
} 


if (8191 << 31 !== -2147483648) { 
  throw new Test262Error('#1006: 8191 << 31 === -2147483648. Actual: ' + (8191 << 31)); 
} 


if (16383 << 31 !== -2147483648) { 
  throw new Test262Error('#1007: 16383 << 31 === -2147483648. Actual: ' + (16383 << 31)); 
} 


if (32767 << 31 !== -2147483648) { 
  throw new Test262Error('#1008: 32767 << 31 === -2147483648. Actual: ' + (32767 << 31)); 
} 


if (65535 << 31 !== -2147483648) { 
  throw new Test262Error('#1009: 65535 << 31 === -2147483648. Actual: ' + (65535 << 31)); 
} 


if (131071 << 31 !== -2147483648) { 
  throw new Test262Error('#1010: 131071 << 31 === -2147483648. Actual: ' + (131071 << 31)); 
} 


if (262143 << 31 !== -2147483648) { 
  throw new Test262Error('#1011: 262143 << 31 === -2147483648. Actual: ' + (262143 << 31)); 
} 


if (524287 << 31 !== -2147483648) { 
  throw new Test262Error('#1012: 524287 << 31 === -2147483648. Actual: ' + (524287 << 31)); 
} 


if (1048575 << 31 !== -2147483648) { 
  throw new Test262Error('#1013: 1048575 << 31 === -2147483648. Actual: ' + (1048575 << 31)); 
} 


if (2097151 << 31 !== -2147483648) { 
  throw new Test262Error('#1014: 2097151 << 31 === -2147483648. Actual: ' + (2097151 << 31)); 
} 


if (4194303 << 31 !== -2147483648) { 
  throw new Test262Error('#1015: 4194303 << 31 === -2147483648. Actual: ' + (4194303 << 31)); 
} 


if (8388607 << 31 !== -2147483648) { 
  throw new Test262Error('#1016: 8388607 << 31 === -2147483648. Actual: ' + (8388607 << 31)); 
} 


if (16777215 << 31 !== -2147483648) { 
  throw new Test262Error('#1017: 16777215 << 31 === -2147483648. Actual: ' + (16777215 << 31)); 
} 


if (33554431 << 31 !== -2147483648) { 
  throw new Test262Error('#1018: 33554431 << 31 === -2147483648. Actual: ' + (33554431 << 31)); 
} 


if (67108863 << 31 !== -2147483648) { 
  throw new Test262Error('#1019: 67108863 << 31 === -2147483648. Actual: ' + (67108863 << 31)); 
} 


if (134217727 << 31 !== -2147483648) { 
  throw new Test262Error('#1020: 134217727 << 31 === -2147483648. Actual: ' + (134217727 << 31)); 
} 


if (268435455 << 31 !== -2147483648) { 
  throw new Test262Error('#1021: 268435455 << 31 === -2147483648. Actual: ' + (268435455 << 31)); 
} 


if (536870911 << 31 !== -2147483648) { 
  throw new Test262Error('#1022: 536870911 << 31 === -2147483648. Actual: ' + (536870911 << 31)); 
} 


if (1073741823 << 31 !== -2147483648) { 
  throw new Test262Error('#1023: 1073741823 << 31 === -2147483648. Actual: ' + (1073741823 << 31)); 
} 


if (2147483647 << 31 !== -2147483648) { 
  throw new Test262Error('#1024: 2147483647 << 31 === -2147483648. Actual: ' + (2147483647 << 31)); 
}

reportCompare(0, 0);
