/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.jena.atlas.lib.SetUtils;
import org.apache.jena.atlas.lib.Trie;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.WrappedGraph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.util.SplitIRI;
import org.apache.jena.util.iterator.ExtendedIterator;

public class PrefixMappingUtils {
    public static Graph graphInUsePrefixMapping(Graph graph) {
        final PrefixMapping prefixMapping = PrefixMappingUtils.calcInUsePrefixMapping(graph);
        prefixMapping.lock();
        WrappedGraph graph2 = new WrappedGraph(graph){

            @Override
            public void performAdd(Triple triple) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void performDelete(Triple triple) {
                throw new UnsupportedOperationException();
            }

            @Override
            public PrefixMapping getPrefixMapping() {
                return prefixMapping;
            }
        };
        return graph2;
    }

    public static PrefixMapping calcInUsePrefixMapping(Graph graph) {
        PrefixMapping prefixMapping = graph.getPrefixMapping();
        if (prefixMapping == null) {
            return null;
        }
        return PrefixMappingUtils.calcInUsePrefixMapping(graph, prefixMapping);
    }

    public static PrefixMapping calcInUsePrefixMapping(Graph graph, PrefixMapping prefixMapping) {
        Map<String, String> pmap = prefixMapping.getNsPrefixMap();
        Trie trie = new Trie();
        pmap.forEach((prefix, uri) -> trie.add((String)uri, prefix));
        ExtendedIterator<Triple> iter = graph.find(null, null, null);
        HashSet inUse = new HashSet();
        Consumer<Node> process = node -> {
            if (!node.isURI()) {
                return;
            }
            String uri = node.getURI();
            List hits = trie.partialSearch(uri);
            if (hits.isEmpty()) {
                return;
            }
            inUse.addAll(hits);
        };
        while (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            process.accept(triple.getSubject());
            process.accept(triple.getPredicate());
            process.accept(triple.getObject());
            if (pmap.size() != inUse.size()) continue;
            break;
        }
        if (pmap.size() == inUse.size()) {
            return prefixMapping;
        }
        PrefixMappingImpl pmap2 = new PrefixMappingImpl();
        inUse.forEach(prefix -> pmap2.setNsPrefix((String)prefix, prefixMapping.getNsPrefixURI((String)prefix)));
        return pmap2;
    }

    public static PrefixMapping calcInUsePrefixMappingTTL(Graph graph) {
        PrefixMapping prefixMapping = graph.getPrefixMapping();
        if (prefixMapping == null) {
            return null;
        }
        return PrefixMappingUtils.calcInUsePrefixMappingTTL(graph, prefixMapping);
    }

    public static PrefixMapping calcInUsePrefixMappingTTL(Graph graph, PrefixMapping prefixMapping) {
        Map<String, String> pmap = prefixMapping.getNsPrefixMap();
        HashSet<String> prefixURIs = new HashSet<String>(pmap.values());
        HashSet inUse = new HashSet();
        Consumer<Node> process = node -> {
            if (!node.isURI()) {
                return;
            }
            String uri = node.getURI();
            int idx = SplitIRI.splitpoint(uri);
            if (idx < 0) {
                return;
            }
            String nsURI = SplitIRI.namespaceTTL(uri);
            String prefix = prefixMapping.getNsURIPrefix(nsURI);
            if (prefix != null) {
                inUse.add(prefix);
            }
        };
        ExtendedIterator<Triple> iter = graph.find(null, null, null);
        while (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            process.accept(triple.getSubject());
            process.accept(triple.getPredicate());
            process.accept(triple.getObject());
            if (inUse.size() != prefixURIs.size()) continue;
            break;
        }
        if (pmap.size() == inUse.size()) {
            return prefixMapping;
        }
        PrefixMappingImpl pmap2 = new PrefixMappingImpl();
        inUse.forEach(prefix -> pmap2.setNsPrefix((String)prefix, prefixMapping.getNsPrefixURI((String)prefix)));
        return pmap2;
    }

    private static Set<String> fullMethod(Model m) {
        Map<String, String> pmap = m.getNsPrefixMap();
        Trie<String> trie = new Trie<String>();
        pmap.forEach((prefix, uri) -> trie.add((String)uri, (String)uri));
        ExtendedIterator<Triple> iter = m.getGraph().find(null, null, null);
        HashSet<String> inUseURIs = new HashSet<String>();
        while (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            PrefixMappingUtils.processFull(trie, inUseURIs, triple.getSubject());
            PrefixMappingUtils.processFull(trie, inUseURIs, triple.getPredicate());
            PrefixMappingUtils.processFull(trie, inUseURIs, triple.getObject());
            if (pmap.size() != inUseURIs.size()) continue;
            break;
        }
        return inUseURIs;
    }

    private static void processFull(Trie<String> trie, Set<String> prefixesInUse, Node node) {
        if (!node.isURI()) {
            return;
        }
        String uri = node.getURI();
        String pref = uri;
        List<String> hits = trie.partialSearch(pref);
        if (hits == null || hits.isEmpty()) {
            return;
        }
        prefixesInUse.addAll(hits);
    }

    private static Set<String> splitMethod(Model m) {
        Model prefixMapping = m;
        Map<String, String> pmap = prefixMapping.getNsPrefixMap();
        HashSet<String> prefixURIs = new HashSet<String>(pmap.values());
        HashSet<String> inUsePrefixURIs = new HashSet<String>();
        ExtendedIterator<Triple> iter = m.getGraph().find(null, null, null);
        while (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            PrefixMappingUtils.processBySplit(prefixURIs, inUsePrefixURIs, triple.getSubject());
            PrefixMappingUtils.processBySplit(prefixURIs, inUsePrefixURIs, triple.getPredicate());
            PrefixMappingUtils.processBySplit(prefixURIs, inUsePrefixURIs, triple.getObject());
            if (inUsePrefixURIs.size() != prefixURIs.size()) continue;
            break;
        }
        return inUsePrefixURIs;
    }

    private static void processBySplit(Collection<String> prefixURIs, Collection<String> inUse, Node node) {
        if (!node.isURI()) {
            return;
        }
        String uri = node.getURI();
        int idx = SplitIRI.splitpoint(uri);
        if (idx < 0) {
            return;
        }
        String prefixUri = uri.substring(0, idx);
        String localname = uri.substring(idx);
        if (prefixURIs.contains(prefixUri)) {
            inUse.add(prefixUri);
        }
    }

    private static void print(Set<String> inUsePrefixURIs, PrefixMapping prefixMapping) {
        Set<String> inUsePrefixes = PrefixMappingUtils.urisToPrefixes(prefixMapping, inUsePrefixURIs);
        System.out.println("In use: " + inUsePrefixURIs);
        System.out.println("In use: " + inUsePrefixes);
        inUsePrefixURIs.forEach(u -> System.out.printf("    %s: -> <%s>\n", prefixMapping.getNsURIPrefix((String)u), u));
        Map<String, String> pmap = prefixMapping.getNsPrefixMap();
        HashSet<String> prefixURIs = new HashSet<String>(pmap.values());
        Set<String> notInUseURIs = SetUtils.difference(prefixURIs, inUsePrefixURIs);
        Set<String> notInUsePrefixes = SetUtils.difference(pmap.keySet(), inUsePrefixes);
        System.out.println("Not in use: " + notInUseURIs);
        System.out.println("Not in use: " + notInUsePrefixes);
        notInUseURIs.forEach(u -> System.out.printf("    %s: -> <%s>\n", prefixMapping.getNsURIPrefix((String)u), u));
    }

    private static Set<String> urisToPrefixes(PrefixMapping prefixMapping, Set<String> inUsePrefixURIs) {
        return inUsePrefixURIs.stream().map(prefixMapping::getNsURIPrefix).collect(Collectors.toSet());
    }
}

