/*****************************************************************************
 * spellcheck_plugin.h
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2008, Gregory D Hosler
 * (ghosler ['at'] users.sourceforge.net)
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 *****************************************************************************/

#ifndef _SPELLCHECK_PLUGIN_H_
#define _SPELLCHECK_PLUGIN_H_

typedef struct _gyachi_spellcheck_plugin {
	char *name;
	char *description;
	void (*activate)(GtkTextView *text_view, int activate, GtkWidget *parent);
} GYACHI_SPELLCHECK_PLUGIN;

extern int register_spellcheck_plugin(GYACHI_SPELLCHECK_PLUGIN *plugin);
extern GList *gyachi_spellcheck_plugins_available();
extern int select_spellcheck_plugin(const char *name);
extern const char *spellcheck_plugin_description(const char *name);
extern const char *spellcheck_plugin_name(const char *description);
extern int is_spellcheck_available();
extern void spellcheck_activate(GtkTextView *text_view, int activate, GtkWidget *parent);

#endif

