/******************************************************************************
 * GYachI-Voiceclient
 * Copyright (C) 2006  Stefan Sikora <hoshy[at]schrauberstube.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/

/*******************
 * Sound interface *
 ******************/
 
// Globals
#define max_tspchunks 200		// How many tsp-chunks the soundbuffer holds
#define chunk_size     96*15		// 1440 bytes is based on 96 bytes of tsp_data per udp packet and each tsp byte
					// generates 15 bytes of pcm data.
#define tspdelay 4			// minimum packets before playback starts
unsigned char soundbuffer[max_tspchunks*chunk_size];
unsigned char recordbuffer[chunk_size];

int recvchunk;					// Where to put in next chunk
int playchunk;					// how many unplayed chunks are in soundbuffer
int silence;
int playing;
int recording;

pthread_cond_t data_cond;
pthread_mutex_t data_mutex;

// ui function
void reset_talk_labels();

// General sound-functions
int init_sound();
void uninit_sound();
void stop_recording();
void start_recording();

// Truespeech-functions
int tsp_conversion(char *src, char *dst, int srclen, int dstlen);
