/*****************************************************************************
 * util.h
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2003-2005, Erica Andrews
 * (Phrozensmoke ['at'] yahoo.com)
 * http://phpaint.sourceforge.net/pyvoicechat/
 * 
 * Copyright (C) 2000-2002 Chris Pinkham
 * cpinkham@corp.infi.net, cpinkham@bc2va.org
 * http://www4.infi.net/~cpinkham/gyach/
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 * cpinkham@infi.net, cpinkham@bc2va.org
 * http://www4.infi.net/~cpinkham/gyach/
 *****************************************************************************/


#ifndef _UTIL_H_
#define _UTIL_H_

typedef struct smiley {
	char *sm_text;
	char *sm_file;
	char *sm_tooltip;
} SMILEY;
extern SMILEY *smileys;

extern char mail_user[];
extern char *recv_sound;
extern char *send_sound;

extern char *bimage_url;
extern int  bimage_timestamp;
extern char *bimage_hash;
extern char *avatar_filetype;

extern void display_message(char *buffer);

extern void delete_yavatars(char *ava_key);
extern void delete_all_bimages();
extern void delete_all_yavatars();
extern int  bimage_exists(char *ava_key);

extern int  gyachi_build_dir(const char *path, int mode);
extern void strip_html_tags( char *str );
extern int  my_system( char *command );
extern int  fetch_url( char *image_url, char *buf, int buf_size, char *post, char *cookie );
extern void *display_url( void *arg );
extern void smileys_load();
extern GtkWidget *load_smiley_icon(char *str);
extern int  check_smiley( char *str );
extern void convert_smileys( char *str );
extern void convert_tags( char *str );
extern void strip_junk( char *str );
extern void subst_escs( char *str );
extern char *filter_text( char *txt );
extern char *replace_args( char *str, char *args );
extern void *fetch_avatar( void *arg );
extern void display_emotes_pane(void);
extern void display_chatroom_pane(void);
extern void display_avatar( char *user, char *avatar );
extern int  download_yavatar(char *avatar, int ava_size, char *burl);
extern void play_sound( char *arg );
extern gint gstrcmp( gpointer a, gpointer b );
extern GList *gyach_g_list_free( GList *list );
extern GList *gyach_g_list_copy( GList *list );
extern GList *gyach_g_list_merge( GList *main, GList *sub );
extern char *download_image( char *image_url );

extern GtkWidget *find_parent_window(GtkWidget *thing);
extern GtkWidget *find_pms_window(char *who);

extern const char *gyach_timestamp();
extern const char *yahoo_timestamp();

/* Flags for select_fd's WAIT_FOR argument. */
enum {
  WAIT_FOR_READ = 1,
  WAIT_FOR_WRITE = 2
};
extern int select_fd (int fd, double maxtime, int wait_for);
extern void check_proxy_config();
extern int connect_to_host(char *hostname, int port, char **error);
extern int open_socket_for_hostname(char *hostname, char **host_addr, GtkWidget *parent, int in_thread);
extern void set_socket_timer(int sockfd, int mytime);
extern int read_sock(int sock, char *buf, int size, int secs);
extern int write_sock(int sock, char *buf, int size, int secs);

#endif /* #ifndef _UTIL_H_ */
